

/******************************************************************************************************
 **                                                                                                  **
 **                            Ex4- Test Control Dot on iLED4x4                                      **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : ARDUINO                                                                    **
 **                     : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.6.7                                                              **
 **                                                                                                  **                   
 **   Port Interface    :     PIN Arduino Board                           ET-iLED4x4RGB              **
 **                         --------------------                         --------------              **
 **                         PIN D8(Rx-PD0)            Connect              DI                        **
 **                                                                                                  **
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   14/July/2016                                                             ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

 #include <Adafruit_NeoPixel.h>

/*#################################################################
 ##                                                              ##
 ##                   Define Color 24 Bit RGB                    ##
 ##                                                              ##
 #################################################################*/

#define Snow        0xFFFAFA
#define Ivory       0xFFFFF0
#define Azure       0xF0FFFF
#define White       0xFFFFFF
#define Black       0x000000
#define Grey        0xBEBEBE
#define Blue        0x0000FF
#define Cyan        0x00FFFF
#define Green       0x00FF00
#define Yellow      0xFFFF00
#define Gold        0xFFD700
#define Peru        0xCD853F
#define Chocolate   0xD2691E
#define Brown       0xA52A2A
#define Salmon      0xFA8072
#define Orange      0xFFA500
#define Red         0xFF0000
#define Pink        0xFFC0CB
#define Magenta     0xFF00FF
#define Violet      0xEE82EE
#define Orchid      0xDA70D6
#define Purple      0xA020F0



 //------------- Define Pin -----------  

 unsigned char  DI_PIN         =  8    ;  
 
// Parameter 1 = number of pixels in strip
// Parameter 2 = pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_KHZ800  800 KHz bitstream (most NeoPixel products w/WS2812 LEDs)
//   NEO_KHZ400  400 KHz (classic 'v1' (not v2) FLORA pixels, WS2811 drivers)
//   NEO_GRB     Pixels are wired for GRB bitstream (most NeoPixel products)
//   NEO_RGB     Pixels are wired for RGB bitstream (v1 FLORA pixels, not v2)

 Adafruit_NeoPixel strip = Adafruit_NeoPixel(16,DI_PIN, NEO_GRB + NEO_KHZ800);


/***********************************************************************
 *                   Function : Setup I/O PortPIN                      *
 ***********************************************************************/
 
void setup()
{

  strip.begin() ;
  strip.show()  ; // Initialize all pixels to 'off' 
  delay(300)    ;  
  
}

/***********************************************************************
 *                                                                     *
 *                              Main Program                           *
 *                                                                     *
 ***********************************************************************/
  
void loop() 
{
   strip.setPixelColor(0,Red)     ; //Set Color Red   to LED Position 0
   strip.setPixelColor(6,Green)   ; //Set Color Green to LED Position 6
   strip.setPixelColor(10,Blue)   ; //Set Color Blue  to LED Position 10 
   strip.setPixelColor(12,Yellow) ; //Set Color Yellow to LED Position 2
   strip.show()                   ; //Display color of iLED All(16dot),LED at not set color default is black Color 

   delay(1000);
  
   strip.setPixelColor(6,Black)   ; //Set Color Black to LED Position 6 = LED Postion6 OFF 
   strip.setPixelColor(10,Black)  ; //Set Color Black to LED Position 10 = LED Postion10 OFF 
  
   strip.show()                   ;//Display color of iLED All(16dot),LED at not set color default is black Color 
   delay(500);

}




