
/******************************************************************************************************
 **                                                                                                  **
 **                                     Ex3-Test Pattern iLED4x4                                     **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : ARDUINO                                                                    **
 **                     : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.6.7                                                              **
 **                                                                                                  **                   
 **   Port Interface    :     PIN Arduino Board                           ET-iLED4x4RGB              **
 **                         --------------------                         --------------              **                                                                         
 **   iLED DI           :                                                                            **
 **                         PIN D8(Rx-PD0)               Connect              DI                     **
 **                                                                                                  **
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   21/July/2016                                                             ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

#include <Adafruit_NeoPixel.h>

unsigned char  DI_PIN         =  8    ; 


// Parameter 1 = number of pixels in strip
// Parameter 2 = pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_KHZ800  800 KHz bitstream (most NeoPixel products w/WS2812 LEDs)
//   NEO_KHZ400  400 KHz (classic 'v1' (not v2) FLORA pixels, WS2811 drivers)
//   NEO_GRB     Pixels are wired for GRB bitstream (most NeoPixel products)
//   NEO_RGB     Pixels are wired for RGB bitstream (v1 FLORA pixels, not v2)

Adafruit_NeoPixel strip = Adafruit_NeoPixel(16,DI_PIN, NEO_GRB + NEO_KHZ800);


/***********************************************************************
 *                   Function : Setup I/O PortPIN                      *
 ***********************************************************************/
 
void setup() 
{
  strip.begin();
  strip.show() ; // Initialize all pixels to 'off'
  
}

/***********************************************************************
 *                                                                     *
 *                              Main Program                           *
 *                                                                     *
 ***********************************************************************/
 
void loop() 
{
  // Some example procedures showing how to display to the pixels:
  
  colorWipe(strip.Color(255, 0, 0), 50); // Red
  colorWipe(strip.Color(0, 255, 0), 50); // Green
  colorWipe(strip.Color(0, 0, 255), 50); // Blue
  //Send a theater pixel chase in...
  theaterChase(strip.Color(127, 127, 127), 50)  ; // White 
  theaterChase(strip.Color(127,   0,   0), 50)  ; // Red 
  theaterChase(strip.Color(  0,   0, 127), 50)  ; // Blue

  rainbow(20);
  rainbowCycle(20);
  theaterChaseRainbow(50);
 
}



/***********************************************************************
 *                             Sub-Program                             *
 ***********************************************************************/

/***-----------------------------------------------------------------** 
  **     Pattern Fill the dots one after the other with a color      **
  ** Paramiter : c = Color RGB 24 Bit  ,wait = Value Delay           **
  **-----------------------------------------------------------------**/
  
void colorWipe(unsigned long c, unsigned char wait) 
 {
   unsigned int i ;

   for( i=0; i<strip.numPixels(); i++) //Loop Set Color to LED All(LED ALL=16)
    {
      strip.setPixelColor(i,c)     ; //Set Color to Position LED (i=Position LED)
      strip.show()                 ; //Display Color LED Active
      delay(wait)                  ;
    }
 }


/***-----------------------------------------------------------------** 
  **               Pattern rainbow dimer Chang Color                 **
  ** Paramiter : wait = Value Delay                                  **
  **-----------------------------------------------------------------**/
  
void rainbow(unsigned char wait)
{
  unsigned int i, j;

  for(j=0; j<256; j++)                             //Loop Color RGB ,1 Color = 1 Byte 0-255)
   {
    for(i=0; i<strip.numPixels(); i++)             //Loop Set Color to LED All(LED ALL=16)
     {
       strip.setPixelColor(i, Wheel((i+j) & 255)); //Set Color to Position LED (i=Position LED)
     }
    strip.show(); //Display Color LED Active
    delay(wait);
   }
 }

 

 /**-----------------------------------------------------------------** 
  **                   Pattern rainbow Cycle                         **
  **   Slightly different, this makes the rainbow equally            **
  **   distributed throughout                                        **
  ** Paramiter : wait = Value Delay                                  **
  **-----------------------------------------------------------------**/
 
void rainbowCycle(unsigned char wait)
 {
   unsigned int i, j;

   for(j=0; j<256*5; j++)   // Loop 5 cycles of all colors on wheel
    {
      for(i=0; i< strip.numPixels(); i++) 
       {
         strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
       }
      strip.show();
      delay(wait);
   }
}

/***-----------------------------------------------------------------** 
  **          Pattern Theatre-style crawling lights.                 **
  ** Paramiter : c= color RGB ,wait = Value Delay                    **
  **-----------------------------------------------------------------**/

void theaterChase(unsigned long c, unsigned char wait) 
 {
   int i,j,q  ;
   
    for(j=0; j<10; j++)   //Loop do 10 cycles of chasing
      {
        for(q=0; q < 3; q++) 
         {
           for(i=0; i < strip.numPixels(); i=i+3) 
            {
              strip.setPixelColor(i+q, c);    //turn every third pixel on
            }
           strip.show() ;     
           delay(wait)  ;
     
           for(i=0; i < strip.numPixels(); i=i+3) 
            {
              strip.setPixelColor(i+q, 0);        //turn every third pixel off
            }
        } //for q
      } //for j
 } 

/***------------------------------------------------------------------------------------** 
  **          Pattern Theatre-style crawling lights with rainbow effect                 **
  ** Paramiter : wait = Value Delay                                                     **
  **------------------------------------------------------------------------------------**/

void theaterChaseRainbow(unsigned char wait) 
{
  int i,j,q ;
  
  for(j=0 ; j < 256 ; j++)      // cycle all 256 colors in the wheel
   {
     for(q=0 ; q < 3 ; q++) 
      {
         for(i=0 ; i < strip.numPixels() ; i=i+3) 
          {
            strip.setPixelColor(i+q , Wheel( (i+j) % 255));    //turn every third pixel on
          }
         strip.show();      
         delay(wait);
       
        for (i=0; i < strip.numPixels(); i=i+3)
         {
          strip.setPixelColor(i+q, 0);                         //turn every third pixel off
         }
    }//for q
  }// for j
}


/**-------------------------------------------------------------------------------** 
 **     Function Tranfer color value 0 to 255(1Byte) to color RGB(3Byte)          **
 **    The colours are a transition r - g - b - back to r.                        **
 ** Parameter : WheelPos = Position LED and value Color 1 Byte                    **    
 **-------------------------------------------------------------------------------**/
  
unsigned long Wheel(byte WheelPos) 
 {
   if(WheelPos < 85) 
    {
     return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);  //Set Color RGB
    } 
   else if(WheelPos < 170) 
    {
      WheelPos -= 85;
      return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3); //Set Color RGB
    } 
   else 
    {
      WheelPos -= 170;
      return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3); //Set Color RGB
    }
}

