

/******************************************************************************************************
 **                                                                                                  **
 **                         Ex2- Remote Control Chang Color of iLED4x4                               **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : ARDUINO                                                                    **
 **                     : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.6.7                                                              **
 **                                                                                                  **                   
 **   Port Interface    :     PIN Arduino Board                           ET-iLED4x4RGB              **
 **                         --------------------                         --------------              **
 **   IR Infared        :                                                                            **
 **                         PIN D9[PB1](IN)           Connect              Data OUT IR               ** 
 **   LED IR Status     :                                                                            **
 **                         PIN D16[A2-PC2](OUT)      Connect              No Use(LED)               **                                                                                    
 **   iLED DI           :                                                                            **
 **                         PIN D8(Rx-PD0)            Connect              DI                        **
 **                                                                                                  **
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   14/July/2016                                                             ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

 #include <IR_iLED4x4.h>
 #include <Adafruit_NeoPixel.h>

/*#################################################################
 ##                                                              ##
 ##                   Define Color 24 Bit RGB                    ##
 ##                                                              ##
 #################################################################*/

#define Snow        0xFFFAFA
#define Ivory       0xFFFFF0
#define Azure       0xF0FFFF
#define White       0xFFFFFF
#define Black       0x000000
#define Grey        0xBEBEBE
#define Blue        0x0000FF
#define Cyan        0x00FFFF
#define Green       0x00FF00
#define Yellow      0xFFFF00
#define Gold        0xFFD700
#define Peru        0xCD853F
#define Chocolate   0xD2691E
#define Brown       0xA52A2A
#define Salmon      0xFA8072
#define Orange      0xFFA500
#define Red         0xFF0000
#define Pink        0xFFC0CB
#define Magenta     0xFF00FF
#define Violet      0xEE82EE
#define Orchid      0xDA70D6
#define Purple      0xA020F0



 //------------- Define Pin -----------  

 unsigned char  DI_PIN         =  8    ;  
 unsigned char IR_RECV         =  9    ; //IR Detect Remote Signal

 
// Parameter 1 = number of pixels in strip
// Parameter 2 = pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_KHZ800  800 KHz bitstream (most NeoPixel products w/WS2812 LEDs)
//   NEO_KHZ400  400 KHz (classic 'v1' (not v2) FLORA pixels, WS2811 drivers)
//   NEO_GRB     Pixels are wired for GRB bitstream (most NeoPixel products)
//   NEO_RGB     Pixels are wired for RGB bitstream (v1 FLORA pixels, not v2)

 Adafruit_NeoPixel strip = Adafruit_NeoPixel(16,DI_PIN, NEO_GRB + NEO_KHZ800);

 IRrecv irrecv(IR_RECV);
 decode_results results;
 
 unsigned long Last_Time = millis(); //Delay Time


//------ Function Display Color iLED All -----------

void Dsp_iLED(unsigned long color) 
{
  unsigned int numLED ;
  
  for(numLED=0 ; numLED<strip.numPixels() ; numLED++) //Loop Set code Color give iLED ALL (16 Dot)
   {
      strip.setPixelColor(numLED,color);              //Set Code Color to LED

   }
  strip.show(); //Give iLED All ON
}
 

//-------- Function Display Pattern iLED -----------
 
void Pattern(unsigned long color) 
{
  int k=0,num ;

  //--------Display Pattern1 ----------
   
  for(k=0;k<3;k++)                                       //Loop Run Pattern1,2  3 time
   {
      for(num=0; num<strip.numPixels(); num++)             //Loop Pattern1 Square small(16 dot LED)
       {
         if((num==5)||(num==6)||(num==9)||(num==10))    //if is LED Position 5,6,9,10 give Set Color(LED ON 4dot)
           strip.setPixelColor(num,color)       ;       //set Color Pattern to iLED
         else                                           //if is not LED Position 5,6,9,10 LED OFF All 
           strip.setPixelColor(num,Black)       ;       //Set Color Black to iLED or OFF iLed
       }
      strip.show()                              ;       //Display Pattern1 
      delay(500)                                ;       //Delay 500ms

 //----------Display Pattern2 -----------
 
     for(num=0; num<strip.numPixels(); num++)             //Loop Pattern2 Square Large (16 dot LED)
      {
        if(((num>=0)&&(num<=4))||(num==7)||(num==8)||((num>=11)&&(num<=15)))    //if is LED Position 0-4,7-8,11-15 give Set Color(LED ON 12dot)
           strip.setPixelColor(num,color)       ;       //set Color Pattern to iLED
        else                                            //if is not LED Position 0-4,7-8,11-15 LED OFF All 
           strip.setPixelColor(num,Black)       ;       //Set Color Black to iLED or OFF iLed
      }
     strip.show()                               ;       //Display Pattern2 
     delay(500)                                 ;       //Delay 500ms   
   
  } //for k
   
  Dsp_iLED(Black); //iLED All OFF 
}

 
/***********************************************************************
 *                   Function : Setup I/O PortPIN                      *
 ***********************************************************************/
 
void setup()
{
 //  Serial.begin(9600); 
 
  irrecv.enableIRIn(); // Start the receiver
  
  strip.begin() ;
  strip.show()  ; // Initialize all pixels to 'off' 
  delay(300)    ;
  Pattern(Blue ); //Red
  
  
}

/***********************************************************************
 *                                                                     *
 *                              Main Program                           *
 *                                                                     *
 ***********************************************************************/
  
void loop() 
{
   unsigned long Remote_Key    ; 
   unsigned int fagdim=0,dim=255 ;

 while(1)
 { 
  if(irrecv.decode(&results))          //Check Signal Infared from Remote
   {
      if(millis() - Last_Time > 250)   //Check delay Time every 250 ms for Protect Press Remote Repeat 
      {
        if((results.value != 0xFFFFFFFF) && (results.value != 0x00) )  //Check Press Remote Repeat and not Press
          {     
             Remote_Key = results.value            ;  //Keep Value Key Code of Remote in 'Remote_Key'
            
                 switch(Remote_Key)     //Check Value KeyCode of Remote(Value KeyCode use Ref. come from Remote of ETT if is Remote other must Chang Keycode for Ref.)
                  { 
                    case 0xFFA25D :    //-------Press Remote Key OFF= LED ON Color Black(LED OFF) ------------                    
                                    Dsp_iLED(Black)         ; // Display All LED Color Black or off LED
                                    strip.setBrightness(255); // Set max brightness for Default
                                    dim = 255               ; //keep value  Brightness  maximum for Default  
                                    fagdim=0                ; //fagdim=0 Disable Key +,- for Adjust Brightness
                                    
                                    break ;
                           
                    case 0xFF30CF :   //-----------Press Remote Key 1=LED ON Color RED----------
                                    Dsp_iLED(Red)     ;    // Display All LED Color Red
                                    fagdim = 1        ;    // fagdim=1 Enable Key +,- for Adjust Brightness
                                    break;
                             
                    case 0xFF18E7 :  //------------Press Remote Key 2=LED ON Color Green ---------                       
                                    Dsp_iLED(Green)   ;  // Display All LED Color Green
                                    fagdim = 1        ;  // fagdim=1 Enable Key +,- for Adjust Brightness  
                                    break ;
                              
                    case 0xFF7A85 :  //-----------Press Remote Key 3 = LED ON Color Blue----------
                             
                                    Dsp_iLED(Blue)    ;   // Display All LED Color Blue        
                                    fagdim = 1        ;   // fagdim=1 Enable Key +,- for Adjust Brightness
                                    break ; 
                     
                     case 0xFF10EF :  //-------------Press Remote Key 4= LED ON Color White------------
                             
                                    Dsp_iLED(White)   ;  // Display All LED Color White
                                    fagdim = 1        ;  // fagdim=1 Enable Key +,- for Adjust Brightness
                                    
                                    break ; 
                   
                     case 0xFF02FD :  //-------------Press Remote Key + (Increment Brightness) ------------
                     
                                      if(fagdim==1)                    //Check fagdim for Enable key + , Control Brightness
                                       {
                                          if(dim<30)                   //Check Value Brightness if < 30
                                          {
                                            dim = dim+2            ;   //Adjust Step increment dimer to Step 2 
                                          }
                                         else                          //if Brightness >= 30
                                          {
                                            dim = dim+25          ;    //Adjust Step increment dimer to Step 25 
                                            if(dim>255)                //Check if Brightness = Maximum 
                                              dim = 255           ;    //Give Brightness = Maximum
                                          }
                                         strip.setBrightness(dim) ;   //Set Value Brightness new
                                         strip.show()             ;   //Update Value Brightness to LED
                                             
                                       } //if fagdim
                                 
                                    break ; 
                                      
                     case 0xFF9867 :  //-------------Press Remote Key - (Decrement Brightness)------------
                     
                                     if(fagdim==1)                    //Check fagdim for Enable key - , Control Brightness
                                      {
                                        if(dim<=30)                   //Check Value Brightness if <= 30
                                         {
                                           dim = dim-2           ;    //Adjust Step Decrement dimer to Step 2 

                                           if(dim<2)                  //Check if Brightness = Minimum 
                                             dim=2               ;    //Give Brightness = Minimum    
                                         }
                                        else                          //if Brightness > 30
                                         {
                                          dim = dim-25           ;    //Adjust Step Decrement dimer to Step 25 
                                         }
                                        strip.setBrightness(dim) ;    //Set Value Brightness new
                                        strip.show()             ;    //Update Value Brightness to LED  
   
                                      } //if fagdim
                               
                                   break ; //case3
                  }//Switch
               
         }//if value
      } // if millis
  
     Last_Time = millis()  ;      
     irrecv.resume()       ; // Receive the next value
  } //if decode
 }//while
}




