


/******************************************************************************************************
 **                                                                                                  **
 **                      Ex1-Read Key code Remote Print to RS232 for MCU Arduino                     **
 **                                                                                                  **
 **             Tx Remote Support Protocal : NEC,SONY,RC5(Phillip),RC6,DISH,SHARP,                   **
 **                                          Panasonic,JVC,SANYO,MITSUBISHI and Other                **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : ARDUINO                                                                    **
 **       	            : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.6.7                                                              **
 **                                                                                                  **										
 **   Port Interface    :     PIN Arduino Board                           ET-iLED4x4RGB              **
 **                         --------------------                         --------------              **
 **   IR Infared        :                                                                            **
 **                         PIN D9[PB1](IN)           Connect              Data OUT IR               ** 
 **   LED IR Status     :                                                                            **
 **                         PIN D16[A2-PC2](OUT)      Connect               No Use(LED)              **                                                                                    
 **   RS232-Uart0       :                                                                            **
 **                         PIN D0(Rx-PD0)            Connect to PC Tx                               **
 **                         PIN D1(Tx-PD1)            Connect to Pc Rx                               **
 **                         Baud Rate 9600                                                           **
 **                                                                                                  **
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   14/July/2016                                                             ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

 #include <IR_iLED4x4.h>
 
 //------------- Define Pin -----------  
 
 unsigned char IR_RECV         =  9    ; //IR Detect Remote Signal
 
 IRrecv irrecv(IR_RECV);
 decode_results results;

 unsigned long Last_Time = millis()    ;//Read Time for Delay


/***********************************************************************
 *                  Function : Read Key code from Remote               *
 ***********************************************************************/
 
void Read_KeyCode(void)
 {
   unsigned long key_code      ; 
       
   if(irrecv.decode(&results))  //Detect Signal Infared IR 
     {
       if(millis() - Last_Time > 250)  //delay Loop every 250 ms
         {
            if((results.value != 0xFFFFFFFF) && (results.value != 0x00) ) //Check value Remote Code != 0x00 and 0xFF 
              {
                  
                 key_code = results.value            ;  //Keep value Key Code in 'key_code'
                 Serial.print("Key Code Remote = ")  ;  //Print value Keycode to RS232 
                 Serial.println(key_code,HEX)        ;  //Format Keycode is Hex
               
              } //if value
     
         } //if millis()
             
       Last_Time = millis(); //Keep vale Delay Old    
       irrecv.resume()     ; // Receive the next value
    } //if decode
     
 }
 
 
 
/***********************************************************************
 *                   Function : Setup I/O PortPIN                      *
 ***********************************************************************/
 
void setup()
{
  Serial.begin(9600); 
   
  irrecv.enableIRIn(); // Start the receiver
  
  
}
 
/***********************************************************************
 *                                                                     *
 *                              Main Program                           *
 *                                                                     *
 ***********************************************************************/
  
void loop() 
{
 
   Serial.println("<=== Press Key Other On Remote ===>")  ;
   
   while(1)
    {
      Read_KeyCode();   //Read Value Key Code and Print to RS232
    }

}




