





/***********************************************************************************************
 *                                                                                             *
 *     Ex2 : Dimmer RGB LED1x1(WS2812B) For "ET-BASE AVR MEGA128"                              *
 *                                                                                             *
 *           Interface RGB LED by SPI (Hardware)  Speed SCK = 8 Mhz =125ns                     *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *
 * Target MCU     : ATMEL AVR-MEGA128                                                          *
 *                : X-TAL : 16 MHz                                                             * 
 *                                                                                             *
 * Editor         : AVR Studio 4.15 Build 623                                                  *
 * Compiler       : WinAVR-20081205                                                            *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                       *
 * Last Update    : 4/April/2014                                                               *
 *                                                                                             *
 *                                                                                             *
 * Port Interface :  ---- MCU-Mega128 ----                    ---- ET-iLED-RGB----             *
 *                                                                                             *
 *        SPI     :    PB2(MOSI-Out)            Connect                DI                      *
 *                     PB1(SCK-Out)             No Use                                         *
 *                     PB0(SS-Out)              No Use                                         *
 *                                                                                             *
 *                     SPI Clock SCK = 125 ns                                                  *
 *                                                                                             *
 ***********************************************************************************************/



#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay


/*#################################################################
 ##                                                              ##
 ##         Define Valu Data for Logic Code (High ,Low)          ##
 ##                                                              ##
 #################################################################*/


#define Logic_Low    0xC0            //Data Logic LOW (Pulse 1=250n[2bitx125ns] ,0=750ns[6bitx125ns] )
#define Logic_High   0xFC            //Data Logic High(Pulse 1=750n[6bitx125ns] ,0=250ns[2bitx125ns] )



/*#################################################################
 ##                                                              ##
 ##                        Define Variable                       ##
 ##                                                              ##
 #################################################################*/


#define  Num_LED    1                             // Number LED Serial Connect in Circuit
 
 
unsigned long LED_Buf[Num_LED]              ;     //Buffer Array LED Display for keep Data Color of LED All 



/*#################################################################
 ##                                                              ##
 ##                            Sub-program                       ##
 ##                                                              ##
 ##################################################################*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++
 ++                                                ++
 ++             1.Function:Delay(us)               ++
 ++++++++++++++++++++++++++++++++++++++++++++++++++++
 ++   Input :                                      ++
 ++           cnt = Time Delay  (us)               ++
 ++                                                ++
 ++++++++++++++++++++++++++++++++++++++++++++++++++++*/

 void delay_us(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_us(1);
  }


/*+++++++++++++++++++++++++++++++++++++++++++++++++++
 ++                                                ++
 ++             2.Function:Delay(ms)               ++
 ++++++++++++++++++++++++++++++++++++++++++++++++++++
 ++   Input :                                      ++
 ++           cnt = Time Delay  (ms)               ++
 ++                                                ++
 ++++++++++++++++++++++++++++++++++++++++++++++++++++*/

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }


 /*+++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                ++
  ++            3.Function:Initial Port             ++
  ++                                                ++ 
  ++++++++++++++++++++++++++++++++++++++++++++++++++++*/

 void Init_Port(void)
  {
    
   DDRB  = 0x07     ;        //Set PB2(DO),PB1(SCK),PB0(SS):Output (1=Out)
   PORTB = 0x00     ;        //Set default PB =0x00      
    
  
  //-------------- Initial SPI Module ----------------

   SPCR=0x5C       ;        // Enable,Bit MSB Transmittede First ,SPI bus as Master,devider(/2),CPOL:CPHA=1
   SPSR=0x01       ;        // Oscillator Freq (SCK)= Fosc/2 when Fosc= 16MHz,(0x01)
                      

  }


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                    ++
  ++                   4.Function:SPI Sent Data 8 bit                   ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                    ++
  ++    Clock SPI : 16MHz/2 = 8MHz = 1/8Mhz = 125 ns                    ++
  ++                                                                    ++
  ++    Input :                                                         ++
  ++            DataByte = Data 1 Byte for Build Logic High,Low 1 bit   ++                                         
  ++                                                                    ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void spi_wr(unsigned char DataByte)
 {
   SPDR = DataByte               ; //Write data to Buffer SPI Module 
   while ((SPSR&0x80) == 0) {;}    //Check Sent data to Buffer Ready
  
 }


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                   ++
  ++      5.Function :Write Data 1 Color 24 Bit GRB    ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                   ++
  ++     Input :  GRB = Color 24 bit GRB               ++
  ++                                                   ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void WrRGB_24Bit(unsigned long GRB)
 {
   unsigned char bt   ;

 //-------------------------Start Write Data RGB Color 24 bit -----------------------------
   
    for(bt=0;bt<24;bt++)              //Loop Write Data  1 Color 24 bit)
    {
      
       if(GRB & 0x80000000)           //Check Color 24 bit[32..16] Start Bit 32 
        {
          spi_wr(Logic_High)      ;   // Write bit data Color  Logic 1
        }
       else
        {
          spi_wr(Logic_Low)       ;   // Write bit data Color  Logic 0
          
        }      
      
        GRB = GRB <<1             ;  //Shift Left  bit data Color 1 bit
    
    } 

 }



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++    6.Function:Convert Data Color 24 bit RGB in Buffer LED All       ++
  ++               to GRB Color 32 bit                                  ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++   Valiable :                                                        ++
  ++             Num_LED = Number LED All at Connect Serial              ++       
  ++                                                                     ++
  ++             LED_Buf = Array Buffer of LED All for Keep Color GRB    ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void RGB_TO_GRB(void)
{
  unsigned int led      ; 
  unsigned long RGB,GRB ; 

   for(led=0;led<Num_LED;led++)         //Loop Read/Write Data Color from Buffer LED All
    { 
	     
     RGB    =  LED_Buf[led]         ;   //Read Code Color RGB from Buffer LED
     RGB  <<=  8                    ;   //Shift Left RGB Color bit [0..23]  to  RGB Color bit [31..16] 
 
     //----------- Exchange RGB Color to GRB Color follow Pattern Data color of WS2812B -----------

     GRB   = RGB & 0x0000FF00       ;   //Mark bit[15..8]   for Color Blue
         
     GRB  |= (RGB & 0x00FF0000)<<8  ;   //Mark bit[23..16]  for Color Green and Shift Left to bit[31..24]
  
     GRB  |= (RGB & 0xFF000000)>>8  ;   //Mark bit[31..24]  for Color Red and Shift Right to bit [23..16](GRB Color Ready)

     LED_Buf[led]  =  GRB           ;   //Keep Data Color GRB to LED_Buf[]
    }
}


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++        7. Function:Write Frame Color to LED All                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++   Valiable :                                                        ++
  ++             Num_LED = Number LED All at Connect Serial              ++       
  ++                                                                     ++
  ++             LED_Buf = Array Buffer of LED All keep Color GRB        ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


void Sent_Frame_Led(void)
 {
   unsigned int led  ; 
  

   RGB_TO_GRB()                       ;  // Chang RGB to GRB

   for(led=0;led<Num_LED;led++)
    { 
      WrRGB_24Bit(LED_Buf[led])       ; //Sent frame color all
    }

   delay_us(50)                       ; //Reset  Code
 }



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++                     8.Function:Clear LED All                        ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++       Input :                                                       ++
  ++               Clear_Color = Color RGB for Clear  LED                ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


void Clear_LED(long Clear_Color)
 {
   unsigned int array  ;  
 
    //---- Keep Data Color to LED Bufer ------

   for(array=0;array<Num_LED;array++)
    { 
      LED_Buf[array]  = Clear_Color      ; //Keep data Color Black to Buffer LED  
    }

   //---------- Sent Data to LED Display ------------  

    Sent_Frame_Led()                     ; //Update LED

 }



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++                    9.Function:Dimmer White Color                    ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++   Input :                                                           ++
  ++             dimColor = Color RGB for Dimmer by Select Use Ascii     ++
  ++                                                                     ++
  ++                        R: Dimmer Color Red                          ++ 
  ++                        G: Dimmer Color Green                        ++
  ++                        B: Dimmer Color Blue                         ++
  ++                        W: Dimmer Color White                        ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


void Dimmer_RGB(unsigned char dimColor)
 {
   unsigned int nm,array           ;
   unsigned long  R,G,B,RGB        ;

   R = 0x000000 ;
   G = 0x000000 ;
   B = 0x000000 ;

   RGB = R|G|B  ;  //Total Color 24 bit

   //----------Loop Dimmer Up ----------

   for(nm=0;nm<256;nm++)
	{

      //--- Keep Data Color to LED Bufer ------

       for(array=0;array<Num_LED;array++)
        { 
          LED_Buf[array]  = RGB                ; //Keep data Color Black to Buffer LED  
        }

       //---------- Sent Data to LED Display ------------  
        Sent_Frame_Led()                      ; //Update LED

        delay_ms(7)         ;                   //delay color Brighness
   
       //-------- Set Color Dimmer---------

       if(dimColor =='R')
         R = R+0x010000      ;  //Inclement Bit Color RGB for Dimmer Up
       if(dimColor =='G') 
	     G = G+0x000100      ;
	   if(dimColor =='B') 
	     B = B+0x000001      ;
       
	   if(dimColor =='W')
	    {
		 R = R+0x010000      ;  //Inclement Bit Color RGB for Dimmer Up
		 G = G+0x000100      ;
	     B = B+0x000001      ;
		} 


        RGB = R|G|B         ;

    }  //end
 
       //-------- Set Color Dimmer---------

       if(dimColor =='R')
         R = R-0x010000      ;  //Inclement Bit Color RGB for Dimmer Up
       if(dimColor =='G') 
	     G = G-0x000100      ;
	   if(dimColor =='B') 
	     B = B-0x000001      ;
       
	   if(dimColor =='W')
	    {
		 R = R-0x010000      ;  //Inclement Bit Color RGB for Dimmer Up
		 G = G-0x000100      ;
	     B = B-0x000001      ;
		} 

       RGB = R|G|B          ;

       delay_ms(100)        ;


  //----------- Loop Dimmer Down -----------
  
   for(nm=0;nm<256;nm++)
	{
       //--- Keep Data Color to LED Bufer ------

       for(array=0;array<Num_LED;array++)
       { 
        LED_Buf[array]  = RGB                ; //Keep data Color Black to Buffer LED  
       }

       //---------- Sent Data to LED Display ------------  
        Sent_Frame_Led()                    ; //Update LED
        
		delay_ms(7)         ;                 //delay color Brighness

        //-------- Set Color Dimmer---------
       if(dimColor =='R')
         R = R-0x010000      ;  //Inclement Bit Color RGB for Dimmer Up
       if(dimColor =='G') 
	     G = G-0x000100      ;
	   if(dimColor =='B') 
	     B = B-0x000001      ;
       
	   if(dimColor =='W')
	    {
		 R = R-0x010000      ;  //Inclement Bit Color RGB for Dimmer Up
		 G = G-0x000100      ;
	     B = B-0x000001      ;
		} 


        RGB = R|G|B    ;

	}

    
 }




/*##########################################################################
 ##                                                                       ##
 ##                            MAIN PROGRAM                               ##
 ##                                                                       ##
 ###########################################################################*/

int main(void)
 {

   Init_Port()        ;   
   delay_ms(200)      ;

   Clear_LED(0x000000)   ; //Display Clear LED 
                  
   while(1)
   {
     Dimmer_RGB('R')  ;
     delay_ms(200)    ;

	 Dimmer_RGB('G')  ;
     delay_ms(200)    ;

	 Dimmer_RGB('B')  ;
     delay_ms(200)    ;

	 Dimmer_RGB('W')  ;
     delay_ms(200)    ;
		  
   }
  

}
   
