


/*************************************************************************************************************
 *                                                                                                           *
 * Ex3.1-TFT43_Read Register Touch : GLCD_Touch Screen 480x272 (ET-TFT43-EVE) For "ET-BASE AVR MEGA128"      *
 *                                                                                                           *
 *                                   Interface GLCD Data SPI Software                                        *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 * Target MCU     : ATMEL AVR-MEGA128                                                                        *
 *                : X-TAL : 16 MHz                                                                           * 
 *                                                                                                           *
 * Editor         : AVR Studio 4.15 Build 623                                                                *
 * Compiler       : WinAVR-20081205                                                                          *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                     *
 * Last Update    : 17/February/2014                                                                         *
 *                                                                                                           *
 * Port Interface :  ---- MCU-Mega128 ----                    ---- ET-TFT43-EVE ----                         *
 *                                                                                                           *
 *      SPI       :                                                                                          *
 *                     PB0 (MISO-In)       Connect           MISO              [Pin0]                        *
 *                     PB1 (MOSI-Out)      Connect          MOSI              [Pin1]                         *
 *                     PB2 (SCK-Out)       Connect          SCK  (Ideal=Low)  [Pin2]                         *
 *                     PB3 (CS-Out)        Connect          CS#  (Active Low) [Pin3]                         *
 *                     PB4 (OUT))          Connect          PD#  (Power down) [Pin4]                         *
 *                     PB5 (IN)            Connect           INT# (Active=Low) [Pin5]                        *
 *                     PB6 (OUT)           Connect         SD_CS(Active=Low) [Pin6]                          *
 *                                                                                                           *
 *                                                                                                           *
 *     Output    : Display Value Register Touch Transform A,B,C,D,E,F                                        *
 *                 Use for Set Touch screen by not calibrate                                                 *
 *                                                                                                           *
 *************************************************************************************************************/



#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay




//********************* 1.Define-FT800 Memory Map Addresses *************************

#define RAM_CMD         0x108000     //Address Start Graphic Engine Command Buffer
#define RAM_DL          0x100000     //Address Start Display list ram


//**************** 2.Define-FT800 Command Memory Read/Write ********************

#define MEM_WRITE       0x80        // FT800 Host Memory Write 
#define MEM_READ        0x3F        // FT800 Host Memory Read


//*************** 3.Define-FT800 Register Address (0x102400-0x10257F) ******************

#define      REG_ID                   0x102400
#define      REG_FRAMES               0x102404
#define      REG_CLOCK                0x102408
#define      REG_FREQUENCY            0x10240C
#define      REG_RENDERMODE           0x102410
#define      REG_SNAPY                0x102414
#define      REG_SNAPSHOT             0x102418
#define      REG_CPURESET             0x10241C
#define      REG_TAP_CRC              0x102420
#define      REG_TAP_MASK             0x102424
#define      REG_HCYCLE               0x102428
#define      REG_HOFFSET              0x10242C
#define      REG_HSIZE                0x102430
#define      REG_HSYNC0               0x102434
#define      REG_HSYNC1               0x102438
#define      REG_VCYCLE               0x10243C
#define      REG_VOFFSET              0x102440
#define      REG_VSIZE                0x102444
#define      REG_VSYNC0               0x102448
#define      REG_VSYNC1               0x10244C
#define      REG_DLSWAP               0x102450
#define      REG_ROTATE               0x102454
#define      REG_OUTBITS              0x102458

#define      REG_DITHER               0x10245C
#define      REG_SWIZZLE              0x102460
#define      REG_CSPREAD              0x102464
#define      REG_PCLK_POL             0x102468
#define      REG_PCLK                 0x10246C
#define      REG_TAG_X                0x102470
#define      REG_TAG_Y                0x102474
#define      REG_TAG                  0x102478
#define      REG_VOL_PB               0x10247C
#define      REG_VOL_SOUND            0x102480
#define      REG_SOUND                0x102484
#define      REG_PLAY                 0x102488
#define      REG_GPIO_DIR             0x10248C
#define      REG_GPIO                 0x102490
#define      REG_INT_FLAGS            0x102498
#define      REG_INT_EN               0x10249C
#define      REG_INT_MASK             0x1024A0
#define      REG_PLAYBACK_START       0x1024A4
#define      REG_PLAYBACK_LENGTH      0x1024A8
#define      REG_PLAYBACK_READPTR     0x1024AC
#define      REG_PLAYBACK_FREQ        0x1024B0
#define      REG_PLAYBACK_FORMAT      0x1024B4
#define      REG_PLAYBACK_LOOP        0x1024B8

#define      REG_PLAYBACK_PLAY        0x1024BC
#define      REG_PWM_HZ               0x1024C0
#define      REG_PWM_DUTY             0x1024C4
#define      REG_MACRO_0              0x1024C8
#define      REG_MACRO_1              0x1024CC
#define      REG_CMD_READ             0x1024E4
#define      REG_CMD_WRITE            0x1024E8
#define      REG_CMD_DL               0x1024EC
#define      REG_TOUCH_MODE           0x1024F0
#define      REG_TOUCH_ADC_MODE       0x1024F4
#define      REG_TOUCH_CHARGE         0x1024F8
#define      REG_TOUCH_SETTLE         0x1024FC
#define      REG_TOUCH_OVERSAMPLE     0x102500
#define      REG_TOUCH_RZTHRESH       0x102504
#define      REG_TOUCH_RAW_XY         0x102508
#define      REG_TOUCH_RZ             0x10250C
#define      REG_TOUCH_SCREEN_XY      0x102510
#define      REG_TOUCH_TAG_XY         0x102514
#define      REG_TOUCH_TAG            0x102518
#define      REG_TOUCH_TRANSFORM_A    0x10251C

#define      REG_TOUCH_TRANSFORM_B    0x102520
#define      REG_TOUCH_TRANSFORM_C    0x102524
#define      REG_TOUCH_TRANSFORM_D    0x102528
#define      REG_TOUCH_TRANSFORM_E    0x10252C
#define      REG_TOUCH_TRANSFORM_F    0x102530
#define      REG_TOUCH_DIRECT_XY      0x102574
#define      REG_TOUCH_DIRECT_Z1Z2    0x102578
#define      REG_TRACKER              0x109000


/************************************************************************ 
 **                                                                    **
 **                4.Define-FT800 Host Commands                        **
 **                                                                    **
 **  -Use by FT800_HostCmdWrite(). Write Control to FT800              **
 **                                                                    **
 ************************************************************************/

//Group Power Mode

#define FT800_ACTIVE    0x00         // Initializes FT800
#define FT800_STANDBY   0x41         // Place FT800 in Standby (clk running)
#define FT800_SLEEP     0x42         // Place FT800 in Sleep (clk off)
#define FT800_PWRDOWN   0x50         // Place FT800 in Power Down (core off)

//Group Clock Switch

#define FT800_CLKEXT    0x44         // Select external clock source
#define FT800_CLK48M    0x62         // Select 48MHz PLL
#define FT800_CLK36M    0x61         // Select 36MHz PLL

//Group Miscellaneous

#define FT800_CORERST   0x68         // Reset core - all registers default


/*************************************************************************** 
 **                                                                       **
 **           5.Define-FT800 Display list commands(DL-CMD)                **
 **                                                                       **
 **  -Use by FT800memWritexx()/FT800memReadxx().Write to Ram-DL           **
 **                                                                       **
 ***************************************************************************/

#define DL_ALPHA_FUNC       0x09000000 // requires OR'd arguments
#define DL_BITMAP_HANDLE    0x05000000 // requires OR'd arguments
#define DL_BITMAP_LAYOUT    0x07000000 // requires OR'd arguments
#define DL_BITMAP_SIZE      0x08000000 // requires OR'd arguments
#define DL_BITMAP_SOURCE    0x01000000 // requires OR'd arguments
#define DL_BITMAP_TFORM_A   0x15000000 // requires OR'd arguments
#define DL_BITMAP_TFORM_B   0x16000000 // requires OR'd arguments
#define DL_BITMAP_TFORM_C   0x17000000 // requires OR'd arguments
#define DL_BITMAP_TFORM_D   0x18000000 // requires OR'd arguments
#define DL_BITMAP_TFORM_E   0x19000000 // requires OR'd arguments
#define DL_BITMAP_TFORM_F   0x1A000000 // requires OR'd arguments
#define DL_BLEND_FUNC       0x0B000000 // requires OR'd arguments
#define DL_BEGIN            0x1F000000 // requires OR'd arguments
#define DL_CALL             0x1D000000 // requires OR'd arguments
#define DL_CLEAR            0x26000000 // requires OR'd arguments
#define DL_CELL             0x06000000 // requires OR'd arguments
#define DL_CLEAR_RGB        0x02000000 // requires OR'd arguments
#define DL_CLEAR_STENCIL    0x11000000 // requires OR'd arguments
#define DL_CLEAR_TAG        0x12000000 // requires OR'd arguments
#define DL_COLOR_A          0x0F000000 // requires OR'd arguments
#define DL_COLOR_MASK       0x20000000 // requires OR'd arguments
#define DL_COLOR_RGB        0x04000000 // requires OR'd arguments
#define DL_DISPLAY          0x00000000
#define DL_END              0x21000000
#define DL_JUMP             0x1E000000 // requires OR'd arguments
#define DL_LINE_WIDTH       0x0E000000 // requires OR'd arguments
#define DL_MACRO            0x25000000 // requires OR'd arguments
#define DL_POINT_SIZE       0x0D000000 // requires OR'd arguments
#define DL_RESTORE_CONTEXT  0x23000000
#define DL_RETURN           0x24000000
#define DL_SAVE_CONTEXT     0x22000000
#define DL_SCISSOR_SIZE     0x1C000000 // requires OR'd arguments
#define DL_SCISSOR_XY       0x1B000000 // requires OR'd arguments
#define DL_STENCIL_FUNC     0x0A000000 // requires OR'd arguments
#define DL_STENCIL_MASK     0x13000000 // requires OR'd arguments
#define DL_STENCIL_OP       0x0C000000 // requires OR'd arguments
#define DL_TAG              0x03000000 // requires OR'd arguments
#define DL_TAG_MASK         0x14000000 // requires OR'd arguments
#define DL_VERTEX2F         0x40000000 // requires OR'd arguments
#define DL_VERTEX2II        0x80000000 // requires OR'd arguments


/******************************************************************************
 **                                                                          **
 **           6.Define-FT800 Co-Processor Engine Commands(CO-CMD)            **
 **                                                                          **
 **         -Use by FT800memWritexx()/FT800memReadxx().Write to Ram-CMD      **
 **                                                                          **
 ******************************************************************************/

#define    CMD_APPEND            0xFFFFFF1E    //Append memory to display list
#define    CMD_BGCOLOR           0xFFFFFF09    //Set the background color
#define    CMD_BUTTON            0xFFFFFF0D    //Draw a button
#define    CMD_CALIBRATE         0xFFFFFF15    //Execute the touch screen calibration routine
#define    CMD_CLOCK             0xFFFFFF14    //Draw an analog clock
#define    CMD_COLDSTART         0xFFFFFF32    //Set co-processor engine state to default values
#define    CMD_DIAL              0xFFFFFF2D    //Draw a rotary dial control
#define    CMD_DLSTART           0xFFFFFF00    //Start a new display list
#define    CMD_FGCOLOR           0xFFFFFF0A    //Set the foreground color
#define    CMD_GAUGE             0xFFFFFF13    //Draw a gauge
#define    CMD_GETMATRIX         0xFFFFFF33    //Retrieves the current matrix coefficients
#define    CMD_GETPTR            0xFFFFFF23    //Get the end memory address of inflated data
#define    CMD_GRADCOLOR         0xFFFFFF34    //Set the 3D Button highlight color
#define    CMD_GRADIENT          0xFFFFFF0B    //Draw a smooth color gradient
#define    CMD_INFLATE           0xFFFFFF22    //Decompress data into memory
#define    CMD_INTERRUPT_TRIG    0xFFFFFF02    //Trigger interrupt INT_CMDFLAG
#define    CMD_KEYS              0xFFFFFF0E    //Draw a row of keys
#define    CMD_LOADIDENTITY      0xFFFFFF26    //Set the current matrix to the identity matrix
#define    CMD_LOADIMAGE         0xFFFFFF24    //Load a JPEG image
#define    CMD_LOGO              0xFFFFFF31    //Play FTDI logo animation
#define    CMD_MEMCPY            0xFFFFFF1D    //Copy a block of memory
#define    CMD_MEMCRC            0xFFFFFF18    //Compute a CRC-32 for memory
#define    CMD_MEMSET            0xFFFFFF1B    //Fill memory with a byte value
#define    CMD_MEMWRITE          0xFFFFFF1A    //Write bytes into memory
#define    CMD_MEMZERO           0xFFFFFF1C    //Write zero to a block of memory
#define    CMD_NUMBER            0xFFFFFF2E    //Draw a decimal number 
#define    CMD_PROGRESS          0xFFFFFF0F    //Draw a process bar
#define    CMD_REGREAD           0xFFFFFF19    //Read a register value
#define    CMD_ROTATE            0xFFFFFF29    //Apply a rotation to the current matrix
#define    CMD_SCALE             0xFFFFFF28    //Apply a scale to the current matrix
#define    CMD_SCREENSAVER       0xFFFFFF2F    //Start an animated screensaver
#define    CMD_SCROLLBAR         0xFFFFFF11    //Draw a scroll bar
#define    CMD_SETFONT           0xFFFFFF2B    //Set up a custom font 
#define    CMD_SETMATRIX         0xFFFFFF2A    //Write the current matrix to the display list
#define    CMD_SKETCH            0xFFFFFF30    //Start a continuous sketch update
#define    CMD_SLIDER            0xFFFFFF10    //Draw a slider
#define    CMD_SNAPSHOT          0xFFFFFF1F    //Take a snapshot of the current screen
#define    CMD_SPINNER           0xFFFFFF16    //Start an animated spinner
#define    CMD_STOP              0xFFFFFF17    //Stop an of spinner, screensaver or sketch
#define    CMD_SWAP              0xFFFFFF01    //Swap the current display list
#define    CMD_TEXT              0xFFFFFF0C    //Draw text
#define    CMD_TOGGLE            0xFFFFFF12    //Draw a toggle switch
#define    CMD_TRACK             0xFFFFFF2C    //Track touches for a graphics object
#define    CMD_TRANSLATE         0xFFFFFF27    //Apply a translation to the current matrix

#define    CMD_IDCT              0xFFFFFF06
#define    CMD_MARCH             0xFFFFFF05
#define    CMD_TOUCH_TRANSFORM   0xFFFFFF20 
#define    CMD_BITMAP_TRANSFORM  0xFFFFFF21
#define    CMD_CRC               0xFFFFFF03
#define    CMD_EXECUTE           0xFFFFFF07 
#define    CMD_GETPOINT          0xFFFFFF08
#define    CMD_GETPROPS          0xFFFFFF25
#define    CMD_HAMMERAUX         0xFFFFFF04 



//*********** 7.Data Parameter Option of DL-CMD,Co-CMD and Register *************

#define CLR_COL              0x4
#define CLR_STN              0x2
#define CLR_TAG              0x1
#define DECR                 4
#define DECR_WRAP            7
#define DLSWAP_DONE          0
#define DLSWAP_FRAME         2
#define DLSWAP_LINE          1
#define DST_ALPHA            3
#define EDGE_STRIP_A         7
#define EDGE_STRIP_B         8
#define EDGE_STRIP_L         6
#define EDGE_STRIP_R         5
#define EQUAL                5
#define GEQUAL               4
#define GREATER              3
#define INCR                 3
#define INCR_WRAP            6
#define INT_CMDEMPTY         32
#define INT_CMDFLAG          64
#define INT_CONVCOMPLETE     128
#define INT_PLAYBACK         16
#define INT_SOUND            8
#define INT_SWAP             1
#define INT_TAG              4
#define INT_TOUCH            2
#define INVERT               5
#define KEEP                 1
#define L1                   1
#define L4                   2
#define L8                   3
#define LEQUAL               2
#define LESS                 1
#define LINEAR_SAMPLES       0
#define LINES                3
#define LINE_STRIP           4
#define NEAREST              0
#define NEVER                0
#define NOTEQUAL             6
#define ONE                  1
#define ONE_MINUS_DST_ALPHA  5
#define ONE_MINUS_SRC_ALPHA  4
#define OPT_CENTER           1536    // 0x6000
#define OPT_CENTERX          512     // 0x0200
#define OPT_CENTERY          1024    // 0x0400
#define OPT_FLAT             256     // 0x0100
#define OPT_MONO             1
#define OPT_NOBACK           4096    // 0x1000
#define OPT_NODL             2
#define OPT_NOHANDS          49152   // 0xC168
#define OPT_NOHM             16384   // 0x4000
#define OPT_NOPOINTER        16384   // 0x4000
#define OPT_NOSECS           32768   // 0x8000
#define OPT_NOTICKS          8192    // 0x2000
#define OPT_RIGHTX           2048    // 0x0800
#define OPT_SIGNED           256     // 0x0100
#define PALETTED             8
#define PLAYCOLOR            0x00A0A080
#define FTPOINTS             2       // "POINTS" is a reserved word
#define RECTS                9
#define REPEAT               1
#define REPLACE              2
#define RGB332               4
#define RGB565               7
#define SRC_ALPHA            2
#define TEXT8X8              9
#define TEXTVGA              10
#define TOUCHMODE_CONTINUOUS 3
#define TOUCHMODE_FRAME      2
#define TOUCHMODE_OFF        0
#define TOUCHMODE_ONESHOT    1
#define ULAW_SAMPLES         1
#define ZERO                 0
#define BITMAPS              1



//***************** 8.Define Color RGB 24 bit *******************


#define      AliceBlue            0xF0F8FF
#define      AntiqueWhite         0xFAEBD7
#define      Aquamarine           0x7FFFD4
#define      Azure                0xF0FFFF
#define      Beige                0xF5F5DC
#define      Bisque               0xFFFAF0
#define      Black                0x000000
#define      BlanchedAlmond       0xFFEBCD
#define      Blue                 0x0000FF
#define      BlueViolet           0x8A2BE2
#define      Brown                0xA52A2A
#define      Burlywood            0xDEB887
#define      CadetBlue            0x5F9EA0
#define      Chartreuse           0x7FFF00
#define      Chocolate            0xD2691E
#define      Coral                0xFF7F50
#define      CornflowerBlue       0x6495ED
#define      Cornsilk             0xFFF8DC
#define      Cyan                 0x00FFFF
#define      DarkGoldenrod        0xB8860B
#define      DarkGreen            0x006400
#define      DarkKaki             0xBDB76B
#define      DarkOliveGreen       0x556B2F
#define      DarkOrange           0xFF8C00
#define      DarkOrchid           0x9932CC
#define      DarkSalmon           0xE9967A
#define      DarkSeaGreen         0x8FBC8F
#define      DarkSlateBlue        0x483D8B
#define      DarkSlateGray        0x2F4F4F
#define      DarkTurquoise        0x00CED1
#define      DarkViolet           0x9400D3
#define      DeepPink             0xFF1493
#define      DeepSkyBlue          0x00BFFF
#define      DimGrey              0x696969
#define      DodgeBlue            0x1E90FF
#define      Firebrick            0xB22222
#define      FloralWhite          0xFFFAF0
#define      ForestGreen          0x228B22
#define      Gainsboro            0xDCDCDC
#define      GhostWhite           0xF8F8FF
#define      Gold                 0xFFD700
#define      Goldenrod            0xDAA520
#define      Gray                 0xBEBEBE
#define      Green                0x00FF00
#define      GreenYellow          0xADFF2F
#define      Honeydew             0xF0FFF0
#define      HotPink              0xFF69B4
#define      IndianRed            0xCD5C5C
#define      LtGoldenrodYellow    0xFAFAD2
#define      Ivory                0xFFFFF0
#define      lavender             0xE6E6FA
#define      Lavender Blush       0xFFF0F5
#define      LawnGreen            0x7CFC00
#define      LemonChiffon         0xFFFACD
#define      LightBlue            0xADD8E6
#define      LightCoral           0xF08080
#define      LightCyan            0xE0FFFF
#define      LightGoldenrod       0xEEDD82
#define      LightGray            0xD3D3D3
#define      LightPink            0xFFB6C1
#define      LightSeaGreen        0x20B2AA
#define      LightSkyBlue         0x87CEFA
#define      LightSalmon          0xFFA07A
#define      LightSlateBlue       0x8470FF
#define      LightSlateGray       0x778899
#define      LightSteelBlue       0xB0C4DE
#define      LightYellow          0xFFFFE0
#define      LimeGreen            0x32CD32
#define      Linen                0xFAF0E6
#define      Magenta              0xFF00FF
#define      Maroon               0xB03060
#define      MediumAquamarine     0x66CDAA
#define      MediumBlue           0x0000CD
#define      MediumOrchid         0xBA55D3
#define      MediumPurple         0x9370DB
#define      MediumSeaGreen       0x3CB371
#define      MediumSlateBlue      0x7B68EE
#define      MediumTurquoise      0x48D1CC
#define      MediumVioletRed      0xC71585
#define      MedSpringGreen       0x00FA9A
#define      MidnightBlue         0x191970
#define      MintCream            0xF5FFFA
#define      MistyRose            0xFFE4E1
#define      Moccasin             0xFFE4B5
#define      NavyBlue             0x000080
#define      NavajoWhite          0xFFDEAD
#define      OldLace              0xFDF5E6
#define      OliveDrab            0x6B8E23
#define      Orange               0xFFA500
#define      OrangeRed            0xFF4500
#define      Orchid               0xDA70D6
#define      PaleGoldenrod        0xEEE8AA
#define      PaleGreen            0x98FB98
#define      PaleTurquoise        0xAFEEEE
#define      PaleVioletRed        0xDB7093
#define      PapayaWhip           0xFFEFD5
#define      PeachPuff            0xFFDAB9
#define      Peru                 0xCD853F
#define      Pink                 0xFFc0CB
#define      Plum                 0xDDA0DD
#define      PowderBlue           0xB0E0E6
#define      Purple               0xA020F0
#define      Red                  0xFF0000
#define      RosyBrown            0xBC8F8F
#define      RoyalBlue            0x4169E1
#define      Salmon               0xFA8072
#define      SaddleBrown          0x8B4513
#define      SandyBrown           0xF4A460
#define      SeaGreen             0x2E8B57
#define      Seashell             0xFFF5EE
#define      Sienna               0xA0522D
#define      SkyBlue              0x87CEEB
#define      SlateBlue            0x6A5ACD
#define      SlateGrey            0x708090
#define      Snow                 0xFFFAFA
#define      SpringGreen          0x00FF7F
#define      SteelBlue            0x4682B4
#define      Tan                  0xD2B48C
#define      Tomato               0xFF6347   
#define      Thistle              0xD8BFD8
#define      Turquoise            0x40E0D0
#define      Violet               0xEE82EE
#define      Wheat                0xF5DEB3
#define      White                0xFFFFFF
#define      WhiteSmoke           0xF5F5F5
#define      Yellow               0xFFFF00
#define      YellowGreen          0x9ACD32
#define      VioletRed            0xD02090



//***************** 9.Define Sound Effect ,Use with REG_SOUND 8 bit Low  *******************
                                     
                                      /* Continuous / Pitch adjus midi */    
                              
#define      Silence         0x00    //       yes    /        no          :No-sound
#define      SquareWave      0x01    //       yes    /        yes        
#define      SineWave        0x02    //       yes    /        yes       
#define      SawtoothWave    0x03    //       yes    /        yes        
#define      TriangleWave    0x04    //       yes    /        yes        
#define      Beeping         0x05    //       yes    /        yes 
#define      Alarm           0x06    //       yes    /        yes 
#define      Warble          0x07    //       yes    /        yes 
#define      Carousel        0x08    //       yes    /        yes 
#define      Short1Pip       0x10    //       no     /        yes   
#define      Short2Pips      0x11    //       no     /        yes  
#define      Short3Pips      0x12    //       no     /        yes  
#define      Short4Pips      0x13    //       no     /        yes  
#define      Short5Pips      0x14    //       no     /        yes  
#define      Short6Pips      0x15    //       no     /        yes  
#define      Short7Pips      0x16    //       no     /        yes  
#define      Short8Pips      0x17    //       no     /        yes  
#define      Short9Pips      0x18    //       no     /        yes  
#define      Short10Pips     0x19    //       no     /        yes  
#define      Short11Pips     0x1A    //       no     /        yes  
#define      Short12Pips     0x1B    //       no     /        yes  
#define      Short13Pips     0x1C    //       no     /        yes  
#define      Short14Pips     0x1D    //       no     /        yes  
#define      Short15Pips     0x1E    //       no     /        yes  
#define      Short16Pips     0x1F    //       no     /        yes  
#define      DTMF_shap       0x23    //       yes    /        no  
#define      DTMF_star       0x2A    //       yes    /        no  
#define      DTMF0           0x30    //       yes    /        no  
#define      DTMF1           0x31    //       yes    /        no  
#define      DTMF2           0x32    //       yes    /        no  
#define      DTMF3           0x33    //       yes    /        no  
#define      DTMF4           0x34    //       yes    /        no  
#define      DTMF5           0x35    //       yes    /        no  
#define      DTMF6           0x36    //       yes    /        no  
#define      DTMF7           0x37    //       yes    /        no  
#define      DTMF8           0x38    //       yes    /        no  
#define      DTMF9           0x39    //       yes    /        no  
#define      Harp            0x40    //       no     /        yes  
#define      Xylophone       0x41    //       no     /        yes  
#define      Tuba            0x42    //       no     /        yes  
#define      Glockenspiel    0x43    //       no     /        yes  
#define      Organ           0x44    //       no     /        yes  
#define      Trumpet         0x45    //       no     /        yes  
#define      Piano           0x46    //       no     /        yes  
#define      Chimes          0x47    //       no     /        yes  
#define      MusicBox        0x48    //       no     /        yes  
#define      Bell            0x49    //       no     /        yes  
#define      Click           0x50    //       no     /        yes  
#define      Switch          0x51    //       no     /        yes  
#define      Cowbell         0x52    //       no     /        yes  
#define      Notch           0x53    //       no     /        yes  
#define      Hihat           0x54    //       no     /        yes  
#define      Kickdrum        0x55    //       no     /        yes  
#define      Pop             0x56    //       no     /        yes  
#define      Clack           0x57    //       no     /        yes  
#define      Chack           0x58    //       no     /        yes  
#define      Mute            0x60    //       no     /        yes  
#define      Unmute          0x61    //       no     /        yes  



//***************** 10.Define MIDI Note Effect ,Use with REG_SOUND 8 bit High  *******************

                              /* Freq (Hz)*/

#define      midC       0        //Level MiddelC
#define      A0        21        //27.5   
#define      A_0       22        //29.1
#define      B0        23        //30.9
#define      C1        24        //32.7
#define      C_1       25        //34.6
#define      D1        26        //36.7
#define      D_1       27        //38.9
#define      E1        28        //41.2
#define      F1        29        //43.7
#define      F_1       30        //46.2
#define      G1        31        //49.0
#define      G_1       32        //51.9
#define      A1        33        //55.0
#define      A_1       34        //58.3
#define      B1        35        //61.7
#define      C2        36        //65.4
#define      C_2       37         //69.3
#define      D2        38        //73.4
#define      D_2       39        //77.8
#define      E2        40        //82.4
#define      F2        41        //87.3
#define      F_2       42        //92.5
#define      G2        43        //98.0
#define      G_2       44        //103.8
#define      A2        45        //110.0
#define      A_2       46        //116.5
#define      B2        47        //123.5
#define      C3        48        //130.8
#define      C_3       49        //138.6
#define      D3        50        //146.8
#define      D_3       51        //155.6
#define      E3        52        //164.8
#define      F3        53        //174.6
#define      F_3       54        //185.0
#define      G3        55        //196.0
#define      G_3       56        //207.7
#define      A3        57        //220.0
#define      A_3       58        //233.1
#define      B3        59        //246.9
#define      C4        60        //261.6
#define      C_4       61        //277.2
#define      D4        62        //293.7
#define      D_4       63        //311.1
#define      E4        64        //329.6
#define      F4        65        //349.2
#define      F_4       66        //370.0
#define      G4        67        //392.0
#define      G_4       68        //415.3
#define      A4        69        //440.0
#define      A_4       70        //466.2
#define      B4        71        //493.9
#define      C5        72        //523.3
#define      C_5       73        //554.4
#define      D5        74        //587.3
#define      D_5       75        //622.3
#define      E5        76        //659.3
#define      F5        77        //698.5
#define      F_5       78        //740.0
#define      G5        79        //784.0
#define      G_5       80        //830.6
#define      A5        81        //880.0
#define      A_5       82        //932.3
#define      B5        83        //987.8
#define      C6        84        //1046.5
#define      C_6       85        //1108.7
#define      D6        86        //1174.7
#define      D_6       87        //1244.5
#define      E6        88        //1318.5
#define      F6        89        //1396.9
#define      F_6       90        //1480.0
#define      G6        91        //1568.0
#define      G_6       92        //1661.2
#define      A6        93        //1760.0 
#define      A_6       94        //1864.7
#define      B6        95        //1975.5
#define      C7        96        //2093.0
#define      C_7       97        //2217.5
#define      D7        98        //2349.3
#define      D_7       99        //2489.0
#define      E7       100        //2637.0
#define      F7       101        //2793.8
#define      F_7      102        //2960.0
#define      G7       103        //3136.0
#define      G_7      104        //3322.4
#define      A7       105        //3520.0
#define      A_7      106        //3729.3
#define      B7       107        //3951.1
#define      C8       108        //4186.0



/*#################################################################
 ##                                                              ##
 ##                        Define Variable                       ##
 ##                                                              ##
 #################################################################*/


unsigned int DL_Offset   = 0x0000;          //Offset Address Pointer of display list memory 
unsigned int cmdOffset   = 0x0000;          //Offset Address Pointer of Command Buffer memmory

unsigned int cmdBufferRd = 0x0000;          //Used to navigate command ring buffer
unsigned int cmdBufferWr = 0x0000;          //Used to navigate command ring buffer

unsigned char ft800Gpio          ;          //Used for FT800 GPIO register

unsigned char num_cha            ;          //keep Number Print Text 


//---------------- Valiable Application -----------------

 unsigned int intA,intB,intC,intD,intE,intF,fracA,fracB,fracC,fracD,fracE,fracF  ;


 char  sig_A[2]  = {" "} ; 
 char  int_A[6]  = {" "} ;
 char  frac_A[6] = {" "} ;

 char  sig_B[2]  = {" "} ; 
 char  int_B[6]  = {" "} ;
 char  frac_B[6] = {" "} ;

 char  sig_C[2]  = {" "} ; 
 char  int_C[6]  = {" "} ;
 char  frac_C[6] = {" "} ;

 char  sig_D[2]  = {" "} ; 
 char  int_D[6]  = {" "} ;
 char  frac_D[6] = {" "} ;

 char  sig_E[2]  = {" "} ; 
 char  int_E[6]  = {" "} ;
 char  frac_E[6] = {" "} ;

 char  sig_F[2]  = {" "} ; 
 char  int_F[6]  = {" "} ;
 char  frac_F[6] = {" "} ;

  
/*#################################################################
 ##                                                              ##
 ##              Define Function Sub-program                     ##
 ##                                                              ##
 ##################################################################*/

                               

/****************************************************************
 **                                                            **
 **    1.Function-About Manage Hardware/Software of MCU        **
 **                                                            **     
 ****************************************************************/

void delay_ms(unsigned int cnt)    ;
void init_port(void)               ;



/***********************************************************************************
 **                                                                               **
 **         2. Function-About Software SPI Read/Write 8 bit (PB0-PB6)             **
 **                                                                               **
 ***********************************************************************************/

void spi_sck_hi(void)             ;
void spi_sck_lo(void)             ;
void spi_cs_hi(void)              ;
void spi_cs_lo(void)              ;
void spi_sdo_hi(void)             ;
void spi_sdo_lo(void)             ;
unsigned char spi_rw(unsigned char Db)   ;



/*******************************************************************************
 **                                                                           **
 **                       3.Function- About Write FT800                       **
 **                                                                           **
 *******************************************************************************/

//-------------- Function-FT800 Power-Down[PB4] ------------------ 

void FT800_PD_hi(void)            ;
void FT800_PD_lo(void)            ;   //Set Power Down FT800

//------------Function-Write Register,Ram-DL,Ram-CMD (Address[22bit] and Data Parameter 8,16,32 bit)---------

void FT800memWrite8(unsigned long addr,unsigned char data8)     ;
void FT800memWrite16(unsigned long addr,unsigned int data16)    ;
void FT800memWrite32(unsigned long addr,unsigned long data32)   ;

//-------------Function-Write Address Ram-CMD and Data Text-String -----------------

void FT800memWriteStr(unsigned long addr,char *str)             ;  //Command for Write Address + Text-String 


//------------ Function-Write Host Command  (Command[6-bit]+0x00+0x00)-------------

void FT800_HostCmdWrite(unsigned char Command)                  ;




/*******************************************************************************
 **                                                                           **
 **                         4.Function-About Read FT800                       **
 **                                                                           **
 *******************************************************************************/


//------------Function-Read Register,Ram-DL,RAm-CMD (Address[22bit] + Data Parameter 8,16,32 bit)---------

unsigned char FT800memRead8(unsigned long addr)                 ;
unsigned int  FT800memRead16(unsigned long addr)                ;
unsigned long FT800memRead32(unsigned long addr)                ; 




/***********************************************************************************
 **                                                                               **
 **           5.Function-About Manage memory address FT800 Ring Buffer            **              
 **                                                                               **
 ***********************************************************************************/


//----------- Function-Increment Address Offset Pointer for Ram-CMD --------------

unsigned int incCMDOffset(unsigned int currentOffset,unsigned char commandSize)     ; 
unsigned int End_incCMDOffset(unsigned int currentOffset,unsigned char commandSize) ; //Use when end Co-Processor CMD 

//-------- Function-Start Offset pointer & Waite Co-Processor CMD Finish executing -------------

void Start_CMDOffset(void) ;



/*************************************************************************************
 **                                                                                 **
 **                         6.Function-About Touch Screen                           **
 **                                                                                 **
 *************************************************************************************/

void Touch_Calibrate(void) ;


/*************************************************************************************
 **                                                                                 **
 **                         7.Function-About FT800 DL-CMD,Co-CMD                    **
 **                                                                                 **
 *************************************************************************************/



void Start_CMDList(long screen_color);
void End_CMDList(void)               ;
void Text_CMD(char *str,int x,int y,int font,int opt,long tx_color)   ;




/*************************************************************************************
 **                                                                                 **
 **                       8.Function-About User Application                         **
 **                                                                                 **
 *************************************************************************************/

void FT800_Initial(void)   ;
void Conv_hex_to_Ascii()   ;
void User_App(void)        ;
void Update_Screen(char *sigA,char *sigB,char *sigC,char *sigD,char *sigE,char *sigF,
                   char *valA,char *valB,char *valC,char *valD,char *valE,char *valF,
                   char *facA,char *facB,char *facC,char *facD,char *facE,char *facF) ;



/*##########################################################################
 ##                                                                       ##
 ##                            MAIN PROGRAM                               ##
 ##                                                                       ##
 ###########################################################################*/

int main(void)
 {
  
   init_port()        ;
   FT800_Initial()   ;
   Touch_Calibrate() ;
   delay_ms(100)     ;
   User_App()        ;

}
    


/*################################################################################
  ##                                                                            ##
  ##                          Function SUB-PROGRAM                              ##
  ##                                                                            ##
  ################################################################################ */

 

/*****************************************************************************
 **                                                                         **
 **            1.Function-About Manage Hardware/Software of MCU             **
 **                                                                         **     
 *****************************************************************************/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++
 ++                                                ++
 ++            1.1) Function-Delay(ms)             ++
 ++                                                ++
 +++++++++++++++++++++++++++++++++++++++++++++++++++*/

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }


 /*+++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                ++
  ++         1.2) Function-Initial Port             ++
  ++                                                ++ 
  +++++++++++++++++++++++++++++++++++++++++++++++++++*/

 void init_port(void)
  {

   DDRB  = 0x5E     ;        //Set PB1[MOSI],PB2[SCK],PB3[CS],PB4[PD#],PB6[SD_CS] = Output ; PB0[MISO],PB5(INT)=Input
   
   //------ Set Value Default Port ------ 
         
   PORTB = 0x7B     ;       //Set Default Port PB0(MISO),PB5(INT) = 1(Pull Up) ,PB4(PD)=1(Disable Power down),PB3(CS)=1, 
                            //                 PB2(SCK)=0,PB1(MOSI)=1 ,PB6(SD_CS) =1  

  }



/***********************************************************************************
 **                                                                               **
 **         2. Function-About Software SPI Read/Write 8 bit (PB0-PB6)             **
 **                                                                               **
 ***********************************************************************************/


//++++++++++++++++ Data MOSI [PB1] ++++++++++++++++++

void spi_sdo_hi(void)
 {
   sbi(PORTB,1) ;        //PB1 =1
 }

void spi_sdo_lo(void)
 {
  cbi(PORTB,1)  ;        //PB1 =0
 }


//+++++++++++++++++ SCK [PB2] ++++++++++++++++++++++

void spi_sck_hi(void)
 {
   sbi(PORTB,2) ;        //PB2 =1
 }

void spi_sck_lo(void) 
 {
   cbi(PORTB,2) ;        //PB2 =0 (Ideal)
 }


//+++++++++++++++++ CS [PB3] ++++++++++++++++++++++

 void spi_cs_hi(void)
 {
   sbi(PORTB,3)  ;       //PB3 =1
 }

void spi_cs_lo(void)
 {
   cbi(PORTB,3) ;        //PB3 =0 (Active)
 }



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 ++                                                                                   ++
 ++                  2.1) Function-SPI Read/Write Data 1 Byte                         ++
 ++                                                                                   ++
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 ++   Input :                                                               ++
 ++           Db = Data or Cmmand  1 Byte (Send data most significant bit first)      ++
 ++                                                                                   ++
 ++   Output:                                                                         ++
 ++           result = Return data 1 byte Pass Function                               ++
 ++                                                                                   ++
 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


unsigned char spi_rw(unsigned char Db)              
{
  unsigned char bt,result=0;                   

     for(bt=0;bt<8;bt++)                     //Loop read/write 8 bit
      {      
      
      //--------- Write Data(PB1) ---------

      if((Db & 0x80)== 0x80)
         spi_sdo_hi()                  ;   //Set bit data(PB1) = 1
      else
         spi_sdo_lo()                  ;    //Clear bit data(PB1) = 0

       
       spi_sck_hi()                     ;    //Start Clock  High (active rise edge) 
     
        //---------- Read Data(PB0) -------
        
       result <<= 1                     ;    //Shift data read to MSB bit  
       if((PINB & 0x01)== 0x01)             //If SDI = "1"                  
        {
          result |= 0x01                ;   //Keep Result of Read-data                             
        }

       Db  <<= 1                        ;    //Shift Next Bit Data   
   
       spi_sck_lo()                     ;   //Clock low        

     }

     return result                      ;
}





/*******************************************************************************
 **                                                                           **
 **                       3.Function- About Write FT800                       **
 **                                                                           **
 *******************************************************************************/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                         ++
  ++                   3.1) Function-FT800 Power-Down[PB4]                   ++
  ++                                                                         ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void FT800_PD_hi(void)
{
   sbi(PORTB,4)       ;   //PB4=1:Disable Power-Down FT800
}


void FT800_PD_lo(void)
{
    cbi(PORTB,4)       ;   //PB4=0:Enable Power-Down FT800
}


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                         ++
  ++          3.2) Function-Write Register,Ram-DL,Ram-CMD +Data              ++
  ++                                                                         ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++ Input:                                                                  ++
  ++         addr    = FT800 memory space address Ram-DL,Ram-CMD,Reg.        ++
  ++                                                                         ++
  ++         dataxx  = Data for Co-CMD,DL-CMD or Reg.                        ++
  ++                                                                         ++
  ++ Overview:         Writes FT800 internal address space                   ++
  ++ Note:             "xx" is data of 8, 16 or 32 bit                       ++
  ++                                                                         ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


//++++++++++++++ Function-Write Address Register,Ram-DL,Ram-CMD + Data 8 bit ++++++++++++++++


void FT800memWrite8(unsigned long addr, unsigned char data8)
{
  spi_cs_lo()                     ; // Set CS# low

  spi_rw(((addr>>16)|MEM_WRITE))  ; // Send Memory Write plus high address byte
  spi_rw(addr>>8)                 ; // Send middle address byte
  spi_rw(addr)                    ; // Send low address byte

  spi_rw(data8)                   ; // Send data byte

  spi_cs_hi()                     ; // Set CS# high
}


//++++++++++++++ Function-Write Address Register,Ram-DL,Ram-CMD + Data 16 bit++++++++++++++++

void FT800memWrite16(unsigned long addr, unsigned int data16)
{

  spi_cs_lo()                     ;   // Set CS# low

  spi_rw(((addr>>16)|MEM_WRITE))  ;   // Send Memory Write plus high address byte
  spi_rw(addr>>8)                 ;   // Send middle address byte
  spi_rw(addr)                    ;   // Send low address byte

  spi_rw(data16)                  ;   // Send data low byte
  spi_rw(data16>>8)               ;   // Send data high byte
  
  spi_cs_hi()                     ;   // Set CS# high

}

//++++++++++++ Function-Write Address Register,Ram-DL,Ram-CMD + Data 32 bit +++++++++++++++

void FT800memWrite32(unsigned long addr, unsigned long data32)
{
  spi_cs_lo()                     ;   // Set CS# low

  spi_rw(((addr>>16)|MEM_WRITE))  ;   // Send Memory Write plus high address byte
  spi_rw(addr>>8)                 ;   // Send middle address byte
  spi_rw(addr)                    ;   // Send low address byte

  spi_rw(data32)                  ;   // Send data low byte
  spi_rw(data32>>8)               ;   
  spi_rw(data32>>16)              ;   
  spi_rw(data32>>24)              ;   // Send data high byte
  
  spi_cs_hi()                     ;   // Set CS# high

}



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                        ++
  ++        3.3) Function-Write Address Ram-CMD and Data Text-String        ++
  ++                                                                        ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++ Input  :                                                               ++
  ++           addr = FT800 memory space address Ram-CMD                    ++
  ++           str  = Data Text String                                      ++
  ++                                                                        ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

                                                          
void FT800memWriteStr(unsigned long addr,char *str)
{
  unsigned int i ;
  
  num_cha = 0                     ;
  spi_cs_lo()                     ;   // Set CS# low

  spi_rw(((addr>>16)|MEM_WRITE))  ;   // Send Memory Write plus high address byte
  spi_rw(addr>>8)                 ;   // Send middle address byte
  spi_rw(addr)                    ;   // Send low address byte


 for (i=0; str[i] != '\0'; i++)       //Check End String In C
  {                 
     spi_rw(str[i])               ;
     num_cha +=  1                ;
   }

  spi_rw(0)                       ;   //Sent End Write String Sent 0

  num_cha = num_cha+1             ;

  spi_cs_hi()                     ;   // Set CS# high

}



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                        ++
  ++      3.4) Function-Write Host Command  (Command[6-bit]+0x00+0x00)      ++
  ++                                                                        ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++  Input :                                                               ++
  ++           Command = FT800 Command                                      ++
  ++                                                                        ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void FT800_HostCmdWrite(unsigned char Command)
{
  spi_cs_lo()            ;  // Set CS# low

  spi_rw(Command)        ;  // Send command
  spi_rw(0x00)           ;  // Commands consist of two more zero bytes
  spi_rw(0x00)           ;  // Send last zero byte

  spi_cs_hi()            ;  // Set CS# high
}





/*******************************************************************************
 **                                                                           **
 **                         4.Function-About Read FT800                       **
 **                                                                           **
 *******************************************************************************/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                         ++
  ++            4.1) Function-Read data Register,Ram-DL,Ram-CMD              ++
  ++                                                                         ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++ Input    :                                                              ++
  ++            Address = FT800 memory space address Ram-DL,CMD,Reg          ++
  ++ Output   :                                                              ++
  ++            Dataxx  = data Read for Co-CMD,DL-CMD or Reg.                ++
  ++                                                                         ++
  ++ Note     : "xx" is data of 8, 16 or 32 bit                              ++
  ++                                                                         ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


//++++++++++++++++++ Function-Read data Memory 8 bit +++++++++++++++++++++++

unsigned char FT800memRead8(unsigned long addr)
{
  unsigned char data8 ;

  spi_cs_lo()                     ; // Set CS# low

  spi_rw(((addr>>16)&MEM_READ))   ; // Send Memory Write plus high address byte
  spi_rw(addr>>8)                 ; // Send middle address byte
  spi_rw(addr)                    ; // Send low address byte
  spi_rw(ZERO)                    ; // Send dummy byte
  data8 = spi_rw(ZERO)            ; // Read data byte

  spi_cs_hi()                     ; // Set CS# high
  return data8                    ; // Return byte read


}


//++++++++++++++++++++ Function-Read data Memory 16 bit ++++++++++++++++++++

unsigned int FT800memRead16(unsigned long addr)
{
  unsigned int data16,dat;

  spi_cs_lo()                                  ; // Set CS# low

  spi_rw(((addr>>16)&MEM_READ))                ; // Send Memory Write plus high address byte
  spi_rw(addr>>8)                              ; // Send middle address byte
  spi_rw(addr)                                 ; // Send low address byte
  spi_rw(ZERO)                                 ; // Send dummy byte


  data16 = spi_rw(ZERO)                        ; // Read low byte
  dat    = spi_rw(ZERO)                        ; // Read high byte
  data16 = (dat << 8)| data16                  ; 
 

  spi_cs_hi()                                  ; // Set CS# high
    
  return data16;                                 // Return integer read
}


//+++++++++++++++++ Function-Read data Memory 32 bit +++++++++++++++++++++

unsigned long FT800memRead32(unsigned long addr)
{
  unsigned long data32,dat;

  spi_cs_lo()                                  ; // Set CS# low

  spi_rw(((addr>>16)&MEM_READ))                ; // Send Memory Write plus high address byte
  spi_rw(addr>>8)                              ; // Send middle address byte
  spi_rw(addr)                                 ; // Send low address byte
  spi_rw(ZERO)                                 ; // Send dummy byte


  data32 = spi_rw(ZERO)                        ; // Read low byte
  dat    = spi_rw(ZERO)                        ; 
  data32 = (dat<<8)| data32                    ;
  dat    = spi_rw(ZERO)                        ; 
  data32 = (dat<<16)| data32                   ;
  dat    = spi_rw(ZERO)                        ; // Read high byte 
  data32 = (dat<<24)| data32                   ;

  spi_cs_hi()                                  ; // Set CS# high
    
  return data32                                ; // Return integer read
}



/***********************************************************************************
 **                                                                               **
 **           5.Function-About Manage memory address FT800 Ring Buffer            **              
 **                                                                               **
 ***********************************************************************************/

 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                        ++
  ++     5.1) Function-Waite Co-Processor Finish executing and              ++
  ++          Start Offset pointer                                          ++
  ++                                                                        ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void Start_CMDOffset(void) 

 {
  //------------Determine Pointer Offset for Ram_CMD Address---------------
    do
     {
       cmdBufferRd = FT800memRead16(REG_CMD_READ)      ;   //***Read Reg.the graphics processor read pointer
       cmdBufferWr = FT800memRead16(REG_CMD_WRITE)     ;   //***Read Reg.the graphics processor write pointer
  
     }while(cmdBufferWr != cmdBufferRd)                ;   //Wait until the two registers match
  
      cmdOffset = cmdBufferWr                          ;   //The new starting point the first location after the last command

  }




/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                                 ++
  ++         5.2) Function-Increment Offset Address Pointer for Ram-CMD              ++
  ++                                                                                 ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++ Input    :                                                                      ++
  ++            currentOffset = graphics processor command list pointer              ++
  ++            commandSize   = number of bytes data or CMD to increment the offset  ++
  ++                                                                                 ++
  ++ Output   : newOffset = the new ring buffer pointer after adding the command     ++ 
  ++                                                                                 ++
  ++ Overview : Adds commandSize to the currentOffset.                               ++
  ++            Checks for 4K ring-buffer offset roll-over                           ++
  ++                                                                                 ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


  //++++++++++++++++++ Function-Increment Offset Address +++++++++++++++++++++++

unsigned int incCMDOffset(unsigned int currentOffset, unsigned char commandSize)
{
    unsigned int newOffset                  ;   //used to hold new offset

    newOffset = currentOffset + commandSize ;   //Calculate new offset

    if(newOffset > 4095)                        //If new offset past boundary...
    {
        newOffset = (newOffset - 4096)      ;   //... roll over pointer
    }

    return newOffset;                           //Return new offset
}



 //++++++++++++ Function-Increment Offset Address Use when end Co-Processor CMD (offset Address/4 = integer)+++++++++++++

unsigned int End_incCMDOffset(unsigned int currentOffset, unsigned char commandSize)
{
  unsigned int newOffset                   ;  //used to hold new offset

   newOffset = currentOffset + commandSize ;  //Calculate new offset

   if(newOffset > 4095)                       //If new offset past boundary...
    {
        newOffset = (newOffset - 4096)     ;  //... roll over pointer
    }
   

  //increment the length and align it by 4 bytes//

   newOffset = (newOffset+3) & 4092        ;

   return newOffset;                          //Return new offset
}



/*************************************************************************************
 **                                                                                 **
 **                         6.Function-About Touch Screen                           **
 **                                                                                 **
 *************************************************************************************/



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                      ++
  ++                6.1) Function-Calibrate Touch Screen                  ++
  ++                                                                      ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void Touch_Calibrate(void)
 {

    // Calibrate Touch Screen //

    //--- 1.Start Display List ---
   Start_CMDList(Black)    ;
    
    //--- 2.1 Co-Processor Draw Text-CMD --- 

   Text_CMD("Please tap on a dot",240,139,26,OPT_CENTER,White)    ;

   //--- 2.2 Co-Processor Calibrate CMD --- 

    FT800memWrite32(RAM_CMD + cmdOffset,CMD_CALIBRATE)             ; //***Sent Co-CMD for Calibrate Touch Screen
    cmdOffset = incCMDOffset(cmdOffset,4)                          ; //Update Offset pointer Ram-CMD 4 byte for Next data


   //--- 3.End Display List and Update Execute ----

    End_CMDList();

    Start_CMDOffset()                                              ; //Wait Calibrate Execute  


}


/*************************************************************************************
 **                                                                                 **
 **                     7.Function-About FT800 DL-CMD,Co-CMD                        **
 **                                                                                 **
 *************************************************************************************/


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                              ++
  ++     7.1) Function:Start Co-Processor Command List (Write Program to Ram_CMD) ++
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++  Input :                                                                     ++
  ++           screen_color  : Color Background Screen                            ++
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  
  void Start_CMDList(long screen_color)
   {

    //-------------------- Start Display List ------------------------

     Start_CMDOffset()                                                  ; //Start Offset pointer for Ram-CMD

     FT800memWrite32(RAM_CMD + cmdOffset,CMD_DLSTART)                   ; //*** Sent Co-CMD Start the display list                                                     
     cmdOffset = incCMDOffset(cmdOffset,4)                              ; //Update Offset pointer Ram-CMD 4 byte for Next CMD     
    
     FT800memWrite32(RAM_CMD + cmdOffset,(DL_CLEAR_RGB | screen_color)) ; //*** Sent DL-CMD Clear color BackGround and Set Color BackGround                  
     cmdOffset = incCMDOffset(cmdOffset,4)                              ; //Update Offset pointer Ram-CMD 4 byte for Next CMD

     FT800memWrite32(RAM_CMD + cmdOffset,(DL_CLEAR | CLR_COL | CLR_STN | CLR_TAG));   //*** Sent DL-CMD Clear the screen - this and the previous prevent artifacts between lists                                                                               // Attributes are the color, stencil and tag buffers
     cmdOffset = incCMDOffset(cmdOffset,4)                              ;             //Update Offset pointer Ram-CMD 4 byte for Next CMD

   }


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                              ++
  ++     7.2) Function:End Co-Processor Command List (Write Program to Ram_CMD)   ++
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  void End_CMDList(void)               
  {
    //----------------- End Display List and Update Execute -----------------

    FT800memWrite32(RAM_CMD + cmdOffset,DL_DISPLAY)          ;//*** Sent DL-CMD End Display List                  
    cmdOffset = incCMDOffset(cmdOffset,4)                    ;//Update Offset pointer Ram-CMD 4 byte for Next CMD
 
    FT800memWrite32(RAM_CMD + cmdOffset,CMD_SWAP)            ;//*** Sent Co-CMD Requse Display List Swap
    cmdOffset = incCMDOffset(cmdOffset,4)                    ;//Update Offset pointer Ram-CMD 4 byte for Next CMD

    FT800memWrite16(REG_CMD_WRITE,cmdOffset)                 ;//*** Sent Data cmdOffset to reg. CMD_Write for
                                                              //Update the ring buffer pointer so the graphics processor starts executing
  } 




/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                              ++
  ++       7.3) Function:Co-Processor Draw Text (Write Program to Ram_CMD)        ++
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++   Input :                                                                    ++
  ++                str =  Text String                                            ++
  ++                x,y =  x,y codinate Text base ,in pixel                       ++
  ++               font =  format font text(16-31)                                 ++
  ++               opt  =  Set Position Text default 0 top-left  or               ++
  ++                       OPT_CENTERX,OPT_CENTERY,OPT_CENTER,OPT_RIGHTX          ++
  ++                                                                              ++
  ++           tx_color =  Color Text                                             ++
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


void Text_CMD(char *str,int x,int y,int font,int opt,long tx_color)
 {

    // Set Attribute Clock //

    FT800memWrite32(RAM_CMD + cmdOffset,(DL_COLOR_RGB | tx_color))    ; //***Sent DL-CMD Set Color Text  
    cmdOffset = incCMDOffset(cmdOffset,4)                             ; //Update Offset pointer Ram-CMD 4 byte for Next CMD

   
   //Start Draw Text//    

    FT800memWrite32(RAM_CMD + cmdOffset,CMD_TEXT)                     ; //***Sent Co-CMD Draw TEXT
    cmdOffset = incCMDOffset(cmdOffset,4)                             ; //Update Offset pointer Ram-CMD 4 byte for Next data

    FT800memWrite16(RAM_CMD + cmdOffset,x)                            ; //---Sent data X-Point top-left (Pixel) 
    cmdOffset = incCMDOffset(cmdOffset,2)                             ; //Update Offset pointer Ram-CMD 2 byte for Next data

    FT800memWrite16(RAM_CMD + cmdOffset,y)                            ; //---Sent data Y-Point top-left (Pixel) 
    cmdOffset = incCMDOffset(cmdOffset,2)                             ; //Update Offset pointer Ram-CMD 2 byte for Next data
  
    FT800memWrite16(RAM_CMD + cmdOffset,font)                         ; //---Sent data Set format font(16,18,20,21,22,23,24...)                                                     
    cmdOffset = incCMDOffset(cmdOffset,2)                             ; //Update Offset pointer Ram-CMD 2 byte for Next data

    FT800memWrite16(RAM_CMD + cmdOffset,opt)                          ; //---Sent data Option : Position Draw  Text                                                     
    cmdOffset = incCMDOffset(cmdOffset,2)                             ; //Update Offset pointer Ram-CMD 2 byte for Next data

    FT800memWriteStr(RAM_CMD + cmdOffset,str)                         ; //---Sent data Text   String      
    cmdOffset = End_incCMDOffset(cmdOffset,num_cha)                   ; //Update Offset pointer Ram-CMD for End CMD-Text
  
  }





/*************************************************************************************
 **                                                                                 **
 **                       8.Function-About User Application                         **
 **                                                                                 **
 *************************************************************************************/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                   ++
  ++                     8.1)Function:FT800 Initial                    ++
  ++                                                                   ++                                       
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


void FT800_Initial(void)         
 {
   int duty = 0 ;

 //---------------------- 1.Walk-Up FT800 -----------------------

     
   FT800_PD_lo()                            ;  //Power-Down FT800
   delay_ms(20)                             ;  //delay 20 ms
    
   FT800_PD_hi()                            ;  //Power-Up FT800  
   delay_ms(20)                             ;  //delay 20 ms


   FT800_HostCmdWrite(FT800_ACTIVE)         ;  //***Sent Host-CMD Start FT800
   delay_ms(5);                                //Give some time to process

   FT800_HostCmdWrite(FT800_CLKEXT)         ;  //***Sent Host-CMD Set FT800 for external clock
   delay_ms(5);                                //Give some time to process

   FT800_HostCmdWrite(FT800_CLK48M)         ;  //***Sent Host-CMD Set FT800 for 48MHz PLL
   delay_ms(5)                              ;  //Give some time to process
                                               //Now FT800 can accept commands at up to 30MHz clock on SPI bus
                                               //This application leaves the SPI bus at 4MHz

  if(FT800memRead8(REG_ID) != 0x7C)            //***Read ID register - is it 0x7C?
   {
   
     while(1);                                 //If we don't get 0x7C, the ineface isn't working - halt with infinite loop
   }  
  
   FT800memWrite8(REG_PCLK,ZERO)           ;   //***Write data zero to Reg.PCLK  for don't clock the LCD until later
   FT800memWrite8(REG_PWM_DUTY,ZERO)       ;   //***Write data zero to Reg.PWM_Duty for Turn off backlight
  


 //-------------------- 2.Configure Display ------------------------

  FT800memWrite16(REG_HSIZE,480)           ;  //***Write data to Reg : Active display width =480 Pixel
  FT800memWrite16(REG_HCYCLE,548)          ;  //***Write data to Reg : Total number of clocks per line, incl front/back porch
  FT800memWrite16(REG_HOFFSET,43)          ;  //***Write data to Reg : start of active line
  FT800memWrite16(REG_HSYNC0,0)            ;  //***Write data to Reg : Start of horizontal sync pulse
  FT800memWrite16(REG_HSYNC1,41)           ;  //***Write data to Reg : End of horizontal sync pulse
  
  FT800memWrite16(REG_VSIZE,272)           ;  //***Write data to Reg : Active display height =272 Pixel
  FT800memWrite16(REG_VCYCLE,292)          ;  //***Write data to Reg : Total number of lines per screen, incl pre/post
  FT800memWrite16(REG_VOFFSET,12)          ;  //***Write data to Reg : Start of active screen
  FT800memWrite16(REG_VSYNC0,0)            ;  //***Write data to Reg : Start of vertical sync pulse
  FT800memWrite16(REG_VSYNC1,10)           ;  //***Write data to Reg : End of vertical sync pulse
  
  FT800memWrite8(REG_SWIZZLE,0)            ;  //***Write data to Reg : FT800 output to LCD - pin order
  FT800memWrite8(REG_PCLK_POL,1)           ;  //***Write data to Reg : LCD data is clocked in on this PCLK edge
                                              //***Write data to Reg : Don't set PCLK yet - wait for just after the first display list


 //------------------- 3.Configure Touch -----------------
  
  FT800memWrite8(REG_TOUCH_MODE,0x03)      ;  //***Write data to Reg : Touch Mode Continuous
  FT800memWrite16(REG_TOUCH_RZTHRESH,1200) ;  //***Write data to Reg : Eliminate any false touches
  

//-------------------- 4. Configure Audio ----------------


  FT800memWrite8(REG_GPIO_DIR,0x82)        ;   //***Write Data to Reg :  Set Direction  GPIO 7,1 = Output

  ft800Gpio = FT800memRead8(REG_GPIO)      ;   //***Read the FT800 GPIO register for a read/modify/write operation
  ft800Gpio = ft800Gpio | 0x02             ;   //set bit 1 of FT800 GPIO register (Audio) - others are inputs

  FT800memWrite8(REG_GPIO,ft800Gpio)       ;   //***Write Data to Reg : Enable(1) the Audio Amp
  
  FT800memWrite8(REG_VOL_PB,ZERO)          ;  //***Write data to Reg : Turn recorded audio volume 
  FT800memWrite8(REG_VOL_SOUND,0x80)       ;  //***Write data to Reg : Turn synthesizer volume 50%(100%=0xFF)  
 
  FT800memWrite16(REG_SOUND,0x0000)        ;  //***Write data to Reg : Select Sound Effect = Silence(No Sound) 
  FT800memWrite8(REG_PLAY,0x01)            ;  //***Write data to Reg : Play Sound Effect

 //------------------ 5.Write Initial Display List & Enable Display -----------------


  FT800memWrite32(RAM_DL+DL_Offset,DL_CLEAR_RGB)  ;   //***Sent DL-CMD Clear color BackGround to Black (default)
  DL_Offset += 4                                  ;   //Update Offset pointer Ram-DL 4 byte for Next DL-CMD

  FT800memWrite32(RAM_DL+DL_Offset,(DL_CLEAR | CLR_COL | CLR_STN | CLR_TAG));   //***Sent DL-CMD Clear C/S/T define which parameters to clear
  DL_Offset += 4                                  ;   //Update Offset pointer Ram-DL 4 byte for Next DL-CMD

  FT800memWrite32(RAM_DL+DL_Offset,DL_DISPLAY)    ;   //***Sent DL-CMD for end of display list

  FT800memWrite32(REG_DLSWAP,DLSWAP_FRAME )       ;   //***Write data(0x02) to Reg : Display List Execute
                                                
  DL_Offset = 0                                   ;   //Reset Display List offset pointer=0 for new Display list
  
  ft800Gpio = FT800memRead8(REG_GPIO)             ;   //***Read the FT800 GPIO register for a read/modify/write operation
  ft800Gpio = ft800Gpio | 0x80                    ;   //set bit 7 of FT800 GPIO register (DISP) - others are inputs

  FT800memWrite8(REG_GPIO,ft800Gpio)              ;   //***Write Data to Reg : Enable the DISP signal to the LCD panel
  FT800memWrite8(REG_PCLK,5)                      ;   //***Write Data to Reg : Now start clocking data to the LCD panel
 
  for(duty = 0; duty <= 128; duty++)
   {
     FT800memWrite8(REG_PWM_DUTY, duty);              //***Write Data to Reg : Turn on backlight - ramp up slowly to full brighness
     delay_ms(10);
   }

  delay_ms(10);

 }



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                              ++
  ++                 8.2) Function: Convert Hex to ASCII  5 digit                 ++
  ++                      for Display Value Reg.Touch Transfer A-F                ++     
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void Conv_hex_to_Ascii()
 {

    //Convert Integer to Ascii//
   
     int_A[0]  = (intA/10000)+0x30  ; 
         intA  = (intA%10000)       ;
     int_A[1]  = (intA/1000)+0x30   ;
         intA  = (intA%1000)        ;
     int_A[2]  = (intA/100)+0x30    ;
         intA  = (intA%100)         ;
     int_A[3]  = (intA/10)+0x30     ;
     int_A[4]  = (intA%10)+0x30     ;

   
     int_B[0]  = (intB/10000)+0x30  ;
         intB  = (intB%10000)       ;
     int_B[1]  = (intB/1000)+0x30   ;
         intB  = (intB%1000)        ;
     int_B[2]  = (intB/100)+0x30    ;
         intB  = (intB%100)         ;
     int_B[3]  = (intB/10)+0x30     ;
     int_B[4]  = (intB%10)+0x30     ;


     int_C[0]  = (intC/10000)+0x30  ;
         intC  = (intC%10000)       ;
     int_C[1]  = (intC/1000)+0x30   ;
         intC  = (intC%1000)        ;
     int_C[2]  = (intC/100)+0x30    ;
         intC  = (intC%100)         ;
     int_C[3]  = (intC/10)+0x30     ;
     int_C[4]  = (intC%10)+0x30     ;


    int_D[0]  = (intD/10000)+0x30   ;
         intD  = (intD%10000)       ;
     int_D[1]  = (intD/1000)+0x30   ;
         intD  = (intD%1000)        ;
     int_D[2]  = (intD/100)+0x30    ;
         intD  = (intD%100)         ;
     int_D[3]  = (intD/10)+0x30     ;
     int_D[4]  = (intD%10)+0x30     ;


     int_E[0]  = (intE/10000)+0x30  ;
         intE  = (intE%10000)       ;
     int_E[1]  = (intE/1000)+0x30   ;
         intE  = (intE%1000)        ;
     int_E[2]  = (intE/100)+0x30    ;
         intE  = (intE%100)         ;
     int_E[3]  = (intE/10)+0x30     ;
     int_E[4]  = (intE%10)+0x30     ;


     int_F[0]  = (intF/10000)+0x30  ;
         intF  = (intF%10000)       ;
     int_F[1]  = (intF/1000)+0x30   ;
         intF  = (intF%1000)        ;
     int_F[2]  = (intF/100)+0x30    ;
         intF  = (intF%100)         ;
     int_F[3]  = (intF/10)+0x30     ;
     int_F[4]  = (intF%10)+0x30     ;



    //Convert Fraction to Ascii//


     frac_A[0]  = (fracA/10000)+0x30  ;
         fracA  = (fracA%10000)       ;
     frac_A[1]  = (fracA/1000)+0x30   ;
         fracA  = (fracA%1000)        ;
     frac_A[2]  = (fracA/100)+0x30    ;
         fracA  = (fracA%100)         ;
     frac_A[3]  = (fracA/10)+0x30     ;
     frac_A[4]  = (fracA%10)+0x30     ;

    
     frac_B[0]  = (fracB/10000)+0x30  ;
         fracB  = (fracB%10000)       ;
     frac_B[1]  = (fracB/1000)+0x30   ;
         fracB  = (fracB%1000)        ;
     frac_B[2]  = (fracB/100)+0x30    ;
         fracB  = (fracB%100)         ;
     frac_B[3]  = (fracB/10)+0x30     ;
     frac_B[4]  = (fracB%10)+0x30     ;


     frac_C[0]  = (fracC/10000)+0x30  ;
         fracC  = (fracC%10000)       ;
     frac_C[1]  = (fracC/1000)+0x30   ;
         fracC  = (fracC%1000)        ;
     frac_C[2]  = (fracC/100)+0x30    ;
         fracC  = (fracC%100)         ;
     frac_C[3]  = (fracC/10)+0x30     ;
     frac_C[4]  = (fracC%10)+0x30     ;


    frac_D[0]  = (fracD/10000)+0x30  ;
         fracD  = (fracD%10000)       ;
     frac_D[1]  = (fracD/1000)+0x30   ;
         fracD  = (fracD%1000)        ;
     frac_D[2]  = (fracD/100)+0x30    ;
         fracD  = (fracD%100)         ;
     frac_D[3]  = (fracD/10)+0x30     ;
     frac_D[4]  = (fracD%10)+0x30     ;
 

     frac_E[0]  = (fracE/10000)+0x30  ;
         fracE  = (fracE%10000)       ;
     frac_E[1]  = (fracE/1000)+0x30   ;
         fracE  = (fracE%1000)        ;
     frac_E[2]  = (fracE/100)+0x30    ;
         fracE  = (fracE%100)         ;
     frac_E[3]  = (fracE/10)+0x30     ;
     frac_E[4]  = (fracE%10)+0x30     ;



     frac_F[0]  = (fracF/10000)+0x30  ;
         fracF  = (fracF%10000)       ;
     frac_F[1]  = (fracF/1000)+0x30   ;
         fracF  = (fracF%1000)        ;
     frac_F[2]  = (fracF/100)+0x30    ;
         fracF  = (fracF%100)         ;
     frac_F[3]  = (fracF/10)+0x30     ;
     frac_F[4]  = (fracF%10)+0x30     ;

 }

 

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                              ++
  ++                      8.3)Function: Update_Screen Application                 ++
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                              ++
  ++  Input :                                                                     ++
  ++                                                                              ++
  ++           color_point = Value Update for Color poin                          ++
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  void Update_Screen(char *sigA,char *sigB,char *sigC,char *sigD,char *sigE,char *sigF,
                     char *valA,char *valB,char *valC,char *valD,char *valE,char *valF,
                     char *facA,char *facB,char *facC,char *facD,char *facE,char *facF)
   {
      
    //----------------- 1.Start Display List ------------------------
      
    Start_CMDList(Black)   ;

  
   //------------------ 2.User Program ------------------------- 

    Text_CMD("*---Read Reg.Touch Transfer---*",20,5,23,0,Blue)        ;
    Text_CMD(" Sig /   Int  / Frac",300,35,23,0,Yellow)               ;
    Text_CMD("Note : Sig+ = 0 ,Sig- = 1",20,250,18,0,Red)             ;
   
   
     

   Text_CMD("Value Reg. Touch Transfer Def.A =",10,60,23,0,White)     ;  
   Text_CMD(sigA,320,60,23,0,Green)     ;
   Text_CMD(valA,335,60,23,0,Green)     ;  
   Text_CMD(".",385,60,23,0,Green)      ;  
   Text_CMD(facA,390,60,23,0,Green)     ; 


   Text_CMD("Value Reg. Touch Transfer Def.B =",10,90,23,0,White)     ;  
   Text_CMD(sigB,320,90,23,0,Green)     ;
   Text_CMD(valB,335,90,23,0,Green)     ;  
   Text_CMD(".",385,90,23,0,Green)      ;  
   Text_CMD(facB,390,90,23,0,Green)     ;  

   Text_CMD("Value Reg. Touch Transfer Def.C =",10,120,23,0,White)    ;  
   Text_CMD(sigC,320,120,23,0,Green)    ;
   Text_CMD(valC,335,120,23,0,Green)    ;
   Text_CMD(".",385,120,23,0,Green)     ;  
   Text_CMD(facC,390,120,23,0,Green)    ;    

   Text_CMD("Value Reg. Touch Transfer Def.D =",10,150,23,0,White)    ; 
   Text_CMD(sigD,320,150,23,0,Green)     ;
   Text_CMD(valD,335,150,23,0,Green)     ;  
   Text_CMD(".",385,150,23,0,Green)      ;  
   Text_CMD(facD,390,150,23,0,Green)     ;  

   Text_CMD("Value Reg. Touch Transfer Def.E =",10,180,23,0,White)    ;  
   Text_CMD(sigE,320,180,23,0,Green)     ;
   Text_CMD(valE,335,180,23,0,Green)     ;   
   Text_CMD(".",385,180,23,0,Green)      ;  
   Text_CMD(facE,390,180,23,0,Green)     ; 

   Text_CMD("Value Reg. Touch Transfer Def.F =",10,210,23,0,White)    ; 
   Text_CMD(sigF,320,210,23,0,Green)     ;
   Text_CMD(valF,335,210,23,0,Green)     ;   
   Text_CMD(".",385,210,23,0,Green)      ;  
   Text_CMD(facF,390,210,23,0,Green)      ; 
    

    //----------------- 3.End Display List and Update Execute -------------


   End_CMDList();

   }

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                              ++
  ++                      8.4) Function: User Application                         ++
  ++                                                                              ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


 void User_App(void)
  {
    unsigned long def ;
    unsigned char sig ;
    
    def   = FT800memRead32(REG_TOUCH_TRANSFORM_A)       ;   //***Read the FT800 register Touch Transform_A 
    intA  = (def >> 16) & 0x00007FFF                    ;   //keep value Integer  Reg.Touch A   
    fracA = def & 0x0000FFFF                            ;   //keep value Fraction Reg.Touch A   

    sig   = def >> 31                                   ;   //keep Signed A
    if(sig == 1)
      sig_A[0] = '-'                                    ;
    else
      sig_A[0] = '+'                                    ;


    def   = FT800memRead32(REG_TOUCH_TRANSFORM_B)       ;   //***Read the FT800 register Touch Transform_B 
    intB  = (def >> 16) & 0x00007FFF                    ;   //keep value Integer  Reg.Touch B   
    fracB = def & 0x0000FFFF                            ;   //keep value Fraction Reg.Touch B   
   
    sig   = def >> 31                                   ;   //keep Signed B
    if(sig == 1)
      sig_B[0] = '-'                                    ;
    else
      sig_B[0] = '+'                                    ;

   
    def   = FT800memRead32(REG_TOUCH_TRANSFORM_C)       ;   //***Read the FT800 register Touch Transform_C 
    intC  = (def >> 16) & 0x00007FFF                    ;   //keep value Integer  Reg.Touch C   
    fracC = def & 0x0000FFFF                            ;   //keep value Fraction Reg.Touch C 
   
    sig   = def >> 31                                   ;   //keep Signed C 
    if(sig == 1)
      sig_C[0] = '-'                                    ;
    else
      sig_C[0] = '+'                                    ;
       

    def   = FT800memRead32(REG_TOUCH_TRANSFORM_D)       ;   //***Read the FT800 register Touch Transform_D 
    intD  = (def >> 16) & 0x00007FFF                    ;   //keep value Integer  Reg.Touch D   
    fracD = def & 0x0000FFFF                            ;   //keep value Fraction Reg.Touch D 
    
    sig   = def >> 31                                   ;   //keep Signed D  
    if(sig == 1)
      sig_D[0] = '-'                                    ;
    else 
      sig_D[0] = '+'                                    ;


    def   = FT800memRead32(REG_TOUCH_TRANSFORM_E)       ;   //***Read the FT800 register Touch Transform_E 
    intE  = (def >> 16) & 0x00007FFF                    ;   //keep value Integer  Reg.Touch E   
    fracE = def & 0x0000FFFF                            ;   //keep value Fraction Reg.Touch E
    
    sig   = def >> 31                                   ;   //keep Signed E   
    if(sig == 1)  
      sig_E[0] = '-'                                    ;
    else
      sig_E[0] = '+'                                    ;


    def   = FT800memRead32(REG_TOUCH_TRANSFORM_F)       ;   //***Read the FT800 register Touch Transform_F 
    intF  = (def >> 16) & 0x00007FFF                    ;   //keep value Integer  Reg.Touch F   
    fracF = def & 0x0000FFFF                            ;   //keep value Fraction Reg.Touch F   
     
    sig   = def >> 31                                   ;   //keep Signed F
    if(sig == 1)
      sig_F[0] = '-'                                    ;
    else 
      sig_F[0] = '+'                                    ;


    Conv_hex_to_Ascii()                                 ;

    Update_Screen(sig_A,sig_B,sig_C,sig_D,sig_E,sig_F,
                  int_A,int_B,int_C,int_D,int_E,int_F,
                  frac_A,frac_B,frac_C,frac_D,frac_E,frac_F) ;

 
  }  //end User App






