/**********************************************/
/* Example Program For ET-BASE Z51F6412 V1.0  */
/* MCU      : Zilog MCS51 / Z51F6412          */
/*          : Run X2 Mode (58.9824 MHz)       */
/* Compiler : Keil C51 (V9.50a)               */
/* Editor   : uVision V4.53.0.6               */
/* Write By : Eakachai Makarn(ETT CO.,LTD.)   */
/* Function : Demo LED Blinking By Delay Poll */
/* Update   : 18 August 2012                  */
/**********************************************/
#include <z51f6412.h>																							// Z8051 : Z51F6412

/*************************************/
/* ET-BASE Z51F6412 Hardware LED Pin */
/*************************************/
#define LED_PIN							(1 << 1)															// P8[1] = LED
#define LED_PORT_DIR				P8IO
#define LED_PORT_DATA 			P8
#define LED_PORT_INIT()    	LED_PORT_DIR 			|=  (LED_PIN)				// LED = Output
#define LED_OFF()						LED_PORT_DATA			&= ~(LED_PIN) 			// LED Pin = 0
#define LED_ON()  					LED_PORT_DATA			|=  (LED_PIN) 			// LED Pin = 1
#define LED_TOGGLE()  			LED_PORT_DATA			^=  (LED_PIN) 			// LED Pin = Toggle

/**********************
 * Function Prototype *
 **********************/
void delay(unsigned long);																				// Delay Time Function(1..4294967295)

/********************
 * Function: main() *
 ********************/
void main(void)
{	  
  /* Config System Clock = Internal RC 8.00 MHz */
	//PLLCR = 0,0,0,00,00,0
	// 0xxxxxxx : PLL Output Status
	// x0xxxxxx : PLL Output Bypass
	// xx0xxxxx : Power PLL = Default
	// xxx00xxx : FBDiv = Default
	// xxxxx00x : PLL M = Default
	// xxxxxxx0 : PLL Disable
	PLLCR = 0x00;																										// Disable PLL
	
	// SCCR = 0,01,0,0,1,00
	// 0xxxxxxx : Stop Mode = Mode 2
	// x01xxxxx : INTRC Clock Divide = INTRC(16MHz)/2 = 8MHz
	// xxx0xxxx : Clock Change By Hardware
	// xxxx0xxx : RC Oscillator Enable
	// xxxxx1xx : XTAL Oscillator Disable
	// xxxxxx00 : System Clock Source = INTRC(16MHz)
	SCCR = 0x24;  																									// INT-RC 8MHz	
	/* Now System Clock = 8.00MHz */
  
  LED_PORT_DIR |= (LED_PIN);																			// Configure LED = Output 
	
	while(1)
	{
		LED_PORT_DATA			&= ~(LED_PIN); 															// LED Pin = 0(OFF)
		LED_PORT_DATA			|=  (LED_PIN); 															// LED Pin = 1(ON)	
		LED_PORT_DATA			^=  (LED_PIN); 															// LED Pin = Toggle
		LED_PORT_DATA			^=  (LED_PIN); 															// LED Pin = Toggle
	} 

}

