/*************************************************/
/* Examples Program For "ET-dsPIC33WEB-V1" Board */
/* Hardware    : ET-dsPIC33WEB-V1.0              */
/* Target MCU  : dsPIC33FJ128GP708               */
/*       	   : X-TAL : 8.00 MHz                */
/* Config Fosc : XTAL = 8MHz (XT+PLL)            */
/*             : PLLPRE[4..0] = 00000 (N1=2)     */
/*             : VCO Input = 8MHz / 2 = 4MHz     */
/*             : PLLDIV[8..0] = 0x26(M=40)       */
/*             : VCO Output = 4 x 40MHz = 160MHz */
/*             : PLLPOST[1:0] = 0:0 (N2=2)       */
/*             : Fosc = 160MHz / 2 = 80MHz       */
/*             : Fcy = Fosc/2 = 80MHz /2 = 40MHz */
/* Compiler    : MPLAB + C30 V3.01  		     */
/* Write By    : Eakachai Makarn(ETT CO.,LTD.)   */
/* Last Update : 16/August/2007                  */
/* Function    : Example Use PWM Control Servo   */
/*************************************************/
/* Used Timer2 Control OC1 Generate PWM Signal   */
/* Used RD0 = OC1 Generate PWM (50 Hz)           */
/* Period = 20mS (1.6uS x 12500)                 */
/* Duty Cycle = 1.0mS <--> 2.0mS                 */
/*************************************************/
// ET-dsPIC33WEB-V1 Hardware Board
// Fcy = 40MHz
// Tcy = 1 / 40MHz = 25nS
// Desire PWM1 Freq = 50Hz (20mS Period)
// Desire Timer Prescale = 64  
// PWM Period = (PRy+1) x (Tcy) x (TMRy Prescale)
// 1 / 50Hz   = (PRy+1) x (Tcy) x (TMRy Prescale)
//            = (PRy+1) x (25 nS) x (64)         
//     	      = (PRy+1) x 1.6uS
// 20mS       = (PRy+1) x 1.6uS  
// Pry        = [20mS / 1.6uS] - 1
//            = 12500-1
//            = 12499
// Duty Cycle 1.0mS <--> 2.0mS
// 1 Cycle = 1.6uS
// Duty Cycle 1.00 mS = 1.0mS / 1.6uS = 625 Cycle
// Duty Cycle 1.50 mS = 1.5mS / 1.6uS = 937.5 Cycle 
// Duty Cycle 2.00 mS = 2.0mS / 1.6uS = 1250 Cycle

#include "p33FJ128GP708.h"                             				// dsPIC33FJ128GP708 MPU Register

/* Setup Configuration For ET-dsPIC33WEB-V1 */
_FOSCSEL(FNOSC_PRIPLL & 											// Select Primary OSC = XT + PLL
         IESO_OFF )													// Startup With User Select OSC
_FOSC(FCKSM_CSDCMD &        										// Clock Switch Disabled	
      OSCIOFNC_OFF &												// OSC2 Pin = Clock O/P
      POSCMD_XT)													// Primary OSC = XT 
_FWDT(FWDTEN_OFF &           										// Disable Watchdog Timer 
      WINDIS_OFF &          										// Disabled Windowed WDT
      WDTPRE_PR128 &        										// Watchdog prescaler=1:128
      WDTPOST_PS32768)     											// Watchdog postscaler=1:32,768
_FPOR(FPWRT_PWR128)       											// Power-on Reset Value = 128ms
_CONFIG3(JTAGEN_OFF);												// Disable JTAG Interface
/* End of Configuration For ET-dsPIC33WEB-V1 */

/* pototype  section */
void delay(unsigned long int);										// Delay Time Function

int main(void)
{  
  /* Start of PLL Config Fcy = 40MIPS */
  CLKDIV &= 0xFFE0;													// PLLPRE[4..0] = 00000 (N1=2)
  CLKDIV &= 0xFF3F;													// PLLPOST[1:0] = 00 (N2=2)
  PLLFBD  = 0x26;													// PLLDIV[8..0] = 000100110(M=40)
  while(!OSCCONbits.LOCK);											// Wait PLL to Lock
  OSCCONbits.CLKLOCK = 1;											// Disable PLL Modify
  /* End of PLL Config Fly = 40MIPS */

  /* Start of Config Timer2 */
  T2CONbits.TON = 1;    											// ON Timer
  T2CONbits.TSIDL = 1;												// Disable Timer in IDLE Mode
  T2CONbits.T32 = 0;           										// Timer = 16 Bit Timer
  T2CONbits.TGATE = 0;												// Disable Timer Gate Control
  T2CONbits.TCKPS1 = 1;        										// Timer Prescale = 1:64			
  T2CONbits.TCKPS0 = 0;
  T2CONbits.TCS = 0;												// Timer Clock Source = Internal

  // Setup Timer Start Count
  TMR2 = 0;          												// Reset Timer to 0x0000 

  // Assign PWM Period
  PR2 = 12499;     													// Assign Period to Timer(20mS)

  // Timer2 Interrupt Control 
  IEC0bits.T2IE = 0;												// Disable Timer2 Interrupt
  /* End of Config Timer2 */

  /* Start of Config OC1 */
  OC1CONbits.OCSIDL = 1;											// Disable OC in IDLE Mode 
  OC1CONbits.OCTSEL = 0;		  									// Select Timer2 = Clock Source
  OC1CONbits.OCFLT = 0;        										// Disable PWM Fault Signal
  OC1CONbits.OCM2 = 1;												// OC1 = PWM Mode + Fault Disable
  OC1CONbits.OCM1 = 1;
  OC1CONbits.OCM0 = 0;      

  // Assign PWM Duty Cycle 
  OC1RS = 938;     													// 1.5mS Duty Cycle
  OC1R = 0;     													// Start Pulse Counter  

  // OC1 Interrupt Control 
  IEC0bits.OC1IE = 0;												// Disable OC1 Interrupt
  /* End of Config OC1 */

  // Demo PWM1(RD0) Control Servo Motor //
  while(1)															// Loop Continue
  {    
    OC1RS = 625;													// 1.0 mS(Left)
    delay(5000000);
    
    OC1RS = 938;													// 1.5 mS(Center)
    delay(5000000);
 
    OC1RS = 1250;													// 2.0 mS(Right)
    delay(5000000);
  } 
}	  
  
/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay(unsigned long int count1)
{
  while(count1 > 0) {count1--;}										// Loop Decrease Counter	
}

