/*************************************************/
/* Examples Program For "ET-dsPIC33WEB-V1" Board */
/* Hardware    : ET-dsPIC33WEB-V1.0              */
/* Target MCU  : dsPIC33FJ128GP708               */
/*       	   : X-TAL : 8.00 MHz                */
/* Config Fosc : XTAL = 8MHz (XT+PLL)            */
/*             : PLLPRE[4..0] = 00000 (N1=2)     */
/*             : VCO Input = 8MHz / 2 = 4MHz     */
/*             : PLLDIV[8..0] = 0x26(M=40)       */
/*             : VCO Output = 4 x 40MHz = 160MHz */
/*             : PLLPOST[1:0] = 0:0 (N2=2)       */
/*             : Fosc = 160MHz / 2 = 80MHz       */
/*             : Fcy = Fosc/2 = 80MHz /2 = 40MHz */
/* Compiler    : MPLAB + C30 V3.01  		     */
/* Write By    : Eakachai Makarn(ETT CO.,LTD.)   */
/* Last Update : 16/August/2007                  */
/* Function    : Example Use SPI Connect 74HC595 */
/*             : LED Moving on Output of 74HC595 */	
/*************************************************/
/* Used ET-MINI I/O 74HC595 Module Interface     */
/* DIN   = (SPI-SDO2=RG8)                        */
/* LATCH = (SPI-SS2#=RG9)                        */
/* CLOCK = (SPI-SCK2=RG6)                        */
/*************************************************/
// ET-dsPIC33WEB-V1 Hardware Board
// Fcy = 40MHz

#include "p33FJ128GP708.h"                             				// dsPIC33FJ128GP708 MPU Register

/* Setup Configuration For ET-dsPIC33WEB-V1 */
_FOSCSEL(FNOSC_PRIPLL & 											// Select Primary OSC = XT + PLL
         IESO_OFF )													// Startup With User Select OSC
_FOSC(FCKSM_CSDCMD &        										// Clock Switch Disabled	
      OSCIOFNC_OFF &												// OSC2 Pin = Clock O/P
      POSCMD_XT)													// Primary OSC = XT 
_FWDT(FWDTEN_OFF &           										// Disable Watchdog Timer 
      WINDIS_OFF &          										// Disabled Windowed WDT
      WDTPRE_PR128 &        										// Watchdog prescaler=1:128
      WDTPOST_PS32768)     											// Watchdog postscaler=1:32,768
_FPOR(FPWRT_PWR128)       											// Power-on Reset Value = 128ms
_CONFIG3(JTAGEN_OFF);												// Disable JTAG Interface
/* End of Configuration For ET-dsPIC33WEB-V1 */

/* pototype  section */
void delay(unsigned long int);										// Delay Time Function

int main(void)
{  
  unsigned char LED; 												// LED Buffer Display

  /* Start of PLL Config Fcy = 40MIPS */
  CLKDIV &= 0xFFE0;													// PLLPRE[4..0] = 00000 (N1=2)
  CLKDIV &= 0xFF3F;													// PLLPOST[1:0] = 00 (N2=2)
  PLLFBD  = 0x26;													// PLLDIV[8..0] = 000100110(M=40)
  while(!OSCCONbits.LOCK);											// Wait PLL to Lock
  OSCCONbits.CLKLOCK = 1;											// Disable PLL Modify
  /* End of PLL Config Fly = 40MIPS */

  /* Start of Config SPI */
  SPI2STATbits.SPIEN = 0;											// Disable SPI Before Change Config
  SPI2STATbits.SPISIDL = 0;											// Continue SPI in Idle Mode
  SPI2STATbits.SPIROV = 0;											// Disable Overflow
 
  SPI2CON1bits.DISSCK = 0;											// Enable SPI Clock(Master Mode)
  SPI2CON1bits.DISSDO = 0;											// Enable SDO
  SPI2CON1bits.MODE16 = 0;											// SPI Data = 8 Bit Mode
  SPI2CON1bits.SMP = 1;												// Input Sampling on Middle
  SPI2CON1bits.CKE = 0;												// Data Change on Falling Clock 
  SPI2CON1bits.SSEN = 0;											// Disable SS2# Pin
  SPI2CON1bits.CKP = 1;												// Clock Normal = 1,Active = 0
  SPI2CON1bits.MSTEN = 1;											// SPI = Master Mode
  SPI2CON1bits.SPRE2 = 0;											// Clock Secondary Prescale = 8
  SPI2CON1bits.SPRE1 = 0;
  SPI2CON1bits.SPRE0 = 0;
  SPI2CON1bits.PPRE1 = 0;											// Clock Primary Prescale = 64
  SPI2CON1bits.PPRE0 = 0;
  
  SPI2CON2bits.FRMEN = 0;											// Disable SPI Frame
  SPI2CON2bits.SPIFSD = 0;											// Frame Sync = Master
  SPI2CON2bits.FRMPOL = 0;											// Frame Sync Active Low
  SPI2CON2bits.FRMDLY = 0;											// Frame Sync = 1st Bit Clock

  // SPI[2] Interrupt Control 
  IEC2bits.SPI2IE = 0;												// Disable SPI2 Interrupt
  IEC2bits.SPI2EIE = 0;												// Disable SPI2 Error Interrupt

  SPI2STATbits.SPIEN = 1;											// Enable SPI Function
  /* End of Config SPI */
   
  // Start Test Output SPI(74HC595) //
  TRISGbits.TRISG9 = 0;											 	// Config RG9 = Output
  while(1)															// Loop Continue
  {
    for (LED = 0x01; LED != 0x00; LED <<= 1)						// Shift Left LED(Right <- Left)
    { 
      LATGbits.LATG9 = 0;											// Enable SPI Chips Select(Prepared Latch 74HC595)

      SPI2BUF = 0xFF-LED;											// Send SPI to 74HC595 Output(Toggle Logic Drive)
	  while(SPI2STATbits.SPITBF);									// Wait SPI Send Complete(SPITBF=0)
   
      LATGbits.LATG9 = 1;											// Disable SPI Chips Select(Latch 74HC595)

      delay(2000000);	    										// Display Delay LED Output
    }								 
  }   
}	  

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay(unsigned long int count1)
{
  while(count1 > 0) {count1--;}										// Loop Decrease Counter	
}
