// External oscillator frequency
#define SYSCLK          32000000
#include "p24fj128ga008.h"
//#include "lcd.h"

// Setup configuration bits
_CONFIG1( JTAGEN_OFF & GCP_OFF & GWRP_OFF & COE_OFF & FWDTEN_OFF & ICS_PGx2) 
_CONFIG2( FCKSM_CSDCMD & OSCIOFNC_ON & POSCMOD_HS & FNOSC_PRIPLL )

#define  DELAY 16000


	// LCD Module I/O pins
	#define LCD_DATA_TRIS	    (unsigned char)TRISE //(*((volatile BYTE*)&TRISE))
	#define LCD_DATA_IO		    (unsigned char)LATE  //(*((volatile BYTE*)&LATE))
	#define LCD_RD_WR_TRIS		(TRISEbits.TRISE5)
	#define LCD_RD_WR_IO		(LATEbits.LATE5)
	#define LCD_RS_TRIS			(TRISEbits.TRISE4)
	#define LCD_RS_IO			(LATEbits.LATE4)
	#define LCD_E_TRIS			(TRISEbits.TRISE6)
	#define LCD_E_IO			(LATEbits.LATE6)


#define   BRATE   34        // 115200 Bd (BREGH=1)
#define   U_ENABLE 0x8008   // enable UART, BREGH=1, 1 stop, no parity
#define   U_TX 0x0400       // enable transmission, clear all fl ags


void initU1( void)
{

  // BREG1 = (Fosc / 8 / 115,200) -1 = 33.7 where Fosc = 32MHz.
	U1BRG = BRATE; // initialize the baud rate generator
	U1MODE = U_ENABLE; // initialize the UART module
	U1STA = U_TX; // enable the Transmitter

} // initU1

int putU1( int c)
{
	while ( U1STAbits.UTXBF); // wait while Tx buffer full
	U1TXREG = c;
return c;
}                            // putU1

char getU1( void)
{
	while ( !U1STAbits.URXDA); // wait for a new character to arrive
	return  U1RXREG;           // read the character from the receive buffer
}                             // getU1


void initU2( void)
{

  // BREG2 = (Fosc / 8 / 115,200) -1 = 33.7 where Fosc = 32MHz.
	U2BRG = BRATE; // initialize the baud rate generator
	U2MODE = U_ENABLE; // initialize the UART module
	U2STA = U_TX; // enable the Transmitter

} // initU2

int putU2( int c)
{
	while ( U2STAbits.UTXBF); // wait while Tx buffer full
	U2TXREG = c;
return c;
} // putU2

char getU2( void)
{
	while ( !U2STAbits.URXDA); // wait for a new character to arrive
	return  U2RXREG;           // read the character from the receive buffer
} // getU2



void Short_delay(void)
{
   long int n;
   for (n=0;n<1000;n++); 
}

/******************************************************************************
 * Function:        static void LCDWrite_CMD(BYTE Data)
 *
 * PreCondition:    None
 *
 * Input:           RS = 0 Write to Config registers
 *					Data - 8 bits of data to write
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Controls the Port I/O pins to cause an LCD write
 *
 * Note:            None
 *****************************************************************************/
static void LCDWrite_CMD(unsigned char Data)
{
   
    LCD_E_IO = 1;
    LCD_RS_IO = 0;
    LCD_RD_WR_IO =0;
   
    LCD_DATA_IO &= 0xF0;
	LCD_DATA_IO |= ((Data>>4) & 0x0F);
   
	Nop();
	Nop();				
	LCD_E_IO = 0;
	Nop();             	   // Wait E Pulse width time
	Nop();
	Nop();Short_delay();
    LCD_E_IO = 1;

    LCD_DATA_IO &= 0xF0;
	LCD_DATA_IO |= (Data & 0x0F);

	Nop();					// Wait Data setup time (min 40ns)
	Nop();
	LCD_E_IO = 0;
	Nop();             	   // Wait E Pulse width time
	Nop();
	Nop();Short_delay();
    LCD_E_IO = 1;

}


/******************************************************************************
 * Function:        static void LCDWrite_DAT(BYTE Data)
 *
 * PreCondition:    None
 *
 * Input:           RS =1  Register Select to DDRRAM
 *					Data - 8 bits of data to write
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Controls the Port I/O pins to cause an LCD write
 *
 * Note:            None
 *****************************************************************************/
static void LCDWrite_DAT(unsigned char Data)
{
    LCD_RS_IO = 1;
    LCD_E_IO = 1;
    LCD_RD_WR_IO =0;

    LCD_DATA_IO &= 0xF0;
	LCD_DATA_IO |= ((Data>>4) & 0x0F);
   
	Nop();
	Nop();				
	LCD_E_IO = 0;
	Nop();             	   // Wait E Pulse width time
	Nop();
	Nop();Short_delay();
    LCD_E_IO = 1;

    LCD_DATA_IO &= 0xF0;
	LCD_DATA_IO |= (Data & 0x0F);

	Nop();					// Wait Data setup time (min 40ns)
	Nop();
	LCD_E_IO = 0;
	Nop();             	   // Wait E Pulse width time
	Nop();
	Nop();Short_delay();
    LCD_E_IO = 1;
}


/******************************************************************************
 * Function:        void LCDInit(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        LCDText[] is blanked, port I/O pin TRIS registers are 
 *					configured, and the LCD is placed in the default state
 *
 * Note:            None
 *****************************************************************************/
void LCDInit(void)
{
    delay();
    delay();
    delay();   // wait for LCD Start-up

    LCDWrite_CMD(0x33);
    LCDWrite_CMD(0x32);
    LCDWrite_CMD(0x28);
    LCDWrite_CMD(0x0C);
    LCDWrite_CMD(0x06);
    LCDWrite_CMD(0x01);
    LCDWrite_CMD(0x01);

}



void delay(void)
{
   TMR1 =0;
   while ( TMR1 < DELAY);  
}

int main ()
{   
   int k,i;
   char c;
   long int dat;
   unsigned char text1[]="ET-PIC24WEB-V1 ";
   unsigned char text2[]=" www.ett.co.th ";

   unsigned char Title_menu[]="Test ET-PIC24WEB-V1 Please Select choice for test";
   unsigned char Choice_1[]="1. Test IO";
   unsigned char Choice_2[]="2. Test LCD";
   unsigned char Choice_3[]="3. Test RS232-1";
   unsigned char Choice_4[]="4. Test RS232-2";

   unsigned char IO_test[]="HELLO Test IO board";
   unsigned char LCD_test[]="HELLO Test LCD";
   unsigned char Rs232_test1[]="HELLO Test RS232-CH1 Please any key to test";
   unsigned char Rs232_test2[]="HELLO Test RS232-CH2 Please any key to test";
	//Code goes here                                   								

	AD1PCFG = 0xFFFF;
	TRISA = 0x0000;
	TRISB = 0x0000;
	TRISC = 0x0000;
	TRISD = 0x0000;
	TRISE = 0x0000;
	TRISF = 0x0014;
    TRISG = 0x0000;

    T1CON = 0x8030;    // TMR1on, prescaler 1:256 Tclk/2


	LCD_E_IO = 1;
	LCD_RD_WR_IO = 0;

	LCD_DATA_TRIS = 0x00;
	LCD_RD_WR_TRIS = 0;
	LCD_RS_TRIS = 0;
 
    LCDInit();
    initU1();    // init the UART1 serial port
    initU2();    // init the UART2 serial port

  putU1(0x0C);

  for (i=0;i<sizeof(Title_menu);i++)   // Printf menu
  {
      putU1(Title_menu[i]);
  }

  putU1(0x0D); putU1(0x0A);

  for (i=0;i<sizeof(Choice_1);i++)   // Printf Choice_1
  {
      putU1(Choice_1[i]);
  }

 putU1(0x0D); putU1(0x0A);

  for (i=0;i<sizeof(Choice_2);i++)   // Printf Choice_2
  {
      putU1(Choice_2[i]);
  }

 putU1(0x0D); putU1(0x0A); 

  for (i=0;i<sizeof(Choice_3);i++)   // Printf Choice_3
  {
      putU1(Choice_3[i]);
  }

 putU1(0x0D); putU1(0x0A);

  for (i=0;i<sizeof(Choice_4);i++)   // Printf Choice_4
  {
      putU1(Choice_4[i]);
  }

 putU1(0x0D); putU1(0x0A);



while (1)
{
    c = 0;

    while (c==0)  { c = getU1(); }   // wait for a character command
 

//-------------------------------- Test IO --------------------------------------------------
 	if (c=='1')
		{

	     	for (i=0;i<sizeof(IO_test);i++)   // Printf Choice_3
  		    {
      		putU1(IO_test[i]);
  	     	}
            putU1(0x0D); putU1(0x0A);

		AD1PCFG = 0xFFFF;
		TRISA = 0x0000;
		TRISB = 0x0000;
		TRISC = 0x0000;
		TRISD = 0x0000;
		TRISE = 0x0000;
		TRISF = 0x0014;
	    TRISG = 0x0000;

        LATA= 0xffff;
        LATB= 0xffff;
        LATC= 0xffff;
        LATD= 0xffff;
        LATE= 0xffff;
        LATF= 0xffff;
        LATG= 0xffff;
       

    		dat = 0x0001;
		while(1)
    	{
      	 dat = 0x0001;
      	 for (k=0;k<17;k++)
	  	 {
       	 	LATA = ~dat;			//  A
        	dat = dat<<1;
        	delay();
         }

      	 dat = 0x0001;
      	 for (k=0;k<17;k++)
	  	 {
       	 	LATB = ~dat;			// B
        	dat = dat<<1;
        	delay();
         }

      	 dat = 0x0001;
      	 for (k=0;k<17;k++)
	  	 {
       	 	LATC = ~dat;			// C
        	dat = dat<<1;
        	delay();
         }

      	 dat = 0x0001;
      	 for (k=0;k<17;k++)
	  	 {
       	 	LATD = ~dat;			// D
        	dat = dat<<1;
        	delay();
         }

      	 dat = 0x0001;
      	 for (k=0;k<17;k++)
	  	 {
       	 	LATE = ~dat;			// E
        	dat = dat<<1;
        	delay();
         }
        
      	 dat = 0x0001;
      	 for (k=0;k<17;k++)
	  	 {
       	 	LATF = ~dat;			// F
        	dat = dat<<1;
        	delay();
         }

      	 dat = 0x0001;
      	 for (k=0;k<17;k++)
	  	 {
       	 	LATG = ~dat;			// G
        	dat = dat<<1;
        	delay();
         }

 
      }
	}
//------------------------------ Test LCD ----------------------------------------------------

 	if (c=='2')
		{
    		for (i=0;i<sizeof(LCD_test);i++)   // Printf Choice_3
  			{
      		putU1(LCD_test[i]);
  			}
        	putU1(0x0D); putU1(0x0A);

    		for (k=0;k<sizeof(text1)-1;k++)   // Print Text to line 1 LCD
			{
      			LCDWrite_DAT(text1[k]); 
			}

    		LCDWrite_CMD(0xC0);    //  goto line 2 LCD

    		for (k=0;k<sizeof(text2)-1;k++)  // Print Text to line 2 LCD  
			{
      		LCDWrite_DAT(text2[k]); 
			}


		}

//------------------------------ Test RS232-1 ----------------------------------------------------
 	if (c=='3')
		{
	     	for (i=0;i<sizeof(Rs232_test1);i++)   // Printf Choice_3
  		    {
      		putU1(Rs232_test1[i]);
  	     	}
            putU1(0x0D); putU1(0x0A);

	      while (1)
	      {
	    	c = getU1();    // wait for a character
	    	putU1( c);      // echo the character

       	  } // End While

		}

//------------------------------ Test RS232-2 ----------------------------------------------------
 	if (c=='4')
		{
	     	for (i=0;i<sizeof(Rs232_test2);i++)   // Printf Choice_3
  		    {
      		putU1(Rs232_test2[i]);
  	     	}
            putU1(0x0D); putU2(0x0A);

	      while (1)
	      {
	    	c = getU2();    // wait for a character
	    	putU2( c);      // echo the character

       	  } // End While

		}

  }  // end while
 
}  // end main
