// External oscillator frequency
#define SYSCLK          32000000
#include "p24fj128ga008.h"

// Setup configuration bits
_CONFIG1( JTAGEN_OFF & GCP_OFF & GWRP_OFF & COE_OFF & FWDTEN_OFF & ICS_PGx2) 
_CONFIG2( FCKSM_CSDCMD & OSCIOFNC_ON & POSCMOD_HS & FNOSC_PRIPLL )


#define BUTTON1   PORTDbits.RD0
#define BUTTON2   PORTDbits.RD1
#define BUTTON3   PORTDbits.RD2
#define BUTTON4   PORTDbits.RD3

#define LED1   	  PORTBbits.RB0
#define LED2      PORTBbits.RB1
#define LED3      PORTBbits.RB2
#define LED4      PORTBbits.RB3

#define  DELAY 16000

void delay(void)
{
   TMR1 =0;
   while ( TMR1 < DELAY);  
}
//--------------------------------------------------------------------------------
int main ()
{   
   int i;
  unsigned char key;
   
	AD1PCFG = 0xFFFF;
	TRISD = 0xFFFF;
	TRISB = 0xFF00;
    T1CON = 0x8030;    // TMR1on, prescaler 1:256 Tclk/2


	while (1)
	{
	   if (BUTTON1==0)LED1=0;else LED1=1;
       if (BUTTON2==0)LED2=0;else LED2=1;
       if (BUTTON3==0)LED3=0;else LED3=1;
       if (BUTTON4==0)LED4=0;else LED4=1;
	} // End While
}  // End main
//--------------------------------------------------------------------------------