;======================================================================
;
; Author        : ADI - Apps
;
; Date          : 26 Oct 2003
;
; File          : Blink.asm
;
; Description   : Blink LED with delay for MicroConverter DEMO            
;
;======================================================================
;       
$MOD847					; Use 8052 predefined Symbols

CSEG					; Defines the following as a segment of code

ORG     0000H				; Load Code at '0'	

		JMP     MAIN		; Jump to MAIN

ORG 004Bh				; Subroutines


;------------------------------------------------------------------

DELAY:					; Delays by 100ms * A

		
		MOV	R0,A		; Acc holds delay variable
 DLY0:		MOV	R1,#019h	; Set up delay loop0
 DLY1:		MOV	R2,#0FEh	; Set up delay loop1
		DJNZ	R2,$		; Dec R2 & Jump here until R2 is 0
		DJNZ	R1,DLY1         ; Dec R1 & Jump DLY1 until R1 is 0
		DJNZ	R0,DLY0		; Dec R0 & Jump DLY0 until R0 is 0
		RET			; Return from subroutine

;======================================================================

MAIN:						; (main program)

		MOV	A,#20H			; Set up delay 
BLINK:		CPL	P3.4			; blink LED using compliment instruction
		CALL 	DELAY			; Call Software delay 
		JMP	BLINK			; Jump to Blink

END



