;======================================================================
;
; Author        : ADI - Apps
;
; Date          : 31st Oct 2003
;
; Filename      : INT0BLNK.ASM
;
; Hardware      : ADuC847
;
; Description   : Blinks LED continuously.
;                 with 50% duty cycle.
;		  Pressing Int0 slows LED toggle rate
;
;======================================================================
;       
$MOD847				; Use ADuC847 predefined Symbols

LED     EQU     P3.4            	; P3.4 is red LED on eval board
FLAG	BIT	00H			; define Flag variable

CSEG					; Defines the following as a segment of code

ORG     0000H				; Load Code at '00H'	
		JMP     MAIN		; Jump to MAIN
;======================================================================
ORG 0003h				; (INT0 ISR)
		INC 	A		; Increment Acc
		RETI			; Return from Interrupt
;======================================================================

					; Subroutines
;------------------------------------------------------------------

DELAY:					

		MOV	R0,A		; Acc holds delay variable
 DLY0:		MOV	R1,#0C8h	; Set up delay loop0
 DLY1:		MOV	R2,#0C8h	; Set up delay loop1
		DJNZ	R2,$		; Dec R2 & Jump here until R2 is 0
		DJNZ	R1,DLY1         ; Dec R1 & Jump DLY1 until R1 is 0
		DJNZ	R0,DLY0		; Dec R0 & Jump DLY0 until R0 is 0
		RET			; Return from subroutine

;======================================================================

MAIN:						; (main program)
		SETB	IT0			; INT0 edge triggered
		SETB	EA			; enable inturrupts
		SETB	EX0			; enable INT0	
		CLR	FLAG			; Clear Bit defined as FLAG	
		MOV	A,#02H			; Initialize A -> 1
BLINK:		CPL	LED			; blink LED using compliment instruction
		CALL	DELAY			; Jump to subroutine DELAY
		JNB	FLAG,BLINK		; If FLAG is still cleared the jump to Blink

END



