;====================================================================
;
; Author        : ADI - Apps
;
; Date          : 2nd July 2003
;
; File          : UART.asm
;
; Hardware      : ADuC847
;
; Description   : This Program transmits the numbers 0->7F (starting
;                 with 0) down the UART in ASCII form to the PC where
;                 they can be viewed using the preconfigured 
;                 Hyperterminal program.  (c:\ADuC\uart.ht)
;                 After the transmission of the 16 bytes a 5 second
;                 delay is called and the process is repeated.
;
;====================================================================
;              
$MOD847                                 ;Use ADuC845 predefined Symbols

LED	EQU	P3.4

;____________________________________________________________________
                                                  ; BEGINNING OF CODE
CSEG
ORG 0000H

	JMP MAIN

ORG 0060H                    ; Start code at address above interrupts			


MAIN:                          ; Main program
        MOV 	PLLCON, #3h
        MOV     T3CON,#83h
        MOV     T3FD,#12h
        MOV     SCON,#52h

START:        
        CPL      LED           ; CPL LED with each transmission
        MOV      DPTR, #TITLE 
        CALL     SENDSTRING    ; write title block on screen

        MOV      R0, #00H    ; Start transmissions from 0
        MOV      R1, #08H    ; Start a new line after 8 transmissions
      
LOOP1:                        ; Every eight transmissions start on a
                              ; new line
        MOV      A, #10       ; Transmit a linefeed
        CALL     SENDCHAR
        MOV      A, #13       ; Transmit a carriage return
        CALL     SENDCHAR

        MOV      R1, #08H 
      
LOOP2:  
        MOV      A, #20H      ; Transmit a SPACE (=ASCII 20) between
                              ; transmissions on same line
        CALL     SENDCHAR

        MOV      A, R0        ; Transmit R0 = present data
        CALL     SENDVAL
        INC      R0           ; increment data
        
        CJNE     A, #7FH, CONT ; check if data =7F, if not continue
        JMP      WAIT5S        ; if = 7F wait and repeat

CONT:   DEC      R1            ; decrement R1....
        MOV      A, R1          
        CJNE     A, #00H, LOOP2 ; and check if new line is required
                                ; jump to loop 2 for a space
        JMP      LOOP1          ; jump to loop 1 for a new line
        

WAIT5S: MOV      A, #60         ; wait 
        CALL     DELAY   
        JMP      START        ; start transmissions again
        

;____________________________________________________________________
                                                         ; SENDSTRING

SENDSTRING:     ; sends ASCII string to UART starting at location
                ; DPTR and ending with a null (0) value

        PUSH    ACC
        PUSH    B
        CLR     A
        MOV     B,A
IO0010: MOV     A,B
        INC     B
        MOVC    A,@A+DPTR
        JZ      IO0020
        CALL    SENDCHAR
        JMP     IO0010
IO0020: POP     B
        POP     ACC

        RET

;____________________________________________________________________
                                                           ; SENDCHAR

SENDCHAR:       ; sends ASCII value contained in A to UART

        JNB     TI,$            ; wait til present char gone
        CLR     TI              ; must clear TI
        MOV     SBUF,A

        RET

;____________________________________________________________________
                                                            ; SENDVAL

SENDVAL:        ; converts the hex value of A into two ASCII chars,
		; and then spits these two characters up the UART.
                ; does not change the value of A.

        PUSH    ACC
        SWAP    A
        CALL    HEX2ASCII
        CALL    SENDCHAR        ; send high nibble
        POP     ACC
        PUSH    ACC
        CALL    HEX2ASCII
        CALL    SENDCHAR        ; send low nibble
        POP     ACC

        RET


;____________________________________________________________________
                                                          ; HEX2ASCII

HEX2ASCII:      ; converts A into the hex character representing the
                ; value of A's least significant nibble

        ANL     A,#00Fh
        CJNE    A,#00Ah,$+3
        JC      IO0030
        ADD     A,#007h
IO0030: ADD     A,#'0'

        RET

;____________________________________________________________________
                                                              ; DELAY
DELAY:			  ; Delays by * A
			  
					

	  MOV	R2,A	   ; Acc holds delay variable
 DLY0:	  MOV	R3,#255     ; Set up delay loop0
 DLY1:	  MOV	R4,#255    ; Set up delay loop1
	  DJNZ	R4,$	   ; Dec R4 & Jump here until R4 is 0
                           ; 
	  DJNZ	R3,DLY1    ; Dec R3 & Jump DLY1 until R3 is 0
                           ;
	  DJNZ	R2,DLY0    ; Dec R2 & Jump DLY0 until R2 is 0
                           ; 
	  RET		   ; Return from subroutine

;____________________________________________________________________


TITLE:    DB 10,10,13,'____________________________________',10,13
          DB 'Analog Devices MicroConverter ADuC847',10,13
          DB '         UART Demo Routine',10,13
          DB '  Transmission of Data from 0 to 7F',10,13,0

END