;====================================================================
;
; Author        : ADI - Apps
;
; Date          : Oct 2003
;
; File          : Tim2_AR.asm
;
; Hardware      : ADuC847
;
; Description   : Flashes light every 65536 machine cycles 
;		  using timer 2 in Auto Reload Mode. 
;____________________________________________________________________
$MOD847                                 ;Use 8052 predefined Symbols

LED	EQU	P3.4

;____________________________________________________________________
                                                  ; BEGINNING OF CODE
CSEG
ORG 0000H

	JMP MAIN
;____________________________________________________________________
                                          ; TIMER 2 INTERRUPT ROUTINE
ORG 002Bh

        CPL     LED        ; Flash the light
        CLR     TF2        ; The TF2 flag must be cleared in software
        RETI


;____________________________________________________________________
                                                       ; MAIN PROGRAM
ORG 0060h                    ; Start code at address above interrupts			

MAIN:                         ; Main program

        SETB     ET2          ; Enable timer2 interrupt

        MOV      TL2, #00h    ; Initialise timer 2 registers & Reload 
        MOV      TH2, #00h    ; values to rollover every 65536
        MOV      RCAP2L, #00h ; machine cycles 
        MOV      RCAP2H, #00h

        SETB     EA           ; Enable interrupts

	MOV	 T2CON, #04h  ; Start timer 2 in 16-bit reload mode

        JMP      $            ; Wait here for timer Interrupts

END
