;********************************************************************
;
; Author        : ADI - Apps            www.analog.com/MicroConverter
;
; Date          : Oct 2003
;
; File          : TIC.asm
;
; Hardware      : ADuC847
;
; Description   : Demonstrates a use of a timer interval counter for 
;		counting longer intervals than the standard 8052 
;		timers are capable of.
;		
;		The LED will flash on power up. By pressing
;		the external interrupt button INT0 the counter will 
;		count how long the button is pressed correct to 
;		1/128th of a second. When released the program will 
;		flash the light at the measured time correct only to
;		the nearest unit (1/128s, seconds, minutes or hours)
;		rounded DOWN.
;		eg) If the button was pressed for 0.91000s the light
;		would complement every 0.90625s (less than 1 second
;		therefore it measures in 1/128s and the nearest unit 
;		less than 0.91000s is 0.90625s). However if the light
;		was on for 1.6s it complements every 1s as the nearest
;		unit is now the second.
;		Pressing the INT0 button again will record a new 
;		time interval which will flash the light in the same
;		way.

;********************************************************************

$MOD847                         ; Use ADuC847 predefined symbols

LED     EQU     P3.4            ; P3.4 drives red LED on eval board
BUTTON  EQU     P3.2		; P3.2 drives the INT0 button on the
				; eval board

;____________________________________________________________________
                                                  ; BEGINNING OF CODE
CSEG
ORG 0000h
        JMP     MAIN            ; jump to main program

;____________________________________________________________________
                                    ; EXTERNAL INTERRUPT VECTOR SPACE
ORG 0003h ;  (INT0 ISR)			

	SETB	LED		; Turn ON the LED while the INT0 
                                ; is pressed

; reset all counters and then start counting	
        ANL     TIMECON, #0FEh  ; Clear the TCEN bits to clear the
                                ; registers; 
                                ;  -Hthsec
                                ;  -sec
                                ;  -min
                                ;  -hour.
                                ; and to clears the internal counter

        ORL     TIMECON, #01h  ; Set the TCEN bit to restart counting

        JNB     BUTTON, $       ; Wait here while button is pressed

        ANL     TIMECON, #0FDh  ; Clear the TIEN bit to stop the 
                                ; counter

; after button is released we can store the value in intval 

LOOP:   CLR     LED             ; Turn off LED to indicate that the 
				; button is released.
	MOV	A, HOUR		
	CJNE	A, #00H, HOURS	; Check if any hrs have been counted
				; If so jump to HOURS
        MOV	A, MIN			
	CJNE	A, #00H, MINS	; Check if any mins have been counted
				; If so jump to MINS
        MOV	A, SEC
        CJNE	A, #00H, SECS	; Check if any secs have been counted
				; If so jump to SECS
	
HUNTHS:	MOV	INTVAL, HTHSEC	;load the value of HTHSEC into INTVAL
	MOV     TIMECON, #00h   ; clear TCEN to reset the registers
        MOV     TIMECON, #03H   ; change TIMECON to measure in 1/128s
				; reset TIEN
	RETI

SECS:	MOV	INTVAL, SEC	; load the value of SEC into INTVAL
	MOV     TIMECON, #00h   ; clear TCEN to reset the registers
	MOV	TIMECON, #13H	; change TIMECON to measure in secs
	RETI

MINS:	MOV	INTVAL, MIN	; load the value of MIN into INTVAL
	MOV     TIMECON, #00h   ; clear TCEN to reset the registers
	MOV	TIMECON, #23H	; change TIMECON to measure in mins
	RETI

HOURS:	MOV	INTVAL, HOUR	; load the value of HOUR onto INTVAL
	MOV     TIMECON, #00h   ; clear TCEN to reset the registers
	MOV	TIMECON, #33H	; change TIMECON to measure in hours
        RETI
;____________________________________________________________________
                                         ; TII INTERRUPT VECTOR SPACE
ORG 0053h
       
	CPL LED        		; Complement the LED every time the 
				; measured time runs up.
	RETI
;_____________________________________________________________________

ORG 0100h

MAIN:	

; Configure Time Interval Counter  
	;MOV PLLCON, #07h
	MOV HTHSEC, #00h
	MOV SEC, #00h
	MOV min, #00h
	mov hour, #00h

	MOV    TIMECON, #03h  ; initialise timecon to count in 1/128s
                              ; -set TCEN to enable the time clock
                              ; -set TIEN to enable the TIC 
                              ; -clear STI to allow automatic relaod
                              ;  of interval timeout 
			      ; -clear TFH to disable 24 hr counting

        MOV    INTVAL, #0Ah   ; initialise to blink LED every 10 units
                              ; the units are 1/128s .... 
			      ;1/(10 * 1/128) = 12.8Hz = LED toggle rate         

; Configure External Interrupt
	SETB    IT0            ; INT0 edge triggered
        SETB    EX0            ; enable INT0 (button on eval board)
	MOV     IEIP2,#04H     ; enable time interval interrupt
        
        SETB    EA             ; enable global interrupts


	JMP     $              ; wait here for interrupts
                               ; main program can be inserted here
	
;____________________________________________________________________

END
