;********************************************************************
;
; Author        : ADI - Apps            www.analog.com/MicroConverter
;
; Date          : Oct 2003
;
; File          : PDown.asm
;
; Hardware      : ADuC847
;
; Description   : Demonstrates a use of a timer interval counter to
;		wake the ADuC847 out of Power down mode after a user
;		specified Power down time.
;
;		The LED will, on power up, flash at approx 1Hz. After approx 40s
;		the ADuC847 will enter power down mode (the LED will 
;		stop flashing in the on position). 
;		
;		By pressing the external interrupt 0 button (INT0) or
;		when the user specified time runs ou the ADuC847 will wake up 
;		and continue blinking as before before entering power down
;		mode again.
;
;********************************************************************

$MOD847                         ; Use 8052 predefined symbols

LED     EQU     P3.4            ; P3.4 drives red LED on eval board

;____________________________________________________________________
                                                  ; BEGINNING OF CODE
CSEG

ORG 0000h

        JMP     MAIN            ; jump to main program


;____________________________________________________________________
                                    ; EXTERNAL INTERRUPT VECTOR SPACE
ORG 0003h 	
	RETI

;____________________________________________________________________
                                         ; TIC INTERRUPT VECTOR SPACE
ORG 0053h
	RETI
;_____________________________________________________________________

ORG 0060h

MAIN:			
        MOV     IEIP2, #0A4h    ; enable time interval interrupt
        
	SETB	IT0             ; INT0 edge triggered
        SETB    EX0             ; enable INT0 (button on eval board)
	SETB    EA              ; enable interrupts

	MOV     INTVAL, #14h    ; initialise intval to 20 
                                ;     => 20 unit delay

BLINK:  MOV     R0, #50       
       
LOOP:   MOV     A, #5          ; Blink light 50 times
        CALL    DELAY
        CPL     LED
        DJNZ    R0, LOOP

	MOV	TIMECON, #13h  ; initialise timecon to 
		               ; -count in secs
	                       ; -start all time counters     

        CLR     LED            ; turn off light when in power down
        MOV     PCON, #22h     ; power down the ADuC847
                               ; Execution stops here until the ADuC
                               ; is powered up again by either an 
                               ; external interrupt or a Time Interval
                               ; Interrupt 
                               ; Note: if using external data mem 
                               ; make sure ALE remains toggling after
                               ; you power up again. i.e. PCON.4=0
 
        MOV	TIMECON, #12h  ; disable TCEN to reset counter to 0
                               ; and to temporarily stop counter 
        JMP     BLINK
        

;____________________________________________________________________
                                                              ; DELAY

DELAY:			  ;
					

	  MOV	R2,A	   ; Acc holds delay variable
 DLY0:	  MOV	R3,#255    ; Set up delay loop0
 DLY1:	  MOV	R4,#255    ; Set up delay loop1
	  DJNZ	R4,$	   ; Dec R4 & Jump here until R4 is 0
                           ; 
	  DJNZ	R3,DLY1    ; 
                           ; 
	  DJNZ	R2,DLY0    ; 
                           ;
	  RET		   ; Return from subroutine


;____________________________________________________________________

END
