;********************************************************************
;
; Author        : ADI - Apps            www.analog.com/MicroConverter
;
; Date          : July 2003
;
; File          : DualDPTR.asm
;
; Hardware      : ADuC847
;
; Description   : Sample Program to show the new ADuC847 features 
;                 of dual DPTRs. In Aspire debugger select Program
;		  Memory and External Memory from the Debug View Bar.
;                 Under Run -> Select Uploadable Areas and under 
;		  External Memory type 0-200 and click OK. This enables 
;		  real time uploading of these locations from this memory
;		  area into the debugger. 
;		  NOTE: Several lines of this program will have to be 
;		  disabled, most notably the UART configuration section
;		  due to the use of the UART debugger. 
;********************************************************************

$MOD847                         ; Use ADuC847 predefined symbols
LED     EQU     P3.4            ; P3.4 drives red LED on eval board

;____________________________________________________________________
                                                  ; BEGINNING OF CODE
CSEG

ORG 0000h
; highest speed
	MOV	PLLCON, #0	;Disable PLLCON write when using debugger

; CONFIGURE UART....

        MOV     T3CON,#86h	;Will need to disable UART configuration
        MOV     T3FD,#12h	;when using debugger as any writes to UART
        MOV     SCON,#52h       ;timing or config registers could affect
                                ;the debugger interface
; enable the intenal On-Chip XRAM
	
	MOV     CFG847, #01h

; move 512 bytes from code memory (adress 1000h -> 1200h) into
; data XRAM (address 0000h -> 0200h)
	; configure the datapointer
	MOV	DPTR, #0
	MOV	DPCON, #55h	; auto toggle between DPTRs
				; auto increment shadow DPTR
				; auto increment main DPTR
				; select shadow DPTR
	MOV	DPTR, #1000h

COPYDATALOOP:
	; read Code Memory using Shadow DPTR
	CLR	A
	MOVC	A, @A+DPTR	; read code memory
				; auto increment shadow DPTR
				; swap to main DPTR
	; write to XRAM using main DPTR
	MOVX	@DPTR, A	; write to XRAM
				; auto increment main DPTR
				; swap to shadow DPTR
	; check if at end of loop
	; NOTE:  shadow DPTR selected (not main)
	MOV	A, DPH
	CJNE	A, #12h, COPYDATALOOP


	NOP	; <----NOTE: Set a breakpoint in the debugger here
		; This will show that the values in code memory
		; at addresses 1000h thru 1200h has been mapped
		; into XRAM at address 0000h thru 0200h.
		; The debugger will not run the nextpiece of
		; code as this requires the use of the serial port




; transmit XRAM up UART
	MOV	DPCON, #4	; select main DPTR
				; auto increment DPTR
				; do not toggle DPTR
	MOV	DPTR, #0
	MOV	R0, #16
SENDXRAM:
	MOVX	A, @DPTR
	CALL	SENDVAL
	DJNZ	R0, SENDXRAM
	; send a newline
	MOV	A, #10
	CALL	SENDCHAR
	MOV	A, #13
	CALL	SENDCHAR
	MOV	R0, #16
	MOV	A, DPH
	CJNE	A, #2, SENDXRAM

	JMP	$


;____________________________________________________________________
                                                            ; SENDVAL

SENDVAL:        ; converts the hex value of A into two ASCII chars,
		; and then spits these two characters up the UART.
                ; does not change the value of A.

        PUSH    ACC
        SWAP    A
        CALL    HEX2ASCII
        CALL    SENDCHAR        ; send high nibble
        POP     ACC
        PUSH    ACC
        CALL    HEX2ASCII
        CALL    SENDCHAR        ; send low nibble
        POP     ACC

        RET
;____________________________________________________________________
                                                           ; SENDCHAR

SENDCHAR:       ; sends ASCII value contained in A to UART

        JNB     TI,$            ; wait til present char gone
        CLR     TI              ; must clear TI
        MOV     SBUF,A

        RET
;____________________________________________________________________
                                                          ; HEX2ASCII

HEX2ASCII:      ; converts A into the hex character representing the
                ; value of A's least significant nibble

        ANL     A,#00Fh
        CJNE    A,#00Ah,$+3
        JC      IO0030
        ADD     A,#007h
IO0030: ADD     A,#'0'

        RET
;____________________________________________________________________
ORG 1000h

DB  00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
DB  10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
DB  20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
DB  30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh
DB  00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
DB  10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
DB  20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
DB  30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh
DB  00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
DB  10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
DB  20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
DB  30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh
DB  00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
DB  10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
DB  20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
DB  30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh
DB  00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
DB  10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
DB  20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
DB  30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh
DB  00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
DB  10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
DB  20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
DB  30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh
DB  00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
DB  10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
DB  20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
DB  30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh
DB  00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
DB  10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
DB  20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
DB  30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh


;____________________________________________________________________

END
