;********************************************************************
;
; Author        : ADI - Apps            www.analog.com/MicroConverter
;
; Date          : 5 November 2001
;
; File          : 847uart1.asm
;
; Hardware      : ADuC847
;
; Description   : sample program that performs ADC conversions in
;                 continuous mode and sends results to a PC via the
;                 UART. Ain channel is Ain1 -> AinCom, Unipolar Mode 
;		  Connect a potentiometer between Vref & Agnd. Connect 
;		  the wiper to Ain1. 
;		  The results of the ADC operation can be viewed using
;		  a Hyperterminal window configured to the appropriate
;		  serial port and using 9600 Baud Rate.
;
;	
;********************************************************************

$MOD847                         ; Use 8052 predefined symbols
LED       EQU     P3.4          ; P3.4 drives red LED on eval board

;____________________________________________________________________
                                                  ; BEGINNING OF CODE
CSEG

ORG 0000h

        JMP     MAIN

;____________________________________________________________________
                                             ; INTERRUPT VECTOR SPACE

ORG 0033h ; (ADC ISR)
	Clr EA
        CPL     LED

        MOV     DPTR,#SEPERATOR         ; send linefeed+CR out UART
        CALL    SENDSTRING

        MOV     A,ADC0H                 ; send ADC data via UART
        CALL    SENDVAL
        MOV     A,ADC0M
        CALL    SENDVAL
        MOV     A,ADC0L
        CALL    SENDVAL
	CLR     RDY0
        SETB EA
        RETI

;====================================================================
                                                       ; MAIN PROGRAM
ORG 0100h

MAIN:
        MOV     SP,#127

; CONFIGURE UART....
        MOV     T3CON,#83h	;9600 Baud
        MOV     T3FD,#12h
        MOV     SCON,#52h

; CONFIGURE ADC....
	CLR     RDY0
        MOV     SF,#45h         ; 
        MOV     ADC0CON1, #07h  ; Buf enabled, Unipolar, Range +2.56V
	MOV 	ADC0CON2, #40h  ; Ref+/- enabled, Ain1 -> Aincom
	MOV     ADCMODE, #34h	; Ofs Calibration on Ain1 -> AinCom
	MOV     ADCMODE, #35h	; Gain Calibration on Ain1 -> AinCom
	MOV     A, OF0H         ; Write OFFSET calibration values to UART		
	call    SENDVAL
	MOV     A, OF0M
 	call    SENDVAL
	MOV     A, OF0L
	Call    SENDVAL
	MOV     DPTR,#SEPERATOR ; send linefeed+CR out UART
        CALL    SENDSTRING
	MOV     A, GN0H		; Write GAIN calibration values to UART
	call    SENDVAL
	MOV     A, GN0M
	call    SENDVAL
	MOV     A, GN0L
	call    SENDVAL
	MOV     DPTR,#SEPERATOR ; send linefeed+CR out UART
        CALL    SENDSTRING
;	jmp $			;Used only if Cal values alone are required
	
        SETB    EADC            ; enable ADC interrupt (trig on RDY0)
        
;___________________________________________________________________
; START CONVERTING & WAIT FOR INTERRUPTS OR INCOMING UART COMS....
WAIT:   SETB    EA     
        MOV  ADCMODE,#033h      ; Cont conversion mode, Chop enabled
	JMP $			; Wait here for ADC interrupt
;____________________________________________________________________

$INCLUDE(UARTIO.asm)

;____________________________________________________________________
                                                   ; TEXT DATA TABLES

SEPERATOR:      DB 10,13,0
CALZSMSG:       DB 'Z',0
CALGNMSG:       DB 'G',0
CALDONEMSG:     DB 'x',0

;____________________________________________________________________

END
