//**************************************************************
// File         : RTDlin.c
// Author       : Automatically generated using 'coefRTD.exe'
// Compiler     : intended for Keil C51
// Description  : Subroutines for linearization of RTD signals
//                using single linear approximation method.
// More Info    : Details in application note AN-709, available
//                at....  http://www.analog.com/MicroConverter
//**************************************************************

// definitons....
#define TMIN (-45)  // = minimum temperature in degC
#define TMAX (85)  // = maximum temperature in degC
#define RMIN (82.2902)  // = input resistance in ohms at -45 degC
#define RMAX (132.803)  // = input resistance in ohms at 85 degC

// single linear approximation coefficients....
#define A (2.57359)
#define B (-257.099)

// linearization routine error band:  
//   = -0.317535degC .. 0.317538degC
// specified over measurement range -45degC .. 85degC

// _____________________________________________________________
// Temperature of RTD Function                             T_rtd
// input: r = resistance of RTD
// output: T_rtd() = corresponding temperature of RTD
// Calculates temperature of RTD as a function of resistance via
// a single linear approximation method.

float T_rtd (float r) {
  float t;

  // compute temperature
  t = A*r + B;

  return (t);
}

// _____________________________________________________________
// Resistance of RTD Function                              R_rtd
// input: t = temperature of RTD
// output: R_rtd() = corresponding resistance of RTD
// Calculates resistance of RTD as a function of temperature via
// a single linear approximation method.

float R_rtd (float t) {
  float r;

  // compute resistance
  r = (t-B)/A;

  return (r);
}

// _____________________________________________________________
// Minimum Temperature Function                         Tmin_rtd
// Returns minimum temperature specified by lookup table.
float Tmin_rtd () {
  return (TMIN);
}

// _____________________________________________________________
// Maximum Temperature Function                         Tmax_rtd
// Returns maximum temperature specified by lookup table.
float Tmax_rtd () {
  return (TMAX);
}

// _____________________________________________________________
// Minimum Resistance Function                          Rmin_rtd
// Returns minimum RTD resistance specified by lookup table.
float Rmin_rtd () {
  return (RMIN);
}

// _____________________________________________________________
// Maximum Resistance Function                          Rmax_rtd
// Returns maximum RTD resistance specified by lookup table.
float Rmax_rtd () {
  return (RMAX);
}
