//********************************************************************
//
// Author        : ADI - Apps            www.analog.com/MicroConverter
//
// Date          : 16 October 2003
//
// File          : 847uart.c
//
// Hardware      : ADuC847
//
// Description   : sample program that performs ADC conversions in
//                 continuous mode and sends results to a PC via the
//                 UART.
//
//********************************************************************

#include <stdio.h>
#include <ADuC847.h>

sbit LED = 0x0B4;

void ADC_int () interrupt 6
{
	LED ^= 1;
	printf("\n\n");
	printf("%bX%bX%bX",ADC0H,ADC0M,ADC0L);
    RDY0 = 0;
}

void main (void)
{

	//Configure UART
    T3CON = 0x83;	//9600 Baud rate
    T3FD = 0x12;
    SCON = 0x52;

	//CONFIGURE ADC AND START CONVERTING....
    SF = 0x200;
    ADC0CON1 = 0x07;	//Full Buffer, Bipolar, +/-2.56V range.
    ADC0CON2 = 0x4A;	//Refin+/-, Ain1->Ain2
    EADC = 1;           //Enable ADC Interrupt
    EA = 1;             //Enable Global Interrupts
    ADCMODE = 0x23;	// continuous conversion on Main channel on main channel

	//WAIT FOR INTERRUPTS....
	while(1);
}

