

/***********************************************************************************************
 *                                                                                             *
 *                Example 2. Tell Time Every 30 Minuit (Address Mode)                          *
 *                                                                                             *
 ***********************************************************************************************
 * Target MCU        : PIC18F8722 (ET-BASE PIC8722)                                            *
 *                   : X-TAL : 10 MHz                                                          *
 *                   : CPU Clock = 40 MHz (x4)                                                 *                                                                  *
 * Editor-Compiler   : CCS Version 4.120                                                       *
 *                                                                                             *
 * Port Interface    :                                                                         *
 *                                                                                             *
 *            SPI    :    # MCU-PIC18F8722 #            ET-Mini ISD2548                        *
 *                        ------------------            ---------------                        *
 *                                                                                             *                                   
 *                          RD0            connect        DIN                                  *                
 *                          RD1            connect        SCK                                  *
 *                          RD2            connect        STB                                  *               
 *                          RD3(IN)        connect        EOM (Must Pull Up)                   *               
 *                          GND            connect        ENA                                  *             
 *                          NO USE         connect        OVF                                  *            
 *                                                                                             *
 *                                                                                             *
 *                                    5V                                                       *
 *                                  --+--                                                      *
 *                                    |                                                        *
 *                                    \                                                        *
 *                                    / 10K                                                    *
 *                                    \                                                        *
 *                                    /                                                        *
 *                                    |                                                        *
 *                                    |                                                        *
 *                                    |                                                        *
 *                                    |         ET-Mini ISD2548       5V                       *
 *                                    |      +-------------------+   --+--                     *
 *                                    |      |                   |     |                       *
 *                           RD0 -----|----->|DIN            +5V +-----+      /|               *
 *                           RD1 -----|----->|SCK                |          /  |               *
 *                           RD2 -----|----->|STR            SP+ +--------||   |               *
 *                           RD3 <----+------|EOM                |        || SP|               *
 *                                           |               SP- +--------||   |               *
 *                                           |                   |          \  |               *
 *                               +-----------|ENA            GND +-----+      \|               *
 *                             __|__         |                   |   __|__                     *
 *                              ---          |                   |    ---                      *
 *                               -        ---|VOF                |     -                       *
 *                                           |                   |                             *
 *                                           |                MIC|----                         *
 *                                           +-------------------+                             *
 *                                            Set Jp1 : to GND                                 *
 *                                                Jp2 : No use (Don't care)                    *
 *                                                                                             *
 *                                                                                             * 
 *                                                                                             *
 *                                                                                             *
 *                                                                                             *
 *         LCD     :   # MCU-PIC18F8722 #                  # LCD 2x16 DISPLAY #                *
 *                     ------------------                  --------------------                *
 *                                                                                             *
 *                          RH1            Connect            RS(OUT)                          *
 *                          RH2            Connect            R/W(OUT)                         *
 *                          RH3            Connect            EN(OUT)                          *  
 *                          RH4-RH7        Connect            Data 4 bit high(Out)             *
 *                                                                                             * 
 *        5V                                                                                   *
 *      --+--                                                                                  *
 *        |                                                                                    *
 *        +-----------------+                                                                  *
 *        |                 |                                                                  *
 *       ---                |                                                                  *
 *       |\|                |                                                                  *
 *    VR |/|<---------------|--+                                                               *
 *   10K ---                |  |  RH1 RH2 RH3            RH4 RH5 RH6 RH7                       *
 *        |                 |  |   ^   ^   ^              ^   ^   ^   ^                        *
 *        |                 |  |   |   |   |              |   |   |   |                        *
 *        +--------------+--|--|---|---|---|--+--+--+--+  |   |   |   |                        *
 *      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|                        *
 *                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_                       *
 *                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |                      *
 *                    |    _________________________________________    |                      *
 *                    |   |                                         |   |                      *
 *                    |   |               Module                    |   |                      *
 *                    |   |         LCD 2x16 Charecter              |   |                      *  
 *                    |   |_________________________________________|   |                      *
 *                    |                                                 |                      *
 *                    |_________________________________________________|                      *
 *                                                                                             *       
 *                                                                                             *
 *   I2C RTC:DS3232: Interface I2C(ID:1101000X = 0xD0(Wr),0xD1(Rd) )                           * 
 *                                                                                             *
 *                 # MCU-PIC18F8722 #                    Mini-DS3232 Module                    *                                                                    *
 *                 -------------------                   -------------------                   *
 *                    RA0 (SDA-I/O)      Connect           SDA(DATA)                           *
 *                    RA1 (SCK-OUT)      Connect           SCL(CLOCK)                          *
 *                                                                                             *        
 *                                                                                             * 
 *                                                                                             *
 *                                 Module ET-ETMI DS3232                                       *
 *                                   -----------------                                         *
 *                                  |                 |                                        *
 *                    VCC --------->|+5V              |                                        *
 *                    RA1 --------->|SCL              |                                        *
 *                    RA0 --------->|SDA              |                                        *
 *                            Nc ---|SQW/INT#         |                                        *
 *                            Nc ---|32KHz            |                                        *
 *                            Nc ---|RST              |                                        *
 *                       +--------->|GND              |                                        *
 *                       |           -----------------                                         *
 *                       |                                                                     *
 *                     __|__                                                                   *
 *                      ---                                                                    *
 *                       -                                                                     *
 *                                                                                             *
 *  Before Operate  :    Use Example_1 for Record Message of Time by 1 Message Use 9 adress    *
 *                                                                                             *
 *                       Message 02 Record : Way-la     (Start Address 9 )                     *
 *                          "    03   "    : Na-ri-ka   (Start Address 18 )                    *
 *                          "    04   "    : Na-tee     (Start Address 27 )                    *
 *                          "    05   "    : Vi-na-tee  (Start Address 36 )                    * 
 *                          "    06   "    : 0          (Start Address 45 )                    * 
 *                          "    07   "    : 1          (Start Address 54 )                    *
 *                          "    08   "    : 2          (Start Address 63 )                    *
 *                          "    09   "    : 3          (Start Address 72 )                    *
 *                          "    10   "    : 4          (Start Address 81 )                    *
 *                          "    11   "    : 5          (Start Address 90 )                    *
 *                          "    12   "    : 6          (Start Address 99 )                    * 
 *                          "    13   "    : 7          (Start Address 108)                    *
 *                          "    14   "    : 8          (Start Address 117)                    *
 *                          "    15   "    : 9          (Start Address 126)                    *  
 *                          "    16   "    : 10         (Start Address 135)                    * 
 *                          "    17   "    : ed         (Start Address 144)                    *
 *                          "    18   "    : 20         (Start Address 153)                    *
 *                       Message 19 Record : ka-na-nee  (Start Address 162)                    *
 *                                                                                             *                                                                       *
 *                                                                                             *
 *                                                                                             *   
 * Last Update     : 17/Junly/2012                                                             *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/



#include <18F8722.h>
#include <stdio.h>

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)

#use fast_io(ALL)                                //Stop Set direction Auto for All Port  by Compiler  


int8 fag_mn,fag_hh     ;
int16 ss,mn,hh,addr    ;
int16 add_hh1,add_hh2  ;


/******************************************************
 **             Function Initial Port                **
 ******************************************************/

 void Init_Port(void)
  {
  
     set_tris_A(0x00)   ;    //Set RA0..RA7 = Output For I2C 
     set_tris_D(0x08)   ;    //Set RD0..RD2 = Output For SPI Control ISD2548 ;RD3 = Input For EOM 
     set_tris_H(0x00)   ;    //Set RH0..RH7 = Output For LCD

    
    //--- Set default output Port ---

     OUTPUT_A(0x00)     ; 
     
  }


/*******************************************************
 **                                                   **
 **                     FUNCTION LCD                  **
 **                                                   **
 *******************************************************/ 


//----------------- Define LCD Control Pin -----------------------

#define Ena_Hi()     OUTPUT_HIGH(PIN_H3) ;         //RH3 = ENA:1
#define Ena_Lo()     OUTPUT_LOW(PIN_H3)  ;         //RH3 = ENA:0



//------------------ write instruction LCD ---------------------
 
void Write_Cmm(unsigned int8 cmm)
{
  OUTPUT_H(cmm & 0xF0 )               ;    //Sent cmm 4 bit(RH4-RH7) High , RS:RH1 = 0 ,R/W:RH2 = 0
  Ena_Hi()                            ;    
  delay_us(300)                       ;
  Ena_Lo()                            ;    
  delay_us(300)                       ;

  OUTPUT_H((cmm << 4) & 0xF0)         ;    //Sent cmm 4 bit(RH4-RH7) Low , RS:RH1 = 0 ,R/W:RH2 = 0
  Ena_Hi()                            ;   
  delay_us(300)                       ;
  Ena_Lo()                            ;   
  delay_us(300)                       ;
}

//------------------ write data lcd ----------------------

void Write_Data(unsigned int8 dat)
{
  
  OUTPUT_H((dat & 0xF0)|0x02)         ;    //Sent data 4 bit(RH4-RH7) High , RS:RH1 = 1 ,R/W:RH2 = 0
  Ena_Hi()                            ;    
  delay_us(300)                       ;
  Ena_Lo()                            ;    
  delay_us(300)                       ;

  OUTPUT_H(((dat << 4) & 0xF0)|0x02)  ;    //Sent cmm 4 bit(RH4-RH7)Low , RS:RH1 = 1 ,R/W:RH2 = 0
  Ena_Hi()                            ;   
  delay_us(300)                       ;
  Ena_Lo()                            ;   
  delay_us(300)                       ;
}


//------------------ Clear All Display LCD ----------------------

void Clr_Display(void)
 {
  Write_Cmm(0x01) ;
 }


//--------------------- initial lcd ------------------------
 
void Init_Lcd(void)
{
  Write_Cmm(0x33)        ;            //Command Control 
  Write_Cmm(0x32)        ;
  Write_Cmm(0x28)        ;
  Write_Cmm(0x0C)        ;           //Set Display On/Off:Display On,Not Show Cursor and not blink Cursor
  Write_Cmm(0x06)        ;           //Set Entry Mode :Increment Address,Cursor Shift Right
    
  Write_Cmm(0x1C)        ;           //Set Cursor Or Display Shift : Shift Right Charecter
  Write_Cmm(0x28)        ;           //Function Set: set interface data 4bit,Set Display LCD 2 Line ,Set Charecter Size 5x7
  Write_Cmm(0x80|0x00)   ;           //Set Address Begin 0x00 (Line1 Charecter1)
  Clr_Display()          ;
}



/***************************************************************
 **                Function SPI Seny data 12 bit              **
 ***************************************************************
 **          RD0 = SDO                                        **
 **          RD1 = SCK                                        **
 **          RD2 = STROB                                      **   
 **                                                           **
 ***************************************************************/

//--------------- Define Pin -----------------------


//--------------- SDO-High(Data-Out) ---------------

#define     Sdo_Hi()          OUTPUT_HIGH(PIN_D0) ;            //RD0= SDO:1
                          
//--------------- SDO-Low(Data-OUT) ----------------

#define     Sdo_Lo()          OUTPUT_LOW(PIN_D0)  ;            //RD0= SDO:0


//--------------- Sck-High(Clock) ---------------

#define     Sck_Hi()          OUTPUT_HIGH(PIN_D1)  ;            //RD1= SCK:1
                          
//--------------- Sck-Low(Clock) ----------------

#define     Sck_Lo()         OUTPUT_LOW(PIN_D1)  ;            //RD1= SCK:0


//--------------- STR-High(Strob) ---------------

#define     Str_Hi()          OUTPUT_HIGH(PIN_D2)  ;          //RD2= Str:1
                          
//--------------- STR-Low(Strob) ----------------

#define     Str_Lo()          OUTPUT_LOW(PIN_D2)  ;            //RD2= Str:0



//----------------- Write Data to ISD2548 12-bit -------------------

void Spi_Wr(unsigned int16 DWord)              
 {
    unsigned int16 Bit ;                   

     Str_Lo()                            ;   //Start Strob 595 to Low

     for(Bit=0;Bit<12;Bit++)                 //Loop write data 12 Bit
      {      
         Sck_Lo()                        ;   //Start 595 Clock  Low

      //--------- write Data(RD0) ---------

        if((DWord & 0x800)== 0x800)
         {
          Sdo_Hi()                       ;   //Set bit data(RD0) = 1
         }
        else 
         {
          Sdo_Lo()                       ;    //Clear bit data(RD0) = 0
         } 
      
        Sck_Hi()                         ;   //Set 595 Clock High for Shift data bit

        DWord <<= 1                      ;   //Shift Next Bit Data        
   
     }

     Str_Hi()                            ;   //Set Strob 595 to High for Out data parallel 


  }


/***************************************************************
 **                    FUNCTION ISD2548                       **
 ***************************************************************
 **  - Memory = 320 Address                                   **
 **  - Time Record Max = 48 secound                           **
 **  - 1 Address   = Time Record 0.15 secound                 **
 **                                                           **
 ***************************************************************/


//-------- Define Data Control ISD2548 ------------

#define PL_CHi            0xA00      //CE,P/R=1;PD=0
#define PL_CLo            0x200      //P/R=1;CE,PD=0
#define REC_CHi           0x800      //CE=1;PD,P/R=0
#define REC_CLo           0x000      //CE,PD,P/R =0
#define STOP              0xE00      //CE,PD,P/R = 1 

//---------------- Read Status EOM : End OF Message ---------------- 
int8 Rd_Eom()
{
  int8 eom                 ;
       
  eom  = INPUT(PIN_D3)     ; //Read RD3 : 0 = end of message , Nomal = 1   
  return eom               ;  
}

//------------------- Check Status EOM -----------------
void Chk_Eom()
 {
  while(Rd_Eom()){;}         // Check Signal EOM to 0 : EOF = 0 :Exit Loop(for End message) 
  while(!Rd_Eom()){;}        // Check Signal EOM to 1 : EOF = 1 :Exit Loop (for Ready Begine Play   Next Message)
 }


//------------ Set Address for Play or Record(Addtess 0-320) ------------

void Set_Add(int16 add)
 { 

   addr = add & 0x1FF   ;  //Mark data Bit9-11 for write  Pin P/R,PD,CE 
   Spi_Wr(addr|STOP)    ;  //Write Pin Address A0-A8 and Pin Contr0l To ISD2548  

 }

//-------------------- Play 1 Message ---------------------

void Play_Back()
 {

   addr = addr &0x01FF   ;  //Mark data Control Bit9-11 Pin P/R,PD,CE for  Play
   Spi_Wr(addr|PL_CLo)   ;  //Write Pin Address A0-A8 and Pin Control for Play To ISD2548(Pin CE =0) 

   addr = addr &0x01FF   ;
   Spi_Wr(addr|PL_CHi)   ;  //Write Pin CE = 1

 }

//----------------- Initial ISD2548 ---------------

 void Init_ISD2548()
  {

    Spi_Wr(STOP)   ;     
    
  }


/**************************************************
 **                 PLAY MESSAGE Time            **
 **************************************************/

void Msg_Time()
 {
     //--------------- Play Message --------------

      Set_Add(162)                  ;  //Set Address for Play " ka-Na-Nee "
      Play_Back()                   ;  //Play Message            
      Chk_Eom()                     ;

      Set_Add(9)                    ;  //Set Address for Play " Way-La"
      Play_Back()                   ;  //Play Message            
      Chk_Eom()                     ;


     
    //**************** Play Time Hour every half hour *******************

     if(fag_hh==1)                          //Check Fag_Hour =1 for Play 2 Message
     {          
       Set_Add(add_hh1)                  ;  //Set Address for Play Number Colum 1 (10,20)
       Play_Back()                       ;  //Play Message            
       Chk_Eom()                         ;
      
       Set_Add(add_hh2)                  ;  //Set Address for Play Number Colum 2 (1-9)
       Play_Back()                       ;  //Play Message            
       Chk_Eom()                         ;
     }
    else                                    //Fag_Hour =0 for Play 1 Message
     {
       Set_Add(add_hh1)                  ;  //Set Address for Play Number (1-9)
       Play_Back()                       ;  //Play Message            
       Chk_Eom()                         ;

     }

    //-------------- Play Message ----------------
      Set_Add(18)                        ;  //Set Address for Play " Narika "
      Play_Back()                        ;  //Play Message            
      Chk_Eom()                          ;
 


    //**************** Play Time Minute at 0,30  Minute *******************
   
    if(fag_mn==1)                          //Check Fag_minute=1 for Play 2 Message
     {          
       Set_Add(72)                      ;  //Set Address for Play "3" 
       Play_Back()                      ;  //Play Message            
       Chk_Eom()                        ;
      
       Set_Add(135)                     ;  //Set Address for Play "10" 
       Play_Back()                      ;  //Play Message            
       Chk_Eom()                        ;
     }
   else                                    //Check Fag_minute for Play 1 Message
     {
       Set_Add(45)                      ;  //Set Address for Play "0" 
       Play_Back()                      ;  //Play Message            
       Chk_Eom()                        ;

     }
     
   //-------------- Play Message ----------------
      Set_Add(27)                       ;  //Set Address for Play " Na-Tee "
      Play_Back()                       ;  //Play Message            
      Chk_Eom()                         ;
 


   //*************** Play Time Secound at 0 Secound *******************
             
      Set_Add(45)                       ;  //Set Address for Play "0" 
      Play_Back()                       ;  //Play Message            
      Chk_Eom()                         ;
    
   //-------------- Play Message ----------------
      Set_Add(36)                      ;  //Set Address for Play " Vi-Na-Tee "
      Play_Back()                      ;  //Play Message            
      Chk_Eom()                        ;

 
 }


 //************************************************************
 //**            Function Convert BCD Time to Ascii          **         
 //************************************************************

 void conv_time(int8 sec,int8 min,int8 hour)
 {
  
   //---------- Convert Second(00-59) to ascii ---------
   ss = sec >> 4             ;
   ss = ss+0x30              ; //Secound byte High to ascii

   sec = sec & 0x0F          ;
   sec = sec+0x30            ; //Secound byte Low to ascii
   ss = (ss << 8)| sec       ; 

   //---------- Convert Minute(00-59) to ascii ---------

   mn = min >> 4             ;
   mn = mn+0x30              ;  //Minuted byte High to ascii

   min = min & 0x0F          ;
   min = min+0x30            ;  //Minuted byte Low to ascii
   mn = (mn << 8)| min       ; 

   //---------- Convert Hour(00-23) to ascii ---------

   hh = hour >> 4            ;  //Hour byte High to ascii
   hh = hh+0x30              ;

   hour = hour & 0x0F        ;
   hour = hour+0x30          ;  //Hour byte Low to ascii
   hh   = (hh << 8)| hour    ; 

 }


 /**************************************************************
  **                                                          **
  **           FUNCTION I2C RTC DS3232                        **
  **          ID:1101000X = 0xD0(Wr),0xD1(Rd)                 **
  **                                                          **
  **************************************************************/

//----------------- Define I2C Control Pin ---------------------

#define SCL_HI()     output_high(PIN_A1) ;         //RA1 = SCL:1
#define SCL_LO()     output_low(PIN_A1)  ;         //RA1 = SCL:0

#define SDA_HI()     output_high(PIN_A0) ;         //RA0 = SDA:1
#define SDA_LO()     output_low(PIN_A0)  ;         //RA0 = SDA:0

#define SDA_IN()     set_tris_A(0x01)    ;         //Set RA0 = SDA: Input
#define SDA_OUT()    set_tris_A(0x00)    ;         //Set RA0 = SDA: Output


//----------------- I2C Start ------------------

void I2C_Start(void)
{ 
   SDA_OUT()              ;  //Set RA0 = output  
 
   SDA_HI()               ;   
   SCL_HI()               ;
   SDA_LO()               ;    
   SCL_LO()               ;
}

//----------------I2C Stop -----------------              

void I2C_Stop(void)
{

   SDA_OUT()             ;  //Set RA0=Output      
  
   SDA_LO()              ;  
   SCL_HI()              ;     
   SDA_HI()              ;
   
}


//----------------------------------------------------------------
//--               Function I2C Write  Data 8 bit               --
//----------------------------------------------------------------
//--  Parameter :                                               --
//--              dat = Data for write 1Byte                    --     
//----------------------------------------------------------------


void I2C_WrByte(unsigned int8 dat)              
{
   unsigned int8 loop ;      


   for(loop=0;loop<8;loop++)                //Loop Write data 8 Bit 
    {                   
      //--------- write Data(SDA:RA0) ---------

      SDA_OUT()                           ;  //Set RA0=SDA= Output  

      if((dat & 0x80)== 0x80)                //Check data bit8 is 0 or 1
       {
          SDA_HI()                       ;   //Sent '1' Out Pin SDA(RA0)
       }
      else
       {
          SDA_LO()                       ;  //Sent '0' Out Pin SDA(RA0)
       }
      
      dat = dat <<1                      ;  //Shift data Next Bit

      SCL_HI()                           ;  //Clock HI       
      SCL_LO()                           ;  //Clock LO       
    } 
          
    SDA_IN()                             ;   //Set RA0=Input 

    SCL_HI()                             ;   //Start ACK Clock
    while(input(PIN_A0)== 0x01){;}           //Check ACK:RA0 = 0 Out Loop
    SCL_LO()                             ;   //End ACK Clock
       
}


//-----------------------------------------------------------------------
//--                   Function Write RTC DS3232                       --
//-----------------------------------------------------------------------
//-- Parameter :                                                       --
//--            addr  = Register Address for write(1Byte)              --
//--            dat   = Data for Set up DS3232(1Byte)                  --    
//-----------------------------------------------------------------------
 
void I2C_WrRTC (unsigned int8 addr,unsigned int8 dat)
{ 
  
   I2C_Start() ;

//---------- Sent Slave address for Write ---------------

   I2C_WrByte(0xD0)       ;  //Send ID Code DS3232+Write (1101 000+0) 

//------------ Sent address Register --------------
 
   I2C_WrByte(addr)       ;   //Send Address Reg. to DS3232

//------------- Sent data to RTC ---------------

   I2C_WrByte(dat)        ;   //Send Data Control to DS3232
  
   I2C_Stop()             ;
 
}
 
 
//-----------------------------------------------------
//--          Function I2C Read  Data 8 bit          --
//-----------------------------------------------------

 signed int8 I2C_RdByte(void)              
 { 
   signed int8 loop,result=0 ;      

   for(loop = 0; loop < 8; loop++)      //Loop Read data 8-Bit
    {
      result = result << 1         ;   //Shift Result Save (MSB <- LSB)
    
      SDA_IN()                     ;      
      SCL_HI()                     ;   //Strobe Read SDA
             
     if(input(PIN_A0) == 0x01)         //Check Data Read Pin SDA(RA0) is '0' or '1'
       result |= 0x01              ;   //If Read Pin SDA is '1' Give Save Bit Data = 1

      SCL_LO()                     ;   //Next Bit Read

    }
    
  return result                    ;

}


//------------------------------------------------------------
//--              Function Read RTC(DS3232) 1 Byte          --
//------------------------------------------------------------
//-- Parameter :                                            --
//--              addr = Register Address for Read          --
//------------------------------------------------------------
 
 signed int8 I2C_RdRTC(unsigned int8 addr)
  {
    signed int8 dat  ;
   
 //-------------- Sent Status Start for write -----------

   I2C_Start()             ;

//------------- Sent Slave Address for Write------------   
    
   I2C_WrByte(0xD0)        ;                //Send ID Code DS3232,Write (1101 000+0)

//------------ Sent address Register --------------

   I2C_WrByte(addr)        ;               //Send Address Reg. to DS3232
 
//---------- New Sent Status Start For Read ----------

   I2C_Start()             ;

//-------------Sent Slave address for Read ------------

  I2C_WrByte(0xD1)         ;               //Send ID Code DS3232 ,Write (1101 000+1)

//------------- Read data 1 Byte ------------
   
   dat = I2C_RdByte()      ;               
  
  

//---------- Sent Status Stop Red ---------------
   I2C_Stop()              ; 
 
   return dat              ;               //Return Data
  }



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
void main() 
{  
   unsigned int8  lp,sec,min,hor,hs1,hs2         ;
 
   unsigned int8 str0[14]  = {"Time:12:00:00"}   ;

   
   Init_Port()       ;
   Init_ISD2548()    ; 
   Init_Lcd()        ;


 
//------------ write string to lcd ----------------
  
  //----------- String mode Time ----------

  Write_Cmm(0x80|0x00)            ;  //Start address lcd = 0x01 Line 1
  for(lp=0;lp<13;lp++)
    Write_Data(str0[lp])          ;  //Print "Time:12:00:00" to LCD
 
//--------- Set Time Secound:Minute:Hour to DS3232-------------

   I2C_WrRTC(0x00,0x55)          ;  //Write Second
   I2C_WrRTC(0x01,0x29)          ;  //Write minute
   I2C_WrRTC(0x02,0x11)          ;  //Write Hour
 
 
  while(true)
   {
     //------------ Read Time ss:mm:hh from ds3232 --------------

    sec  = I2C_RdRTC(0x00)          ;  //Read Second
    min  = I2C_RdRTC(0x01)          ;  //Read minute
    hor  = I2C_RdRTC(0x02)          ;  //Read Hour  24 Hour
    conv_time(sec,min,hor)          ;  //Convert sec:min:hor to ascii


//------------ Write Data hh:mm:ss to LCD -------------

    Write_Cmm(0x80|0x05)    ;  //Start address lcd = 0x05
    Write_Data(hh>>8)       ;
    Write_Data(hh)          ;
   
    Write_Cmm(0x80|0x08)    ;  //Start address lcd = 0x08
    Write_Data(mn>>8)       ;
    Write_Data(mn)          ;

    Write_Cmm(0x80|0x0B)    ;  //Start address lcd = 0x0B
    Write_Data(ss>>8)       ;
    Write_Data(ss)          ;


    hs1 = hh>>8             ;  // Keep Hour Ascii Byte High
    hs2 = hh                ;  // Keep Hour Ascii Byte Low


   //------------- Check at 0-minute , 0-Secound For Play Message  -----------------

   if((min == 0x00) && (sec == 0x00))
    {
      fag_mn = 0                         ;   //Set fag for play Number minute 1 Message (0 minute)          


      if((hs1==0x30)||((hs1==0x31)&&(hs2==0x30))||((hs1==0x32)&&(hs2==0x30)))  //Check Hour 00-09,10,20 Narika for play 1 message
       {
       fag_hh = 0                        ;   //Set fag_Hour = 0 for play number 1 message(0-9,10,20)
       
       if(hs1 == 0x30)                       //Check 00-09 Narika for Set Address Message 0-9
         {
          add_hh1 = ((hs2-0x30)*9)+45   ;   //Calculate address Message for play By 45 = Address start for Message "0" and 9 = 1 message   use 9 Address
           }
        else                                // check 10,20 Narika for Set Address Message 10,20
         {
          if(hs1 == 0x31)                   //Set Postion Address Message "10" = (16x9)-9  :16= order message
             add_hh1 = 135              ;
          else
             add_hh1 = 153              ;   //Set Postion Address Message "20" =(18x9)-9
         }
       }
      else                                  //Check Hour 11-19,21-23 Narika for Play 2 Message
       {
       fag_hh = 1                       ;   //Set fag_Hour=1 for play number 2 message(11-19,21,23)

       //-----------Set Position Message 1 -----------------

       if(hs1 == 0x31)                      //Set Position Address Message "10"
         add_hh1 = 135                  ;
       else
          add_hh1 = 153                 ;   //Set Position Address Message "20"
   
   
         //-----------Set Position Message 2 -----------------
        
       if(hs2 == 0x31)                      //if hs2='1' 
          hs2 = hs2+10                   ;   //give hs2 = hs2+ 0x0A for order Message 'ed'
   
         add_hh2 = ((hs2-0x30)*9)+45      ;   //Calculate address Message for play

      }

     Msg_Time()                           ;   //Play Time Message    at xx:00:00

    }

   //------------- Check at 30-minute, 0-Secound For Play Message  -----------------

   if((min == 0x30)&&(sec == 0x00))                    
    {
     fag_mn = 1                           ;            //Set fag for play Number minute 2 Message (3,10 minute)
  

     if((hs1==0x30)||((hs1==0x31)&&(hs2==0x30))||((hs1==0x32)&&(hs2==0x30)))  //Check Hour 00-09,10,20 Narika for play 1 message
      {
       fag_hh = 0                         ;            //Set fag_Hour = 0 for play number 1 message(0-9,10,20)
       
       if(hs1 == 0x30)                                 //Check 00-09 Narika for Set Address Message 0-9
         {
          add_hh1 = ((hs2-0x30)*9)+45     ;            //Calculate address Message for play By 45 = Address start for Message "0" and 9 = 1 message   use 9 Address
           }
        else                                           //check 10,20 Narika for Set Address Message 10,20
         {
          if(hs1 == 0x31)                            
             add_hh1 = 135                ;            //Set Position Address Message "10"
          else
             add_hh1 = 153                ;            //Set Position Address Message "20"
         }
      }
     else                                              //Check Hour 11-19,21-23 Narika for Play 2 Message
      {
       fag_hh = 1                         ;            //Set fag_Hour=1 for play number 2 message(11-19,21,23)

       //-----------Set Position Message 1 -----------------

       if(hs1 == 0x31)        
         add_hh1 = 135                    ;            //Set Position Address Message "10"
       else
          add_hh1 = 153                   ;            //Set Position Address Message "20"
       
         //-----------Set Position Message 2 -----------------
      
       if(hs2 == 0x31)                                // if hs2='1' 
          hs2 = hs2+10                    ;           // give hs2 = hs2+ 0x0A for order Message 'ed'
         
       
       add_hh2 = ((hs2-0x30)*9)+45        ;          //Calculate address Message for play
 
      }
      Msg_Time()                          ;          //Play Time Message    at xx:30:00
    } // if Check 30 Minute
    
    
   }
   
}
