

/***********************************************************************************************
 *                                                                                             *
 *             Example_1. Control ISD2548 Record(MIC) & Play Back (Address Mode)               *
 *                                                                                             *
 ***********************************************************************************************
 * Target MCU        : PIC18F8722(ET-BASE PIC8722)                                             *
 *                   : X-TAL : 10 MHz                                                          *
 *                   : CPU Clock = 40 MHz (x4)                                                 *                                                                  *
 * Editor-Compiler   : CCS Version 4.120                                                       *
 *                                                                                             *
 * Port Interface    :                                                                         *
 *                                                                                             *
 *            SPI    :     # MCU-PIC18F8722 #           ET-Mini ISD2548                        *
 *                         -------------------          ---------------                        *
 *                                                                                             *                                   
 *                          RD0            connect        DIN                                  *                
 *                          RD1            connect        SCK                                  *
 *                          RD2            connect        STB                                  *               
 *                          RD3(IN)        connect        EOM (Must Pull Up)                   *               
 *                          GND            connect        ENA                                  *             
 *                          NO USE         connect        OVF                                  *            
 *                                                                                             *
 *                                                                                             *
 *                                    5V                                                       *
 *                                  --+--                                                      *
 *                                    |                                                        *
 *                                    \                                                        *
 *                                    / 10K                                                    *
 *                                    |          ET-Mini ISD2548       5V                      *
 *                                    |      +-------------------+   --+--                     *
 *                                    |      |                   |     |                       *
 *                           RD0 -----|----->|DIN            +5V +-----+      /|               *
 *                           RD1 -----|----->|SCK                |          /  |               *
 *                           RD2 -----|----->|STR            SP+ +--------||   |               *
 *                           RD3 <----+------|EOM                |        || SP|               *
 *                                           |               SP- +--------||   |               *
 *                                           |                   |          \  |               *
 *                               +-----------|ENA            GND +-----+      \|               *
 *                             __|__         |                   |   __|__                     *
 *                              ---          |                   |    ---                      *
 *                               -        ---|VOF                |     -                       *
|*                                           |                   |       _ --                  *
 *                                           |               MIC+|------| |                    *
 *                                           |                  -|------|_|                    *
 *                                           +-------------------+         --                  *
 *                                                                                             *
 *                                            Set Jp1 : to GND                                 *
 *                                                Jp2 : to MIC or ANA IN                       *
 *                                                                                             *                       
 *                                                                                             *
 *                                                                                             *
 *         LCD     :   # MCU-PIC18F8722 #                  # LCD 2x16 DISPLAY #                *
 *                     ------------------                  --------------------                *
 *                                                                                             *
 *                          RH1            Connect            RS(OUT)                          *
 *                          RH2            Connect            R/W(OUT)                         *
 *                          RH3            Connect            EN(OUT)                          *  
 *                          RH4-RH7        Connect            Data 4 bit high(Out)             *
 *                                                                                             * 
 *        5V                                                                                   *
 *      --+--                                                                                  *
 *        |                                                                                    *
 *        +-----------------+                                                                  *
 *        |                 |                                                                  *
 *       ---                |                                                                  *
 *       |\|                |                                                                  *
 *    VR |/|<---------------|--+                                                               *
 *   10K ---                |  |  RH1 RH2 RH3            RH4 RH5 RH6 RH7                       *
 *        |                 |  |   ^   ^   ^              ^   ^   ^   ^                        *
 *        |                 |  |   |   |   |              |   |   |   |                        *
 *        +--------------+--|--|---|---|---|--+--+--+--+  |   |   |   |                        *
 *      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|                        *
 *                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_                       *
 *                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |                      *
 *                    |    _________________________________________    |                      *
 *                    |   |                                         |   |                      *
 *                    |   |               Module                    |   |                      *
 *                    |   |         LCD 2x16 Charecter              |   |                      *  
 *                    |   |_________________________________________|   |                      *
 *                    |                                                 |                      *
 *                    |_________________________________________________|                      *
 *                                                                                             *       
 *                                                                                             *
 *                                                                                             *
 *                                                                                             *
 *      SWITCH    :   # MCU-PIC18F8722 #            # SW. for User COntrol Play& Record#       *
 *                    ------------------             -----------------------------------       * 
 *                       RJ0,RJ1          Not use         Pull-Up 5V                           *
 *                       RJ2(IN)          connect         SW. Select Message UP+               *
 *                       RJ3(IN)          connect         SW. Select Message Down-             *
 *                       RJ4(IN)          connect         SW. Record Message                   *
 *                       RJ5(IN)          connect         SW. Play Message All                 *
 *                       RJ6(IN)          connect         SW. STOP Play Message All            *
 *                       RJ7(IN)          connect         SW. Play 1 Message at Select         *
 *                                                                                             *
 *                     5V                                                                      *
 *                   --+--                                                                     *
 *                     |                                                                       *
 *                     +-------+-------+-------+-------+-------+                               *  
 *                     |       |       |       |       |       |                               *
 *                     /       /       /       /       /       /                               *
 *                     \       \       \       \       \       \                               *
 *                     /10K    /10K    /10K    /10K    /10K    /10K                            *
 *                     \       \       \       \       \       \                               *
 *      (Selec.Msg.+)  |       |       |       |       |       |                               *
 *         RJ2 <-------+       |       |       |       |       |                               *
 *      (Selec.Msg.-)  |       |       |       |       |       |                               *
 *         RJ3 <---------------+       |       |       |       |                               *
 *      (Record)       |       |       |       |       |       |                               *
 *         RJ4 <-----------------------+       |       |       |                               *
 *      (Play All)     |       |       |       |       |       |                               *
 *         RJ5 <-------------------------------+       |       |                               *
 *    (Stop Play all)  |       |       |       |       |       |                               *
 *         RJ6 <---------------------------------------+       |                               *
 *      (Play Back)    |       |       |       |       |       |                               *
 *         RJ7 <---------------------------------------|-------+                               *
 *                     |       |       |       |       |       |                               *
 *                     |       |       |       |       |       |                               *
 *                SW.2\   SW.3\   SW.4\   sw.5\   sw.6\   SW7 \                                *
 *                     |       |       |       |       |       |                               *
 *                     |       |       |       |       |       |                               *
 *                   --+--   --+--   --+--   --+--   --+--   --+--                             *
 *                     G       G       G       G       G       G                               *
 *                                                                                             *
 *                                                                                             *
 * Poperity Message : 1 address = record sound 0.15 sec.   When                                *
 *                    ISD2548 Record Full 48 sec. and have Address 320 Address. Thus           *
 *                    This Example Give 1 Message long 1.2 sec.Only Thus ISD2548 Record        *
 *                    Full 35 Message by :                                                     *
 *                                     1 message = 1.2/0.15 = 8 Address                        *
 *                                     Add EOM signal 1 address                                *
 *                    Thus ,           1 Message = 9 Address                                   * 
 *                    ISD2548 1 Chip record =   320/9 = 35 message                             *
 *                                                                                             *
 *                                                                                             *
 * Last Update     : 17/07/2012                                                                *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/

#include <18F8722.h>
#include <stdio.h>

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)

#use fast_io(ALL)                                //Stop Set direction Auto for All Port  by Compiler  



int16 nh,nl,addr   ;


 /****************************************************
  **             Function Initial Port              **
  ****************************************************/

 void Init_Port(void)
  {
     set_tris_D(0x08)   ;    //Set RD0..RD2 = Output For SPI Control ISD2548,RD3=Input for EOM
     set_tris_H(0x00)   ;    //Set RH0..RH7 = Output For LCD
     set_tris_J(0xFF)   ;    //Set RJ0..R7  = Input  For Switch SW.2-SW.7 

  }


/*******************************************************
 **                                                   **
 **                     FUNCTION LCD                  **
 **                                                   **
 *******************************************************/ 


//----------------- Define LCD Control Pin --------------------

#define Ena_Hi()     OUTPUT_HIGH(PIN_H3) ;         //RH3 = ENA:1
#define Ena_Lo()     OUTPUT_LOW(PIN_H3)  ;         //RH3 = ENA:0

//-------------------- write instruction LCD --------------------

void Write_Cmm(unsigned int8 cmm)
{
  OUTPUT_H(cmm & 0xF0 )               ;    //Sent cmm 4 bit(RH4-RH7) High , RS:RH1 = 0 ,R/W:RH2 = 0
  Ena_Hi()                            ;    
  delay_us(300)                       ;
  Ena_Lo()                            ;    
  delay_us(300)                       ;

  OUTPUT_H((cmm << 4) & 0xF0)         ;    //Sent cmm 4 bit(RH4-RH7) Low , RS:RH1 = 0 ,R/W:RH2 = 0
  Ena_Hi()                            ;   
  delay_us(300)                       ;
  Ena_Lo()                            ;   
  delay_us(300)                       ;
}


 //------------ write data lcd --------------

void Write_Data(unsigned int8 dat)
{
  
  OUTPUT_H((dat & 0xF0)|0x02)         ;    //Sent data 4 bit(RH4-RH7) High , RS:RH1 = 1 ,R/W:RH2 = 0
  Ena_Hi()                            ;    
  delay_us(300)                       ;
  Ena_Lo()                            ;    
  delay_us(300)                       ;

  OUTPUT_H(((dat << 4) & 0xF0)|0x02)  ;    //Sent cmm 4 bit(RH4-RH7)Low , RS:RH1 = 1 ,R/W:RH2 = 0
  Ena_Hi()                            ;   
  delay_us(300)                       ;
  Ena_Lo()                            ;   
  delay_us(300)                       ;
}

 //----------- Clear Display LCD ------------  

void Clr_Display(void)
 {
  write_cmm(0x01) ;
 }
 
 //------------ Clear Line 1 LCD -------------  
void Clear_L1()
 {
  int8 k ;

   Write_Cmm(0x80|0x00)     ;  //Start address lcd = 0x4B Line 2
   for(k=0;k<16;k++)   
     Write_Data(0x20)       ;  //Plot Space to lcd 
 }
 
 
//------------- initial lcd ---------------

void Init_Lcd(void)
{
  Write_Cmm(0x33)        ;           //Command Control 
  Write_Cmm(0x32)        ;
  Write_Cmm(0x28)        ;
  Write_Cmm(0x0C)        ;           //Set Display On/Off:Display On,Not Show Cursor and not blink Cursor
  Write_Cmm(0x06)        ;           //Set Entry Mode :Increment Address,Cursor Shift Right
  
  Write_Cmm(0x1C)        ;           //Set Cursor Or Display Shift : Shift Right Charecter
  Write_Cmm(0x28)        ;           //Function Set: set interface data 4bit,Set Display LCD 2 Line ,Set Charecter Size 5x7
  Write_Cmm(0x80|0x00)   ;           //Set Address Begin 0x00 (Line1 Charecter1)
  Clr_Display()          ;
}

//--------------- Convert Ascii -----------------


void Conv_Ascii(int16 num)
 {
   nh = (num/10)+0x30  ;
   nl = (num%10)+0x30  ;
 }


/***************************************************************
 **                Function SPI Seny data 12 bit              **
 ***************************************************************
 **          RD0 = SDO                                        **
 **          RD1 = SCK                                        **
 **          RD2 = STROB                                      **   
 **                                                           **
 ***************************************************************/

//--------------- Define Pin -----------------------


//--------------- SDO-High(Data-Out) ---------------

#define     Sdo_Hi()          OUTPUT_HIGH(PIN_D0)    ;          //RD0= SDO:1
                          
//--------------- SDO-Low(Data-OUT) ----------------

#define     Sdo_Lo()          OUTPUT_LOW(PIN_D0)     ;         //RD0= SDO:0


//--------------- Sck-High(Clock) ---------------

#define     Sck_Hi()          OUTPUT_HIGH(PIN_D1)   ;          //RD1= SCK:1
                          
//--------------- Sck-Low(Clock) ----------------

#define     Sck_Lo()         OUTPUT_LOW(PIN_D1)     ;          //RD1= SCK:0


//--------------- STR-High(Strob) ---------------

#define     Str_Hi()          OUTPUT_HIGH(PIN_D2)  ;          //RD2= Str:1
                          
//--------------- STR-Low(Strob) ----------------

#define     Str_Lo()          OUTPUT_LOW(PIN_D2)   ;          //RD2= Str:0



//----------------- Write Data to ISD2548 12-bit -------------------

void Spi_Wr(unsigned int16 DWord)              
 {
    unsigned int16 Bit ;                   

     Str_Lo()                              ;    //Start Strob 595 to Low

     for(Bit=0;Bit<12;Bit++)                    //Loop write data 12 Bit
      {      
         Sck_Lo()                          ;    //Start 595 Clock  Low

      //--------- write Data(RD0) ---------

        if((DWord & 0x800)== 0x800)
         {
          Sdo_Hi()                       ;    //Set bit data(RD0) = 1
         }
        else 
         {
          Sdo_Lo()                       ;    //Clear bit data(RD0) = 0
         } 
      
        Sck_Hi()                         ;    //Set 595 Clock High for Shift data bit

        DWord <<= 1                      ;    //Shift Next Bit Data        
   
     }

     Str_Hi()                            ;   //Set Strob 595 to High for Out data parallel 


  }



/***************************************************************
 **                    FUNCTION ISD2548                       **
 ***************************************************************
 **  - Memory = 320 Address                                   **
 **  - Time Record Max = 48 secound                           **
 **  - 1 Address   = Time Record 0.15 secound                 **
 **                                                           **
 ***************************************************************/


//-------- Define Data Control ISD2548 ------------

#define PL_CHi            0xA00      //CE,P/R=1;PD=0
#define PL_CLo            0x200      //P/R=1;CE,PD=0
#define REC_CHi           0x800      //CE=1;PD,P/R=0
#define REC_CLo           0x000      //CE,PD,P/R =0
#define STOP              0xE00      //CE,PD,P/R = 1 


//---------------- Read Status EOM : End OF Message ---------------- 
int8 Rd_Eom()
{
  int8 eom                 ;        
       
  eom  = INPUT(PIN_D3)     ; //Read RD3 : 0 = end of message , Nomal = 1   
  return eom               ;  
}



//------------ Set Address for Play or Record(Addtess 0-320) ------------

void Set_Add(int16 add)
 { 

   addr = add & 0x1FF   ;  //Mark data Bit9-11 for write  Pin P/R,PD,CE 
   Spi_Wr(addr|STOP)    ;  //Write Pin Address A0-A8 and Pin Contr0l To ISD2548  

 }


//-------------------- Play 1 Message ---------------------

void Play_Back()
 {

   addr = addr & 0x01FF    ;  //Mark data Control Bit9-11 Pin P/R,PD,CE for  Play
   Spi_Wr(addr|PL_CLo)     ;  //Write Pin Address A0-A8 and Pin Control for Play To ISD2548(Pin CE =0) 

   addr = addr & 0x01FF    ;
   Spi_Wr(addr|PL_CHi)     ;  //Write Pin CE = 1

 }

 
//---------------- Record Message -------------------

void Record()
 {
   addr = addr&0x01FF      ;  //Mark data Control Bit9-11 Pin P/R,PD,CE  for Record 
   Spi_Wr(addr|REC_CHi)    ;  //Write Pin Address A0-A8 and Pin Control P/R,PD=0 and CE=1 for Record 

   addr = addr&0x01FF      ;
   Spi_Wr(addr|REC_CLo)    ;  //Write Pin CE =0 Start Recode

 }
 
//----------------Stop Play&Record Message -------------------

void Stop_PR()
 {   
   addr = addr&0x01FF   ; 
   Spi_Wr(addr|STOP)    ;   //Write data for Stop Record by Pin Control P/R,PD,CE=1 

 }

//----------------- Initial ISD2548 ---------------

 void Init_ISD2548()
  {

    Spi_Wr(STOP)   ;     
    
  }


/**************************************************
 **            Function Switch                   **
 **************************************************/
 
//-------------- Check press SW.2-SW.7 -----------

void Check_Sw()
 {
   while((INPUT_J()& 0xFC)!= 0xFC){;}  //Check SW. RJ[2..7] Release All 
   delay_ms(50)            ;
 }

//---------------- Read SW.2-SW.7 (RJ2-RJ7)-----------------

int8 Rd_Sw()
 {
  int8 sw                   ;

   sw = INPUT_J()           ;  //Read press SW. RJ[2..7]
   sw = (~sw) & 0xFC        ;  //Mark RJ[2..7] and invert data (Normal Value Not press SW. is logic 1)

   return sw                ;

 }




/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
void main() 
{
   unsigned int8   sw,lp                          ;
   unsigned int16  nm=1                           ;
   signed int16    add = 0                        ;
   unsigned int8 str0[11]  = {"Message:01"}       ;
   unsigned int8 str1[8]   = {"Play =>"}          ;
   unsigned int8 str2[12]  = {"Play ALL =>"}      ;
   unsigned int8 str3[10]  = {"Rec [(0)]"}        ;
   unsigned int8 str4[15]  = {"<<==Select==>>"}   ;

   Init_Port()       ;
   Init_ISD2548()    ; 
   Init_Lcd()        ;


 //--------------  Start  --------------

  Write_Cmm(0x80|0x01)            ;  //Start address lcd = 0x01 Line 1
  for(lp=0;lp<14;lp++)
    Write_Data(str4[lp])          ;  //Print "<<==Select==>>" to LCD
 
  Write_Cmm(0x80|0x43)            ;  //Start address lcd = 0x43 Line 2
  for(lp=0;lp<10;lp++)
    Write_Data(str0[lp])          ;  //Print "Message:01" to LCD

  Set_Add(0)                      ;  //Set Address begin for Play or Record

  while(true)
   { 
     sw = Rd_Sw() ; 

     switch(sw)
      {
                     
        case 0x04 :  //SW.2(RJ2) = Select Increment order Message ++
                        
                   nm = nm+1               ;  //Counter Message for show LCD             
                   if(nm>35)                   //check number message not exceed 35 message              #####--1. Line For Edit--#####
                     nm = 1                ;

                   Conv_Ascii(nm)          ;  //Convert number message to ascii
                   Write_Cmm(0x80|0x4B)    ;  //Start address lcd = 0x4B Line 2      
                   Write_Data(nh)          ;  //Plot number colum10 to lcd 
                   Write_Data(nl)          ;  //Plot number colum unit to lcd
                
                   add = add+9             ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message     #####-- 2. Line For Edit--#####
                   if(add > 306)              //Check Position Address for Record end Message (Last Message is 35)                      #####-- 3. Line For Edit--#####
                     add = 0               ;  //if last message Recorded. Give return Start Address at 0 New
                
                   Set_Add(add)            ;  //Set Address for Play or Record
             
                   Check_Sw()              ;
                   
                    
                     
              break                        ;

         case 0x08 :  //SW.3(RJ3) = Select Decrement order Message --
                        
                    nm= nm-1                ;  //Counter Message for show LCD             
                    if(nm<1)                   //check number message not exceed 35 message
                      nm = 35               ;                                                            //#####--4. Line For Edit--#####

                    Conv_Ascii(nm)          ;  //Convert number message to ascii
                    Write_Cmm(0x80|0x4B)    ;  //Start address lcd = 0x4B Line 2      
                    Write_Data(nh)          ;  //Plot number colum10 to lcd 
                    Write_Data(nl)          ;  //Plot number colum unit to lcd
                
                    add = add-9             ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message          #####--Line5. For Edit--#####
                    if(add < 0)                 //Check Position Address for Record end Message (Last Message is 35) 
                      add = 306             ;   //if last message Recorded. Give return Start Address at 0 New                                 #####--Line6. For Edit--#####
                
                    Set_Add(add)            ;  //Set Address for Play or Record
                    
                    Check_Sw()              ;
             
              break ;

         case 0x10 : //SW.4(RJ4) = Record Message
                               
                    Clear_L1()                      ;  //Clear Message On LCD L1
                    Write_Cmm(0x80|0x03)            ;  //Start address lcd = 0x03 Line 1
                    for(lp=0;lp<9;lp++)
                       Write_Data(str3[lp])         ;  //Print "Rec [(0)]" to LCD

                    //delay_ms(10)                     ;
                 
                    Write_Cmm(0x80|0x09)            ;  //Start address lcd = 0x09 Line 1     
                    Write_Cmm(0x0D)                 ;  //LCD Blink 
                    
                    Record()                        ;  //Start Record
    
                    delay_ms(1200)                  ;  //wait record 1.2 sec.(use 1.2s/0.15s = 8 Address+ 1 for eom=9 address)        #####--Line7. For Edit--#####
                    Stop_PR()                       ;  //Stop Record   at 1.2 sec./ 1-message
                
                    Write_Cmm(0x0C)                 ;  //Stop LCD Blink 
                 
                    Write_Cmm(0x80|0x01)            ;  //Start address lcd = 0x01 Line 1
                    for(lp=0;lp<14;lp++)
                      Write_Data(str4[lp])          ;  //Print "<<==Select==>>" to LCD

                    Check_Sw()                      ;        

                break ;

          case 0x20: //SW.5(RJ5) = Play All Message
                               
                    Clear_L1()                       ;  //Clear Message On LCD Line1
                    Write_Cmm(0x80|0x03)             ;  //Start address lcd = 0x04 Line 1       
                    
                    for(lp=0;lp<11;lp++)
                     {
                      Write_Data(str2[lp])           ;  //Print "Play All =>" to LCD
                     }
                     
                     add =0                          ;
                    for(nm=1;nm<=35;nm++)                      //#####-- Line8. For Edit--#####
                     {
                       Conv_Ascii(nm)                ;  //Convert number message to ascii
                       Write_Cmm(0x80|0x4B)          ;  //Start address lcd = 0x4B Line 2      
                       Write_Data(nh)                ;  //Plot number colum10 to lcd 
                       Write_Data(nl)                ;  //Plot number colum unit to lcd
                               
                       Set_Add(add)                  ;  //Set Address for Play 
                       Play_Back()                   ;  //Play Message

                       add = add+9                   ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message         #####-- Line9. For Edit--#####
            
                       while((Rd_Eom())&&(nm <36))      //Wait end 1 message                  #####--Line10. For Edit--#####
                        {
                         sw = Rd_Sw()                ;  //SW.6(RJ6) = Stop Play Message
                         if(sw == 0x40)
                          {
                           Stop_PR()                 ;  //Stop Play Message  
                           nm = 37                   ;                                    //  #####--Line11. For Edit--#####
                          }       
                        }
                      
                       while(!Rd_Eom())  {;}         ;  //Wait EOM back to '1' for Play Next Message
                                  
                       }  
                                           
                     add = 0                         ;  //Clear Address    
                     nm  = 1                         ;  //Start Display Message1 
                      
                     Write_Cmm(0x80|0x01)            ;  //Start address lcd = 0x01 Line 1
                     for(lp=0;lp<14;lp++)
                       Write_Data(str4[lp])          ;  //Print "<<==Select==>>" to L1
                  
                     Write_Cmm(0x80|0x4B)            ;  //Start address lcd = 0x4B Line 2      
                     Write_Data(0x30)                ;  //Plot number 0 to lcd 
                     Write_Data(0x31)                ;  //Plot number 1 to lcd             
                     
                     Set_Add(0)                      ;  //Set Address 0 for Play 
                     Check_Sw()                      ;  

              break ;
      
          case 0x80: //SW.7(RJ7) = Play one Message
                               
                     Clear_L1()                     ;  //Clear Message On LCD Line1
                     Write_Cmm(0x80|0x04)           ;  //Start address lcd = 0x04 Line 1       
                     for(lp=0;lp<7;lp++)
                       Write_Data(str1[lp])         ;  //Print "Play =>" to LCD

                     Play_Back()                    ;  //Play Message

                     Write_Cmm(0x80|0x0A)           ;  //Start address lcd = 0x0A Line 1     
                     Write_Cmm(0x0D)                ;  //LCD Blink 

                     while(Rd_Eom()){;}             ;  //Wait end 1 message
                
                     Write_Cmm(0x0C)                ; //Stop LCD Blink 

                     Write_Cmm(0x80|0x01)           ;  //Start address lcd = 0x01 Line 1
                     for(lp=0;lp<14;lp++)
                        Write_Data(str4[lp])        ;  //Print "<<==Select==>>" to LCD
            
                     Check_Sw()                     ;  

              break ;

     }  //switch 
   }
}      //End

 


