
/****************************************************************************
* NAME: AT89C51RE2.h           
*----------------------------------------------------------------------------
* PURPOSE: SFR Description file for AT89C51RE2 products 
* 				ON KEIL compiler
*****************************************************************************/

#define Sfr(x, y)	    sfr x   = y
#define Sbit(x, y, z)       sbit x  = y^z
#define Sfr16(x,y)	    sfr16 x = y


/******************************************/
/* Include file for 8051 SFR Definitions  */
/******************************************/

/*------------ Port SFRs BYTE -------------*/

Sfr  (P0,0x80)         ;  //Address Port P0       
     Sbit (P0_7,0x80,7);  //Bit P0
     Sbit (P0_6,0x80,6);
     Sbit (P0_5,0x80,5);
     Sbit (P0_4,0x80,4);
     Sbit (P0_3,0x80,3);
     Sbit (P0_2,0x80,2);
     Sbit (P0_1,0x80,1);
     Sbit (P0_0,0x80,0);

Sfr  (P1,0x90)         ;  //Address Port P1      
     Sbit (P1_7,0x90,7);  //Bit P1
     Sbit (P1_6,0x90,6);
     Sbit (P1_5,0x90,5);
     Sbit (P1_4,0x90,4);
     Sbit (P1_3,0x90,3);
     Sbit (P1_2,0x90,2);
     Sbit (P1_1,0x90,1);
     Sbit (P1_0,0x90,0);

     Sbit (CEX4,0x90,7); //Address alternate of P1
     Sbit (CEX3,0x90,6);
     Sbit (CEX2,0x90,5);
     Sbit (CEX1,0x90,4);
     Sbit (CEX0,0x90,3);
     Sbit (CEI ,0x90,2);
     Sbit (T2EX,0x90,1);
     Sbit (T2  ,0x90,0);

   
Sfr  (P2,0xA0)         ; //Address Port P2
     Sbit (P2_7,0xA0,7); //Bit P2
     Sbit (P2_6,0xA0,6);
     Sbit (P2_5,0xA0,5);
     Sbit (P2_4,0xA0,4);
     Sbit (P2_3,0xA0,3);
     Sbit (P2_2,0xA0,2);
     Sbit (P2_1,0xA0,1);
     Sbit (P2_0,0xA0,0);
     
Sfr  (P3,0xB0)         ; //Address Port P3       
     Sbit (P3_7,0xB0,7); //Bit P3
     Sbit (P3_6,0xB0,6);
     Sbit (P3_5,0xB0,5);
     Sbit (P3_4,0xB0,4);
     Sbit (P3_3,0xB0,3);
     Sbit (P3_2,0xB0,2);
     Sbit (P3_1,0xB0,1);
     Sbit (P3_0,0xB0,0);
     
     Sbit (RD   ,0xB0,7);//Address alternate of P3
     Sbit (WR   ,0xB0,6);
     Sbit (T1   ,0xB0,5);
     Sbit (T0   ,0xB0,4);
     Sbit (INT1 ,0xB0,3);
     Sbit (INT0 ,0xB0,2);
     Sbit (TXD_0,0xB0,1);
     Sbit (RXD_0,0xB0,0);

Sfr  (P4,0xC0)         ;  //Address Port P4       
     Sbit (P4_7,0xC0,7);  //Bit P4
     Sbit (P4_6,0xC0,6);
     Sbit (P4_5,0xC0,5);
     Sbit (P4_4,0xC0,4);
     Sbit (P4_3,0xC0,3);
     Sbit (P4_2,0xC0,2); 
     Sbit (P4_1,0xC0,1);
     Sbit (P4_0,0xC0,0);

Sfr  (P5,0xE8)         ; //Address Port P5      
     Sbit (P5_7,0xE8,7); //Bit P5
     Sbit (P5_6,0xE8,6);
     Sbit (P5_5,0xE8,5);
     Sbit (P5_4,0xE8,4);
     Sbit (P5_3,0xE8,3);
     Sbit (P5_2,0xE8,2);
     Sbit (P5_1,0xE8,1);
     Sbit (P5_0,0xE8,0);

Sfr  (P6,0xF8)         ; //Address Port P6       
     Sbit (P6_1,0xF8,1); //Bit P6
     Sbit (P6_0,0xF8,0);

     Sbit (TXD_1,0xF8,1);
     Sbit (RXD_1,0xF8,0);

/*------------------ C51 Core SFRS --------------------*/
    
Sfr (PSW,0xD0)          ;  //Address Program Status Word       
    Sbit (CY ,0xD0,7);
    Sbit (AC ,0xD0,6);
    Sbit (F0 ,0xD0,5);
    Sbit (RS1,0xD0,4);
    Sbit (RS0,0xD0,3);
    Sbit (OV ,0xD0,2);
    Sbit (F1 ,0xD0,1);
    Sbit (P  ,0xD0,0);

Sfr (ACC,0xE0);          //Address Accumulator   
Sfr (B  ,0xF0);          //Address B Register
Sfr (SP ,0x81);          //Address Stack Pointer   
Sfr (DPL,0x82);          //Address Data Pointer Low Byte   
Sfr (DPH,0x83);          //Address Data Pointer High Byte
      


/*------------------ TIMERS registers SFRs ---------------------*/

Sfr  (TCON,0x88)      ; //Address Timer/Counter0 and 1 Control
     Sbit (TF1,0x88,7);
     Sbit (TR1,0x88,6);
     Sbit (TF0,0x88,5);
     Sbit (TR0,0x88,4);
     Sbit (IE1,0x88,3);
     Sbit (IT1,0x88,2);
     Sbit (IE0,0x88,1);
     Sbit (IT0,0x88,0);
        
Sfr (TMOD  ,0x89);         //Address Timer/Counter0 and 1 Modes 
Sfr (TL0   ,0x8A);         //Address Timer/Counter0 Low Byte
Sfr (TL1   ,0x8B);         //Address Timer/Counter1 Low Byte
Sfr (TH0   ,0x8C);         //Address Timer/Counter0 High Byte       
Sfr (TH1   ,0x8D);         //Address Timer/Counter1 High Byte 
Sfr (WDTRST,0xA6);         //Address WatchDog Timer Reset  
Sfr (WDTPRG,0xA7);         //Address WatchDog Timer Program  
   
Sfr (T2CON,0xC8);          //Address Timer/Counter2 Control
    Sbit (TF2  ,0xC8,7);
    Sbit (EXF2 ,0xC8,6);
    Sbit (RCLK ,0xC8,5);
    Sbit (TCLK ,0xC8,4);
    Sbit (EXEN2,0xC8,3);
    Sbit (TR2  ,0xC8,2);
    Sbit (CT2  ,0xC8,1);
    Sbit (CPRL2,0xC8,0);

Sfr (T2MOD ,0xC9);         //Address Timer/Counter2 Mode 
Sfr (RCAP2L,0xCA);         //Address Timer/Counter2 Reload/Capture Low Byte   
Sfr (RCAP2H,0xCB);         //Address Timer/Counter2 Reload/Capture Low Byte         
Sfr (TL2   ,0xCC);         //Address Timer/Counter2 Low Byte           
Sfr (TH2   ,0xCD);         //Address Timer/Counter2 High Byte      
    


/*------------------- Serial UART0 SFRs ------------------------*/

Sfr  (SCON_0,0x98);           //Address Serial Control 0    
     Sbit (SM0_0,0x98,7);
     Sbit (FE_0 ,0x98,7);
     Sbit (SM1_0,0x98,6);
     Sbit (SM2_0,0x98,5);
     Sbit (REN_0,0x98,4);
     Sbit (TB8_0,0x98,3);
     Sbit (RB8_0,0x98,2);
     Sbit (TI_0 ,0x98,1);
     Sbit (RI_0 ,0x98,0);

Sfr (SBUF_0  ,0x99);        //Address Serial Data Buffer 0  
Sfr (BRL_0   ,0x9A);        //Address Baud Rate Reload 0
Sfr (BDRCON_0,0x9B);        //Address Baud Rate Control 0
Sfr (SADDR_0 ,0xA9);        //Address Slave Address 0
Sfr (SADEN_0 ,0xB9);        //Address Slave Address Mask 0

 
/*------------------- Serial UART1 SFRs ------------------------*/

Sfr  (SCON_1,0xC0);           //Address Serial Control 1    
     Sbit (SM0_1,0xC0,7);
     Sbit (FE_1 ,0xC0,7);
     Sbit (SM1_1,0xC0,6);
     Sbit (SM2_1,0xC0,5);
     Sbit (REN_1,0xC0,4);
     Sbit (TB8_1,0xC0,3);
     Sbit (RB8_1,0xC0,2);
     Sbit (TI_1 ,0xC0,1);
     Sbit (RI_1 ,0xC0,0);

Sfr (SBUF_1  ,0xC1);        //Address Serial Data Buffer 1  
Sfr (BRL_1   ,0xBB);        //Address Baud Rate Reload 1
Sfr (BDRCON_1,0xBC);        //Address Baud Rate Control 1
Sfr (SADEN_1 ,0xBA);        //Address Slave Address Mask 1
Sfr (SADDR_1 ,0xAA);        //Address Slave Address 1


/*---------------- SPI Controller SFRs ---------------*/

Sfr (SPCON,0xC3);   //Address SPI Control
Sfr (SPSCR,0xC4);   //Address SPI Status
Sfr (SPDAT,0xC5);   //Address SPI Data

/*-------------------- Interrupt SFRs -----------------------*/

Sfr (IEN0,0xA8)      ; //Address Interrupt Enable Control 0
    Sbit (EA ,0xA8,7);
    Sbit (EC ,0xA8,6);
    Sbit (ET2,0xA8,5);
    Sbit (ES ,0xA8,4);
    Sbit (ET1,0xA8,3);
    Sbit (EX1,0xA8,2);
    Sbit (ET0,0xA8,1);
    Sbit (EX0,0xA8,0);
    
Sfr (IEN1,0xB1);  //Address Interrupt Enable Control 1 
Sfr (IPH0,0xB7);  //Address Interrupt Priority Control High 0    
Sfr (IPH1,0xB3);  //Address Interrupt Priority Control High 1     
Sfr (IPL0,0xB8);  //Address Interrupt Priority Control Low 0    
Sfr (IPL1,0xB2);  //Address Interrupt Priority Control Low 1     

/*--------------------- PCA SFRs ----------------------*/

Sfr (CCON,0xD8);        //Address PCA Timer/Counter Control 
    Sbit (CF  ,0xD8,7);
    Sbit (CR  ,0xD8,6);
    Sbit (CCF4,0xD8,4);
    Sbit (CCF3,0xD8,3);
    Sbit (CCF2,0xD8,2);
    Sbit (CCF1,0xD8,1);
    Sbit (CCF0,0xD8,0); 
    
Sfr (CMOD,0xD9);       //Address PCA Timer/Counter Mode
Sfr (CL  ,0xE9);       //Address PCA Timer/Counter Low Byte
Sfr (CH  ,0xF9);       //Address PCA Timer/Counter High Byte  
 
Sfr (CCAPM0,0xDA);    //Address PCA Timer/Counter Mode0
Sfr (CCAPM1,0xDB);    //Address PCA Timer/Counter Mode1
Sfr (CCAPM2,0xDC);    //Address PCA Timer/Counter Mode2
Sfr (CCAPM3,0xDD);    //Address PCA Timer/Counter Mode3
Sfr (CCAPM4,0xDE);    //Address PCA Timer/Counter Mode4

Sfr (CCAP0L,0xEA);    //Address PCA Compare Capture Module 0 L  
Sfr (CCAP1L,0xEB);    //Address PCA Compare Capture Module 1 L     
Sfr (CCAP2L,0xEC);    //Address PCA Compare Capture Module 2 L     
Sfr (CCAP3L,0xED);    //Address PCA Compare Capture Module 3 L      
Sfr (CCAP4L,0xEE);    //Address PCA Compare Capture Module 4 L 

    
Sfr (CCAP0H,0xFA);    //Address PCA Compare Capture Module 0 H   
Sfr (CCAP1H,0xFB);    //Address PCA Compare Capture Module 1 H 
Sfr (CCAP2H,0xFC);    //Address PCA Compare Capture Module 2 H 
Sfr (CCAP3H,0xFD);    //Address PCA Compare Capture Module 3 H 
Sfr (CCAP4H,0xFE);    //Address PCA Compare Capture Module 4 H 


/*-------------------- Keyboard Interface SFRs -----------------*/

Sfr (KBLS,0x9C); //Address Keyboard Level Selector
Sfr (KBE ,0x9D); //Address Keyboard Input Enable
Sfr (KBF ,0x9E); //Address Keyboard Flag Register

/*------------------ System Management SFRs -----------------*/

Sfr (PCON ,0x87);     //Address Power Control
Sfr (AUXR ,0x8E);     //Address Auxiliary Register 0
Sfr (AUXR1,0xA2);     //Address Auxiliary Register 1
Sfr (CKRL ,0x97);     //Address Clock Reload Register

Sfr (BMSEL ,0x92);   //Address Bank Memory Select
Sfr (CKCON0,0x8F);   //Address Clock Control Register 0
Sfr (CKCON1,0xAF);   //Address Clock Control Register 1

/*---------- Flash and EEPROM Data Memory SFRs --------------*/

Sfr (FCON,0xD1) ;   //Flash Controller Control
Sfr (FSTA,0xD3) ;   //Flash Controller Status










