

/***********************************************************************************************
 *                                                                                             *
 *                        Example 3. Read Ticket Machine (Address Mode)                        *
 * 																					     	   *
 *                      - Determine Read Message Ticket Number  since '01-99'                  *
 *                      - Determine Number counter service =  6 Counter                        *                    
 *                                                                                             *
 ***********************************************************************************************
 *						                                                                       * 
 *  MCU             : AT89C51RE2(Use CP-JR51RE2 V1.0 Board)                                    *
 *  Compiler        : Keil C51 (V8.05 a)                                                       *
 *												                                               *
 *  PORT Interface  :										                                   *
 *                                                                                             *
 *             # MCU-51RE2 #  		   	         #ET-MINI ISD2548#                             *
 *             ------------                      -----------------                             *
 *                                                                                             *                                   
 *               P1.0(Out)         connect            DIN                                      *                
 *               P1.1(Out)         connect            SCK                                      *
 *               P1.2(Out)         connect            STB                                      *               
 *               P1.3(IN)          connect            EOM (Must Pull Up)                       *               
 *               GND               connect            ENA                                      *             
 *               NO USE            connect            OVF                                      *            
 *                                                                                             *
 *                                                                                             *
 *                                    5V                                                       *
 *                                  --+--                                                      *
 *                                    |                                                        *
 *                                    \                                                        *
 *                                    / 10K                                                    *
 *                                    \                                                        *
 *                                    /                                                        *
 *                                    |                                                        *
 *                                    |                                                        *
 *                                    |         ET-Mini ISD2548        5V                      *
 *                                    |      +-------------------+   --+--                     *
 *                                    |      |                   |     |                       *
 *                           P1.0 ----|----->|DIN            +5V +-----+      /|               *
 *                           P1.1 ----|----->|SCK                |          /  |               *
 *                           P1.2 ----|----->|STR            SP+ +--------||   |               *
 *                           P1.3 <---+------|EOM                |        || SP|               *
 *                                           |               SP- +--------||   |               *
 *                                           |                   |          \  |               *
 *                               +-----------|ENA            GND +-----+      \|               *
 *                             __|__         |                   |   __|__                     *
 *                              ---          |                   |    ---                      *
 *                               -        ---|VOF                |     -                       *
 *                                           |                   |                             *
 *                                           |                MIC|----                         *
 *                                           +-------------------+                             *
 *                                            Set Jp1 : to GND                                 *
 *                                                Jp2 : No use (Don't care)                    *
 *                                                                                             *
 *                                                                                             *
 *           # MCU-RE2 #                      # LCD 2x16 DISPLAY #                             *
 *           -----------                      --------------------                             *
 *              P2.1		      connect          E                                           *
 *              P2.2              connect          RW								   	       *
 *              P2.3			  connect	       RS									       *
 *              P2.4-P2.7         connect	   data 4 bit high                                 *
 *       5V                                                                                    *
 *      --+--                                                                                  *
 *        |                                                                                    *
 *        +-----------------+                                                                  *
 *        |                 |                                                                  *
 *       ---                |                                                                  *
 *       |\|                |                                                                  *
 *    VR |/|<---------------|--+                                                               *
 *   10K ---                |  | P2.3 P2.2 P2.1         P2.4 P2.5 P2.6 P2.7                    *
 *        |                 |  |   ^   ^   ^              ^   ^   ^   ^                        *
 *        |                 |  |   |   |   |              |   |   |   |                        *
 *        +--------------+--|--|---|---|---|--+--+--+--+  |   |   |   |                        *
 *      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|                        *
 *                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_                       *
 *                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |                      *
 *                    |    _________________________________________    |                      *
 *                    |   |                                         |   |                      *
 *                    |   |               Module                    |   |                      *
 *                    |   |         LCD 2x16 Charecter              |   |                      *  
 *                    |   |_________________________________________|   |                      *
 *                    |                                                 |                      *
 *                    |_________________________________________________|                      *
 *                                                                                             *     
 *                                                                                             *
 *			    # MCU-RE2 #                      #SW. for Counter service at ready#            *
 *     	        -----------	                     -----------------------------------           *																						   *
 *               P3.2(IN)         connect           SW. Counter channel Number '1'             *
 *			     P3.3(IN)         connect           SW. Counter channel Number '2'    		   *
 *               P3.4(IN)         connect           SW. Counter channel Number '3'             *
 *               P3.5(IN)         connect           SW. Counter channel Number '4'             *
 *               P3.6(IN)         connect           SW. Counter channel Number '5'             *
 *               P3.7(IN)         connect           SW. Counter channel Number '6'             *
 *																							   *
 *			   	   5V				     													   *
 *              --+-- 																		   *
 *                |																		       *
 *                +--------+--------+--------+--------+--------+							   *
 *			      |	       |		|		 |		  |	   	   |							   *
 *				  /	       /	    /		 /		  /		   /							   *
 *		 		  \		   \		\		 \		  \		   \							   *
 *                /10K     /10K  	/10K	 /10K	  /10K	   /10K						       *
 *				  \		   \ 	    \		 \	      \	  	   \							   *
 *		    	  |	  	   |	    |		 |		  |		   |							   *
 * (Counter CH1)  |    	   |		|		 |		  |		   |							   *
 *   P3.2 <-------+    	   |	    |		 |		  |		   |							   *
 * (Counter CH2)  |		   |	    |		 |		  |	       |							   *
 *	 P3.3 <----------------+        |		 |		  |		   |							   *
 * (Counter CH3)  |	   	   |		|		 |		  |		   |							   *
 *   P3.4 <-------------------------+		 |		  |	       |							   *
 * (Counter CH4)  |	  	   |		|		 |		  |	   	   |							   *
 *   P3.5 <----------------------------------+        |	  	   |							   *
 * (Counter CH5)  |		   |		|		 |		  |		   |							   *
 *	 P3.6 <-------------------------------------------+		   |							   *
 * (Counter CH6)  |        |        |		 |	      |		   |							   *
 *	 P3.7 <----------------------------------------------------+							   *
 *				  |        |        |		 |		  |	   	   |							   *
 *				  |		   |		|		 |		  |	 	   |							   *
 *			 SW.2\    SW.3\    SW.4\    sw.5\    sw.6\	  sw.7\						           *
 *  		      |	  	   |	    |		 |		  |		   |					           *
 *				  |	 	   |		|	     |		  |	   	   |							   *
 *              --+--	 --+--	  --+--	   --+--    --+--	 --+--							   *
 *				  G	       G	    G		 G		  G	       G							   *
 *              																	           *
 *																							   *
 *	                                                                                           *
 *  Before Operate  :	  Use Example_1 for Record Message by 1 Message Use 9 address          * 
 *                                                                                             *
 *                       Message 02   "    : Tee-chong     (Start Address 9 )                  *
 *                          "    03   "    : Bor-ri-kan    (Start Address 18)                  *
 *                          "    04   "    : Ka            (Start Address 27)                  *
 *                          "    05   "    : 1 	    	   (Start Address 36)                  *
 *                          "    06   "    : 2             (Start Address 45)                  *
 *                          "    07   "    : 3             (Start Address 54)                  *
 *                          "    08   "    : 4             (Start Address 63)                  *
 *                          "    09   "    : 5             (Start Address 72)                  *
 *                          "    10   "    : 6             (Start Address 81)                  * 
 *                          "    11   "    : 7   	 	   (Start Address 90)  	               *
 *                          "    12   "    : 8             (Start Address 99)                  *
 *                          "    13   "    : 9             (Start Address 108)                 * 
 *                          "    14   "    : 10 	       (Start Address 117)                 *
 *                          "    15   "    : ed            (Start Address 126)                 *
 *                          "    16   "    : 20            (Start Address 135)                 *
 *                          "    17   "    : 30            (Start Address 144)                 * 
 *                          "    18   "    : 40   	 	   (Start Address 153)                 *
 *                          "    19   "    : 50            (Start Address 162)                 *
 *                          "    20   "    : 60            (Start Address 171)                 * 
 *                          "    21   "    : 70 		   (Start Address 180)                 *
 *                          "    22   "    : 80            (Start Address 189)                 *
 *                          "    23   "    : 90            (Start Address 198)                 *                                                                                          *
  *                      Message 24 Record : Chen-may-lak  (Start Address 207)                 *
 *																							   *
 *  Date     :  17/Junly/2012   	                                                           *
 *  Write By : Sittiphol Yooyod(ETT CO.,LTD.)                                                  *
 *												                                               *
 ***********************************************************************************************/
  
  						
#include <at89c51re2.h>
#include <stdio.h>

int add_nm1,add_nm2,add_ch,addr                ;

unsigned char number = 0,ch = 0,fag_nm=0,nh,nl ;


/********************************************
 **             Function Delay             **
 ********************************************/

 //--------- delay ----------
void delay(int count)          
 {
    int i,j;
    for(i=0;i<=count;i++)
    for(j=0;j<=count;j++)	 ;
 }


/*******************************************************
 **											 	      **
 **                     FUNCTION LCD                  **
 **												      **
 *******************************************************/ 

 sbit   Ena = P2^1           ;  //Refferent Bit2.1 = Ena

//---------- Write Command to LCD -------------
 
void Wr_CmmLCD(unsigned char cmm)
{  
  P2 = cmm & 0xF0            ;	  //Sent cmm 4 bit High, RS:P2.3=0, RW:P2.2=0 
  Ena = 1                    ;    
  delay(20)                  ;
  Ena = 0                    ;    
  delay(20)                  ;

  P2 = (cmm << 4) & 0xF0     ;  //Sent cmm 4 bit Low, RS:P2.3=0, RW:P2.2=0
  Ena = 1                    ;   
  delay(20)                  ;
  Ena = 0                    ;   
  delay(20)                  ;
}

//------------- Write data to lcd ----------------

void Wr_DataLCD(unsigned char dat)
{ 
  P2 = (dat & 0xF0)|0x08               ;	  //Sent cmm 4 bit High, RS:P2.3=1, RW:P2.2=0
  Ena = 1                              ;    
  delay(20)                            ;
  Ena = 0                              ;    
  delay(20)                            ;

  P2 = ((dat << 4) & 0xF0) | 0x08      ;	 //Sent cmm 4 bit Low, RS:P2.3=1 , RW:P2.2=0
  Ena = 1                              ;    
  delay(20)                            ;
  Ena = 0                              ;    
  delay(20)                            ;

}


//----------- Clear All Display ------------

void Clr_Display(void)
 {
  Wr_CmmLCD(0x01) ;
 }


//---------------- initial lcd -------------------


void Init_Lcd(void)
{
  Wr_CmmLCD(0x33);	        //Command Control 
  Wr_CmmLCD(0x32);
  Wr_CmmLCD(0x28);
  Wr_CmmLCD(0x0C);  	    //Set Display On/Off:Display On,Not Show Cursor and not blink Cursor
  Wr_CmmLCD(0x06);  	    //Set Entry Mode :Increment Address,Cursor Shift Right

  Wr_CmmLCD(0x1C);          //Set Cursor Or Display Shift : Shift Right Charecter
  Wr_CmmLCD(0x28);      	//Function Set: set interface data 4bit,Set Display LCD 2 Line ,Set Charecter Size 5x7
  Wr_CmmLCD(0x80|0x00);		//Set Address Begin 0x00 (Line1 Charecter1)
  Clr_Display();
}


//-------------- Convert Ascii ----------------

void Conv_Ascii(char num)
 {
	nh = (num/10)+0x30  ;
	
	if(nh == 0x30)		   // Check nh = '0' Give nh= space
	 nh = 0x20          ;  // Not display '0' on LCD

	nl = (num%10)+0x30  ;
	
 }



/***************************************************************
 **                Function SPI Seny data 12 bit              **
 ***************************************************************
 **          P1.0 = SDO                                       **
 **          P1.1 = SCK                                       **
 **          P1.2 = STROB                                     **   
 **          Sent First bit High                              **
 ***************************************************************/

//--------------- Define Pin -----------------------


//--------------- SDO-High(Data-Out) ---------------

#define     Sdo_Hi()      P1_0 = 1            //P1.0= SDO:1

                          
//--------------- SDO-Low(Data-OUT) ----------------

#define     Sdo_Lo()      P1_0 = 0            //P1.0= SDO:0



//--------------- Sck-High(Clock) ---------------

#define     Sck_Hi()      P1_1 = 1            //P1.1= SCK:1
                          
//--------------- Sck-Low(Clock) ----------------

#define     Sck_Lo()      P1_1 = 0           //P1.1= SCK:0



//--------------- STR-High(Strob) ---------------

#define     Str_Hi()      P1_2 = 1            //P1.2= Str:1
                          
//--------------- STR-Low(Strob) ----------------

#define     Str_Lo()      P1_2 = 0            //P1.2= Str:0



//----------------- Write Data to ISD2548 12-bit -------------------

void Spi_Wr(unsigned int DWord)			  	
 {
    unsigned int Bit ;				 	   

     Str_Lo()                             ;  //Start Strob 595 to Low

     for(Bit=0;Bit<12;Bit++)                 //Loop write data 12 Bit
      {		
	   	Sck_Lo()                          ;	 //Start 595 Clock  Low

		//--------- write Data(P1.0) ---------

		if((DWord & 0x800)== 0x800)
		    Sdo_Hi()                     ;   //Set bit data(P1.0) = 1
		else 
		    Sdo_Lo()                     ;	 //Clear bit data(P1.0) = 0
		   	 
		
		Sck_Hi()                         ;   //Set 595 Clock High for Shift data bit

		DWord <<= 1                      ;	 //Shift Next Bit Data        
	
	  }

    Str_Hi()                             ;   //Set Strob 595 to High for Out data parallel 


  }


/************************************************************
 **                    FUNCTION ISD2548	                   **
 **                                                        **
 **  -Memory = 320 Address								   ** 
 **  -Time Record Max = 48 secound					       **
 **                                                        **
 ************************************************************/



//-------- Define Data Control ISD2548 ------------

#define PL_CHi            0xA00      //CE,P/R=1;PD=0
#define PL_CLo            0x200      //P/R=1;CE,PD=0
#define REC_CHi           0x800      //CE=1;PD,P/R=0
#define REC_CLo           0x000      //CE,PD,P/R =0
#define STOP              0xE00      //CE,PD,P/R = 1 



//---------------- Read Status EOM : End OF Message ---------------- 
unsigned char Rd_Eom()
{
  unsigned char eom        ;
       
  P1_3 = 1                 ; //Set Port P1.3 = input
  eom  = P1_3              ; //Read P1.3 : 0 = end of message , Nomal = 1   
  return eom               ;  
}


//------------------- Check Status EOM -----------------
void Chk_Eom()
 {
  while(Rd_Eom()){;}   // Check Signal EOM to 0 : EOF = 0 :Exit Loop(for End message) 
  while(!Rd_Eom()){;}  // Check Signal EOM to 1 : EOF = 1 :Exit Loop (for Ready Begine Play	Next Message)
 }


//------------ Set Address for Play or Record(Addtess 0-320) ------------

void Set_Add(int add)
 { 

   addr = add & 0x1FF   ;  //Mark data Bit9-11 for write  Pin P/R,PD,CE 
   Spi_Wr(addr|STOP)	;  //Write Pin Address A0-A8 and Pin Contr0l To ISD2548  

 }

 


//-------------------- Play 1 Message ---------------------

void Play_Back()
 {

   addr = addr &0x01FF  ;  //Mark data Control Bit9-11 Pin P/R,PD,CE for  Play
   Spi_Wr(addr|PL_CLo)	;  //Write Pin Address A0-A8 and Pin Control for Play To ISD2548(Pin CE =0) 

   addr = addr &0x01FF  ;
   Spi_Wr(addr|PL_CHi)	;  //Write Pin CE = 1

 }

//----------------- Initial ISD2548 ---------------

 void Init_ISD2548()
  {

    Spi_Wr(STOP)	;     
    
  }

 /*************************************************
  **        Function PLAY MESSAGE Ticket         **
  *************************************************/
 
void Msg_Number()
 {
     //--------------- Play Message #1 "Chen-My-Lak"	--------------

      Set_Add(207)                  ;  //Set Address for Play Message  #1 
      Play_Back()                   ;  //Play "Chen-My-Lak"				
	  Chk_Eom()                     ;  //waite EOM chang '1' to '0'(EOF) and '0' to '1'(Ready begin New Message)


	  if(fag_nm==1)	  //Play Number 2 Message   
	    {
		 Set_Add(add_nm1)           ;  //Set Address for Play  Message at 1
         Play_Back()                ;  //Play Message Number				
         Chk_Eom()                  ;  //waite EOM chang '1' to '0'(EOF) and '0' to '1'(Ready begin New Message)
	     
		 Set_Add(add_nm2)           ;  //Set Address for Play  Message at 2
         Play_Back()                ;  //Play Message Number				
         Chk_Eom()                  ;  //waite EOM chang '1' to '0'(EOF) and '0' to '1'(Ready begin New Message)	
		}
	  else	   //Play Number 1 Message
		{
		  Set_Add(add_nm1)           ;  //Set Address for Play  Message at 1
          Play_Back()                ;  //Play Message Number				
          Chk_Eom()                  ;  //waite EOM chang '1' to '0'(EOF) and '0' to '1'(Ready begin New Message)
		}
	  

	 //------------------- Play Message #2,#3 "Tee-Chong","Bor-ri-kan" ---------------------

      Set_Add(9)                    ;  //Set Address for Play Message  #2 
      Play_Back()                   ;  //Play "Tee-Chong"				
	  Chk_Eom()                     ;  //waite EOM chang '1' to '0'(EOF) and '0' to '1'(Ready begin New Message)

	  Set_Add(18)                   ;  //Set Address for Play Message  #3 
      Play_Back()                   ;  //Play "Bor-ri-kan"				
	  Chk_Eom()                     ;  //waite EOM chang '1' to '0'(EOF) and '0' to '1'(Ready begin New Message)


   	  Set_Add(add_ch)               ;  //Set Address for Play Message  Number Channel(1-6)
      Play_Back()                   ;  //Play Number Channel "1-6"				
	  Chk_Eom()                     ;  //waite EOM chang '1' to '0'(EOF) and '0' to '1'(Ready begin New Message)


    //------------------- Play Message #4 "ka" ---------------------

	  Set_Add(27)                   ;  //Set Address for Play Message  #4 
      Play_Back()                   ;  //Play "ka"				
	  Chk_Eom()                     ;  //waite EOM chang '1' to '0'(EOF) and '0' to '1'(Ready begin New Message)

 }
		

//***********************************************************
//**           Function Calculate Address Message          **
//***********************************************************

void Cal_Addr_Meg()
{
  	number++                               ;       //Counter Number 1-99

	if(number>99)
	  number = 1                           ;	   //Clear Counter Number = 1 

    //----------------- Fine Address Message -----------------------

    if(((number>=1)&&(number<=10))||(number==20)||(number==30)||(number==40)||
	    (number==50)||(number==60)||(number==70)||(number==80)||(number==90))	  //Check for Play 1 message 
	  {
		fag_nm = 0                         ;	    //Set Flag for platy 1 Message
						   
	    if((number>=1)&&(number<=10))	           //Check Counter 1-10				
		   add_nm1	= 	 (number*9)+27	   ;	   //Keep Address for Play Message '1-10' (27 = Address Start for Messsage '1')
	    else                                       //if Number Counter = 20,30,40,50,60,70,80,90
			add_nm1 =  ((number/10)*9)+117 ;       //Keep Address for Message('20,30,40,50,60,70,80,90')                    						 
	  }
	 else   //Check for Play 2 Message
	  {
	    fag_nm  = 1                        ;	   //Set Flag for platy 2 Message
						   

		//---Set address Message 1 -----
													       
		if((number/10)==1)			              //If Number  11-19
		  add_nm1 = 117                    ;	  //Keep Address Message '10'
    	else								      //if Number 21-29,31-39,41-49,51-59,61-69,71-79,81-89,91-99
		  add_nm1 = ((number/10)*9)+117    ;	  //Calcilate and Set Address Message '20,30,40...90'

	    //---Set address Message 2 -----

		 if((number%10)==1)	                     //if Number%10 = 1
		    add_nm2 = 126                 ;      //Keep Address message 'ed'		 
		 else								  	 //if Number%10 > 1	(2-9)
			add_nm2 = ((number%10)*9)+27  ;      //Keep Address message '2-9'
	  }
}




//**********************************************************
//**                   Function Switch                    **
//**********************************************************

//-------------- Check press SW.2-SW.7 -----------

void Check_Sw()
 {
    P3 = 0xFF                     ;
	while((P3&0xFC) != 0xFC){;}	    //Check SW. P3[2..7] Release All 
	delay(50)                     ;

 }

//---------------- Read SW.2-SW.7 -----------------

unsigned char Rd_Sw()
 {
    unsigned char sw         ;

    P3 = 0xFF                ;
	sw = P3                  ;	 //Read press SW. P3[2..7]
	sw = (~sw)& 0xFC         ;	 //Mark P3[2..7] and invert data (Normal Value Not press SW. is logic 1)

	return sw                ;

 }


/************************************************************************************
 **                                                                                **
 ** ###################### ------------ MAIN Program ----------- ################# **
 **                                                                                **
 ************************************************************************************/

main()
 {
   unsigned char key ;
  // CKCON0   = 0xFE                  ;   //Set MCU 12 Clock Mode
   BMSEL    = 0x00                    ;   //Select Bank 0+Command Bank for Area Flash
 
   CKCON0   = 0x01                    ;   //div 6 clk mode  X2=1
   AUXR     = 0x10                    ;   //Set XRAM = 1792 Byte


   Init_ISD2548() ; 
   Init_Lcd()     ;


//------------ write string to lcd ----------------
  
  //----------- String mode Time ----------

   Wr_CmmLCD(0x80|0x00)    ;  //Start address lcd = 0x00  Line 1
   Wr_DataLCD('C')         ;  //Plot data to lcd
   Wr_DataLCD('O')         ;
   Wr_DataLCD('U')         ;
   Wr_DataLCD('N')         ;
   Wr_DataLCD('T')         ;
   Wr_DataLCD('E')         ;
   Wr_DataLCD('R')         ;
   Wr_DataLCD('=')         ;
  
   Wr_CmmLCD(0x80|0x40)    ;  //Start address lcd = 0x08  Line 1
   Wr_DataLCD('N')         ;  //Plot data to lcd
   Wr_DataLCD('U')         ;
   Wr_DataLCD('M')         ;
   Wr_DataLCD('B')         ;
   Wr_DataLCD('E')         ;
   Wr_DataLCD('R')         ;
   Wr_DataLCD(0x20)        ;
   Wr_DataLCD('=')         ;


   delay(100);

 
 
  while(1)
  {
    delay(100); 

   	key = Rd_Sw() ;	

	switch(key)
	 {
	     case 0x04:   //SW2-IN2 -------> COUNTER-1 Call 
					   
						add_ch = 36			     ;	//Keep address Message '1' for Channel

						Cal_Addr_Meg()           ;  //Call Calculate Address Message

                        //------------Show Number On LCD ----------------
						 
					    Wr_CmmLCD(0x80|0x0B)    ;  //Start address lcd = 0x0B  Line 1
					    Wr_DataLCD('1')         ;  //Show Channel '1' On LCD

                       	Conv_Ascii(number)      ;  //Convert Ascii for Number Show to LCD Line2
						Wr_CmmLCD(0x80|0x4A)    ;  //Start address lcd = 0x4A  Line 2
					    Wr_DataLCD(nh)          ;  //Show Number Colum High On LCD
					    Wr_DataLCD(nl)          ;  //Show Number Colum Low On LCD

						Msg_Number()            ;  //Call Play Sound Message
						
						Check_Sw()              ;  //Check Press Repeat	SW.

			  break ;

         case 0x08:   //SW3-IN3 -------> COUNTER-2 Call


				     	add_ch = 45			     ;  //Keep address Message '2' for Channel

						Cal_Addr_Meg()           ;  //Call Calculate Address Message

                        //------------Show Number On LCD ----------------
						 
					    Wr_CmmLCD(0x80|0x0B)    ;  //Start address lcd = 0x0B  Line 1
					    Wr_DataLCD('2')         ;  //Show Channel '2' On LCD

                       	Conv_Ascii(number)      ;  //Convert Ascii for Number Show to LCD Line2
						Wr_CmmLCD(0x80|0x4A)    ;  //Start address lcd = 0x4A  Line 2
					    Wr_DataLCD(nh)          ;  //Show Number Colum High On LCD
					    Wr_DataLCD(nl)          ;  //Show Number Colum Low On LCD

						Msg_Number()            ;  //Call Play Sound Message
						
						Check_Sw()              ;  //Check Press Repeat	SW.

			  break ;

	  
         case 0x10:   //SW4-IN4 -------> COUNTER-3 Call


				     	add_ch = 54			    ;	//Keep address Message '3' for Channel

						Cal_Addr_Meg()          ;  //Call Calculate Address Message

                        //------------Show Number On LCD ----------------
						 
					    Wr_CmmLCD(0x80|0x0B)    ;  //Start address lcd = 0x0B  Line 1
					    Wr_DataLCD('3')         ;  //Show Channel '3' On LCD

                       	Conv_Ascii(number)      ;  //Convert Ascii for Number Show to LCD Line2
						Wr_CmmLCD(0x80|0x4A)    ;  //Start address lcd = 0x4A  Line 2
					    Wr_DataLCD(nh)          ;  //Show Number Colum High On LCD
					    Wr_DataLCD(nl)          ;  //Show Number Colum Low On LCD

						Msg_Number()            ;  //Call Play Sound Message
						
						Check_Sw()              ;  //Check Press Repeat	SW.

			  break ;

           case 0x20:   //SW5-IN5 -------> COUNTER-4 Call


				     	add_ch = 63			    ;	//Keep address Message '4' for Channel

						Cal_Addr_Meg()          ;  //Call Calculate Address Message

                        //------------Show Number On LCD ----------------
						 
					    Wr_CmmLCD(0x80|0x0B)    ;  //Start address lcd = 0x0B  Line 1
					    Wr_DataLCD('4')         ;  //Show Channel '4' On LCD

                       	Conv_Ascii(number)      ;  //Convert Ascii for Number Show to LCD Line2
						Wr_CmmLCD(0x80|0x4A)    ;  //Start address lcd = 0x4A  Line 2
					    Wr_DataLCD(nh)          ;  //Show Number Colum High On LCD
					    Wr_DataLCD(nl)          ;  //Show Number Colum Low On LCD

						Msg_Number()            ;  //Call Play Sound Message
						
						Check_Sw()              ;  //Check Press Repeat	SW.

			  break ;

           case 0x40:   //SW6-IN6 -------> COUNTER-5 Call


				     	add_ch = 72			    ;	//Keep address Message '5' for Channel

						Cal_Addr_Meg()          ;  //Call Calculate Address Message

                        //------------Show Number On LCD ----------------
						 
					    Wr_CmmLCD(0x80|0x0B)    ;  //Start address lcd = 0x0B  Line 1
					    Wr_DataLCD('5')         ;  //Show Channel '5' On LCD

                       	Conv_Ascii(number)      ;  //Convert Ascii for Number Show to LCD Line2
						Wr_CmmLCD(0x80|0x4A)    ;  //Start address lcd = 0x4A  Line 2
					    Wr_DataLCD(nh)          ;  //Show Number Colum High On LCD
					    Wr_DataLCD(nl)          ;  //Show Number Colum Low On LCD

						Msg_Number()            ;  //Call Play Sound Message
						
						Check_Sw()              ;  //Check Press Repeat	SW.

			  break ;

            case 0x80:   //SW6-IN6 -------> COUNTER-6 Call


				     	add_ch = 81			    ;	//Keep address Message '6' for Channel

						Cal_Addr_Meg()          ;  //Call Calculate Address Message

                        //------------Show Number On LCD ----------------
						 
					    Wr_CmmLCD(0x80|0x0B)    ;  //Start address lcd = 0x0B  Line 1
					    Wr_DataLCD('6')         ;  //Show Channel '6' On LCD

                       	Conv_Ascii(number)      ;  //Convert Ascii for Number Show to LCD Line2
						Wr_CmmLCD(0x80|0x4A)    ;  //Start address lcd = 0x4A  Line 2
					    Wr_DataLCD(nh)          ;  //Show Number Colum High On LCD
					    Wr_DataLCD(nl)          ;  //Show Number Colum Low On LCD

						Msg_Number()            ;  //Call Play Sound Message
						
						Check_Sw()              ;  //Check Press Repeat	SW.

			  break ;


	 }     //switch
   }	   // While 	
 }	       // end
