

 /**********************************************************************************************
  *                                                                                            *
  *                Example 2. Tell Time Every 30 Minuit (Address Mode)                         *
  *                                                                                            *
  **********************************************************************************************
  *						                                                                       * 
  *  MCU              : AT89C51RE2(Use CP-JR51RE2 V1.0 Board)                                  *
  *  Compiler         : Keil C51 (V8.05 a)                                                     *
  *												                                               *
  *  PORT Interface   :										                                   *
  *             SPI   :  # MCU-51RE2 #  		   	         #ET-MINI ISD2548#                 *
  *                      ------------                       -------------------                *
  *                                                                                            *                                   
  *                      P1.0(Out)         connect            DIN                              *                
  *                      P1.1(Out)         connect            SCK                              *
  *                      P1.2(Out)         connect            STB                              *               
  *                      P1.3(IN)          connect            EOM (Must Pull Up)               *               
  *                      GND               connect            ENA                              *             
  *                      NO USE            connect            OVF                              *            
  *                                                                                            *
  *                                                                                            *
  *                                    5V                                                      *
  *                                  --+--                                                     *
  *                                    |                                                       *
  *                                    \                                                       *
  *                                    / 10K                                                   *
  *                                    \                                                       *
  *                                    /                                                       *
  *                                    |                                                       *
  *                                    |                                                       *
  *                                    |                                                       *
  *                                    |         ET-Mini ISD2548       5V                      *
  *                                    |      +-------------------+   --+--                    *
  *                                    |      |                   |     |                      *
  *                           P1.0 ----|----->|DIN            +5V +-----+      /|              *
  *                           P1.1 ----|----->|SCK                |          /  |              *
  *                           P1.2 ----|----->|STR            SP+ +--------||   |              *
  *                           P1.3 <---+------|EOM                |        || SP|              *
  *                                           |               SP- +--------||   |              *
  *                                           |                   |          \  |              *
  *                               +-----------|ENA            GND +-----+      \|              *
  *                             __|__         |                   |   __|__                    *
  *                              ---          |                   |    ---                     *
  *                               -        ---|VOF                |     -                      *
  *                                           |                   |                            *
  *                                           |                MIC|----                        *
  *                                           +-------------------+                            *
  *                                            Set Jp1 : to GND                                *
  *                                                Jp2 : No use (Don't care)                   *
  *                                                                                            *
  *                                                                                            * 
  *                                                                                            *
  *              LCD :    # MCU-51RE2 #                        # LCD 2x16 DISPLAY #            *
  *                        -----------                        --------------------             *
  *                          P2.1			   connect               E                         *
  *                          P2.2              connect               RW		                   *
  *                          P2.3			   connect          	 RS					       *
  *                          P2.4-P2.7         connect	       data 4 bit high                 *
  *       5V                                                                                   *
  *      --+--                                                                                 *
  *        |                                                                                   *
  *        +-----------------+                                                                 *
  *        |                 |                                                                 *
  *       ---                |                                                                 *
  *       |\|                |                                                                 *
  *    VR |/|<---------------|--+                                                              *
  *   10K ---                |  | P2.3 P2.2 P2.1         P2.4 P2.5 P2.6 P2.7                   *
  *        |                 |  |   ^   ^    ^             ^   ^   ^   ^                       *
  *        |                 |  |   |   |    |             |   |   |   |                       *
  *        +--------------+--|--|---|---|---|--+--+--+--+  |   |   |   |                       *
  *      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |                       *
  *       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |                       *
  *        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|                       *
  *                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_                      *
  *                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |                     *
  *                    |    _________________________________________    |                     *
  *                    |   |                                         |   |                     *
  *                    |   |               Module                    |   |                     *
  *                    |   |         LCD 2x16 Charecter              |   |                     *  
  *                    |   |_________________________________________|   |                     *
  *                    |                                                 |                     *
  *                    |_________________________________________________|                     *
  *                                                                                            * 
  *                                                                                            *    
  *                                                                                            *
  *		     I2C RTC : DS3232 = Interface I2C(ID:1101000X = 0xD0(Wr),0xD1(Rd) )                * 
  *																			                   *
  *                    # MCU-51RE2 #                       Mini-DS3232 Module                  * 																				       *
  *                    -------------                       ------------------                  *
  *                    P3.6 (SCK-out)	   Connect 		    SCL(Clock) 		                   *
  *                    P3.7 (SDA-I/O)	   Connect 		    SDA(DATA)    	                   *
  *                                                                                            *        
  *                                       													   *
  *                                   Module ET-ETMI DS3232	                                   *
  *									  ---------------------									   *
  *                                  |                     |								   *
  *                 VCC  ----------->|+5V				   |								   *
  *					P3.6 ----------->|SCL	               |								   *
  *					P3.7<----------->|SDA			 	   |								   *
  *			                   Nc ---|SQW/INT#			   |								   *
  *				               Nc ---|32KHz				   |								   *
  *					           Nc ---|RST				   |								   *
  *					          +----->|GND				   |								   *
  *                           |       ---------------------     						   	   *
  *					 	      |																   *
  *							__|__															   *
  *							 ---															   *
  *							  -																   *
  *	                                                                                           *
  *  Before Operate  :	  Use Example_1 for Record Message of Time by 1 Message Use 9 address  *
  *                                                                                            *
  *                       Message 02 Record : Way-la     (Start Address 9 )                    *
  *                          "    03   "    : Na-ri-ka   (Start Address 18 )                   *
  *                          "    04   "    : Na-tee     (Start Address 27 )                   *
  *                          "    05   "    : Vi-na-tee  (Start Address 36 )                   *
  *                          "    06   "    : 0          (Start Address 45 )                   * 
  *                          "    07   "    : 1 	 	 (Start Address 54 )                   *
  *                          "    08   "    : 2          (Start Address 63 )                   *
  *                          "    09   "    : 3          (Start Address 72 )                   *
  *                          "    10   "    : 4          (Start Address 81 )                   *
  *                          "    11   "    : 5          (Start Address 90 )                   *
  *                          "    12   "    : 6          (Start Address 99 )                   * 
  *                          "    13   "    : 7   	 	 (Start Address 108)  	               *
  *                          "    14   "    : 8          (Start Address 117)                   *
  *                          "    15   "    : 9          (Start Address 126)                   * 
  *                          "    16   "    : 10 		 (Start Address 135)                   *
  *                          "    17   "    : ed         (Start Address 144)                   *
  *                          "    18   "    : 20         (Start Address 153)                   *
  *                       Message 19 Record : ka-na-nee  (Start Address 162)                   *
  *                                                                                            *
  *																							   *
  *  Date          : 18/Junly/2012   	                                                       *
  *  Write By      : Sittiphol Yooyod(ETT CO.,LTD.)                                            *
  *												                                               *
  **********************************************************************************************/
  
  						
#include <at89c51re2.h>
#include <stdio.h>

 unsigned char fag_mn,fag_hh   ;
 int ss,mn,hh,addr             ;
 int add_hh1,add_hh2           ;


/********************************************
 **             Function Delay             **
 ********************************************/

 //--------- delay ----------
void delay(int count)          
 {
    int i,j;
    for(i=0;i<=count;i++)
    for(j=0;j<=count;j++)	 ;
 }


 /************************************************************
  **             Function  Convert BCD Time to Ascii        **         
  ************************************************************/

 void conv_time(char sec,char min,char hour)
 {
  
   //---------- Convert Second(00-59) to ascii ---------
   ss = sec >> 4             ;
   ss = ss+0x30  		     ; //Secound byte High to ascii

   sec = sec & 0x0F          ;
   sec = sec+0x30            ; //Secound byte Low to ascii
   ss = (ss << 8)| sec       ; 

   //---------- Convert Minute(00-59) to ascii ---------

   mn = min >> 4             ;
   mn = mn+0x30  		     ;  //Minuted byte High to ascii

   min = min & 0x0F          ;
   min = min+0x30            ;  //Minuted byte Low to ascii
   mn = (mn << 8)| min       ; 

   //---------- Convert Hour(00-23) to ascii ---------

   hh = hour >> 4            ;  //Hour byte High to ascii
   hh = hh+0x30  		     ;

   hour = hour & 0x0F        ;
   hour = hour+0x30          ;  //Hour byte Low to ascii
   hh   = (hh << 8)| hour    ; 

 }


/*******************************************************
 **											 	      **
 **                     FUNCTION LCD                  **
 **												      **
 *******************************************************/ 

 sbit   Ena = P2^1           ;  //Refferent Bit2.1 = Ena

//---------- Write Command to LCD -------------
 
void Wr_CmmLCD(unsigned char cmm)
{  
  P2 = cmm & 0xF0            ;	  //Sent cmm 4 bit High, RS:P2.3=0, RW:P2.2=0 
  Ena = 1                    ;    
  delay(20)                  ;
  Ena = 0                    ;    
  delay(20)                  ;

  P2 = (cmm << 4) & 0xF0     ;  //Sent cmm 4 bit Low, RS:P2.3=0, RW:P2.2=0
  Ena = 1                    ;   
  delay(20)                  ;
  Ena = 0                    ;   
  delay(20)                  ;
}

//------------- Write data to lcd ----------------

void Wr_DataLCD(unsigned char dat)
{ 
  P2 = (dat & 0xF0)|0x08               ;	  //Sent cmm 4 bit High, RS:P2.3=1, RW:P2.2=0
  Ena = 1                              ;    
  delay(20)                            ;
  Ena = 0                              ;    
  delay(20)                            ;

  P2 = ((dat << 4) & 0xF0) | 0x08      ;	 //Sent cmm 4 bit Low, RS:P2.3=1 , RW:P2.2=0
  Ena = 1                              ;    
  delay(20)                            ;
  Ena = 0                              ;    
  delay(20)                            ;

}


//----------- Clear All Display ------------

void Clr_Display(void)
 {
  Wr_CmmLCD(0x01) ;
 }


//---------------- initial lcd -------------------


void Init_Lcd(void)
{
  Wr_CmmLCD(0x33);	        //Command Control 
  Wr_CmmLCD(0x32);
  Wr_CmmLCD(0x28);
  Wr_CmmLCD(0x0C);  	    //Set Display On/Off:Display On,Not Show Cursor and not blink Cursor
  Wr_CmmLCD(0x06);  	    //Set Entry Mode :Increment Address,Cursor Shift Right

  Wr_CmmLCD(0x1C);          //Set Cursor Or Display Shift : Shift Right Charecter
  Wr_CmmLCD(0x28);      	//Function Set: set interface data 4bit,Set Display LCD 2 Line ,Set Charecter Size 5x7
  Wr_CmmLCD(0x80|0x00);		//Set Address Begin 0x00 (Line1 Charecter1)
  Clr_Display();
}


/***************************************************************
 **                Function SPI Seny data 12 bit              **
 ***************************************************************
 **          P1.0 = SDO                                       **
 **          P1.1 = SCK                                       **
 **          P1.2 = STROB                                     **   
 **          Sent First bit High                              **
 ***************************************************************/

//--------------- Define Pin -----------------------


//--------------- SDO-High(Data-Out) ---------------

#define     Sdo_Hi()      P1_0 = 1            //P1.0= SDO:1

                          
//--------------- SDO-Low(Data-OUT) ----------------

#define     Sdo_Lo()      P1_0 = 0            //P1.0= SDO:0



//--------------- Sck-High(Clock) ---------------

#define     Sck_Hi()      P1_1 = 1            //P1.1= SCK:1
                          
//--------------- Sck-Low(Clock) ----------------

#define     Sck_Lo()      P1_1 = 0           //P1.1= SCK:0



//--------------- STR-High(Strob) ---------------

#define     Str_Hi()      P1_2 = 1            //P1.2= Str:1
                          
//--------------- STR-Low(Strob) ----------------

#define     Str_Lo()      P1_2 = 0            //P1.2= Str:0



//----------------- Write Data to ISD2548 12-bit -------------------

void Spi_Wr(unsigned int DWord)			  	
 {
    unsigned int Bit ;				 	   

     Str_Lo()                             ;  //Start Strob 595 to Low

     for(Bit=0;Bit<12;Bit++)                 //Loop write data 12 Bit
      {		
	   	Sck_Lo()                          ;	 //Start 595 Clock  Low

		//--------- write Data(P1.0) ---------

		if((DWord & 0x800)== 0x800)
		    Sdo_Hi()                     ;   //Set bit data(P1.0) = 1
		else 
		    Sdo_Lo()                     ;	 //Clear bit data(P1.0) = 0
		   	 	
		Sck_Hi()                         ;   //Set 595 Clock High for Shift data bit

		DWord <<= 1                      ;	 //Shift Next Bit Data        
	
	  }
    Str_Hi()                             ;   //Set Strob 595 to High for Out data parallel 
  }



/************************************************************
 **                    FUNCTION ISD2548	                   **
 **                                                        **
 **  -Memory = 320 Address								   ** 
 **  -Time Record Max = 48 secound					       **
 **                                                        **
 ************************************************************/


//-------- Define Data Control ISD2548 ------------

#define PL_CHi            0xA00      //CE,P/R=1;PD=0
#define PL_CLo            0x200      //P/R=1;CE,PD=0
#define REC_CHi           0x800      //CE=1;PD,P/R=0
#define REC_CLo           0x000      //CE,PD,P/R =0
#define STOP              0xE00      //CE,PD,P/R = 1 



//---------------- Read Status EOM : End OF Message ---------------- 
unsigned char Rd_Eom()
{
  unsigned char eom        ;
       
  P1_3 = 1        ; //Set Port P1.3 = input
  eom  = P1_3     ; //Read P1.3 : 0 = end of message , Nomal = 1   
  return eom      ;  
}


//------------------- Check Status EOM -----------------
void Chk_Eom()
 {
  while(Rd_Eom()){;}   // Check Signal EOM to 0 : EOF = 0 :Exit Loop(for End message) 
  while(!Rd_Eom()){;}  // Check Signal EOM to 1 : EOF = 1 :Exit Loop (for Ready Begine Play	Next Message)
 }


//------------ Set Address for Play or Record(Addtess 0-320) ------------

void Set_Add(int add)
 { 

   addr = add & 0x1FF   ;  //Mark data Bit9-11 for write  Pin P/R,PD,CE 
   Spi_Wr(addr|STOP)	;  //Write Pin Address A0-A8 and Pin Contr0l To ISD2548  

 }

 

//-------------------- Play 1 Message ---------------------

void Play_Back()
 {

   addr = addr &0x01FF  ;  //Mark data Control Bit9-11 Pin P/R,PD,CE for  Play
   Spi_Wr(addr|PL_CLo)	;  //Write Pin Address A0-A8 and Pin Control for Play To ISD2548(Pin CE =0) 

   addr = addr &0x01FF  ;
   Spi_Wr(addr|PL_CHi)	;  //Write Pin CE = 1

 }

//----------------- Initial ISD2548 ---------------

 void Init_ISD2548()
  {
    Spi_Wr(STOP)	;     
    
  }



//*************************************************
//**              PLAY MESSAGE Time              **
//*************************************************

void Msg_Time()
 {
     //--------------- Play Message --------------

      Set_Add(162)                       ;  //Set Address for Play " ka-Na-Nee "
      Play_Back()                        ;  //Play Message				
	  Chk_Eom();

	  Set_Add(9)                         ;  //Set Address for Play " Way-La"
      Play_Back()                        ;  //Play Message				
      Chk_Eom();

	  
	 //**************** Play Time Hour every half hour *******************

     if(fag_hh==1)	                         //Check Fag_Hour =1 for Play 2 Message
	  {			 
	   Set_Add(add_hh1)                  ;  //Set Address for Play Number Colum 1 (10,20)
       Play_Back()                       ;  //Play Message				
	   Chk_Eom()                         ;
      
	   Set_Add(add_hh2)                  ;  //Set Address for Play Number Colum 2 (1-9)
       Play_Back()                       ;  //Play Message				
	   Chk_Eom()                         ;
	  }
	 else			                        //Fag_Hour =0 for Play 1 Message
	  {
	   Set_Add(add_hh1)                  ;  //Set Address for Play Number (1-9)
       Play_Back()                       ;  //Play Message				
	   Chk_Eom()                         ;

	  }

	 //-------------- Play Message ----------------
 	  Set_Add(18)                        ;  //Set Address for Play " Narika "
      Play_Back()                        ;  //Play Message				
	  Chk_Eom();
 

	 //**************** Play Time Minute at 0,30  Minute *******************
	
	 if(fag_mn==1)	                       //Check Fag_minute=1 for Play 2 Message
	  {			 
	   Set_Add(72)                      ;  //Set Address for Play "3" 
       Play_Back()                      ;  //Play Message				
	   Chk_Eom();
      
	   Set_Add(135)                     ;  //Set Address for Play "10" 
       Play_Back()                      ;  //Play Message				
	   Chk_Eom();
	  }
	else			                       //Check Fag_minute for Play 1 Message
	  {
	   Set_Add(45)                      ;  //Set Address for Play "0" 
       Play_Back()                      ;  //Play Message				
	   Chk_Eom();

	  }
	  
	//-------------- Play Message ----------------
 	  Set_Add(27)                       ;  //Set Address for Play " Na-Tee "
      Play_Back()                       ;  //Play Message				
	  Chk_Eom();
 


	//*************** Play Time Secound at 0 Secound *******************
				 
	  Set_Add(45)                       ;  //Set Address for Play "0" 
      Play_Back()                       ;  //Play Message				
	  Chk_Eom();
    
	//-------------- Play Message ----------------
 	  Set_Add(36)                       ;  //Set Address for Play " Vi-Na-Tee "
      Play_Back()                       ;  //Play Message				
	  Chk_Eom();

 
 }



 /*************************************************************
  **														 **
  **           FUNCTION I2C RTC DS3232  					 **
  **	       ID:1101000X = 0xD0(Wr),0xD1(Rd) 				 **
  **                                                         **
  *************************************************************/ 

 //--------------------- Define I2C Pin -----------------------


#define     SCK_HI()    P3_6 = 1 	//P3.6=SCK:1
#define     SCK_LO()    P3_6 = 0 	//P3.6=SCK:0

#define     SDA_HI()    P3_7 = 1    //P3.7=SDA:1 
#define     SDA_LO()    P3_7 = 0 	//P3.7=SDA:0


sbit  SDA = P3^7         ;  //Refferent Bit3.7 = SDA


//----------------- I2C Start ------------------
void I2C_start()
{

   SDA_HI()              ;	//I2C Start Condition					
   SCK_HI()              ;
   SDA_LO()              ;					
   SCK_LO()              ;

}

//---------------- I2C Stop -----------------

void I2C_stop()
{
   SDA_LO()              ;	//I2C Stop Condition					  
   SCK_HI()              ;
   SDA_HI()              ;		
}


//-----------------------------------------------------------------------
//--                      I2C Write 8bit Data                          --
//-----------------------------------------------------------------------                                           
//--  Parameter : dat = data for DS3232 (1Byte)                        --
//--                                                                   --       
//-----------------------------------------------------------------------

void I2C_WrByte(unsigned char dat)			  	
{
   unsigned char loop ;		

   for(loop =0;loop<8;loop++)       //Loop Write data 8-Bit
    {
     if((dat & 0x80)==0x80) 		//Check Data bit8 is '0' or '1'? 
       SDA_HI()                  ;	//If data is '1' Set Pin P3.7(SDA) = 1
     else                   
       SDA_LO()                  ;  //if data is '0' Set Pin P3.7(SDA) = 0

     SCK_HI()                    ;  //Clock HI
     SCK_LO()                    ;  //Clock LO
  
     dat <<= 1                   ;  //Shift Left Data For Send (MSB <- LSB)
   }

   SDA_HI()                      ;  //Release SDA
   SCK_HI()                      ;  //Start ACK Clock
   while(SDA&0x01){;}               //Check ACK:P3.7 = 0 Out Loop
   SCK_LO()                      ;  //End ACK Clock

}


//------------------------------------------------------------------------ 
//--                    Function Write RTC(DS3232)                      --
//------------------------------------------------------------------------
//-- Parameter :                                                        --
//--             addr  = Address  Register for write(1Byte)             --
//--             dat   = Data for Set up DS3232(1Byte)                  --                      
//------------------------------------------------------------------------
 
void I2C_WrRTC (char addr,signed char dat)
{ 
  
   I2C_start()           ;	//I2C Start Condition					
  
//---------- Sent Slave address for Write ---------------

   I2C_WrByte(0xD0)      ;  //Send ID Code DS3232+Write (1101 000+0)

//--------- Sent address Register  ----------------

   I2C_WrByte(addr)      ;	//Send Address Reg. to DS3232
  
//------------- Sent data to RTC 1 byte ---------------

   I2C_WrByte(dat)       ;	//Send Data Control to DS3232
 
//------------ Sent Status Stop Write---------------  

   I2C_stop();
  
}

 
//-------------------------------------------------------------------
//--                 Function I2C Read  8 bit Data                 --  
//-------------------------------------------------------------------       

 unsigned char I2C_RdByte(void)			  	
 { 
   unsigned char loop,result=0 ;		
    
  	
   for(loop = 0; loop < 8; loop++)	   //Loop Read data 8-Bit
    {
      result <<= 1                 ;   //Shift Result Save (MSB <- LSB)   

	  SDA_HI()                     ;   //Release Data	
	  SCK_HI()                     ;   //Strobe Read SDA	
      if((SDA&0x01) == 0x01)           //Check Data Read Pin SDA(P1.7) is '0' or '1'
	    result |= 0x01             ;   //If Read Pin SDA is '1' Give Save Bit Data = 1
      SCK_LO()                     ;   //Next Bit Read

    } 

 return result                     ;

}

 
//-------------------------------------------------------------
//--              Function Read RTC(DS3232) 1 Byte           --
//-------------------------------------------------------------
//-- Parameter :                                             --
//--              addr = Register Address for Read           --
//-------------------------------------------------------------

 unsigned char I2C_RdRTC(unsigned char addr)
  {
    unsigned char dat  ;
   
//-------------- Sent Status Start for write -----------

   I2C_start()               ; 			 	 //I2C Stat condition
  
//------------- Sent Slave Address for Write------------	
 
   I2C_WrByte(0xD0)         ;				//Send ID Code DS3232,Write (1101 000+0)

//------------ Sent address Register --------------

   I2C_WrByte(addr)         ;				//Send Address Reg. to DS3232


//---------- New Sent Status Start For Read ----------

   I2C_start()              ;				//I2C Stat condition
  						   
//-------------Sent Slave address for Read ------------

   I2C_WrByte(0xD1)         ;				//Send ID Code DS3232 ,Write (1101 000+1)
  
//------------- Read data 1 Byte ------------
   
   dat = I2C_RdByte()       ;				//Read Data 1-Byte From DS3232 
  
//---------- Sent Status Stop Red ---------------
   I2C_stop()               ; 				//I2C Stop Condition
 

	return dat              ;               //Return Data
  }


 

/************************************************************************************
 **                                                                                **
 ** ###################### ------------ MAIN Program ----------- ################# **
 **                                                                                **
 ************************************************************************************/

main()
 {
   unsigned char sec,min,hor,hs1,hs2  ;

  // CKCON0   = 0xFE                  ;   //Set MCU 12 Clock Mode
   BMSEL    = 0x00                    ;   //Select Bank 0+Command Bank for Area Flash
 
   CKCON0 = 0x01                      ;   //div 6 clk mode  X2=1
   AUXR   = 0x10                      ;   //Set XRAM = 1792 Byte

   Init_ISD2548()                    ; 
   Init_Lcd()                        ;


//------------ write string to lcd ----------------
  
  //----------- String mode Time ----------

   Wr_CmmLCD(0x80|0x00)    ;  //Start address lcd = 0x00  Line 1
   Wr_DataLCD('T')         ;  //Plot data to lcd
   Wr_DataLCD('i')         ;
   Wr_DataLCD('m')         ;
   Wr_DataLCD('e')         ;
   Wr_DataLCD(':')         ;
   Wr_CmmLCD(0x80|0x07)    ;  //Start address lcd = 0x07  Line 1
   Wr_DataLCD(':')         ;
   Wr_CmmLCD(0x80|0x0A)    ;  //Start address lcd = 0x0A  Line 1
   Wr_DataLCD(':')         ;

   delay(100);

 //--------- Set Time Secound:Minute:Hour to DS3232-------------

   I2C_WrRTC(0x00,0x55)    ;  //Write Second
   I2C_WrRTC(0x01,0x29)    ;  //Write minute
   I2C_WrRTC(0x02,0x11)    ;  //Write Hour
 
 while(1)
 {

 //------------ Read Time ss:mm:hh from ds3232 --------------

	sec = I2C_RdRTC(0x00)          ;  //Read Second
    min = I2C_RdRTC(0x01)          ;  //Read minute
	hor = I2C_RdRTC(0x02)          ;  //Read Hour  24 Hour
	conv_time(sec,min,hor)         ;  //Convert sec:min:hor to ascii


//------------ Write Data hh:mm:ss to LCD -------------

	Wr_CmmLCD(0x80|0x05)    ;  //Start address lcd = 0x05
    Wr_DataLCD(hh>>8)       ;
	Wr_DataLCD(hh)          ;
	
	Wr_CmmLCD(0x80|0x08)    ;  //Start address lcd = 0x08
    Wr_DataLCD(mn>>8)       ;
	Wr_DataLCD(mn)          ;

	Wr_CmmLCD(0x80|0x0B)    ;  //Start address lcd = 0x0B
    Wr_DataLCD(ss>>8)       ;
	Wr_DataLCD(ss)          ;


	hs1 = hh>>8             ;  // Keep Hour Ascii Byte High
	hs2 = hh                ;  // Keep Hour Ascii Byte Low


   //------------- Check at 0-minute , 0-Secound For Play Message  -----------------

   if((min == 0x00) && (sec == 0x00))
    {
	   fag_mn = 0                          ;	//Set fag for play Number minute 1 Message (0 minute)	       


	   if((hs1==0x30)||((hs1==0x31)&&(hs2==0x30))||((hs1==0x32)&&(hs2==0x30)))  //Check Hour 00-09,10,20 Narika for play 1 message
	    {
		 fag_hh = 0                        ;   //Set fag_Hour = 0 for play number 1 message(0-9,10,20)
		 
		 if(hs1 == 0x30)                       //Check 00-09 Narika for Set Address Message 0-9
		   {
		    add_hh1 = ((hs2-0x30)*9)+45	   ;   //Calculate address Message for play By 45 = Address start for Message "0" and 9 = 1 message	use 9 Address
           }
		  else		  	                       // check 10,20 Narika for Set Address Message 10,20
		   {
			 if(hs1 == 0x31)	               //Set Postion Address Message "10" = (16x9)-9  :16= order message
			    add_hh1 = 135              ;
			 else
			    add_hh1 = 153              ;   //Set Postion Address Message "20"    =(18x9)-9
		   }
	    }
	   else		                               //Check Hour 11-19,21-23 Narika for Play 2 Message
	    {
		 fag_hh = 1                        ;   //Set fag_Hour=1 for play number 2 message(11-19,21,23)

		 //-----------Set Position Message 1 -----------------

		 if(hs1 == 0x31)	                   //Set Position Address Message "10"
			add_hh1 = 135                  ;
		 else
		    add_hh1 = 153                  ;   //Set Position Address Message "20"
	
	
	      //-----------Set Position Message 2 -----------------
	 	 
		 if(hs2 == 0x31)	                   //if hs2='1' 
		    hs2 = hs2+10                   ;   //give hs2 = hs2+ 0x0A for order Message 'ed'
	
         add_hh2 = ((hs2-0x30)*9)+45	   ;   //Calculate address Message for play

	   }

	  Msg_Time()                           ;   //Play Time Message 	at xx:00:00

	 }

   //------------- Check at 30-minute, 0-Secound For Play Message  -----------------

	if((min == 0x30)&&(sec == 0x00))                    
	 {
	  fag_mn = 1                           ;   		      //Set fag for play Number minute 2 Message (3,10 minute)
  

	  if((hs1==0x30)||((hs1==0x31)&&(hs2==0x30))||((hs1==0x32)&&(hs2==0x30)))  //Check Hour 00-09,10,20 Narika for play 1 message
	   {
		 fag_hh = 0                        ;	         //Set fag_Hour = 0 for play number 1 message(0-9,10,20)
		 
		 if(hs1 == 0x30)                                 //Check 00-09 Narika for Set Address Message 0-9
		   {
		    add_hh1 = ((hs2-0x30)*9)+45	   ;		     //Calculate address Message for play By 45 = Address start for Message "0" and 9 = 1 message	use 9 Address
           }
		  else		  	                                 //check 10,20 Narika for Set Address Message 10,20
		   {
			 if(hs1 == 0x31)	                         
			    add_hh1 = 135              ;	      	 //Set Position Address Message "10"
			 else
			    add_hh1 = 153              ;	         //Set Position Address Message "20"
		   }
	   }
	  else		                                         //Check Hour 11-19,21-23 Narika for Play 2 Message
	   {
		 fag_hh = 1                        ; 	         //Set fag_Hour=1 for play number 2 message(11-19,21,23)

		 //-----------Set Position Message 1 -----------------

		 if(hs1 == 0x31)	     
			add_hh1 = 135                  ;       	     //Set Position Address Message "10"
		 else
		    add_hh1 = 153                  ;	         //Set Position Address Message "20"
		 
         //-----------Set Position Message 2 -----------------
		
		 if(hs2 == 0x31)	                             // if hs2='1' 
		    hs2 = hs2+10                   ;	         // give hs2 = hs2+ 0x0A for order Message 'ed'
         
		 
		 add_hh2 = ((hs2-0x30)*9)+45	   ;			 //Calculate address Message for play

	   }
	   Msg_Time()                          ;		    //Play Time Message 	at xx:30:00
	 } // if Check 30 Minute
  }	   // While 	
 }	   // end
