

 /**********************************************************************************************
  *                                                                                            *
  *                Example_1. Control ISD2548 Record & Play Back (Address Mode)                *
  *                                                                                            *
  **********************************************************************************************
  *                                                                                            * 
  *  MCU      : AT89C51RE2(Use CP-JR51RE2 V1.0 Board)                                          *
  *  Compiler : Keil C51 (V8.05 a)                                                             *
  *                                                                                            *
  *  PORT Interface   :                                                                        *
  *                                                                                            *
  *             SPI   :   # MCU-51RE2 #                  #ET-MINI ISD2548#                     *
  *                       -------------                    ----------------                    *                             
  *                       P1.0(Out)         connect            DIN                             *                
  *                       P1.1(Out)         connect            SCK                             *
  *                       P1.2(Out)         connect            STB                             *               
  *                       P1.3(IN)          connect            EOM (Must Pull Up)              *               
  *                       GND               connect            ENA                             *             
  *                       NO USE            connect            OVF                             *            
  *                                                                                            *
  *                                                                                            *
  *                                    5V                                                      *
  *                                  --+--                                                     *
  *                                    |                                                       *
  *                                    \                                                       *
  *                                    / 10K                                                   *
  *                              \                                                             *
  *                                    /          ET-Mini ISD2548       5V                     *
  *                                    |      +-------------------+   --+--                    *
  *                                    |      |                   |     |                      *
  *                           P1.0 ----|----->|DIN            +5V +-----+      /|              *
  *                           P1.1 ----|----->|SCK                |          /  |              *
  *                           P1.2 ----|----->|STR            SP+ +--------||   |              *
  *                           P1.3 <---+------|EOM                |        || SP|              *
  *                                           |               SP- +--------||   |              *
  *                                           |                   |          \  |              *
  *                               +-----------|ENA            GND +-----+      \|              *
  *                             __|__         |                   |   __|__                    *
  *                              ---          |                   |    ---                     *
  *                               -        ---|VOF                |     -                      *
  *                                           |                   |       _ --                 *                                           
  *                                           |               MIC+|------| |                   *
  *                                           |                  -|------|_|                   *
  *                                           +-------------------+         --                 *
  *                                                                                            *
  *                                            Set Jp1 : to GND                                *
  *                                                Jp2 : to MIC or ANA IN                      *
  *                                                                                            *
  *                                                                                            *
  *                                                                                            *
  *           LCD    :    # MCU-51RE2 #                      # LCD 2x16 DISPLAY #              *
  *                       -------------                      --------------------              *
  *                          P2.1            connect               E                           *
  *                          P2.2              connect            RW                           *
  *                          P2.3            connect              RS                           *
  *                          P2.4-P2.7         connect        data 4 bit high                  *
  *       5V                                                                                   *
  *      --+--                                                                                 *
  *        |                                                                                   *
  *        +-----------------+                                                                 *
  *        |                 |                                                                 *
  *       ---                |                                                                 *
  *       |\|                |                                                                 *
  *    VR |/|<---------------|--+                                                              *
  *   10K ---                |  |P2.3 P2.2 P2.1         P2.4 P2.5 P2.6 P2.7                    *
  *        |                 |  |   ^   ^   ^              ^   ^   ^   ^                       *
  *        |                 |  |   |   |   |              |   |   |   |                       *
  *        +--------------+--|--|---|---|---|--+--+--+--+  |   |   |   |                       *
  *      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |                       *
  *       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |                       *
  *        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|                       *
  *                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_                      *
  *                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |                     *
  *                    |    _________________________________________    |                     *
  *                    |   |                                         |   |                     *
  *                    |   |               Module                    |   |                     *
  *                    |   |         LCD 2x16 Charecter              |   |                     *  
  *                    |   |_________________________________________|   |                     *
  *                    |                                                 |                     *
  *                    |_________________________________________________|                     *
  *                                                                                            *     
  *                                                                                            *
  *       Switch   :   # MCU-51RE2 #                 # SW. for User COntrol Play& Record #     *
  *                    -------------                  -----------------------------------      *                                                                     *
  *                      P3.2(IN)         connect         SW. Select Message UP+               *
  *                      P3.3(IN)         connect         SW. Select Message Down-             *
  *                      P3.4(IN)         connect         SW. Record Message                   *
  *                      P3.5(IN)         connect         SW. Play Message All                 *
  *                      P3.6(IN)         connect         SW. STOP Play Message All            *
  *                      P3.7(IN)         connect         SW. Play 1 Message at Select         *
  *                                                                                            *
  *                  5V                                                                        *
  *              --+--                                                                         *
  *                |                                                                           *
  *                +--------+--------+--------+--------+--------+                              *
  *                |        |        |        |        |        |                              *
  *                /        /        /        /        /        /                              *
  *                \        \        \        \        \        \                              *
  *                /10K     /10K     /10K     /10K     /10K     /10K                           *
  *                \        \        \        \        \        \                              *
  *                |        |        |        |        |        |                              *
  * (Selec.Msg.+)  |        |        |        |        |        |                              *
  *   P3.2 <-------+        |        |        |        |        |                              *
  * (Selec.Msg.-)  |        |        |        |        |        |                              *
  *   P3.3 <----------------+        |        |        |        |                              *
  * (Record)       |        |        |        |        |        |                              *
  *   P3.4 <-------------------------+        |        |        |                              *
  * (Play All)     |        |        |        |        |        |                              *
  *   P3.5 <----------------------------------+        |        |                              *
  * (Stop Plall)   |        |        |        |        |        |                              *
  *   P3.6 <-------------------------------------------+        |                              *
  * (Play Back)    |        |        |        |        |        |                              *
  *   P3.7 <-------------------------------------------|--------+                              *
  *                |        |        |        |        |        |                              *
  *                |        |        |        |        |        |                              *
  *           SW.2\    SW.3\    SW.4\    sw.5\    sw.6\    SW.7\                               *
  *                |        |        |        |        |        |                              *
  *                |        |        |        |        |        |                              *
  *              --+--    --+--    --+--    --+--    --+--    --+--                            *
  *                G        G        G        G        G        G                              *
  *                                                                                            *
  *                                                                                            *
  * Poperity Message : 1 address = record sound 0.15 sec.   When                               *
  *                    ISD2548 Record Full 48 sec. and have Address 320 Address. Thus          *
  *                    This Example Give 1 Message long 1.2 sec.Only Thus ISD2548 Record       *
  *                    Full 35 Message by :                                                    *
  *                                     1 message = 1.2/0.15 = 8 Address                       *
  *                                     Add EOM signal 1 address                               *
  *                    Thus ,           1 Message = 9 Address                                  *
  *                    ISD2548 1 Chip record =   320/9 = 35 mesage                             *
  *                                                                                            *
  *  Date     :  17/Junly/2012                                                                 *
  *  Write By : Sittiphol Yooyod(ETT CO.,LTD.)                                                 *
  *                                                                                            *
  **********************************************************************************************/
  
                    
#include <at89c51re2.h>
#include <stdio.h>

unsigned char nh,nl   ;
unsigned int counter=0,addr ;



/********************************************
 **             Function Delay             **
 ********************************************/

 //--------- delay ----------
void delay(int count)          
 {
    int i,j;
    for(i=0;i<=count;i++)
    for(j=0;j<=count;j++)    ;
 }


/*******************************************************
 **                                                   **
 **                     FUNCTION LCD                  **
 **                                                   **
 *******************************************************/ 

 sbit   Ena = P2^1           ;  //Refferent Bit2.1 = Ena

//---------- Write Command to LCD -------------
 
void Wr_CmmLCD(unsigned char cmm)
{  
  P2 = cmm & 0xF0            ;     //Sent cmm 4 bit High, RS:P2.3=0, RW:P2.2=0 
  Ena = 1                    ;    
  delay(20)                  ;
  Ena = 0                    ;    
  delay(20)                  ;

  P2 = (cmm << 4) & 0xF0     ;  //Sent cmm 4 bit Low, RS:P2.3=0, RW:P2.2=0
  Ena = 1                    ;   
  delay(20)                  ;
  Ena = 0                    ;   
  delay(20)                  ;
}

//------------- Write data to lcd ----------------

void Wr_DataLCD(unsigned char dat)
{ 
  P2 = (dat & 0xF0)|0x08               ;     //Sent cmm 4 bit High, RS:P2.3=1, RW:P2.2=0
  Ena = 1                              ;    
  delay(20)                            ;
  Ena = 0                              ;    
  delay(20)                            ;

  P2 = ((dat << 4) & 0xF0) | 0x08      ;    //Sent cmm 4 bit Low, RS:P2.3=1 , RW:P2.2=0
  Ena = 1                              ;    
  delay(20)                            ;
  Ena = 0                              ;    
  delay(20)                            ;

}


//----------- Clear All Display ------------

void Clr_Display(void)
 {
  Wr_CmmLCD(0x01) ;
 }

//--------- Clear Line 1 LCD ---------------

void Clear_L1()
 {
  char k ;

   Wr_CmmLCD(0x80|0x00)    ;  //Start address lcd = 0x4B Line 2
   for(k=0;k<16;k++)   
   Wr_DataLCD(0x20)       ;  //Plot Space to lcd 
 }

//---------------- initial lcd -------------------


void Init_Lcd(void)
{
  Wr_CmmLCD(0x33);           //Command Control 
  Wr_CmmLCD(0x32);
  Wr_CmmLCD(0x28);
  Wr_CmmLCD(0x0C);          //Set Display On/Off:Display On,Not Show Cursor and not blink Cursor
  Wr_CmmLCD(0x06);          //Set Entry Mode :Increment Address,Cursor Shift Right

  Wr_CmmLCD(0x1C);          //Set Cursor Or Display Shift : Shift Right Charecter
  Wr_CmmLCD(0x28);          //Function Set: set interface data 4bit,Set Display LCD 2 Line ,Set Charecter Size 5x7
  Wr_CmmLCD(0x80|0x00);     //Set Address Begin 0x00 (Line1 Charecter1)
  Clr_Display();
}


//-------------- Convert Ascii ----------------

void Conv_Ascii(int num)
 {
   nh = (num/10)+0x30  ;
   nl = (num%10)+0x30  ;
   
 }



/***************************************************************
 **                Function SPI Seny data 12 bit              **
 ***************************************************************
 **          P1.0 = SDO                                       **
 **          P1.1 = SCK                                       **
 **          P1.2 = STROB                                     **   
 **          Sent First bit High                              **
 ***************************************************************/

//--------------- Define Pin -----------------------


//--------------- SDO-High(Data-Out) ---------------

#define     Sdo_Hi()      P1_0 = 1            //P1.0= SDO:1

                          
//--------------- SDO-Low(Data-OUT) ----------------

#define     Sdo_Lo()      P1_0 = 0            //P1.0= SDO:0



//--------------- Sck-High(Clock) ---------------

#define     Sck_Hi()      P1_1 = 1            //P1.1= SCK:1
                          
//--------------- Sck-Low(Clock) ----------------

#define     Sck_Lo()      P1_1 = 0           //P1.1= SCK:0



//--------------- STR-High(Strob) ---------------

#define     Str_Hi()      P1_2 = 1            //P1.2= Str:1
                          
//--------------- STR-Low(Strob) ----------------

#define     Str_Lo()      P1_2 = 0            //P1.2= Str:0



//----------------- Write Data to ISD2548 12-bit -------------------

void Spi_Wr(unsigned int DWord)              
 {
    unsigned int Bit ;                   

     Str_Lo()                             ;    //Start Strob 595 to Low

     for(Bit=0;Bit<12;Bit++)                    //Loop write data 12 Bit
      {      
         Sck_Lo()                         ;    //Start 595 Clock  Low

      //--------- write Data(P1.0) ---------

      if((DWord & 0x800)== 0x800)
          Sdo_Hi()                        ;    //Set bit data(P1.0) = 1
      else 
          Sdo_Lo()                        ;    //Clear bit data(P1.0) = 0
             
      
      Sck_Hi()                            ;    //Set 595 Clock High for Shift data bit

      DWord <<= 1                         ;    //Shift Next Bit Data        
   
     }

    Str_Hi()                              ;   //Set Strob 595 to High for Out data parallel 


  }

/************************************************************
 **                    FUNCTION ISD2548                    **
 **                                                        **
 **  -Memory = 320 Address                                 ** 
 **  -Time Record Max = 48 secound                         **
 **  -1 Address   = Time Record 0.15 secound               **
 **                                                        **
 ************************************************************/


//-------- Define Data Control ISD2548 ------------

#define PL_CHi            0xA00      //CE,P/R=1;PD=0
#define PL_CLo            0x200      //P/R=1;CE,PD=0
#define REC_CHi           0x800      //CE=1;PD,P/R=0
#define REC_CLo           0x000      //CE,PD,P/R =0
#define STOP              0xE00      //CE,PD,P/R = 1 




//---------------- Read Status EOM : End OF Message ---------------- 
unsigned char Rd_Eom()
{
  unsigned char eom        ;
       
  P1_3 = 1        ; //Set Port P1.3 = input
  eom  = P1_3     ; //Read P1.3 : 0 = end of message , Nomal = 1   
  return eom      ;  
}


//------------ Set Address for Play or Record(Addtess 0-320) ------------

void Set_Add(int add)
 { 

   addr = add & 0x1FF   ;  //Mark data Bit9-11 for write  Pin P/R,PD,CE 
   Spi_Wr(addr|STOP)   ;  //Write Pin Address A0-A8 and Pin Contr0l To ISD2548  

 }


//-------------------- Play 1 Message ---------------------

void Play_Back()
 {

   addr = addr &0x01FF  ;  //Mark data Control Bit9-11 Pin P/R,PD,CE for  Play
   Spi_Wr(addr|PL_CLo)   ;  //Write Pin Address A0-A8 and Pin Control for Play To ISD2548(Pin CE =0) 

   addr = addr &0x01FF  ;
   Spi_Wr(addr|PL_CHi)   ;  //Write Pin CE = 1

 }


//---------------- Record Message -------------------

void Record()
 {
   addr = addr&0x01FF   ;  //Mark data Control Bit9-11 Pin P/R,PD,CE  for Record 
   Spi_Wr(addr|REC_CHi)   ;  //Write Pin Address A0-A8 and Pin Control P/R,PD=0 and CE=1 for Record 

   addr = addr&0x01FF   ;
   Spi_Wr(addr|REC_CLo)   ;  //Write Pin CE =0 Start Recode

 }
 
//----------------Stop Play&Record Message -------------------

void Stop_PR()
 {   
   addr = addr&0x01FF   ; 
   Spi_Wr(addr|STOP)   ;   //Write data for Stop Record by Pin Control P/R,PD,CE=1 

 }

//----------------- Initial ISD2548 ---------------

 void Init_ISD2548()
  {
    Spi_Wr(STOP)   ;      
  }


/*************************************************
 **            Function Switch                 **
 *************************************************/

//-------------- Check press SW.2-SW.7 -----------

void Check_Sw()
 {
    P3 = 0xFF                    ;
   while((P3&0xFC) != 0xFC){;}     //Check SW. P3[2..7] Release All 
   delay(50)                     ;

 }

//---------------- Read SW.2-SW.7 -----------------

unsigned char Rd_Sw()
 {
    unsigned char sw            ;

   P3 = 0xFF                    ;
   sw = P3                      ;    //Read press SW. P3[2..7]
   sw = (~sw)& 0xFC             ;    //Mark P3[2..7] and invert data (Normal Value Not press SW. is logic 1)

   return sw                    ;

 }



//---------- Interrupt Service Timer0 for 1 ms -----------

 void TM0_Mod1() interrupt 1 
 {
 
  TF0     = 0            ; //Clear int. flag 
  TH0     = 0xF4         ; //Up date 16bit Reload Timer0
  TL0     = 0x00         ; //0xF400 = 1 ms 

  counter = counter+1    ; //Counter for Cursor blink
 }



/************************************************************************************
 **                                                                                **
 ** ###################### ------------ MAIN Program ----------- ################# **
 **                                                                                **
 ************************************************************************************/

main()
 {
   unsigned char sw,lp                ;
   int  nm=1                          ;
   signed int  add = 0                ;
   char str0[10] = {"Message:01"}     ;
   char str1[7]  = {"Play =>"}        ;
   char str2[11] = {"Play ALL =>"}    ;
   char str3[9]  = {"Rec [(0)]"}      ;
   char str4[14] = {"<<==Select==>>"} ;

  // CKCON0   = 0xFE                  ;   //Set MCU 12 Clock Mode
   BMSEL  = 0x00                      ;   //Select Bank 0+Command Bank for Area Flash
 
   CKCON0 = 0x01                      ;   //div 6 clk mode  X2=1
   AUXR   = 0x10                      ;   //Set XRAM = 1792 Byte


   Init_ISD2548() ; 
   Init_Lcd();

  //------- Initial Timer0 Control Cursor ---------

  TH0   = 0xF4   ;   //Start Interrupt every 1 ms
  TL0   = 0x00   ;
      
  TMOD |= 0x01   ;   //Use Timer0 Mode1 16-bit                                                                         
  ET0   = 0      ;   //Disable Timer0 Interrupt 
  TR0   = 0      ;   //Set TCON Reg. Off Timer0
                     
  EA   = 1       ;   //Enable global Interrupt  


 //--------------  Start  --------------

  Wr_CmmLCD(0x80|0x01)            ;  //Start address lcd = 0x01 Line 1
  for(lp=0;lp<14;lp++)
    Wr_DataLCD(str4[lp])          ;  //Print "<<==Select==>>" to LCD
 
  Wr_CmmLCD(0x80|0x43)            ;  //Start address lcd = 0x43 Line 2
  for(lp=0;lp<10;lp++)
    Wr_DataLCD(str0[lp])          ;  //Print "Message:01" to LCD

  Set_Add(0)                      ;  //Set Address begin for Play or Record

  while(1)
   { 
     sw = Rd_Sw() ; 

     switch(sw)
     {                
        case 0x04 :  //SW.2(P3.2) = Select Increment order Message ++
                        
                   nm= nm+1                 ;  //Counter Message for show LCD             
                   if(nm>35)                   //check number message not exceed 35 message
                     nm = 1                 ;

                   Conv_Ascii(nm)           ;  //Convert number message to ascii
                   Wr_CmmLCD(0x80|0x4B)     ;  //Start address lcd = 0x4B Line 2      
                   Wr_DataLCD(nh)           ;  //Plot number colum10 to lcd 
                   Wr_DataLCD(nl)           ;  //Plot number colum unit to lcd
                
                   add = add+9              ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message
                   if(add > 306)               //Check Position Address for Record end Message (Last Message is 35) 
                   add = 0                  ;   //if last message Recorded. Give return Start Address at 0 New
                
                   Set_Add(add)             ;  //Set Address for Play or Record
                    
                   Check_Sw()               ;

                   break ;

         case 0x08 :  //SW.3(P3.3) = Select Decrement order Message --
                        
                    nm = nm-1                 ;   //Counter Message for show LCD             
                    if(nm<1)                      //check number message not exceed 35 message
                      nm = 35                 ;

                    Conv_Ascii(nm)            ;  //Convert number message to ascii
                    Wr_CmmLCD(0x80|0x4B)      ;  //Start address lcd = 0x4B Line 2      
                    Wr_DataLCD(nh)            ;  //Plot number colum10 to lcd 
                    Wr_DataLCD(nl)            ;  //Plot number colum unit to lcd
                
                    add = add-9               ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message
                    if(add < 0)                  //Check Position Address for Record end Message (Last Message is 35) 
                      add = 306               ;  //if last message Recorded. Give return Start Address at 0 New
                
                    Set_Add(add)              ;  //Set Address for Play or Record
                    
                    Check_Sw()                ;
            						             
                    break ;

        case 0x10 :  //SW.4(P3.4) = Record Message
                               
                    Clear_L1()                         ;  //Clear Message On LCD L1
                    Wr_CmmLCD(0x80|0x03)               ;  //Start address lcd = 0x03 Line 1
                    for(lp=0;lp<9;lp++)
                      Wr_DataLCD(str3[lp])             ;  //Print "Rec [(0)]" to LCD
                 
                    Wr_CmmLCD(0x80|0x09)               ;  //Start address lcd = 0x09 Line 1     
                    Wr_CmmLCD(0x0D)                    ;  //LCD Blink 
                    ET0  = 1                           ;  //Enable Timer0 Interrupt  
                    TR0  = 1                           ;  //Set TCON Reg. On Timer0

                    Record()                           ;  //Start Record
      
                    while(counter<1200){;}                //wait record 1.2 sec.(use 1.2s/0.15s = 8 Address+ 1 for eom=9 address)
                    Stop_PR()                          ;  //Stop Record   at 1.2 sec./ 1-message
                
                    Wr_CmmLCD(0x0C)                    ;  //Stop LCD Blink 

                    counter  = 0                       ;  //Clear Counter
                    ET0      = 0                       ;  //Disable Timer0 Interrupt  
                    TR0      = 0                       ;  //Set TCON Reg. OFF Timer0 
                   
                    Wr_CmmLCD(0x80|0x01)               ;  //Start address lcd = 0x01 Line 1
                    for(lp=0;lp<14;lp++)
                      Wr_DataLCD(str4[lp])             ;  //Print "<<==Select==>>" to LCD

                    Check_Sw()                         ;
                    break ;


          case 0x20: //SW.5(P3.5) = Play All Message
                               
                    Clear_L1()                       ;  //Clear Message On LCD Line1
                    Wr_CmmLCD(0x80|0x03)             ;  //Start address lcd = 0x04 Line 1       
                    for(lp=0;lp<11;lp++)
                     {
                       Wr_DataLCD(str2[lp])          ;  //Print "Play All =>" to LCD
                     }
              
                    add = 0                          ;
                    for(nm=1;nm<=35;nm++)
                     {
                       Conv_Ascii(nm)                ;  //Convert number message to ascii
                       Wr_CmmLCD(0x80|0x4B)          ;  //Start address lcd = 0x4B Line 2      
                       Wr_DataLCD(nh)                ;  //Plot number colum10 to lcd 
                       Wr_DataLCD(nl)                ;  //Plot number colum unit to lcd
                               
                       Set_Add(add)                  ;  //Set Address for Play 
                       Play_Back()                   ;  //Play Message

                       add = add+9                   ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message
            
                       while((Rd_Eom())&&(nm <36))     //Wait end 1 message EOM to '0' Exit loop
                        {
                         sw = Rd_Sw()                ;  //----SW.6(P3.6) = Stop Play Message----
                         if(sw == 0x40)
                          {
                           Stop_PR()                 ;  //Stop Play Message  
                           nm = 37                   ;  
                          }       
                        }						 
                       while(!Rd_Eom())  {;}         ;  //Wait EOM back to '1' for Play Next Message   
                     }

                   add = 0                           ;  //Clear Address  
                   nm  = 1                           ;  //Start Display Message1   
                      
                   Wr_CmmLCD(0x80|0x01)              ;  //Start address lcd = 0x01 Line 1
                   for(lp=0;lp<14;lp++)
                     Wr_DataLCD(str4[lp])            ;  //Print "<<==Select==>>" to L1
                  
                   Wr_CmmLCD(0x80|0x4B)              ;  //Start address lcd = 0x4B Line 2      
                   Wr_DataLCD(0x30)                  ;  //Plot number 0 to lcd 
                   Wr_DataLCD(0x31)                  ;  //Plot number 1 to lcd             
                     
                   Set_Add(0)                        ;  //Set Address 0 for Play 
                   Check_Sw()                        ;  

                   break ;
      
          case 0x80: //SW.7(P3.7) = Play one Message
                               
                    Clear_L1()                       ;  //Clear Message On LCD Line1
                    Wr_CmmLCD(0x80|0x04)             ;  //Start address lcd = 0x04 Line 1       
                    for(lp=0;lp<7;lp++)
                      Wr_DataLCD(str1[lp])           ;  //Print "Play =>" to LCD

                    Play_Back()                      ;  //Play Message

                    Wr_CmmLCD(0x80|0x0A)             ;  //Start address lcd = 0x0A Line 1     
                    Wr_CmmLCD(0x0D)                  ;  //LCD Blink 

                    while(Rd_Eom()){;}               ;  //Wait end 1 message
                								   
                    Wr_CmmLCD(0x0C)                  ;  //Stop LCD Blink 

                    Wr_CmmLCD(0x80|0x01)             ;  //Start address lcd = 0x01 Line 1
                     for(lp=0;lp<14;lp++)
                        Wr_DataLCD(str4[lp])         ;  //Print "<<==Select==>>" to LCD
            
                    Check_Sw()                       ;  

              break ;

     }  //switch 
   }
 }
