

/***********************************************************************************************
 *                                                                                             *
 *                Example 2. Tell Time Every 30 Minuit (Address Mode)                          *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *
 * Target MCU     : ATMEL AVR-MEGA128(ET-BASE AVR ATmega128 r3)                                *
 *       	      : X-TAL : 16 MHz                                                             * 
 *                                                                                             *
 * Editor         : AVR Studio 4.15 Build 623                                                  *
 * Compiler       : WinAVR-20081205                                                            *
 *                                                                                             *
 * Port Interface :                                                                            *
 *                                                                                             *
 *         SPI    :        # MCU-MEGA128 #           ET-Mini ISD2548                           *
 *                         --------------            ---------------                           *
 *                                                                                             *                                   
 *                          PC0            connect        DIN                                  *                
 *                          PC1            connect        SCK                                  *
 *                          PC2            connect        STB                                  *               
 *                          PC3(IN)        connect        EOM  (Must Pull Up)                  *               
 *                          GND            connect        ENA                                  *             
 *                          NO USE         connect        OVF                                  *
 *                                                                                             *
 *                                                                                             *
 *                                                                                             *
 *                       (Use Internal Pull up in AVR)                                         *
 *                                    5V                                                       *
 *                                  --+--                                                      *
 *                                    |                                                        *
 *                                    \                                                        *
 *                                    / 10K                                                    *
 *                                    \                                                        *
 *                                    /                                                        *
 *                                    |                                                        *
 *                                    |          ET-Mini ISD2548       5V                      *
 *                                    |      +-------------------+   --+--                     *
 *                                    |      |                   |     |                       *
 *                           PC0 -----|----->|DIN            +5V +-----+      /|               *
 *                           PC1 -----|----->|SCK                |          /  |               *
 *                           PC2 -----|----->|STR            SP+ +--------||   |               *
 *                           PC3 <----+------|EOM                |        || SP|               *
 *                                           |               SP- +--------||   |               *
 *                                           |                   |          \  |               *
 *                               +-----------|ENA            GND +-----+      \|               *
 *                             __|__         |                   |   __|__                     *
 *                              ---          |                   |    ---                      *
 *                               -        ---|VOF                |     -                       *
 *                                           |                   |                             *
 *                                           |                MIC|---                          *
 *                                           +-------------------+                             *
 *                                            Set Jp1 : to GND                                 *
 *                                                Jp2 : No use (Don't care)                    *
 *                                                                                             *
 *                                                                                             *
 *                                                                                             *
 *         LCD     :     # MCU-MEGA128 #                   # LCD 2x16 DISPLAY #                *
 *                       ---------------                   --------------------                *
 *                                                                                             *
 *                          PG4              Connect          RS(OUT)                          *
 *                          PD7              Connect          EN(OUT)                          *  
 *                          PG0-PG3          Connect          Data 4 bit High(Out)             *
 *                                                                                             * 
 *        5V                                                                                   *
 *      --+--                                                                                  *
 *        |                                                                                    *
 *        +-----------------+                                                                  *
 *        |                 |                                                                  *
 *       ---                |                                                                  *
 *       |\|                |                                                                  *
 *    VR |/|<---------------|--+                                                               *
 *   10K ---                |  |  PG4     PD7            PG0 PG1 PG2 PG3                       *
 *        |                 |  |   ^       ^              ^   ^   ^   ^                        *
 *        |                 |  |   |       |              |   |   |   |                        *
 *        +--------------+--|--|---|---+---|--+--+--+--+  |   |   |   |                        *
 *      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|                        *
 *                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_                       *
 *                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |                      *
 *                    |    _________________________________________    |                      *
 *                    |   |                                         |   |                      *
 *                    |   |               Module                    |   |                      *
 *                    |   |         LCD 2x16 Charecter              |   |                      *  
 *                    |   |_________________________________________|   |                      *
 *                    |                                                 |                      *
 *                    |_________________________________________________|                      *
 *                                                                                             *       
 *                                                                                             *
 *                                                                                             *
 *                                                                                             *     
 *                                                                                             *
 *   I2C RTC:DS3232: Interface I2C(ID:1101000X = 0xD0(Wr),0xD1(Rd) )                           * 
 *                                                                                             *
 *                 # MCU-MEGA128 #                       Mini-DS3232 Module                    *                                                                    *
 *                 ---------------                       ------------------                    *
 *                  PD0 (SCK-OUT)        Connect            SCL(CLOCK)                         *
 *                  PD1 (SDA-I/O)        Connect            SDA(DATA)                          *
 *                                                                                             *        
 *                                                                                             * 
 *                                                                                             *
 *                                 Module ET-ETMI DS3232                                       *
 *                                   -----------------                                         *
 *                                  |                 |                                        *
 *                    VCC --------->|+5V              |                                        *
 *                    PD0 --------->|SCL              |                                        *
 *                    PD1 --------->|SDA              |                                        *
 *                            Nc ---|SQW/INT#         |                                        *
 *                            Nc ---|32KHz            |                                        *
 *                            Nc ---|RST              |                                        *
 *                       +--------->|GND              |                                        *
 *                       |           -----------------                                         *
 *                       |       Set Jp SCL : ENA (Pull Up)                                    *
 *                       |           Jp SDA : ENA (Pull Up)                                    *                                                         
 *                     __|__                                                                   *
 *                      ---                                                                    *
 *                       -                                                                     *
 *                                                                                             *
 *                                                                                             *
 *  Before Operate  :    Use Example_1 for Record Message of Time by 1 Message Use 9 adress    *
 *                                                                                             *
 *                       Message 02 Record : Way-la     (Start Address 9 )                     *
 *                          "    03   "    : Na-ri-ka   (Start Address 18 )                    *
 *                          "    04   "    : Na-tee     (Start Address 27 )                    *
 *                          "    05   "    : Vi-na-tee  (Start Address 36 )                    * 
 *                          "    06   "    : 0          (Start Address 45 )                    * 
 *                          "    07   "    : 1          (Start Address 54 )                    *
 *                          "    08   "    : 2          (Start Address 63 )                    *
 *                          "    09   "    : 3          (Start Address 72 )                    *
 *                          "    10   "    : 4          (Start Address 81 )                    *
 *                          "    11   "    : 5          (Start Address 90 )                    *
 *                          "    12   "    : 6          (Start Address 99 )                    * 
 *                          "    13   "    : 7          (Start Address 108)                    *
 *                          "    14   "    : 8          (Start Address 117)                    *
 *                          "    15   "    : 9          (Start Address 126)                    *  
 *                          "    16   "    : 10         (Start Address 135)                    * 
 *                          "    17   "    : ed         (Start Address 144)                    *
 *                          "    18   "    : 20         (Start Address 153)                    * 
 *                       Message 19   "    : ka-na-nee  (Start Address 162)                    *
 *                                                                                             *                                                                       
 *                                                                                             *
 *                                                                                             *   
 * Last Update     : 12/Junly/2012                                                             *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/



#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay




char fag_mn,fag_hh    ;
int  ss,mn,hh,addr    ;
int  add_hh1,add_hh2  ;



/*****************************************
 **         Function Delay              **
 *****************************************/


 //------------ Delay us ------------

 void delay_us(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_us(1);
  }


//------------- Delay ms -------------

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }


/*****************************************
 **        Function Initial Port        **
 *****************************************/

 void Init_Port(void)
  {
   
   DDRC  = 0x07     ;        //Set PC0..PC2:Output For SPI Control ISD2548 ;PC3:Input
   DDRD  = 0xFF     ;        //Set PD(0..7) = output for Control LCD(PD7)  and I2C (PD0..PD1) 
   DDRG  = 0xFF     ;        //Set PG(0..7) = output for data LCD

   //--- Set default output Port ---
 
   PORTC = 0x08     ;        //PC3 = Input Pull Up
   PORTD = 0x00     ;
   PORTG = 0x00     ;

  }


 //************************************************************
 //**             Function  Convert BCD Time to Ascii        **         
 //************************************************************

 void conv_time(char sec,char min,char hour)
 {
  
   //---------- Convert Second(00-59) to ascii ---------
   ss = sec >> 4             ;
   ss = ss+0x30              ; //Secound byte High to ascii

   sec = sec & 0x0F          ;
   sec = sec+0x30            ; //Secound byte Low to ascii
   ss = (ss << 8)| sec       ; 

   //---------- Convert Minute(00-59) to ascii ---------

   mn = min >> 4             ;
   mn = mn+0x30              ;  //Minuted byte High to ascii

   min = min & 0x0F          ;
   min = min+0x30            ;  //Minuted byte Low to ascii
   mn = (mn << 8)| min       ; 

   //---------- Convert Hour(00-23) to ascii ---------

   hh = hour >> 4            ;  //Hour byte High to ascii
   hh = hh+0x30              ;

   hour = hour & 0x0F        ;
   hour = hour+0x30          ;  //Hour byte Low to ascii
   hh   = (hh << 8)| hour    ; 

 }

/*******************************************************
 **                                                   **
 **                   FUNCTION LCD                    **
 **                                                   **
 *******************************************************/ 


//-------------- Define LCD Control Pin ------------------

#define ENA_HI()     sbi(PORTD,7)    //PD7 = ENA:1
#define ENA_LO()     cbi(PORTD,7)    //PD7 = ENA:0



//------- write instruction LCD ------------


void Write_Cmm(unsigned char cmm)
{
  
  PORTG = (cmm>>4) & 0x0F    ;   //Sent cmm 4 bit High,RS:PG4 = 0 
  ENA_HI()                   ;    
  delay_us(250)              ;
  ENA_LO()                   ;    
  delay_us(250)              ;

  PORTG = cmm & 0x0F         ;   //Sent cmm 4 bit Low,RS:PG4 = 0
  ENA_HI()                   ;   
  delay_us(250)              ;
  ENA_LO()                   ;   
  delay_us(250)              ;
}


//--------- write data lcd ----------          

void Write_Data(unsigned char dat)
{
  
  PORTG = ((dat>>4) & 0x0F)|0x10  ;   //Sent data 4 bit High,RS:PG4 = 1 
  ENA_HI()                        ;    
  delay_us(250)                   ;
  ENA_LO()                        ;    
  delay_us(250)                   ;

  PORTG = (dat & 0x0F)|0x10       ;   //Sent data 4 bit Low,RS:PG4 = 1
  ENA_HI()                        ;   
  delay_us(250)                   ;
  ENA_LO()                        ;   
  delay_us(250)                   ;
}


//------------- Clear Display LCD -------------

void clr_display(void)
 {
  Write_Cmm(0x01) ;
 }



 //----------- Clear Line 1 LCD ------------      


void Clear_L1()
 {
  char k ;

   Write_Cmm(0x80|0x00)     ;  //Start address lcd = 0x4B Line 2
   for(k=0;k<16;k++)   
     Write_Data(0x20)       ;  //Plot Space to lcd 
 }



//----------- Initial lcd ------------  

void Init_Lcd(void)
{
  Write_Cmm(0x33);	        //Command Control 
  Write_Cmm(0x32);
  Write_Cmm(0x28);
  Write_Cmm(0x0C);  	    //Set Display On/Off:Display On,Not Show Cursor and not blink Cursor
  Write_Cmm(0x06);  	    //Set Entry Mode :Increment Address,Cursor Shift Right
    
  Write_Cmm(0x1C);          //Set Cursor Or Display Shift : Shift Right Charecter
  Write_Cmm(0x28);      	//Function Set: set interface data 4bit,Set Display LCD 2 Line ,Set Charecter Size 5x7
  Write_Cmm(0x80|0x00);		//Set Address Begin 0x00 (Line1 Charecter1)
  clr_display();
}





/****************************************************************
 **                Function SPI Sent Data 12 Bit               **                                                  
 ****************************************************************                                          
 **   PC0 = SDO                                                **
 **   PC1 = SCK                                                **
 **   PC2 = STROB                                              **
 **                                                            **
 ****************************************************************/

 //--------------- Define Pin Control SPI -----------------

//--------------- SDO-High(Data-Out) ---------------

#define     Sdo_Hi()          sbi(PORTC,0)            //PC0= SDO:1
                          
//--------------- SDO-Low(Data-OUT) ----------------

#define     Sdo_Lo()         cbi(PORTC,0)            //PC0= SDO:0


//--------------- Sck-High(Clock) ---------------

#define     Sck_Hi()          sbi(PORTC,1)            //PC1= SCK:1
                          
//--------------- Sck-Low(Clock) ----------------

#define     Sck_Lo()         cbi(PORTC,1)            //PC1= SCK:0

//--------------- STR-High(Strob) ---------------

#define     Str_Hi()          sbi(PORTC,2)            //PC2= Str:1
                          
//--------------- STR-Low(Strob) ----------------

#define     Str_Lo()          cbi(PORTC,2)            //PC2= Str:0




//----------------- Write Data to ISD2548 12-bit -------------------

void Spi_Wr(unsigned int DWord)			  	
 {
    unsigned int Bit ;				 	   

     Str_Lo()                             ;  //Start Strob 595 to Low

     for(Bit=0;Bit<12;Bit++)                 //Loop write data 12 Bit
      {		
	   	Sck_Lo()                          ;	 //Start 595 Clock  Low

		//--------- write Data(PC0) ---------

		if((DWord & 0x800)== 0x800)
		    Sdo_Hi()                     ;   //Set bit data(PC0) = 1
		else 
		    Sdo_Lo()                     ;	 //Clear bit data(PC0) = 0
		   	 
		
		Sck_Hi()                         ;   //Set 595 Clock High for Shift data bit

		DWord <<= 1                      ;	 //Shift Next Bit Data        
	
	  }

    Str_Hi()                             ;   //Set Strob 595 to High for Out data parallel 


  }



/***************************************************************
 **                   FUNCTION ISD2548                        **
 ***************************************************************
 **  - Memory = 320 Address                                   **
 **  - Time Record Max = 48 secound                           **
 **  - 1 Address   = Time Record 0.15 secound                 **
 **                                                           **
 ***************************************************************/


//-------- Define Data Control ISD2548 ------------

#define PL_CHi            0xA00      //CE,P/R=1;PD=0
#define PL_CLo            0x200      //P/R=1;CE,PD=0
#define REC_CHi           0x800      //CE=1;PD,P/R=0
#define REC_CLo           0x000      //CE,PD,P/R =0
#define STOP              0xE00      //CE,PD,P/R = 1 


//---------------- Read Status EOM : End OF Message ---------------- 

char Rd_Eom()
{
  char eom                 ;
       
  eom  = PINC              ; //Read PC3 : 0 = end of message , Nomal = 1   
  eom  = eom & 0x08        ;
  return eom               ;  
}



//------------------- Check Status EOM -----------------
void Chk_Eom()
 {
  while(Rd_Eom()){;}   // Check Signal EOM to 0 : EOF = 0 :Exit Loop(for End message) 
  while(!Rd_Eom()){;}  // Check Signal EOM to 1 : EOF = 1 :Exit Loop (for Ready Begine Play   Next Message)
 }


//------------ Set Address for Play or Record(Addtess 0-320) ------------

void Set_Add(int add)
 { 

   addr = add & 0x1FF   ;  //Mark data Bit9-11 for write  Pin P/R,PD,CE 
   Spi_Wr(addr|STOP)	;  //Write Pin Address A0-A8 and Pin Contr0l To ISD2548  

 }



//-------------------- Play 1 Message ---------------------

void Play_Back()
 {

   addr = addr &0x01FF  ;  //Mark data Control Bit9-11 Pin P/R,PD,CE for  Play
   Spi_Wr(addr|PL_CLo)	;  //Write Pin Address A0-A8 and Pin Control for Play To ISD2548(Pin CE =0) 

   addr = addr &0x01FF  ;
   Spi_Wr(addr|PL_CHi)	;  //Write Pin CE = 1

 }

 

//----------------- Initial ISD2548 ---------------

 void Init_ISD2548()
  {

    Spi_Wr(STOP)	;     
    
  }





//*******************************************************************
//**                       Function PLAY MESSAGE Time              **
//*******************************************************************

void Msg_Time()
 {
     //--------------- Play Message --------------

      Set_Add(162)                       ;  //Set Address for Play " ka-Na-Nee "
      Play_Back()                        ;  //Play Message            
      Chk_Eom()                          ;

      Set_Add(9)                         ;  //Set Address for Play " Way-La"
      Play_Back()                        ;  //Play Message            
      Chk_Eom();


     
    //**************** Play Time Hour every half hour *******************


     if(fag_hh==1)                          //Check Fag_Hour =1 for Play 2 Message
     {          
       Set_Add(add_hh1)                  ;  //Set Address for Play Number Colum 1 (10,20)
       Play_Back()                       ;  //Play Message            
       Chk_Eom()                         ;
      
       Set_Add(add_hh2)                  ;  //Set Address for Play Number Colum 2 (1-9)
       Play_Back()                       ;  //Play Message            
       Chk_Eom();
     }
    else                                    //Fag_Hour =0 for Play 1 Message
     {
       Set_Add(add_hh1)                  ;  //Set Address for Play Number (1-9)
       Play_Back()                       ;  //Play Message            
       Chk_Eom();

     }

    //-------------- Play Message ----------------
      Set_Add(18)                        ;  //Set Address for Play " Narika "
      Play_Back()                        ;  //Play Message            
      Chk_Eom();
 


    //**************** Play Time Minute at 0,30  Minute *******************
   
    if(fag_mn==1)                          //Check Fag_minute=1 for Play 2 Message
     {          
       Set_Add(72)                      ;  //Set Address for Play "3" 
       Play_Back()                      ;  //Play Message            
       Chk_Eom();
      
       Set_Add(135)                     ;  //Set Address for Play "10" 
       Play_Back()                      ;  //Play Message            
       Chk_Eom();
     }
   else                                    //Check Fag_minute for Play 1 Message
     {
       Set_Add(45)                      ;  //Set Address for Play "0" 
       Play_Back()                      ;  //Play Message            
       Chk_Eom();

     }
     
   //-------------- Play Message ----------------
      Set_Add(27)                       ;  //Set Address for Play " Na-Tee "
      Play_Back()                       ;  //Play Message            
      Chk_Eom()                         ;
 


   //*************** Play Time Secound at 0 Secound *******************
             
      Set_Add(45)                       ;  //Set Address for Play "0" 
      Play_Back()                       ;  //Play Message            
      Chk_Eom()                         ;
    
   //-------------- Play Message ----------------
      Set_Add(36)                      ;  //Set Address for Play " Vi-Na-Tee "
      Play_Back()                      ;  //Play Message            
      Chk_Eom()                        ;

 
 }




 /**************************************************************
  **                                                          **
  **           FUNCTION I2C RTC DS3232                        **
  **          ID:1101000X = 0xD0(Wr),0xD1(Rd)                 **
  **                                                          **
  **************************************************************/

//--------------- Define I2C Control Pin ------------------


#define SCL_HI()     sbi(PORTD,0)     //PD0=SCK:1
#define SCL_LO()     cbi(PORTD,0)     //    SCK:0

#define SDA_HI()     sbi(PORTD,1)     //PD1=SDA:1
#define SDA_LO()     cbi(PORTD,1)     //    SDA:0

#define SDA_IN()     cbi(DDRD,1)      //Set PD1 = SDA: Input
#define SDA_OUT()    sbi(DDRD,1)      //Set PD1 = SDA: Output
 
#define SDA          PIND             //Referent PIND = SDA


//----------------- I2C Start ------------------

void I2C_Start(void)
{ 
   SDA_OUT()              ;  //Set PD1 = output  
 
   SDA_HI()               ;   
   SCL_HI()               ;
   SDA_LO()               ;    
   SCL_LO()               ;
}


//----------------I2C Stop -----------------              

void I2C_Stop(void)
{

   SDA_OUT()             ;  //Set PD1=Output      
  
   SDA_LO()              ;  
   SCL_HI()              ;     
   SDA_HI()              ;
   
}

 //-----------------------------------------------------------------
 //--                      I2C Write  Data 8 bit                  --
 //----------------------------------------------------------------- 
 //--       Parameter :                                           --                
 //--                   dat = Data for write 1Byte                --           
 //-----------------------------------------------------------------


void I2C_WrByte(unsigned char dat)              
{
   unsigned char loop ;      


   for(loop=0;loop<8;loop++)                 //Loop Write data 8 Bit 
    {                   
      //--------- write Data(SDA:RA0) ---------

      SDA_OUT()                          ;   //Set PD1=SDA= Output  

      if((dat & 0x80)== 0x80)                //Check data bit8 is 0 or 1
       {
          SDA_HI()                       ;   //Sent '1' Out Pin SDA(PD1)
       }
      else
       {
          SDA_LO()                       ;   //Sent '0' Out Pin SDA(PD1)
       }
      
      dat = dat <<1                      ;   //Shift data Next Bit

      SCL_HI()                           ;   //Clock HI       
      SCL_LO()                           ;   //Clock LO       
    } 
          
    SDA_IN()                             ;   //Set PD1=Input 

    SCL_HI()                             ;   //Start ACK Clock
    while(SDA & 0x02){;}                     //Check ACK:PD1 = 0 Out Loop
    SCL_LO()                             ;   //End ACK Clock
       
}


 //----------------------------------------------------------------------
 //--                   Function Write RTC DS3232                      --
 //----------------------------------------------------------------------
 //--  Parameter :                                                     --
 //--              addr = Register Address for write(1Byte)            --
 //--              dat  = Data for Set up DS3232(1Byte)                --    
 //----------------------------------------------------------------------
 
void I2C_WrRTC (unsigned char addr,unsigned char dat)
{ 
  
   I2C_Start()            ;

//---------- Sent Slave address for Write ---------------

   I2C_WrByte(0xD0)       ;   //Send ID Code DS3232+Write (1101 000+0)

//------------ Sent address Register --------------
 
   I2C_WrByte(addr)       ;   //Send Address Reg. to DS3232

//------------- Sent data to RTC ---------------

   I2C_WrByte(dat)        ;   //Send Data Control to DS3232
  
   I2C_Stop()             ;
 
}
 
 
 //------------------------------------------------------------------
 //--                 Function I2C Read  Data 8 bit                --
 //------------------------------------------------------------------

 signed char I2C_RdByte(void)              
 { 
   signed char loop,result=0       ;      

   for(loop = 0; loop < 8; loop++)      //Loop Read data 8-Bit
    {
      result = result << 1         ;   //Shift Result Save (MSB <- LSB)
    
      SDA_IN()                     ;      
      SCL_HI()                     ;   //Strobe Read SDA
             
      if((SDA & 0x02) == 0x02)         //Check Data Read Pin SDA(PD1) is '0' or '1'
	    result |= 0x01             ;   //If Read Pin SDA is '1' Give Save Bit Data = 1



      SCL_LO()                     ;   //Next Bit Read

    }
    
  return result                    ;

}


 //------------------------------------------------------------
 //--              Function Read RTC(DS3232) 1 Byte          --
 //-- Parameter :                                            --
 //--              addr = Register Address for Read          --
 //------------------------------------------------------------
 
 signed char I2C_RdRTC(unsigned char addr)
  {
    signed char dat  ;
   
 //-------------- Sent Status Start for write -----------

   I2C_Start()             ;

//------------- Sent Slave Address for Write------------   
    
   I2C_WrByte(0xD0)        ;                //Send ID Code DS3232,Write (1101 000+0)

//------------ Sent address Register --------------

   I2C_WrByte(addr)        ;               //Send Address Reg. to DS3232
 
//---------- New Sent Status Start For Read ----------

   I2C_Start()             ;

//-------------Sent Slave address for Read ------------

  I2C_WrByte(0xD1)         ;               //Send ID Code DS3232 ,Write (1101 000+1)

//------------- Read data 1 Byte ------------
   
   dat = I2C_RdByte()      ;               
  
  

//---------- Sent Status Stop Red ---------------
   I2C_Stop()              ; 
 
   return dat              ;               //Return Data
  }





/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
int main(void) 
{  
   unsigned char  lp,sec,min,hor,hs1,hs2         ;
 
   unsigned char str0[14]  = {"Time:12:00:00"}   ;

   
   Init_Port()       ;
   Init_ISD2548()    ; 
   Init_Lcd()        ;


 
//------------ write string to lcd ----------------
  
  //----------- String mode Time ----------

  Write_Cmm(0x80|0x00)            ;  //Start address lcd = 0x01 Line 1
  for(lp=0;lp<13;lp++)
    Write_Data(str0[lp])          ;  //Print "Time:12:00:00" to LCD
 
//--------- Set Time Secound:Minute:Hour to DS3232-------------

   I2C_WrRTC(0x00,0x55)    ;  //Write Second
   I2C_WrRTC(0x01,0x29)    ;  //Write minute
   I2C_WrRTC(0x02,0x11)    ;  //Write Hour
 
 
  while(1)
   {
     //------------ Read Time ss:mm:hh from ds3232 --------------

    sec  = I2C_RdRTC(0x00)          ;  //Read Second
    min  = I2C_RdRTC(0x01)          ;  //Read minute
    hor  = I2C_RdRTC(0x02)          ;  //Read Hour  24 Hour
    conv_time(sec,min,hor)          ;  //Convert sec:min:hor to ascii


//------------ Write Data hh:mm:ss to LCD -------------

    Write_Cmm(0x80|0x05)    ;  //Start address lcd = 0x05
    Write_Data(hh>>8)       ;
    Write_Data(hh)          ;
   
    Write_Cmm(0x80|0x08)    ;  //Start address lcd = 0x08
    Write_Data(mn>>8)       ;
    Write_Data(mn)          ;

    Write_Cmm(0x80|0x0B)    ;  //Start address lcd = 0x0B
    Write_Data(ss>>8)       ;
    Write_Data(ss)          ;


    hs1 = hh>>8             ;  // Keep Hour Ascii Byte High
    hs2 = hh                ;  // Keep Hour Ascii Byte Low


   //------------- Check at 0-minute , 0-Secound For Play Message  -----------------

   if((min == 0x00) && (sec == 0x00))
    {
      fag_mn = 0                             ;    //Set fag for play Number minute 1 Message (0 minute)          


      if((hs1==0x30)||((hs1==0x31)&&(hs2==0x30))||((hs1==0x32)&&(hs2==0x30)))  //Check Hour 00-09,10,20 Narika for play 1 message
       {
         fag_hh = 0                          ;    //Set fag_Hour = 0 for play number 1 message(0-9,10,20)
       
         if(hs1 == 0x30)                          //Check 00-09 Narika for Set Address Message 0-9
          {
            add_hh1 = ((hs2-0x30)*9)+45      ;   //Calculate address Message for play By 45 = Address start for Message "0" and 9 = 1 message   use 9 Address
          }
         else                                    // check 10,20 Narika for Set Address Message 10,20
          {
            if(hs1 == 0x31)                      //Set Postion Address Message "10" = (16x9)-9  :16= order message
              add_hh1 = 135                  ;
            else
              add_hh1 = 153                  ;   //Set Postion Address Message "20"    =(18x9)-9
          }
       }
      else                                       //Check Hour 11-19,21-23 Narika for Play 2 Message
       {
         fag_hh = 1                          ;   //Set fag_Hour=1 for play number 2 message(11-19,21,23)

        //-----------Set Position Message 1 -----------------

         if(hs1 == 0x31)                         //Set Position Address Message "10"
           add_hh1 = 135                     ;
         else
           add_hh1 = 153                     ;   //Set Position Address Message "20"
   
   
         //-----------Set Position Message 2 -----------------
        
         if(hs2 == 0x31)                         //if hs2='1' 
           hs2 = hs2+10                      ;   //give hs2 = hs2+ 0x0A for order Message 'ed'
   
         add_hh2 = ((hs2-0x30)*9)+45         ;   //Calculate address Message for play

       }

      Msg_Time()                             ;   //Play Time Message    at xx:00:00

     }   //if check 0 Minute



   //------------- Check at 30-minute, 0-Secound For Play Message  -----------------

   if((min == 0x30)&&(sec == 0x00))                    
    {
      fag_mn = 1                            ;             //Set fag for play Number minute 2 Message (3,10 minute)
  

      if((hs1==0x30)||((hs1==0x31)&&(hs2==0x30))||((hs1==0x32)&&(hs2==0x30)))  //Check Hour 00-09,10,20 Narika for play 1 message
       {
         fag_hh = 0                         ;            //Set fag_Hour = 0 for play number 1 message(0-9,10,20)
       
         if(hs1 == 0x30)                                 //Check 00-09 Narika for Set Address Message 0-9
           {
            add_hh1 = ((hs2-0x30)*9)+45     ;            //Calculate address Message for play By 45 = Address start for Message "0" and 9 = 1 message   use 9 Address
           }
         else                                            //check 10,20 Narika for Set Address Message 10,20
           {
             if(hs1 == 0x31)                            
                add_hh1 = 135               ;            //Set Position Address Message "10"
             else
                add_hh1 = 153               ;            //Set Position Address Message "20"
           }
       }
      else                                               //Check Hour 11-19,21-23 Narika for Play 2 Message
       {
         fag_hh = 1                         ;            //Set fag_Hour=1 for play number 2 message(11-19,21,23)

         //-----------Set Position Message 1 -----------------

         if(hs1 == 0x31)        
           add_hh1 = 135                    ;            //Set Position Address Message "10"
         else
           add_hh1 = 153                    ;            //Set Position Address Message "20"
       
         //-----------Set Position Message 2 -----------------
      
         if(hs2 == 0x31)                                // if hs2='1' 
           hs2 = hs2+10                     ;           // give hs2 = hs2+ 0x0A for order Message 'ed'
         
       
         add_hh2 = ((hs2-0x30)*9)+45        ;           //Calculate address Message for play
 
       }
      Msg_Time()                            ;           //Play Time Message    at xx:30:00
    } // if Check 30 Minute
    
    
   } //while
   
}    //end
