

/***********************************************************************************************
 *                                                                                             *
 *             Example_1. Control ISD2548 Record(MIC) & Play Back (Address Mode)               *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *
 * Target MCU     : ATMEL AVR-MEGA128 (ET-BASE AVR ATmega128 r3)                               *
 *       	      : X-TAL : 16 MHz                                                             * 
 *                                                                                             *
 * Editor         : AVR Studio 4.15 Build 623                                                  *
 * Compiler       : WinAVR-20081205                                                            *
 *                                                                                             *
 * Port Interface :                                                                            *
 *                                                                                             *
 *         SPI    :        # MCU-MEGA128 #           ET-Mini ISD2548                           *
 *                         --------------            ---------------                           *
 *                                                                                             *                                   
 *                          PC0            connect        DIN                                  *                
 *                          PC1            connect        SCK                                  *
 *                          PC2            connect        STB                                  *               
 *                          PC3(IN)        connect        EOM (Must Pull up)                   *               
 *                          GND            connect        ENA                                  *             
 *                          NO USE         connect        OVF                                  *            
 *                                                                                             *
 *                                                                                             *
 *                                                                                             *
 *                       (Use Internal Pull up in AVR)                                         *
 *                                    5V                                                       *
 *                                  --+--                                                      *
 *                                    |                                                        *
 *                                    \                                                        *
 *                                    / 10K                                                    *
 *                                    \        ET-Mini ISD2548         5V                      *
 *                                    /      +-------------------+   --+--                     *
 *                                    |      |                   |     |                       *
 *                           PC0 -----|----->|DIN            +5V +-----+      /|               *
 *                           PC1 -----|----->|SCK                |          /  |               *
 *                           PC2 -----|----->|STR            SP+ +--------||   |               *
 *                           PC3 <----+------|EOM                |        || SP|               *
 *                                           |               SP- +--------||   |               *
 *                                           |                   |          \  |               *
 *                               +-----------|ENA            GND +-----+      \|               *
 *                             __|__         |                   |   __|__                     *
 *                              ---          |                   |    ---                      *
 *                               -        ---|VOF                |     -                       *
 *                                           |                   |       _ --                  *
 *                                           |               MIC+|------| |                    *
 *                                           |                  -|------|_|                    *
 *                                           +-------------------+         --                  *
 *                                                                                             *
 *                                            Set Jp1 : to GND                                 *
 *                                                Jp2 : to MIC or ANA IN                       *
 *                                                                                             *
 *                                                                                             *
 *         LCD     :     # MCU-MEGA128 #                   # LCD 2x16 DISPLAY #                *
 *                       ---------------                   --------------------                *
 *                                                                                             *
 *                          PG4              Connect          RS(OUT)                          *
 *                          PD7              Connect          EN(OUT)                          *  
 *                          PG0-PG3          Connect          Data 4 bit High(Out)             *
 *                                                                                             * 
 *        5V                                                                                   *
 *      --+--                                                                                  *
 *        |                                                                                    *
 *        +-----------------+                                                                  *
 *        |                 |                                                                  *
 *       ---                |                                                                  *
 *       |\|                |                                                                  *
 *    VR |/|<---------------|--+                                                               *
 *   10K ---                |  |  PG4     PD7            PG0 PG1 PG2 PG3                       *
 *        |                 |  |   ^       ^              ^   ^   ^   ^                        *
 *        |                 |  |   |       |              |   |   |   |                        *
 *        +--------------+--|--|---|---+---|--+--+--+--+  |   |   |   |                        *
 *      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |                        *
 *        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|                        *
 *                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_                       *
 *                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |                      *
 *                    |    _________________________________________    |                      *
 *                    |   |                                         |   |                      *
 *                    |   |               Module                    |   |                      *
 *                    |   |         LCD 2x16 Charecter              |   |                      *  
 *                    |   |_________________________________________|   |                      *
 *                    |                                                 |                      *
 *                    |_________________________________________________|                      *
 *                                                                                             *       
 *                                                                                             *
 *                                                                                             *
 *                                                                                             *
 *      SWITCH    :   # MCU-MEGA128 #               # SW. for User COntrol Play& Record#       *
 *                    ------------------             -----------------------------------       * 
 *                       PE0,PE1           Not use        Pull-Up 5V                           *
 *                       PE2(IN)          connect         SW. Select Message UP+               *
 *                       PE3(IN)          connect         SW. Select Message Down-             *
 *                       PE4(IN)          connect         SW. Record Message                   *
 *                       PE5(IN)          connect         SW. Play Message All                 *
 *                       PE6(IN)          connect         SW. STOP Play Message All            *
 *                       PE7(IN)          connect         SW. Play 1 Message at Select         *
 *                                                                                             *
 *                     5V                                                                      *
 *                   --+--                                                                     *
 *                     |                                                                       *
 *                     +-------+-------+-------+-------+-------+                               *  
 *                     |       |       |       |       |       |                               *
 *                     /       /       /       /       /       /                               *
 *                     \       \       \       \       \       \                               *
 *                     /10K    /10K    /10K    /10K    /10K    /10K                            *
 *                     \       \       \       \       \       \                               *
 *      (Selec.Msg.+)  |       |       |       |       |       |                               *
 *         PE2 <-------+       |       |       |       |       |                               *
 *      (Selec.Msg.-)  |       |       |       |       |       |                               *
 *         PE3 <---------------+       |       |       |       |                               *
 *      (Record)       |       |       |       |       |       |                               *
 *         PE4 <-----------------------+       |       |       |                               *
 *      (Play All)     |       |       |       |       |       |                               *
 *         PE5 <-------------------------------+       |       |                               *
 *      (Stop Play All)|       |       |       |       |       |                               *
 *         PE6 <---------------------------------------+       |                               *
 *      (Play Back)    |       |       |       |       |       |                               *
 *         PE7 <---------------------------------------|-------+                               *
 *                     |       |       |       |       |       |                               *
 *                     |       |       |       |       |       |                               *
 *                SW.2\   SW.3\   SW.4\   sw.5\   sw.6\   SW7 \                                *
 *                     |       |       |       |       |       |                               *
 *                   __|__   __|__   __|__   __|__   __|__   __|__                             *
 *                    ---     ---     ---     ---     ---     ---                              *
 *                     -       -       -       -       -       -                               *
 *                                                                                             *
 *                                                                                             *
 *                                                                                             *
 * Poperity Message : 1 address = record sound 0.15 sec.   When                                *
 *                    ISD2548 Record Full 48 sec. and have Address 320 Address. Thus           *
 *                    This Example Give 1 Message long 1.2 sec.Only Thus ISD2548 Record        *
 *                    Full 35 Message by :                                                     *
 *                                     1 message = 1.2/0.15 = 8 Address                        *
 *                                     Add EOM signal 1 address                                *
 *                    Thus ,           1 Message = 9 Address                                   * 
 *                    ISD2548 1 Chip record =   320/9 = 35 message                             *
 *                                                                                             *
 *                                                                                             *
 * Last Update     : 12/Junly/2012                                                             *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/




#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay


int nh,nl,addr   ;

/*****************************************
 **         Function Delay us           **
 *****************************************/

 void delay_us(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_us(1);
  }


/*****************************************
 **         Function Delay ms           **
 *****************************************/

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }


/*****************************************
 **        Function Initial Port        **
 *****************************************/

 void Init_Port(void)
  {
   
   DDRC  = 0x07     ;        //Set PC0..PC2:Output For SPI Control ISD2548 ;PC3=Input
     
   DDRE  = 0x00     ;        //Set PE(0..7) = Input for Switch  
    
   DDRD  = 0xFF     ;        //Set PD(0..7) = output for Control LCD
   DDRG  = 0xFF     ;        //Set PG(0..7) = output for data LCD


 //--- Set default output Port ----
 
   PORTC = 0x08     ;        //PC3 = Input Pull Up
   PORTD = 0x00     ;
   PORTG = 0x00     ;

  }



/*******************************************************
 **                                                   **
 **                    FUNCTION LCD                   **
 **                                                   **
 *******************************************************/ 


//-------------- Define LCD Control Pin ------------------

#define ENA_HI()     sbi(PORTD,7)    //PD7 = ENA:1
#define ENA_LO()     cbi(PORTD,7)    //PD7 = ENA:0




//------------------ write instruction LCD -------------------

void Write_Cmm(unsigned char cmm)
{
  
  PORTG = (cmm>>4) & 0x0F    ;   //Sent cmm 4 bit High,RS:PG4 = 0 
  ENA_HI()                   ;    
  delay_us(250)              ;
  ENA_LO()                   ;    
  delay_us(250)              ;

  PORTG = cmm & 0x0F         ;   //Sent cmm 4 bit Low,RS:PG4 = 0
  ENA_HI()                   ;   
  delay_us(250)              ;
  ENA_LO()                   ;   
  delay_us(250)              ;
}




 //------------ write data lcd --------------


void Write_Data(unsigned char dat)
{
  
  PORTG = ((dat>>4) & 0x0F)|0x10  ;   //Sent data 4 bit High,RS:PG4 = 1 
  ENA_HI()                        ;    
  delay_us(250)                   ;
  ENA_LO()                        ;    
  delay_us(250)                   ;

  PORTG = (dat & 0x0F)|0x10       ;   //Sent data 4 bit Low,RS:PG4 = 1
  ENA_HI()                        ;   
  delay_us(250)                   ;
  ENA_LO()                        ;   
  delay_us(250)                   ;
}


 //----------- Clear Display LCD ------------    


void clr_display(void)
 {
  Write_Cmm(0x01) ;
 }


 //------------ Clear Line 1 LCD -------------          

void Clear_L1()
 {
  char k ;

   Write_Cmm(0x80|0x00)     ;  //Start address lcd = 0x4B Line 2
   for(k=0;k<16;k++)   
     Write_Data(0x20)       ;  //Plot Space to lcd 
 }



 //------------- initial lcd ---------------

void Init_Lcd(void)
{
  Write_Cmm(0x33);	        //Command Control 
  Write_Cmm(0x32);
  Write_Cmm(0x28);
  Write_Cmm(0x0C);  	    //Set Display On/Off:Display On,Not Show Cursor and not blink Cursor
  Write_Cmm(0x06);  	    //Set Entry Mode :Increment Address,Cursor Shift Right
    
  Write_Cmm(0x1C);          //Set Cursor Or Display Shift : Shift Right Charecter
  Write_Cmm(0x28);      	//Function Set: set interface data 4bit,Set Display LCD 2 Line ,Set Charecter Size 5x7
  Write_Cmm(0x80|0x00);		//Set Address Begin 0x00 (Line1 Charecter1)
  clr_display();
}


//--------------- Convert Ascii -----------------


void Conv_Ascii(int num)
 {
   nh = (num/10)+0x30  ;
   nl = (num%10)+0x30  ;
   
 }




/***************************************************************
 **                Function SPI Seny data 12 bit              **
 ***************************************************************
 **          PC0 = SDO                                        **
 **          PC1 = SCK                                        **
 **          PC2 = STROB                                      **   
 **                                                           **
 ***************************************************************/

//--------------- Define Pin -----------------------


//--------------- SDO-High(Data-Out) ---------------

#define     Sdo_Hi()          sbi(PORTC,0)            //PC0= SDO:1
                          
//--------------- SDO-Low(Data-OUT) ----------------

#define     Sdo_Lo()         cbi(PORTC,0)            //PC0= SDO:0



//--------------- Sck-High(Clock) ---------------

#define     Sck_Hi()          sbi(PORTC,1)            //PC1= SCK:1
                          
//--------------- Sck-Low(Clock) ----------------

#define     Sck_Lo()         cbi(PORTC,1)            //PC1= SCK:0



//--------------- STR-High(Strob) ---------------

#define     Str_Hi()          sbi(PORTC,2)            //PC2= Str:1
                          
//--------------- STR-Low(Strob) ----------------

#define     Str_Lo()          cbi(PORTC,2)            //PC2= Str:0



//----------------- Write Data to ISD2548 12-bit -------------------

void Spi_Wr(unsigned int DWord)			  	
 {
    unsigned int Bit ;				 	   

     Str_Lo()                             ;  //Start Strob 595 to Low

     for(Bit=0;Bit<12;Bit++)                 //Loop write data 12 Bit
      {		
	   	Sck_Lo()                          ;	 //Start 595 Clock  Low

		//--------- write Data(PC0) ---------

		if((DWord & 0x800)== 0x800)
		    Sdo_Hi()                     ;   //Set bit data(PC0) = 1
		else 
		    Sdo_Lo()                     ;	 //Clear bit data(PC0) = 0
		   	 
		
		Sck_Hi()                         ;   //Set 595 Clock High for Shift data bit

		DWord <<= 1                      ;	 //Shift Next Bit Data        
	
	  }

    Str_Hi()                             ;   //Set Strob 595 to High for Out data parallel 


  }



/***************************************************************
 **                   FUNCTION ISD2548                        **
 ***************************************************************
 **  - Memory = 320 Address                                   **
 **  - Time Record Max = 48 secound                           **
 **  - 1 Address   = Time Record 0.15 secound                 **
 **                                                           **
 ***************************************************************/


//-------- Define Data Control ISD2548 ------------

#define PL_CHi            0xA00      //CE,P/R=1;PD=0
#define PL_CLo            0x200      //P/R=1;CE,PD=0
#define REC_CHi           0x800      //CE=1;PD,P/R=0
#define REC_CLo           0x000      //CE,PD,P/R =0
#define STOP              0xE00      //CE,PD,P/R = 1 


//---------------- Read Status EOM : End OF Message ---------------- 

char Rd_Eom()
{
  char eom                 ;
       
  eom  = PINC              ; //Read PC3 : 0 = end of message , Nomal = 1   
  eom  = eom & 0x08        ;
  return eom               ;  
}


//------------ Set Address for Play or Record(Addtess 0-320) ------------

void Set_Add(int add)
 { 

   addr = add & 0x1FF   ;  //Mark data Bit9-11 for write  Pin P/R,PD,CE 
   Spi_Wr(addr|STOP)	;  //Write Pin Address A0-A8 and Pin Contr0l To ISD2548  

 }



//-------------------- Play 1 Message ---------------------

void Play_Back()
 {

   addr = addr &0x01FF  ;  //Mark data Control Bit9-11 Pin P/R,PD,CE for  Play
   Spi_Wr(addr|PL_CLo)	;  //Write Pin Address A0-A8 and Pin Control for Play To ISD2548(Pin CE =0) 

   addr = addr &0x01FF  ;
   Spi_Wr(addr|PL_CHi)	;  //Write Pin CE = 1

 }

 
//---------------- Record Message -------------------

void Record()
 {
   addr = addr&0x01FF   ;  //Mark data Control Bit9-11 Pin P/R,PD,CE  for Record 
   Spi_Wr(addr|REC_CHi)	;  //Write Pin Address A0-A8 and Pin Control P/R,PD=0 and CE=1 for Record 

   addr = addr&0x01FF   ;
   Spi_Wr(addr|REC_CLo)	;  //Write Pin CE =0 Start Recode

 }
 
//----------------Stop Play&Record Message -------------------

void Stop_PR()
 {   
   addr = addr&0x01FF   ; 
   Spi_Wr(addr|STOP)	;   //Write data for Stop Record by Pin Control P/R,PD,CE=1 

 }


//----------------- Initial ISD2548 ---------------

 void Init_ISD2548()
  {

    Spi_Wr(STOP)	;     
    
  }


//-------------- Check press SW.2-SW.7 -----------

void Check_Sw()
 {
   while((PINE&0xFC) != 0xFC){;}   //Check SW. PE[2..7] Release All 
   delay_ms(50)            ;
 }

//---------------- Read SW.2-SW.7 ( PE[2..7])-----------------

char Rd_Sw()
 {
  char sw                  ;

   sw = PINE               ;  //Read press SW. PE[2..7]
   sw = (~sw) & 0xFC       ;  //Mark PE[2..7] and invert data (Normal Value Not press SW. is logic 1)

   return sw               ;

 }



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
 {
   unsigned char sw,lp                            ;
   unsigned int  nm=1                             ;
   signed int    add = 0                          ;
   unsigned char str0[11]  = {"Message:01"}       ;
   unsigned char str1[8]   = {"Play =>"}          ;
   unsigned char str2[12]  = {"Play ALL =>"}      ;
   unsigned char str3[10]  = {"Rec [(0)]"}        ;
   unsigned char str4[15]  = {"<<==Select==>>"}   ;

   Init_Port()       ;
   Init_ISD2548()    ; 
   Init_Lcd()        ;


 //--------------  Start  --------------

  Write_Cmm(0x80|0x01)            ;  //Start address lcd = 0x01 Line 1
  for(lp=0;lp<14;lp++)
    Write_Data(str4[lp])          ;  //Print "<<==Select==>>" to LCD
 

  Write_Cmm(0x80|0x43)            ;  //Start address lcd = 0x43 Line 2
  for(lp=0;lp<10;lp++)
    Write_Data(str0[lp])          ;  //Print "Message:01" to LCD

  Set_Add(0)                      ;  //Set Address begin for Play or Record

  while(1)
   { 
     sw = Rd_Sw() ; 

     switch(sw)
      {
                     
        case 0x04 :  //SW.2(PE2) = Select Increment order Message ++
                        
                   nm = nm+1               ;  //Counter Message for show LCD             
                   if(nm>35)                  //check number message not exceed 35 message              #####--1. Line For Edit--#####
                     nm = 1                ;

                   Conv_Ascii(nm)          ;  //Convert number message to ascii
                   Write_Cmm(0x80|0x4B)    ;  //Start address lcd = 0x4B Line 2      
                   Write_Data(nh)          ;  //Plot number colum10 to lcd 
                   Write_Data(nl)          ;  //Plot number colum unit to lcd
                
                   add = add+9             ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message     #####-- 2. Line For Edit--#####
                   if(add > 306)              //Check Position Address for Record end Message (Last Message is 35)                      #####-- 3. Line For Edit--#####
                     add = 0               ;  //if last message Recorded. Give return Start Address at 0 New
                
                   Set_Add(add)            ;  //Set Address for Play or Record
			        
                   Check_Sw()              ;  //Check Release SW.
                   
                    
                     
              break                        ;

         case 0x08 :  //SW.3(PE3) = Select Decrement order Message --
                        
                    nm= nm-1                ;  //Counter Message for show LCD             
                    if(nm<1)                   //check number message not exceed 35 message
                      nm = 35               ;                                                            //#####--4. Line For Edit--#####

                    Conv_Ascii(nm)          ;  //Convert number message to ascii
                    Write_Cmm(0x80|0x4B)    ;  //Start address lcd = 0x4B Line 2      
                    Write_Data(nh)          ;  //Plot number colum10 to lcd 
                    Write_Data(nl)          ;  //Plot number colum unit to lcd
                
                    add = add-9             ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message          #####--Line5. For Edit--#####
                    if(add < 0)                 //Check Position Address for Record end Message (Last Message is 35) 
                      add = 306             ;   //if last message Recorded. Give return Start Address at 0 New                                 #####--Line6. For Edit--#####
                
                    Set_Add(add)            ;  //Set Address for Play or Record

                    Check_Sw()              ;
             
              break ;

         case 0x10 : //SW.4(PE4) = Record Message
                               
                    Clear_L1()                      ;  //Clear Message On LCD L1
                    Write_Cmm(0x80|0x03)            ;  //Start address lcd = 0x03 Line 1
                    for(lp=0;lp<9;lp++)
                       Write_Data(str3[lp])         ;  //Print "Rec [(0)]" to LCD

                   // delay_ms(10)                  ;
                 
                    Write_Cmm(0x80|0x09)            ;  //Start address lcd = 0x09 Line 1     
                    Write_Cmm(0x0D)                 ;  //LCD Blink 
                    
                    Record()                        ;  //Start Record
    
                    delay_ms(1200)                  ;  //wait record 1.2 sec.(use 1.2s/0.15s = 8 Address+ 1 for eom=9 address)        #####--Line7. For Edit--#####
        
				 
				    Stop_PR ()                      ;  //Stop Record   at 1.2 sec./ 1-message
                
                    Write_Cmm(0x0C)                 ;  //Stop LCD Blink 
                 
                    Write_Cmm(0x80|0x01)            ;  //Start address lcd = 0x01 Line 1
                    for(lp=0;lp<14;lp++)
                      Write_Data(str4[lp])          ;  //Print "<<==Select==>>" to LCD

                    Check_Sw()                      ;        

                break ;

          case 0x20: //SW.5(PE5) = Play All Message
                               
                    Clear_L1()                     ;  //Clear Message On LCD Line1
                    Write_Cmm(0x80|0x03)           ;  //Start address lcd = 0x04 Line 1       
                    
                    for(lp=0;lp<11;lp++)
                     {
                      Write_Data(str2[lp])           ;  //Print "Play All =>" to LCD
                     }
                     
                     add =0                          ;
                    for(nm=1;nm<=35;nm++)                      //#####-- Line8. For Edit--#####
                     {
                       Conv_Ascii(nm)                ;  //Convert number message to ascii
                       Write_Cmm(0x80|0x4B)          ;  //Start address lcd = 0x4B Line 2      
                       Write_Data(nh)                ;  //Plot number colum10 to lcd 
                       Write_Data(nl)                ;  //Plot number colum unit to lcd
                               
                       Set_Add(add)                  ;  //Set Address for Play 
                       Play_Back()                   ;  //Play Message

                       add = add+9                   ;  //Increment every 9 Address(8address for 1message +1address for EOM) For next Message         #####-- Line9. For Edit--#####
            
                       while((Rd_Eom())&&(nm <36))      //Wait end 1 message                  #####--Line10. For Edit--#####
                        {   
                         sw = Rd_Sw()                ;  //SW.6(PE6) = Stop Play Message
                         if(sw == 0x40)
                          {
                           Stop_PR()                 ;  //Stop Play Message  
                           nm = 37                   ;                                    //  #####--Line11. For Edit--#####
                          }       
                        }
                      
                       while(!Rd_Eom())  {;}          ;  //Wait EOM back to '1' for Play Next Message
                                  
                       }  
                                           
                     add = 0                         ;  //Clear Address    
                     nm  = 1                         ;  //Start Display Message1 
                      
                     Write_Cmm(0x80|0x01)            ;  //Start address lcd = 0x01 Line 1
                     for(lp=0;lp<14;lp++)
                       Write_Data(str4[lp])          ;  //Print "<<==Select==>>" to L1
                  
                     Write_Cmm(0x80|0x4B)            ;  //Start address lcd = 0x4B Line 2      
                     Write_Data(0x30)                ;  //Plot number 0 to lcd 
                     Write_Data(0x31)                ;  //Plot number 1 to lcd             
                     
                     Set_Add(0)                      ;  //Set Address 0 for Play 
                     Check_Sw()                      ;  

              break ;
      
          case 0x80: //SW.7(PE7) = Play one Message
                               
                     Clear_L1()                     ;  //Clear Message On LCD Line1
                     Write_Cmm(0x80|0x04)           ;  //Start address lcd = 0x04 Line 1       
                     for(lp=0;lp<7;lp++)
                       Write_Data(str1[lp])         ;  //Print "Play =>" to LCD

                     Play_Back()                    ;  //Play Message

                     Write_Cmm(0x80|0x0A)           ;  //Start address lcd = 0x0A Line 1     
                     Write_Cmm(0x0D)                ;  //LCD Blink 

                     while(Rd_Eom()){;}             ;  //Wait end 1 message
                
                     Write_Cmm(0x0C)                ; //Stop LCD Blink 

                     Write_Cmm(0x80|0x01)           ;  //Start address lcd = 0x01 Line 1
                     for(lp=0;lp<14;lp++)
                        Write_Data(str4[lp])        ;  //Print "<<==Select==>>" to LCD
            
                     Check_Sw()                     ;  

              break ;

     }  //switch 
	
   }
}      //End

 


