/*******************************************/
/* Example Program For ET-BASE51 AC3 V1.0  */
/* MCU      : AT89C51AC3(XTAL=29.4912 MHz) */
/*          : Frequency Bus = 58.9824 MHz  */
/* Compiler : Keil C51 (V7.50)             */
/* Write By : Eakachai Makarn(ETT CO.,LTD.)*/
/* Examples : Demo Software SPI (MCP4922)  */
/*******************************************/
/*******************************************/
/* SPI Interface to ET-MINI MCP4922(DAC)   */
/* P1.0  --> LDAC#             	           */
/* P1.1  --> CS#                           */
/* P1.2  --> SDI   				           */
/* P1.3  --> SCK      		               */
/*******************************************/
// Demo SPI + ET-MINI MCP4922(12Bit SPI DAC)

/* Include  Section */
#include <reg52.h>														// Standard 8052 SFR : File

/* AT89C51AC3 SFR */
sfr CKCON = 0x8F;														// Clock Control

// Define Software SPI Pin Signal //
sbit MCP4922_LDAC = P1^0;												// Latch DAC Output
sbit MCP4922_CS   = P1^1;												// Chips Select DAC
sbit MCP4922_SDI  = P1^2;												// Software Pin MOSI 
sbit MCP4922_SCK  = P1^3;												// Software Pin SCK 

/* User Define Function */
void SPI_WriteByte(unsigned char DataByte);								// Write Byte to SPI
void SPI_Delay(void);				   									// SPI Delay Clock
void Write_MCP4922(unsigned char DAC_Channel,unsigned int DAC_Data);	// Write MCP4922 Data

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main()
{  
  CKCON = 0x01;															// Initial X2 Mode (BUS Clock = 58.9824 MHz) 
  
  MCP4922_LDAC = 1;  													// Prepare Start Signal
  MCP4922_CS = 1;                  										
  MCP4922_SDI = 0;
  MCP4922_SCK = 0;

  // Strat Write DAC Output 
  Write_MCP4922(0x00,0xFFF);	 										// DAC-A = Full Scale of REF-A
  Write_MCP4922(0x01,0x7FF);	 										// DAC-B = 1/2  Scale of REF-B

  while(1);																// Loop Continue

}

/***********************/
/* Write 1 Byte to SPI */
/***********************/
void SPI_WriteByte(unsigned char DataByte)								// Write Byte to SPI
{
  unsigned char Bit = 0;												// Bit Counter

  for (Bit = 0; Bit < 8; Bit++)				   							// 8 Bit Write
      {
	    MCP4922_SDI = (bit)((DataByte & 0x80) >> 7);					// MSB First of Data Bit(7..0)
		MCP4922_SCK = 1;		   										// Strobe Bit Data

		SPI_Delay();								    				// Delay Clock

		MCP4922_SCK = 0;  												// Next Clock
		DataByte <<= 1;	 												// Next Bit Data
      }
}

/**************************/
/* Delay SPI Clock Signal */
/**************************/
void SPI_Delay(void)
{
  int x;  																// Short Delay Counter
  x++;
  x++;
}


/**********************/
/* MCP4922 Write Data */
/**********************/
void Write_MCP4922(unsigned char DAC_Channel,unsigned int DAC_Data)	  	// Write DAC Output
{                                     
  MCP4922_CS = 0;                  										// Enable MCP4922 

  switch (DAC_Channel)													// Select DAC Channel(0=A,1=B)						
  {
    case 0x00: DAC_Data |= 0x3000;										// Write DAC-A
  	           break;
  	case 0x01: DAC_Data |= 0xB000;										// Write DAC-B
  	           break;
  }
  
  SPI_WriteByte((DAC_Data >> 8)& 0xFF);  								// Data Byte High
  SPI_WriteByte(DAC_Data & 0xFF);  										// Data Byte Low

  MCP4922_CS = 1;                  										// Disable MCP4922
    
  MCP4922_LDAC = 0;														// Enable Pulse Latch
  MCP4922_LDAC = 1;  	  
}   

