;/************************************/;
;/* Examples For : ET-MINI MCP4922   */;
;/* Hardware     : ET-BASE51AC3 V1   */;
;/* Controller   : AT89C51AC3        */;
;/* Run X-TAL    : 29.4912 MHz       */;
;/*              : Run X2 Mode       */;
;/* System Clock : 58.9824 MHz       */;
;/* Assembler    : SXA51.EXE         */;
;/* File Name    : SPI_DAC1.ASM      */;
;/* Function     : Demo Software SPI */;
;/*              : Interface MCP4922 */;
;/************************************/;
;/************************************/;
;/* AT89C51AC3 Interface MCP4922     */;
;/* -> P1.0(I/O)   --> LDAC#         */;
;/* -> P1.1(I/O)   --> CS#           */;
;/* -> P1.2(I/O)   --> SDI           */;
;/* -> P1.3(I/O)   --> SCK           */;
;/************************************/;
;
;/* AT89C51AC3 Clock Control */;
AUXR                EQU     8EH
CKCON0              EQU     8FH
CKCON1              EQU     9FH
IEN0                EQU     0A8H
;
;/* 12 Bit DAC(MCP4922) Interface */;
MCP4922_LDAC_PIN    EQU     P1.0                            ; Port I/O
MCP4922_CS_PIN      EQU     P1.1                            ; Port I/O
MCP4922_DIN_PIN     EQU     P1.2                            ; Port I/O
MCP4922_CLK_PIN     EQU     P1.3                            ; Port I/O

                    ORG     20H
DAC_DATA:           DS      2                               ; DAC Output
STACK:              DS      30                              ; Stack 30 Byte

                    ORG     0000H                           ; Reset Vector of CPU
                    ;
MAIN:               MOV     SP,#STACK                       ; Initial Stack
                    MOV     CKCON0,#00000001B               ; 6 Clock Mode(X2 Mode)
                    ;
                    SETB    MCP4922_CS_PIN                  ; Prepared Signal
                    SETB    MCP4922_LDAC_PIN
                    CLR     MCP4922_CLK_PIN
                    ;
                    ;/* Start Write DAC Output */;
                    MOV     DAC_DATA+0,#0FH                 ; Full Scale of REF-A
                    MOV     DAC_DATA+1,#0FFH
                    LCALL   MCP4922_SEND_DA0                ; Send Data to DAC
                    ;
                    MOV     DAC_DATA+0,#07H                 ; 1/2 Scale of REF-B
                    MOV     DAC_DATA+1,#0FFH
                    LCALL   MCP4922_SEND_DA1                ; Send Data to DAC
                    ;
                    SJMP    $

;/***************************/;
;/* Update Output To DAC-A  */;
;/* Input : DAC_DATA+[0..1] */;
;/***************************/;
;
MCP4922_SEND_DA0:   CLR     MCP4922_CS_PIN                  ; Enable MCP4922 Interface
                    MOV     A,DAC_DATA+0                    ; Setup DAC = A
                    ORL     A,#00110000B                    ; DAC-A,Un-Buffer,Power-ON
                    LCALL   SEND_BYTE_MCP4922               ; Send High Byte
                    MOV     A,DAC_DATA+1
                    LCALL   SEND_BYTE_MCP4922               ; Send Low Byte
                    SETB    MCP4922_CS_PIN                  ; Disable MCP4922 Interface
                    ;
                    ;/* Latch DAC Output Signal */;
                    CLR     MCP4922_LDAC_PIN                ; Latch DAC Output
                    SETB    MCP4922_LDAC_PIN
                    RET

;/***************************/;
;/* Update Output To DAC-B  */;
;/* Input : DAC_DATA+[0..1] */;
;/***************************/;
;
MCP4922_SEND_DA1:   CLR     MCP4922_CS_PIN                  ; Enable MCP4922 Interface
                    MOV     A,DAC_DATA+0                    ; Setup DAC = B
                    ORL     A,#10110000B                    ; DAC-B,Un-Buffer,Power-ON
                    LCALL   SEND_BYTE_MCP4922               ; Send High Byte
                    MOV     A,DAC_DATA+1
                    LCALL   SEND_BYTE_MCP4922               ; Send Low Byte
                    SETB    MCP4922_CS_PIN                  ; Disable MCP4922 Interface
                    ;
                    ;/* Latch DAC Output Signal */;
                    CLR     MCP4922_LDAC_PIN                ; Latch DAC Output
                    SETB    MCP4922_LDAC_PIN
                    RET

;/************************/;
;/* Send Byte to MCP4922 */;
;/* Input : ACC          */;
;/************************/;
;
SEND_BYTE_MCP4922:  MOV     B,#8                            ; Shift Out 1 Byte Counter
                    ;
SHF_BYTE_MCP4922:   RLC     A                               ; Shift Out MSB First (D[7..0])
                    MOV     MCP4922_DIN_PIN,C
                    SETB    MCP4922_CLK_PIN                 ; Shift Clock at Rising Edge
                    CLR     MCP4922_CLK_PIN
                    DJNZ    B,SHF_BYTE_MCP4922              ; Loop Send This Byte
                    RET

                    END

