;***************************************************************
; Table V800.TBL supports the NEC V851 (uPD703000) Microcontroller
; and other chips in the V800 series.

	CPU	"V800.TBL"		;CPU table
	HOF	"MOT32"			;Hex format
	ALGN	2			;Align to half-word boundary
					;Remember to align words to 4 bytes!	
	
; Peripheral I/O registers for the V851
;
P0	EQU	$FFFFF000	;Port 0
P1	EQU	$FFFFF002	;Port 1
P2	EQU	$FFFFF004	;Port 2
P3	EQU	$FFFFF006	;Port 3
P4	EQU	$FFFFF008	;Port 4
P5	EQU	$FFFFF00A	;Port 5
P6	EQU	$FFFFF00C	;Port 6
P9	EQU	$FFFFF012	;Port 9
P10	EQU	$FFFFF014	;Port 10
PM0	EQU	$FFFFF020	;Port 0 mode register
PM1	EQU	$FFFFF022	;Port 1 mode register
PM2	EQU	$FFFFF024	;Port 2 mode register
PM3	EQU	$FFFFF026	;Port 3 mode register
PM4	EQU	$FFFFF028	;Port 4 mode register
PM5	EQU	$FFFFF02A	;Port 5 mode register
PM6	EQU	$FFFFF02C	;Port 6 mode register
PM9	EQU	$FFFFF032	;Port 9 mode register
PM10	EQU	$FFFFF034	;Port 10 mode register
PMC0	EQU	$FFFFF040	;Port 0 mode control register
PMC2	EQU	$FFFFF044	;Port 2 mode control register
PMC3	EQU	$FFFFF046	;Port 3 mode control register
MM	EQU	$FFFFF04C	;Memory expansion mode register
PMC10	EQU	$FFFFF054	;Port 10 mode control register
DWC	EQU	$FFFFF060	;Data wait control register
BCC	EQU	$FFFFF062	;Bus wait control register
PSC	EQU	$FFFFF070	;Power save control register
SYS	EQU	$FFFFF078	;System status register
BRG0	EQU	$FFFFF084	;Baud rate generator register 0
BPRM0	EQU	$FFFFF086	;Baud rate generator prescaler mode register 0
CSIM0	EQU	$FFFFF088	;Clocked serial interface mode register 0
SIO0	EQU	$FFFFF08A	;Clocked serial interface mode register 0
ASIM00	EQU	$FFFFF0C0	;UART mode register 00
ASIM01	EQU	$FFFFF0C2	;UART mode register 01
ASIS0	EQU	$FFFFF0C4	;UART status register 0
RXB0	EQU	$FFFFF0C8	;UART reception buffer 0
RXB0L	EQU	$FFFFF0CA	;UART reception buffer 0L
TXS0	EQU	$FFFFF0CC	;UART transmission shift register 0
TXS0L	EQU	$FFFFF0CE	;UART transmission shift register 0L
OVIC1	EQU	$FFFFF100	;Interrupt control register
PIIC0	EQU	$FFFFF102	;Interrupt control register
PIIC1	EQU	$FFFFF104	;Interrupt control register
PIIC2	EQU	$FFFFF106	;Interrupt control register
PIIC3	EQU	$FFFFF108	;Interrupt control register
CMIC4	EQU	$FFFFF10A	;Interrupt control register
CSIC0	EQU	$FFFFF10C	;Interrupt control register
SEIC0	EQU	$FFFFF10E	;Interrupt control register
SRIC0	EQU	$FFFFF110	;Interrupt control register
STIC0	EQU	$FFFFF112	;Interrupt control register
POIC0	EQU	$FFFFF114	;Interrupt control register
POIC1	EQU	$FFFFF116	;Interrupt control register
POIC2	EQU	$FFFFF118	;Interrupt control register
POIC3	EQU	$FFFFF11A	;Interrupt control register
ISPR	EQU	$FFFFF166	;In-service priority register
PRCMD	EQU	$FFFFF170	;Command register
INTM0	EQU	$FFFFF180	;External interrupt mode register 0
INTM1	EQU	$FFFFF182	;External interrupt mode register 1
INTM2	EQU	$FFFFF184	;External interrupt mode register 2
TOVS	EQU	$FFFFF230	;Timer overflow status register
TUM1	EQU	$FFFFF240	;Timer unit mode register
TMC1	EQU	$FFFFF242	;Timer control register 1
TOC1	EQU	$FFFFF244	;Timer output control register 1
TM1	EQU	$FFFFF250	;Timer register
CC10	EQU	$FFFFF252	;Capture/compare register 10
CC11	EQU	$FFFFF254	;Capture/compare register 11
CC12	EQU	$FFFFF256	;Capture/compare register 12
CC13	EQU	$FFFFF258	;Capture/compare register 13
TMC4	EQU	$FFFFF342	;Timer control register 4
TM4	EQU	$FFFFF350	;Timer register 4 
CM4	EQU	$FFFFF352	;Compare register 4

; Example V800 instructions
;
	ORG	000h
RESET:	JR	BEGIN		;RESET vector

	ORG	010h
NMI:	RETI

	ORG	120h
INTP00:	RETI

	ORG	130h
INTP01:	RETI

	ORG	140h
INTP02:	RETI

	ORG	150h
INTP03:	RETI

	ORG	200h
BEGIN:	ADD	R0,R0			;
	ADD	R0,R31			;
	ADD	R31,LP			;
	ADD	R31,R31			;
	ADD	SP,LP			;
	ADD	GP,EP			;
	ADD	EP,GP			;
	ADD	LP,SP			;
	ADD	-16,R0			;
	ADD	-7,R31			;
	ADD	-1,R0			;
	ADD	0,R31			;
	ADD	15,LP			;
	ADD	16,EP			;
	ADD	17,GP			;
	ADD	31,SP			;

	ADDI	-$8000,R0,R0		;
	ADDI	-$1,R0,R31		;
	ADDI	$0,R31,LP		;
	ADDI	$1,R31,R31		;
	ADDI	$12,SP,LP		;
	ADDI	$123,GP,EP		;
	ADDI	$1234,EP,GP		;
	ADDI	$FFFF,LP,SP		;

	AND	R0,R0			;
	AND	SP,LP			;
	AND	LP,SP			;

	ANDI	-$8000,R0,R0		;
	ANDI	$FFFF,LP,SP		;

	BGT	BEFORE 			;
	BGE	BEFORE 			;
	BLT	BEFORE 			;
	BLE	BEFORE 			;
	BH	BEFORE 			;
	BNL	BEFORE 			;
	BL	BEFORE 			;
	BNH	BEFORE 			;
	BE	BEFORE 			;
	BNE	BEFORE 			;
BEFORE:	BV	BEFORE 			;
	BNV	BEFORE 			;
	BN	BEFORE 			;
	BP	BEFORE 			;
	BC	BEFORE 			;
	BNC	BEFORE 			;
	BZ	BEFORE 			;
	BNZ	BEFORE 			;
	BR	BEFORE 			;
	BSA	BEFORE			;

	CLR1	0,-$8000[R0]		;
	CLR1	1,   -$1[R0]		;
	CLR1	2,   $0[R31]		;
	CLR1	3,   $1[R31]		;
	CLR1	4,   $12[SP]		;
	CLR1	5,  $123[GP]		;
	CLR1	6, $1234[R0]		;
	CLR1	7, $7FFF[LP]		;

	CMP	R0,R0			;
	CMP	LP,SP			;
	CMP	-16,R0			;
	CMP	-7,R31			;
	CMP	31,SP			;

	DI				;

	DIVH	R0,R0			;
	DIVH	LP,SP			;

	EI				;

	HALT				;

	jARL	$00000,R0		;
	JARL	BEFORE,R0		;
	JARL	BEFORE,LP		;
	JARL	BEFORE,EP		;
	JARL	BEFORE,GP		;
	JARL	BEFORE,SP		;
	JARL	BEFORE,R31		;
	JARL	$1FFFE,R31		;

	JMP	[R0]			;
	JMP	[R31]			;
	JMP	[LP]			;

	JR	$00000			;
	JR	BEFORE			;
	JR	$1FFFE			;

	LD.B	-$8000[R0],R0		;
	LD.B	   -$1[R0],R31		;
	LD.B	   $0[R31],LP		;
	LD.B	   $1[R31],R31		;
	LD.B	 $7FFF[LP],SP		;

	LD.H	-$8000[R0],R0		;
	LD.H	 $7FFE[LP],SP		;

	LD.W	-$8000[R0],R0		;
	LD.W	 $7FFE[LP],SP		;

	LDSR	R0,EIPC			;			
	LDSR	R31,EIPSW		;	
	LDSR	LP,FEPC			;
	LDSR	EP,FEPSW		;
	LDSR	SP,PSW			;

	MOV	R0,R0			;
	MOV	R0,R31			;
	MOV	LP,SP			;
	MOV	-16,R0			;
	MOV	-7,R31			;
	MOV	31,SP			;

	MOVEA	-$8000,R0,R0		;
	MOVEA	$FFFF,LP,SP		;

	MOVHI	-$8000,R0,R0		;
	MOVHI	$FFFF,LP,SP		;

	MULH	R0,R0			;
	MULH	LP,SP			;
	MULH	-16,R0			;
	MULH	-7,R31			;
	MULH	31,SP			;

	MULHI	-$8000,R0,R0		;
	MULHI	$FFFF,LP,SP		;

	NOP				;

	NOT	R0,R0			;
	NOT	LP,SP			;
	NOT1	0,-$8000[R0]		;
	NOT1	7, $7FFF[LP]		;

	OR	R0,R0			;
	OR	LP,SP			;

	ORI	-$8000,R0,R0		;
	ORI	$FFFF,LP,SP		;

	RETI				;

	SAR	R0,R0			;
	SAR	LP,SP			;
	SAR	-16,R0			;
	SAR	-7,R31			;
	SAR	31,SP			;

	SATADD	R0,R0			;
	SATADD	LP,SP			;
	SATADD	-16,R0			;
	SATADD	-7,R31			;
	SATADD	31,SP			;

	SATSUB	R0,R0			;
	SATSUB	LP,SP			;

	SATSUBI	-$8000,R0,R0		;
	SATSUBI	$FFFF,LP,SP		;

	SATSUBR	R0,R0			;
	SATSUBR	LP,SP			;

	SET1	0,-$8000[R0]		;
	SET1	7, $7FFF[LP]		;

 	SETF	V,R0			;
	SETF	C,R1			;
	SETF	Z,R2			;
	SETF	NH,R3			;
	SETF	S,R4			;
	SETF	T,R5			;
	SETF	LT,R6			;
	SETF	LE,R7			;
	SETF	NV,R8			;	
	SETF	NC,R9			;
	SETF	NZ,R10			;
	SETF	H,R0			;
	SETF	NS,LP			;
	SETF	SA,EP			;
	SETF	GE,GP			;
	SETF	GT,SP			;
	SETF	V,R0			;
	SETF	L,R0			;
	SETF	Z,R0			;
	SETF	NH,R0			;
	SETF	N,R0			;
	SETF	T,R0			;
	SETF	LT,R0			;
	SETF	LE,R0			;
	SETF	NV,R0			;
	SETF	NL,R0			;
	SETF	NZ,R0			;
	SETF	H,R0			;
	SETF	P,R31			;

	SHL	R0,R0			;
	SHL	LP,SP			;
	SHL	-16,R0			;
	SHL	31,SP			;

	SHR	R0,R0			;
	SHR	LP,SP			;
	SHR	-16,R0			;
	SHR	31,SP			;

	SLD.B	  0[EP],R0		;
	SLD.B	  1[EP],R31		;
	SLD.B	110[EP],EP		;
	SLD.B	127[EP],LP		;
	SLD.H	  0[EP],R0		;
	SLD.H	254[EP],LP		;
	SLD.W	  0[EP],R0		;
	SLD.W	112[EP],EP		;
	SLD.W	252[EP],LP		;

	SST.B	 R0,  0[EP]		;
	SST.B	 LP,127[EP]		;
	SST.W	 R0,  0[EP]		;
	SST.H	 EP,110[EP]		;
	SST.H	 LP,254[EP]		;
	SST.W	 R0,  0[EP]		;
	SST.W	 LP,252[EP]		;

	ST.B	 R0,-$8000[R0]		;
	ST.B	 SP, $7FFF[LP]		;

	ST.H	 R0,-$8000[R0]		;
	ST.H	 SP, $7FFE[LP]		;

	ST.W	 R0,-$8000[R0]		;
	ST.W	 GP, $1234[R0]		;
	ST.W	 SP, $7FFE[LP]		;

	STSR	EIPC,R0			;			
	STSR	EIPSW,R31		;	
	STSR	ECR,GP			;
	STSR	PSW,SP			;

	SUB	R0,R0			;
	SUB	LP,SP			;

	SUBR	R0,R0			;
	SUBR	LP,SP			;

	TRAP	$00			;
	TRAP	$01			;
	TRAP	$0F			;
	TRAP	$10			;
	TRAP	$1F			;

	TST	R0,R0			;
	TST	LP,SP			;
	TST1	0,-$8000[R0]		;
	TST1	1,   -$1[R0]		;
	TST1	7, $7FFF[LP]		;

	XOR	R0,R0			;
	XOR	GP,EP			;
	XOR	EP,GP			;
	XOR	LP,SP			;

	XORI	-$8000,R0,R0		;
	XORI	$FFFF,LP,SP		;

	END

