;**************************************************************
; This table supports the SGS-THOMSON ST9 family of processors.
; The special function registers and bits for this family are 
; defined at the end of file "ST9.TBL" using EQU and RPTXT 
; directives.  The following CASE directive must be placed
; before the CPU directive.
;
	CASE	"On"		;Case sensitive, a must for ST9
	CPU	"ST9.TBL"	;PROCESSOR TABLE
	HOF	"int8"		;Hex format

;**************************************************************
; Some St9 instructions showing most addressing modes...
;
	band	r15.7,r0.0
	band	r13.6,r2.1
	band	r11.5,r4.2
	band	r9.4,r6.3
	band	r7.3,r8.!4
	band	r5.2,r10.!5
	band	r3.1,r12.!6
	band	r1.0,r14.!7

	bcpl	r15.7
	bcpl	r13.6
	bcpl	r11.5
	bcpl	r9.4
	bcpl	r7.3
	bcpl	r5.2
	bcpl	r3.1
	bcpl	r1.0

	btjf	r15.7,lbtjf
	btjf	r13.6,lbtjf
	btjf	r11.5,lbtjf
lbtjf:	btjf	r9.4,lbtjf
	btjf	r7.3,lbtjf
	btjf	r5.2,lbtjf
	btjf	r3.1,lbtjf
	btjf	r1.0,lbtjf

	btset	r15.7
	btset	r13.6
	btset	r11.5
	btset	r9.4
	btset	r7.3
	btset	r5.2
	btset	r3.1
	btset	r1.0
	btset	(rr14).0
	btset	(rr12).1
	btset	(rr10).2
	btset	(rr8).3
	btset	(rr6).4
	btset	(rr4).5
	btset	(rr2).6
	btset	(rr0).7

	call	(RR0)
	call	(RR254)
	call	(rr0)
	call	(rr14)
	call	ljp
	call	ljr

	ccf

	cpjfi	r0,(rr0),lcpjfi
	cpjfi	r0,(rr14),lcpjfi
lcpjfi: cpjfi	r15,(rr0),lcpjfi
	cpjfi	r15,(rr14),lcpjfi

	clr	R0
	clr	R255
	clr	r0
	clr	r15
	clr	(R0)
	clr	(R255)
	clr	(r0)
	clr	(r15)

	dec	R0
	dec	R255
	dec	r0
	dec	r15
	dec	(R0)
	dec	(R255)
	dec	(r0)
	dec	(r15)

	decw	RR0
	decw	RR254
	decw	rr0
	decw	rr14

	di

	div	rr0,r0
	div	rr0,r15
	div	rr14,r0
	div	rr14,r15

	divws	rr0,rr0,RR8
	divws	rr0,rr14,RR8
	divws	rr14,rr0,RR8
	divws	rr14,rr14,RR8
	divws	rr0,rr0,rr8
	divws	rr0,rr14,rr8
	divws	rr14,rr0,rr8
	divws	rr14,rr14,rr8

	djnz	r0,ldjnz
	djnz	r1,ldjnz
ldjnz:	djnz	r7,ldjnz
	djnz	r14,ldjnz
	djnz	r15,ldjnz

	dwjnz	RR0,ldwjnz
	dwjnz	RR8,ldwjnz
	dwjnz	RR14,ldwjnz
	dwjnz	rr0,ldwjnz
	dwjnz	rr2,ldwjnz
ldwjnz: dwjnz	rr8,ldwjnz
	dwjnz	rr14,ldwjnz

	ei

	ext	RR0
	ext	RR8
	ext	RR14
	ext	rr0
	ext	rr8
	ext	rr14

	halt

	iret

	jp	(RR0)
	jp	(RR254)
	jp	(rr0)
	jp	(rr14)
	jp	ljp

	jpf	ljp
	jplt	ljp
	jple	ljp
	jpule	ljp
	jpov	ljp
	jpmi	ljp
	jpz	ljp
	jpc	ljp
	jpt	ljp
	jpge	ljp
ljp:	jpgt	ljp
	jpugt	ljp
	jpnov	ljp
	jppl	ljp
	jpnz	ljp
	jpnc	ljp

	jrf	ljr
	jrlt	ljr
	jrle	ljr
	jrule	ljr
	jrov	ljr
	jrmi	ljr
	jrz	ljr
	jrc	ljr
	jrt	ljr
	jrge	ljr
ljr:	jrgt	ljr
	jrugt	ljr
	jrnov	ljr
	jrpl	ljr
	jrnz	ljr
	jrnc	ljr

	ldpp	(rr0)+,(rr0)+
	ldpp	(rr0)+,(rr14)+
	ldpp	(rr14)+,(rr0)+
	ldpp	(rr14)+,(rr14)+
	lddp	(rr0)+,(rr0)+
	lddp	(rr0)+,(rr14)+
	lddp	(rr14)+,(rr0)+
	lddp	(rr14)+,(rr14)+
	ldpd	(rr0)+,(rr0)+
	ldpd	(rr0)+,(rr14)+
	ldpd	(rr14)+,(rr0)+
	ldpd	(rr14)+,(rr14)+
	lddd	(rr0)+,(rr0)+
	lddd	(rr0)+,(rr14)+
	lddd	(rr14)+,(rr0)+
	lddd	(rr14)+,(rr14)+

	ld	r0,R0
	ld	r0,R255
	ld	r15,R0
	ld	r15,R255
	ld	r0,r0
	ld	r0,r15
	ld	r15,r0
	ld	r15,r15
	ld	R0,r0
	ld	R0,r15
	ld	R255,r0
	ld	R255,r15
	ld	(r0),r0
	ld	(r0),r15
	ld	(r15),r0
	ld	(r15),r15
	ld	r0,(r0)
	ld	r0,(r15)
	ld	r15,(r0)
	ld	r15,(r15)
	ld	(r0),R0
	ld	(r0),R255
	ld	(r15),R0
	ld	(r15),R255
	ld	(r0),r0
	ld	(r0),r15
	ld	(r15),r0
	ld	(r15),r15
	ld	R0,(r0)
	ld	R0,(r15)
	ld	R255,(r0)
	ld	R255,(r15)
	ld	-128(r0),r0
	ld	-1(r0),r15
	ld	0(r15),r0
	ld	127(r15),r15
	ld	r0,-128(r0)
	ld	r0,-1(r15)
	ld	r15,0(r0)
	ld	r15,127(r15)
	ld	R0,R0
	ld	R255,R0
	ld	R255,R255

	ld	r0,(rr0)
	ld	r0,(rr14)
	ld	r15,(rr0)
	ld	r15,(rr14)
	ld	(r0)+,(rr0)+
	ld	(r0)+,(rr14)+
	ld	(r15)+,(rr0)+
	ld	(r15)+,(rr14)+
	ld	R0,(rr0)+
	ld	R0,(rr14)+
	ld	R255,(rr0)+
	ld	R255,(rr14)+
	ld	r0,(rr0)+
	ld	r0,(rr14)+
	ld	r15,(rr0)+
	ld	r15,(rr14)+
	ld	R0,-(rr0)
	ld	R0,-(rr14)
	ld	R255,-(rr0)
	ld	R255,-(rr14)
	ld	r0,-(rr0)
	ld	r0,-(rr14)
	ld	r15,-(rr0)
	ld	r15,-(rr14)
	ld	R0,(rr0)
	ld	R0,(rr14)
	ld	R255,(rr0)
	ld	R255,(rr14)
	ld	r0,rr14(rr0)
	ld	r0,rr0(rr14)
	ld	r15,rr14(rr0)
	ld	r15,rr0(rr14)
	ld	R0,-128(rr0)
	ld	R0,-1(rr14)
	ld	R255,0(rr0)
	ld	R255,127(rr14)
	ld	r0,-128(rr0)
	ld	r0,-1(rr14)
	ld	r15,0(rr0)
	ld	r15,127(rr14)
	ld	r0,-65535
	ld	r0,-1
	ld	r15,0
	ld	r15,65535
	ld	R0,-65000(rr0)
	ld	R0,-129(rr14)
	ld	R255,128(rr0)
	ld	R255,65000(rr14)
	ld	r0,-65000(rr0)
	ld	r0,-129(rr14)
	ld	r15,128(rr0)
	ld	r15,65000(rr14)

	ld	(rr0)+,(r0)+
	ld	(rr14)+,(r0)+
	ld	(rr0)+,(r15)+
	ld	(rr14)+,(r15)+
	ld	(rr0),r0
	ld	(rr14),r0
	ld	(rr0),r15
	ld	(rr14),r15
	ld	(rr0)+,R0
	ld	(rr14)+,R0
	ld	(rr0)+,R255
	ld	(rr14)+,R255
	ld	(rr0)+,r0
	ld	(rr14)+,r0
	ld	(rr0)+,r15
	ld	(rr14)+,r15
	ld	-(rr0),R0
	ld	-(rr14),R0
	ld	-(rr0),R255
	ld	-(rr14),R255
	ld	-(rr0),r0
	ld	-(rr14),r0
	ld	-(rr0),r15
	ld	-(rr14),r15
	ld	(rr0),R0
	ld	(rr14),R0
	ld	(rr0),R255
	ld	(rr14),R255
	ld	rr14(rr0),r0
	ld	rr0(rr14),r0
	ld	rr14(rr0),r15
	ld	rr0(rr14),r15
	ld	-128(rr0),R0
	ld	-1(rr14),R0
	ld	0(rr0),R255
	ld	127(rr14),R255
	ld	-128(rr0),r0
	ld	-1(rr14),r0
	ld	0(rr0),r15
	ld	127(rr14),r15
	ld	-65535,r0
	ld	-1,r0
	ld	0,r15
	ld	65535,r15
	ld	-65000(rr0),R0
	ld	-129(rr14),R0
	ld	128(rr0),R255
	ld	65000(rr14),R255
	ld	-65000(rr0),r0
	ld	-129(rr14),r0
	ld	128(rr0),r15
	ld	65000(rr14),r15

	ld	(RR0),(rr0)
	ld	(RR0),(rr14)
	ld	(RR254),(rr0)
	ld	(RR254),(rr14)
	ld	(rr0),(rr0)
	ld	(rr0),(rr14)
	ld	(rr14),(rr0)
	ld	(rr14),(rr14)
	ld	r0,#-128
	ld	r12,#0
	ld	r15,#255
	ld	R0,#-128
	ld	R127,#0
	ld	R255,#255
	ld	(rr0),#-128
	ld	(rr12),#0
	ld	(rr14),#255
	ld	0,#-128
	ld	255,#0
	ld	65535,#255

	ldw	rr0,rr0
	ldw	rr0,rr14
	ldw	rr14,rr0
	ldw	rr14,rr14
	ldw	(r0),RR0
	ldw	(r0),RR254
	ldw	(r15),RR0
	ldw	(r15),RR254
	ldw	(r0),rr0
	ldw	(r0),rr14
	ldw	(r15),rr0
	ldw	(r15),rr14
	ldw	RR0,(r0)
	ldw	RR0,(r15)
	ldw	RR254,(r0)
	ldw	RR254,(r15)
	ldw	rr0,(r0)
	ldw	rr0,(r15)
	ldw	rr14,(r0)
	ldw	rr14,(r15)
	ldw	-128(r0),rr0
	ldw	-1(r0),rr14
	ldw	0(r15),rr0
	ldw	127(r15),rr14
	ldw	rr0,-128(r0)
	ldw	rr14,-1(r0)
	ldw	rr0,0(r15)
	ldw	rr14,127(r15)
	ldw	RR0,RR0
	ldw	RR0,RR254
	ldw	RR254,RR0
	ldw	RR254,RR254
	ldw	rr0,RR0
	ldw	rr0,RR254
	ldw	rr14,RR0
	ldw	rr14,RR254
	ldw	RR0,rr0
	ldw	RR0,rr14
	ldw	RR254,rr0
	ldw	RR254,rr14

	ldw	rr0,(rr0)
	ldw	rr0,(rr14)
	ldw	rr14,(rr0)
	ldw	rr14,(rr14)
	ldw	RR0,(rr0)+
	ldw	RR0,(rr14)+
	ldw	RR254,(rr0)+
	ldw	RR254,(rr14)+
	ldw	rr0,(rr0)+
	ldw	rr0,(rr14)+
	ldw	rr14,(rr0)+
	ldw	rr14,(rr14)+
	ldw	RR0,-(rr0)
	ldw	RR0,-(rr14)
	ldw	RR254,-(rr0)
	ldw	RR254,-(rr14)
	ldw	rr0,-(rr0)
	ldw	rr0,-(rr14)
	ldw	rr14,-(rr0)
	ldw	rr14,-(rr14)
	ldw	RR0,(rr0)
	ldw	RR0,(rr14)
	ldw	RR254,(rr0)
	ldw	RR254,(rr14)
	ldw	rr0,rr14(rr0)
	ldw	rr0,rr0(rr14)
	ldw	rr14,rr14(rr0)
	ldw	rr14,rr0(rr14)
	ldw	RR0,-128(rr0)
	ldw	RR0,-1(rr14)
	ldw	RR254,0(rr0)
	ldw	RR254,127(rr14)
	ldw	rr0,-128(rr0)
	ldw	rr0,-1(rr14)
	ldw	rr14,0(rr0)
	ldw	rr14,127(rr14)
	ldw	rr0,-65535
	ldw	rr0,-1
	ldw	rr14,0
	ldw	rr14,65535
	ldw	RR0,-65000(rr0)
	ldw	RR0,-129(rr14)
	ldw	RR254,128(rr0)
	ldw	RR254,65000(rr14)
	ldw	rr0,-65000(rr0)
	ldw	rr0,-129(rr14)
	ldw	rr14,128(rr0)
	ldw	rr14,65000(rr14)
	ldw	(rr0),rr0
	ldw	(rr14),rr0
	ldw	(rr0),rr14
	ldw	(rr14),rr14
	ldw	(rr0)+,RR0
	ldw	(rr14)+,RR0
	ldw	(rr0)+,RR254
	ldw	(rr14)+,RR254
	ldw	(rr0)+,rr0
	ldw	(rr14)+,rr0
	ldw	(rr0)+,rr14
	ldw	(rr14)+,rr14
	ldw	-(rr0),RR0
	ldw	-(rr14),RR0
	ldw	-(rr0),RR254
	ldw	-(rr14),RR254
	ldw	-(rr0),rr0
	ldw	-(rr14),rr0
	ldw	-(rr0),rr14
	ldw	-(rr14),rr14
	ldw	(rr0),RR0
	ldw	(rr14),RR0
	ldw	(rr0),RR254
	ldw	(rr14),RR254
	ldw	rr14(rr0),rr0
	ldw	rr0(rr14),rr0
	ldw	rr14(rr0),rr14
	ldw	rr0(rr14),rr14
	ldw	-128(rr0),RR0
	ldw	-1(rr14),RR0
	ldw	0(rr0),RR254
	ldw	127(rr14),RR254
	ldw	-128(rr0),rr0
	ldw	-1(rr14),rr0
	ldw	0(rr0),rr14
	ldw	127(rr14),rr14
	ldw	-65535,rr0
	ldw	-1,rr0
	ldw	0,rr14
	ldw	65535,rr14
	ldw	-65000(rr0),RR0
	ldw	-129(rr14),RR0
	ldw	128(rr0),RR254
	ldw	65000(rr14),RR254
	ldw	-65000(rr0),rr0
	ldw	-129(rr14),RR0
	ldw	128(rr0),rr14
	ldw	65000(rr14),rr14

	ldw	(rr0),(rr0)
	ldw	(rr0),(rr14)
	ldw	(rr14),(rr0)
	ldw	(rr14),(rr14)
	ldw	RR0,#-32768
	ldw	RR8,#-128
	ldw	RR126,#0
	ldw	RR250,#255
	ldw	RR254,#65535
	ldw	rr0,#-32768
	ldw	rr8,#-128
	ldw	rr12,#0
	ldw	rr14,#255
	ldw	rr14,#65535
	ldw	(rr0),#-32768
	ldw	(rr0),#-128
	ldw	(rr12),#0
	ldw	(rr14),#255
	ldw	(rr14),#65535
	ldw	-128(rr0),#-32768
	ldw	-1(rr0),#-128
	ldw	0(rr12),#0
	ldw	127(rr14),#255
	ldw	255(rr14),#65535
	ldw	-32768(rr0),#-32768
	ldw	-1111(rr0),#-128
	ldw	256(rr12),#0
	ldw	1127(rr14),#255
	ldw	65535(rr14),#65535
	ldw	0,#-128
	ldw	255,#0
	ldw	65535,#255

	pea	-128(RR8)
	pea	-1(RR16)
	pea	0(RR32)
	pea	127(RR64)
	pea	-128(rr8)
	pea	-1(rr0)
	pea	0(rr2)
	pea	127(rr4)
	pea	128(RR128)
	pea	32767(RR254)
	pea	128(rr8)
	pea	32767(rr4)

	peau	-128(RR8)
	peau	-1(RR16)
	peau	0(RR32)
	peau	127(RR64)
	peau	-128(rr8)
	peau	-1(rr0)
	peau	0(rr2)
	peau	127(rr4)
	peau	128(RR128)
	peau	32767(RR254)
	peau	128(rr8)
	peau	32767(rr4)

	spp	#0
	spp	#22
	spp	#63

	srp	#0
	srp	#31

	END

