;***************************************************************
; THE H8-300H TABLE CONTAINS THE INSTRUCTIONS USED BY THE
; HITACHI H8/300H MICROCOMPUTER, USING THE SYNTAX DEFINED
; IN THE H8/300H SERIES PROGRAMMING MANUAL.

; NOTE!  SPH,SPL,SP,ESP & ERSP may also be used
;	 to represent R7H,R7L,R7, E7 & ER7 respectively.

; NOTE!  ACCESS TO WORD DATA IN MEMORY MUST ALWAYS
;	 BEGIN AT AN EVEN ADDRESS.  TO INSURE THIS,
; USE THE ALIGN DIRECTIVE.
; I.E.
	ALGN	2		;Align code

; NOTE!  IN ASSEMBLY-LANGUAGE CODING IT IS USUALLY
;	 NOT NECESSARY TO SPECIFY THE GENERAL OR
; SPECIAL FORMAT (BY CODING :8, .B ETC.).  IF THE FORMAT
; SPECIFICATION IS OMITTED, THE ASSEMBLER AUTOMATICALLY
; GENERATES THE SHORTEST OBJECT CODE.  IF A FORMAT IS
; SPECIFIED, THE ASSEMBLER FOLLOWS THE FORMAT
; SPECIFICATION.  See examples below:

	CPU	"H8-300H.TBL"		;Declare CPU
	HOF	"MOT16" 		;Use 24 bit addressing

	ORG	1000H

xx08:	equ	12h			;Immediate values
xx16:	equ	1234h
xx24:	equ	123456h
xx32:	equ	12345678h

dd08:	equ	23h			;Displacement values
dd16:	equ	2345h
dd24:	equ	234567h

aa08:	equ	0FFFF34h		;Absolute values
aa16:	equ	0FF3456h
aa24:	equ	0345678h

	ADD.B	#XX08,R5H
	ADD.B	#XX08,SPL
	ADD.B	#XX08:8,R5H
	ADD.B	#XX08:8,R5L
	ADD.B	R0H,R0H
	ADD.B	R5H,R6L
	ADD.B	SPH,SPL

	ADD.W	#XX16,R5
	ADD.W	#XX16,SP
	ADD.W	#XX16:16,E4
	ADD.W	R0,R0
	ADD.W	R6,E3
	ADD.W	SP,SP

	ADD.L	#XX32,ER5
	ADD.L	#XX32,ERSP
	ADD.L	#XX32:32,ER4
	ADD.L	ER0,ER0
	ADD.L	ER6,ER3
	ADD.L	ERSP,ERSP

	ADD	#XX08,R5H
	ADD	#XX08,SPL
	ADD	#XX08:8,R5H
	ADD	#XX08:8,R5L
	ADD	R0H,R0H
	ADD	R5H,R6L
	ADD	SPH,SPL
	ADD	#XX16,R5
	ADD	#XX16,SP
	ADD	#XX16:16,E4
	ADD	R0,R0
	ADD	R6,E3
	ADD	SP,SP
	ADD	#XX32,ER5
	ADD	#XX32,ERSP
	ADD	#XX32:32,ER4
	ADD	ER0,ER0
	ADD	ER6,ER3
	ADD	ERSP,ERSP

	ADDS	#1,ER0
	ADDS	#1,ER5
	ADDS	#2,ER0
	ADDS	#2,ER7
	ADDS	#4,ER0
	ADDS	#4,ERSP

	ADDX	#XX08:8,R0H
	ADDX	#XX08:8,R4H
	ADDX	#XX08,R4L
	ADDX	#XX08,R7L
	ADDX	R0H,R0H
	ADDX	R4H,R5L

	ANDC	#XX08:8,CCR
	ANDC	#XX08,CCR

	BAND	#5,R1L
	BAND	#7:3,R7H
	BAND	#7,@ER0
	BAND	#5:3,@ER3
	BAND	#6,@ER1
	BAND	#6,@ER3
	BAND	#5,@ER5
	BAND	#7,@ER5
	BAND	#7,@aa08
	BAND	#6:3,@aa08:8

	BRA	$ + 36H
	BT	$ + 36H
	BRN	$ + 36H
	BF	$ + 36H
	BHI	$ + 36H
	BLS	$ + 36H
	BCC	$ + 36H
	BHS	$ + 36H
	BCS	$ + 36H
	BLO	$ + 36H
	BNE	$ + 36H
	BEQ	$ + 36H
	BVC	$ + 36H
	BVS	$ + 36H
	BPL	$ + 36H
	BMI	$ + 36H
	BGE	$ + 36H
	BLT	$ + 36H
	BGT	$ + 36H
	BLE	$ + 36H
	BRA	$ + 36H:8
	BT	$ + 36H:8
	BRN	$ + 36H:8
	BF	$ + 36H:8
	BHI	$ + 36H:8
	BLS	$ + 36H:8
	BCC	$ + 36H:8
	BHS	$ + 36H:8
	BCS	$ + 36H:8
	BLO	$ + 36H:8
	BNE	$ + 36H:8
	BEQ	$ + 36H:8
	BVC	$ + 36H:8
	BVS	$ + 36H:8
	BPL	$ + 36H:8
	BMI	$ + 36H:8
	BGE	$ + 36H:8
	BLT	$ + 36H:8
	BGT	$ + 36H:8
	BLE	$ + 36H:8
	BRA	$+1038H
	BT	$+1038H
	BRN	$+1038H
	BF	$+1038H
	BHI	$+1038H
	BLS	$+1038H
	BCC	$+1038H
	BHS	$+1038H
	BCS	$+1038H
	BLO	$+1038H
	BNE	$+1038H
	BEQ	$+1038H
	BVC	$+1038H
	BVS	$+1038H
	BPL	$+1038H
	BMI	$+1038H
	BGE	$+1038H
	BLT	$+1038H
	BGT	$+1038H
	BLE	$+1038H
	BRA	$+1038H:16
	BT	$+1038H:16
	BRN	$+1038H:16
	BF	$+1038H:16
	BHI	$+1038H:16
	BLS	$+1038H:16
	BCC	$+1038H:16
	BHS	$+1038H:16
	BCS	$+1038H:16
	BLO	$+1038H:16
	BNE	$+1038H:16
	BEQ	$+1038H:16
	BVC	$+1038H:16
	BVS	$+1038H:16
	BPL	$+1038H:16
	BMI	$+1038H:16
	BGE	$+1038H:16
	BLT	$+1038H:16
	BGT	$+1038H:16
	BLE	$+1038H:16

	BCLR	#2,R0H
	BCLR	#0:3,R0L
	BCLR	#6,R2H
	BCLR	#1,R7L
	BCLR	#0,@ER1
	BCLR	#0,@ER2
	BCLR	#1,@ER2
	BCLR	#2,@ER0
	BCLR	#2,@ER1
	BCLR	#3,@ER0
	BCLR	#5:3,@ER7
	BCLR	#6,@ER7
	BCLR	#7,@ER7
	BCLR	#0,@aa08:8
	BCLR	#4,@aa08
	BCLR	#4:3,@aa08
	BCLR	#7:3,@aa08:8
	BCLR	R0H,R0H
	BCLR	R2L,R5L
	BCLR	R7L,R7L
	BCLR	R0H,@ER1
	BCLR	R0H,@ER2
	BCLR	R0H,@ER3
	BCLR	R0H,@ER5
	BCLR	R0H,@ER6
	BCLR	R1H,@ER3
	BCLR	R1H,@ER5
	BCLR	R7L,@ER5
	BCLR	R7L,@ER6
	BCLR	R7L,@ER7
	BCLR	R0H,@aa08:8
	BCLR	R4L,@aa08:8
	BCLR	R5L,@aa08
	BCLR	R7L,@aa08:8

	BIAND	#2,R0H
	BIAND	#0:3,R0L
	BIAND	#6,R2H
	BIAND	#1,R7L
	BIAND	#0,@ER1
	BIAND	#0,@ER2
	BIAND	#1,@ER2
	BIAND	#2,@ER0
	BIAND	#2,@ER1
	BIAND	#3,@ER0
	BIAND	#5:3,@ER7
	BIAND	#6,@ER7
	BIAND	#7,@ER7
	BIAND	#0,@aa08:8
	BIAND	#4,@aa08
	BIAND	#4:3,@aa08
	BIAND	#7:3,@aa08:8

	BSR	$ + 36H
	BSR	$ + 36H:8
	BSR	$+1038H
	BSR	$+1038H:16

	DAA	R0H
	DAA	R0L
	DAA	R1H
	DAA	R1L
	DAA	R6H
	DAA	R6L
	DAA	R7H

	DAS	R0H
	DAS	R3L

	DEC.B	R1H
	DEC.B	R7L

	DEC.W	#1,R0
	DEC.W	#1,R7
	DEC.W	#1,E0
	DEC.W	#1,E7
	DEC.W	#2,R0
	DEC.W	#2,R7
	DEC.W	#2,E0
	DEC.W	#2,E7

	DEC.L	#1,ER0
	DEC.L	#1,ER7
	DEC.L	#2,ER0
	DEC.L	#2,ER7

	DEC	R1H
	DEC	R7L
	DEC	#1,R0
	DEC	#1,R7
	DEC	#1,E0
	DEC	#1,E7
	DEC	#2,R0
	DEC	#2,R7
	DEC	#2,E0
	DEC	#2,E7
	DEC	#1,ER0
	DEC	#1,ER7
	DEC	#2,ER0
	DEC	#2,ER7

	DIVXS.B R0H,R0
	DIVXS.B R4H,R2
	DIVXS.B R7L,R7
	DIVXS.B R0H,E0
	DIVXS.B R4H,E2
	DIVXS.B R7L,E7

	DIVXS.W R0,ER0
	DIVXS.W R2,ER1
	DIVXS.W R7,ER2
	DIVXS.W E0,ER3
	DIVXS.W E2,ER4
	DIVXS.W E7,ER7

	DIVXS	R0H,R0
	DIVXS	R4H,R2
	DIVXS	R7L,R7
	DIVXS	R0H,E0
	DIVXS	R4H,E2
	DIVXS	R7L,E7
	DIVXS	R0,ER0
	DIVXS	R2,ER1
	DIVXS	R7,ER2
	DIVXS	E0,ER3
	DIVXS	E2,ER4
	DIVXS	E7,ER7

	EEPMOV.B
	EEPMOV.W

	EXTS.W	R0
	EXTS.W	R7
	EXTS.W	E0
	EXTS.W	E7

	EXTS.L	ER0
	EXTS.L	ER7

	EXTS	R0
	EXTS	R7
	EXTS	E0
	EXTS	E7
	EXTS	ER0
	EXTS	ER7

	JMP	@ER0
	JMP	@ER1
	JMP	@ER2
	JMP	@ER4
	JMP	@ER7
	JMP	@aa24
	JMP	@aa24:24
	JMP	@@aa08
	JMP	@@aa08:8

	JSR	@ER0
	JSR	@ER1
	JSR	@ER4
	JSR	@ER5
	JSR	@ER6
	JSR	@ER7
	JSR	@aa24:24
	JSR	@aa24
	JSR	@@aa08
	JSR	@@aa08:8

	LDC.B	#xx08:8,CCR
	LDC.B	#xx08,CCR
	LDC.B	R0H,CCR
	LDC.B	R1H,CCR
	LDC.B	R7L,CCR

	LDC.W	@ER0,CCR
	LDC.W	@ER7,CCR
	LDC.W	@(dd16,ER0),CCR
	LDC.W	@(dd16,ER7),CCR
	LDC.W	@(dd16:16,ER0),CCR
	LDC.W	@(dd16:16,ER7),CCR
	LDC.W	@(dd24,ER0),CCR
	LDC.W	@(dd24,ER7),CCR
	LDC.W	@(dd24:24,ER0),CCR
	LDC.W	@(dd24:24,ER7),CCR
	LDC.W	@ER0+,CCR
	LDC.W	@ER7+,CCR
	LDC.W	@aa16,CCR
	LDC.W	@aa16:16,CCR
	LDC.W	@aa24,CCR
	LDC.W	@aa24:24,CCR

	LDC	#xx08:8,CCR
	LDC	#xx08,CCR
	LDC	R0H,CCR
	LDC	R1H,CCR
	LDC	R7L,CCR
	LDC	@ER0,CCR
	LDC	@ER7,CCR
	LDC	@(dd16,ER0),CCR
	LDC	@(dd16,ER7),CCR
	LDC	@(dd16:16,ER0),CCR
	LDC	@(dd16:16,ER7),CCR
	LDC	@(dd24,ER0),CCR
	LDC	@(dd24,ER7),CCR
	LDC	@(dd24:24,ER0),CCR
	LDC	@(dd24:24,ER7),CCR
	LDC	@ER0+,CCR
	LDC	@ER7+,CCR
	LDC	@aa16,CCR
	LDC	@aa16:16,CCR
	LDC	@aa24,CCR
	LDC	@aa24:24,CCR

	MOV.B	#xx08,R0H
	MOV.B	#xx08,R7L
	MOV.B	#xx08:8,R0H
	MOV.B	#xx08:8,R7L
	MOV.B	R0H,R7L
	MOV.B	R1H,R6L
	MOV.B	R2H,R5L
	MOV.B	R3H,R4L
	MOV.B	R4H,R3L
	MOV.B	R5H,R2L
	MOV.B	R6H,R1L
	MOV.B	R7H,R0L
	MOV.B	R0L,R7H
	MOV.B	R1L,R6H
	MOV.B	R2L,R5H
	MOV.B	R3L,R4H
	MOV.B	R4L,R3H
	MOV.B	R5L,R2H
	MOV.B	R6L,R1H
	MOV.B	R7L,R0H
	MOV.B	@ER0,R0H
	MOV.B	@ER0,R7L
	MOV.B	@ER7,R0H
	MOV.B	@ER7,R7L
	MOV.B	@(dd16,ER0),R0H
	MOV.B	@(dd16,ER7),R0H
	MOV.B	@(dd16,ER0),R7L
	MOV.B	@(dd16,ER7),R7L
	MOV.B	@(dd16:16,ER0),R0H
	MOV.B	@(dd16:16,ER7),R0H
	MOV.B	@(dd16:16,ER0),R7L
	MOV.B	@(dd16:16,ER7),R7L
	MOV.B	@(dd24,ER0),R0H
	MOV.B	@(dd24,ER7),R0H
	MOV.B	@(dd24,ER0),R7L
	MOV.B	@(dd24,ER7),R7L
	MOV.B	@(dd24:24,ER0),R0H
	MOV.B	@(dd24:24,ER7),R0H
	MOV.B	@(dd24:24,ER0),R7L
	MOV.B	@(dd24:24,ER7),R7L
	MOV.B	@ER0+,R0H
	MOV.B	@ER0+,R7L
	MOV.B	@ER7+,R0H
	MOV.B	@ER7+,R7L
	MOV.B	@aa08,R0H
	MOV.B	@aa08,R7L
	MOV.B	@aa08:8,R0H
	MOV.B	@aa08:8,R7L
	MOV.B	@aa16,R0H
	MOV.B	@aa16,R7L
	MOV.B	@aa16:16,R0H
	MOV.B	@aa16:16,R7L
	MOV.B	@aa24,R0H
	MOV.B	@aa24,R7L
	MOV.B	@aa24:24,R0H
	MOV.B	@aa24:24,R7L
	MOV.B	R6H,@ER2
	MOV.B	R0H,@ER4
	MOV.B	R1L,@ER7
	MOV.B	R5L,@ER7
	MOV.B	R7L,@ER7
	MOV.B	R5H,@(dd16,ER4)
	MOV.B	R0L,@(dd16,ER7)
	MOV.B	R4L,@(dd16,ER7)
	MOV.B	R4H,@(dd16:16,ER1)
	MOV.B	R6L,@(dd16:16,ER7)
	MOV.B	R7L,@(dd16:16,ER7)
	MOV.B	R5H,@(dd24,ER4)
	MOV.B	R0L,@(dd24,ER7)
	MOV.B	R4L,@(dd24,ER7)
	MOV.B	R4H,@(dd24:24,ER1)
	MOV.B	R6L,@(dd24:24,ER7)
	MOV.B	R7L,@(dd24:24,ER7)
	MOV.B	R0H,@-ER0
	MOV.B	R1H,@-ER0
	MOV.B	R2H,@-ER0
	MOV.B	R6H,@-ER7
	MOV.B	R7L,@-ER7
	MOV.B	R2L,@aa08
	MOV.B	R0H,@aa08:8
	MOV.B	R0L,@aa08:8
	MOV.B	R7L,@aa08:8
	MOV.B	R5L,@aa16:16
	MOV.B	R6H,@aa16
	MOV.B	R6L,@aa16:16
	MOV.B	R7L,@aa16:16
	MOV.B	R5L,@aa24:24
	MOV.B	R6H,@aa24
	MOV.B	R6L,@aa24:24
	MOV.B	R7L,@aa24:24

	MOV.W	#xx16,R0
	MOV.W	#xx16,E7
	MOV.W	#xx16:16,R0
	MOV.W	#xx16:16,E7
	MOV.W	R0,E7
	MOV.W	R1,E6
	MOV.W	R2,E5
	MOV.W	R3,E4
	MOV.W	R4,E3
	MOV.W	R5,E2
	MOV.W	R6,E1
	MOV.W	R7,E0
	MOV.W	E0,R7
	MOV.W	E1,R6
	MOV.W	E2,R5
	MOV.W	E3,R4
	MOV.W	E4,R3
	MOV.W	E5,R2
	MOV.W	E6,R1
	MOV.W	E7,R0
	MOV.W	@ER0,R0
	MOV.W	@ER0,E7
	MOV.W	@ER7,R0
	MOV.W	@ER7,E7
	MOV.W	@(dd16,ER0),R0
	MOV.W	@(dd16,ER7),R0
	MOV.W	@(dd16,ER0),E7
	MOV.W	@(dd16,ER7),E7
	MOV.W	@(dd16:16,ER0),R0
	MOV.W	@(dd16:16,ER7),R0
	MOV.W	@(dd16:16,ER0),E7
	MOV.W	@(dd16:16,ER7),E7
	MOV.W	@(dd24,ER0),R0
	MOV.W	@(dd24,ER7),R0
	MOV.W	@(dd24,ER0),E7
	MOV.W	@(dd24,ER7),E7
	MOV.W	@(dd24:24,ER0),R0
	MOV.W	@(dd24:24,ER7),R0
	MOV.W	@(dd24:24,ER0),E7
	MOV.W	@(dd24:24,ER7),E7
	MOV.W	@ER0+,R0
	MOV.W	@ER0+,E7
	MOV.W	@ER7+,R0
	MOV.W	@ER7+,E7
	MOV.W	@aa16,R0
	MOV.W	@aa16,E7
	MOV.W	@aa16:16,R0
	MOV.W	@aa16:16,E7
	MOV.W	@aa24,R0
	MOV.W	@aa24,E7
	MOV.W	@aa24:24,R0
	MOV.W	@aa24:24,E7
	MOV.W	R6,@ER2
	MOV.W	R0,@ER4
	MOV.W	R1,@ER7
	MOV.W	R5,@ER7
	MOV.W	R7,@ER7
	MOV.W	R5,@(dd16,ER4)
	MOV.W	R0,@(dd16,ER7)
	MOV.W	R4,@(dd16,ER7)
	MOV.W	R4,@(dd16:16,ER1)
	MOV.W	R6,@(dd16:16,ER7)
	MOV.W	R7,@(dd16:16,ER7)
	MOV.W	R0,@(dd24,ER0)
	MOV.W	R0,@(dd24,ER7)
	MOV.W	E7,@(dd24,ER0)
	MOV.W	E7,@(dd24,ER7)
	MOV.W	R0,@(dd24:24,ER0)
	MOV.W	R0,@(dd24:24,ER7)
	MOV.W	E7,@(dd24:24,ER0)
	MOV.W	E7,@(dd24:24,ER7)
	MOV.W	R0,@-ER0
	MOV.W	R1,@-ER0
	MOV.W	R2,@-ER0
	MOV.W	R6,@-ER7
	MOV.W	R7,@-ER7
	MOV.W	R5,@aa16:16
	MOV.W	R6,@aa16
	MOV.W	R6,@aa16:16
	MOV.W	R7,@aa16:16
	MOV.W	R0,@aa24
	MOV.W	E7,@aa24
	MOV.W	R0,@aa24:24
	MOV.W	E7,@aa24:24

	MOV.L	#xx32,ER0
	MOV.L	#xx32,ER7
	MOV.L	#xx32:32,ER0
	MOV.L	#xx32:32,ER7
	MOV.L	ER0,ER7
	MOV.L	ER1,ER6
	MOV.L	ER2,ER5
	MOV.L	ER3,ER4
	MOV.L	ER4,ER3
	MOV.L	ER5,ER2
	MOV.L	ER6,ER1
	MOV.L	ER7,ER0
	MOV.L	@ER0,ER0
	MOV.L	@ER0,ER7
	MOV.L	@ER7,ER0
	MOV.L	@ER7,ER7
	MOV.L	@(dd16,ER0),ER0
	MOV.L	@(dd16,ER7),ER0
	MOV.L	@(dd16,ER0),ER7
	MOV.L	@(dd16,ER7),ER7
	MOV.L	@(dd16:16,ER0),ER0
	MOV.L	@(dd16:16,ER7),ER0
	MOV.L	@(dd16:16,ER0),ER7
	MOV.L	@(dd16:16,ER7),ER7
	MOV.L	@(dd24,ER0),ER0
	MOV.L	@(dd24,ER7),ER0
	MOV.L	@(dd24,ER0),ER7
	MOV.L	@(dd24,ER7),ER7
	MOV.L	@(dd24:24,ER0),ER0
	MOV.L	@(dd24:24,ER7),ER0
	MOV.L	@(dd24:24,ER0),ER7
	MOV.L	@(dd24:24,ER7),ER7
	MOV.L	@ER0+,ER0
	MOV.L	@ER0+,ER7
	MOV.L	@ER7+,ER0
	MOV.L	@ER7+,ER7
	MOV.L	@aa16,ER0
	MOV.L	@aa16,ER7
	MOV.L	@aa16:16,ER0
	MOV.L	@aa16:16,ER7
	MOV.L	@aa24,ER0
	MOV.L	@aa24,ER7
	MOV.L	@aa24:24,ER0
	MOV.L	@aa24:24,ER7
	MOV.L	ER6,@ER2
	MOV.L	ER0,@ER4
	MOV.L	ER1,@ER7
	MOV.L	ER5,@ER7
	MOV.L	ER7,@ER7
	MOV.L	ER5,@(dd16,ER4)
	MOV.L	ER0,@(dd16,ER7)
	MOV.L	ER4,@(dd16:16,ER1)
	MOV.L	ER7,@(dd16:16,ER7)
	MOV.L	ER0,@(dd24,ER0)
	MOV.L	ER0,@(dd24,ER7)
	MOV.L	ER7,@(dd24,ER0)
	MOV.L	ER7,@(dd24,ER7)
	MOV.L	ER0,@(dd24:24,ER0)
	MOV.L	ER0,@(dd24:24,ER7)
	MOV.L	ER7,@(dd24:24,ER0)
	MOV.L	ER7,@(dd24:24,ER7)
	MOV.L	ER0,@-ER0
	MOV.L	ER1,@-ER0
	MOV.L	ER2,@-ER0
	MOV.L	ER6,@-ER7
	MOV.L	ER7,@-ER7
	MOV.L	ER5,@aa16:16
	MOV.L	ER6,@aa16
	MOV.L	ER6,@aa16:16
	MOV.L	ER7,@aa16:16
	MOV.L	ER0,@aa24
	MOV.L	ER7,@aa24
	MOV.L	ER0,@aa24:24
	MOV.L	ER7,@aa24:24

	MOV	#xx08,R0H
	MOV	#xx08,R7L
	MOV	#xx08:8,R0H
	MOV	#xx08:8,R7L
	MOV	R0H,R7L
	MOV	R1H,R6L
	MOV	R2H,R5L
	MOV	R3H,R4L
	MOV	R4H,R3L
	MOV	R5H,R2L
	MOV	R6H,R1L
	MOV	R7H,R0L
	MOV	R0L,R7H
	MOV	R1L,R6H
	MOV	R2L,R5H
	MOV	R3L,R4H
	MOV	R4L,R3H
	MOV	R5L,R2H
	MOV	R6L,R1H
	MOV	R7L,R0H
	MOV	@ER0,R0H
	MOV	@ER0,R7L
	MOV	@ER7,R0H
	MOV	@ER7,R7L
	MOV	@(dd16,ER0),R0H
	MOV	@(dd16,ER7),R0H
	MOV	@(dd16,ER0),R7L
	MOV	@(dd16,ER7),R7L
	MOV	@(dd16:16,ER0),R0H
	MOV	@(dd16:16,ER7),R0H
	MOV	@(dd16:16,ER0),R7L
	MOV	@(dd16:16,ER7),R7L
	MOV	@(dd24,ER0),R0H
	MOV	@(dd24,ER7),R0H
	MOV	@(dd24,ER0),R7L
	MOV	@(dd24,ER7),R7L
	MOV	@(dd24:24,ER0),R0H
	MOV	@(dd24:24,ER7),R0H
	MOV	@(dd24:24,ER0),R7L
	MOV	@(dd24:24,ER7),R7L
	MOV	@ER0+,R0H
	MOV	@ER0+,R7L
	MOV	@ER7+,R0H
	MOV	@ER7+,R7L
	MOV	@aa08,R0H
	MOV	@aa08,R7L
	MOV	@aa08:8,R0H
	MOV	@aa08:8,R7L
	MOV	@aa16,R0H
	MOV	@aa16,R7L
	MOV	@aa16:16,R0H
	MOV	@aa16:16,R7L
	MOV	@aa24,R0H
	MOV	@aa24,R7L
	MOV	@aa24:24,R0H
	MOV	@aa24:24,R7L
	MOV	R6H,@ER2
	MOV	R0H,@ER4
	MOV	R1L,@ER7
	MOV	R5L,@ER7
	MOV	R7L,@ER7
	MOV	R5H,@(dd16,ER4)
	MOV	R0L,@(dd16,ER7)
	MOV	R4L,@(dd16,ER7)
	MOV	R4H,@(dd16:16,ER1)
	MOV	R6L,@(dd16:16,ER7)
	MOV	R7L,@(dd16:16,ER7)
	MOV	R5H,@(dd24,ER4)
	MOV	R0L,@(dd24,ER7)
	MOV	R4L,@(dd24,ER7)
	MOV	R4H,@(dd24:24,ER1)
	MOV	R6L,@(dd24:24,ER7)
	MOV	R7L,@(dd24:24,ER7)
	MOV	R0H,@-ER0
	MOV	R1H,@-ER0
	MOV	R2H,@-ER0
	MOV	R6H,@-ER7
	MOV	R7L,@-ER7
	MOV	R2L,@aa08
	MOV	R0H,@aa08:8
	MOV	R0L,@aa08:8
	MOV	R7L,@aa08:8
	MOV	R5L,@aa16:16
	MOV	R6H,@aa16
	MOV	R6L,@aa16:16
	MOV	R7L,@aa16:16
	MOV	R5L,@aa24:24
	MOV	R6H,@aa24
	MOV	R6L,@aa24:24
	MOV	R7L,@aa24:24

	MOV	#xx16,R0
	MOV	#xx16,E7
	MOV	#xx16:16,R0
	MOV	#xx16:16,E7
	MOV	R0,E7
	MOV	R1,E6
	MOV	R2,E5
	MOV	R3,E4
	MOV	R4,E3
	MOV	R5,E2
	MOV	R6,E1
	MOV	R7,E0
	MOV	E0,R7
	MOV	E1,R6
	MOV	E2,R5
	MOV	E3,R4
	MOV	E4,R3
	MOV	E5,R2
	MOV	E6,R1
	MOV	E7,R0
	MOV	@ER0,R0
	MOV	@ER0,E7
	MOV	@ER7,R0
	MOV	@ER7,E7
	MOV	@(dd16,ER0),R0
	MOV	@(dd16,ER7),R0
	MOV	@(dd16,ER0),E7
	MOV	@(dd16,ER7),E7
	MOV	@(dd16:16,ER0),R0
	MOV	@(dd16:16,ER7),R0
	MOV	@(dd16:16,ER0),E7
	MOV	@(dd16:16,ER7),E7
	MOV	@(dd24,ER0),R0
	MOV	@(dd24,ER7),R0
	MOV	@(dd24,ER0),E7
	MOV	@(dd24,ER7),E7
	MOV	@(dd24:24,ER0),R0
	MOV	@(dd24:24,ER7),R0
	MOV	@(dd24:24,ER0),E7
	MOV	@(dd24:24,ER7),E7
	MOV	@ER0+,R0
	MOV	@ER0+,E7
	MOV	@ER7+,R0
	MOV	@ER7+,E7
	MOV	@aa16,R0
	MOV	@aa16,E7
	MOV	@aa16:16,R0
	MOV	@aa16:16,E7
	MOV	@aa24,R0
	MOV	@aa24,E7
	MOV	@aa24:24,R0
	MOV	@aa24:24,E7
	MOV	R6,@ER2
	MOV	R0,@ER4
	MOV	R1,@ER7
	MOV	R5,@ER7
	MOV	R7,@ER7
	MOV	R5,@(dd16,ER4)
	MOV	R0,@(dd16,ER7)
	MOV	R4,@(dd16,ER7)
	MOV	R4,@(dd16:16,ER1)
	MOV	R6,@(dd16:16,ER7)
	MOV	R7,@(dd16:16,ER7)
	MOV	R0,@(dd24,ER0)
	MOV	R0,@(dd24,ER7)
	MOV	E7,@(dd24,ER0)
	MOV	E7,@(dd24,ER7)
	MOV	R0,@(dd24:24,ER0)
	MOV	R0,@(dd24:24,ER7)
	MOV	E7,@(dd24:24,ER0)
	MOV	E7,@(dd24:24,ER7)
	MOV	R0,@-ER0
	MOV	R1,@-ER0
	MOV	R2,@-ER0
	MOV	R6,@-ER7
	MOV	R7,@-ER7
	MOV	R5,@aa16:16
	MOV	R6,@aa16
	MOV	R6,@aa16:16
	MOV	R7,@aa16:16
	MOV	R0,@aa24
	MOV	E7,@aa24
	MOV	R0,@aa24:24
	MOV	E7,@aa24:24

	MOV	#xx32,ER0
	MOV	#xx32,ER7
	MOV	#xx32:32,ER0
	MOV	#xx32:32,ER7
	MOV	ER0,ER7
	MOV	ER1,ER6
	MOV	ER2,ER5
	MOV	ER3,ER4
	MOV	ER4,ER3
	MOV	ER5,ER2
	MOV	ER6,ER1
	MOV	ER7,ER0
	MOV	@ER0,ER0
	MOV	@ER0,ER7
	MOV	@ER7,ER0
	MOV	@ER7,ER7
	MOV	@(dd16,ER0),ER0
	MOV	@(dd16,ER7),ER0
	MOV	@(dd16,ER0),ER7
	MOV	@(dd16,ER7),ER7
	MOV	@(dd16:16,ER0),ER0
	MOV	@(dd16:16,ER7),ER0
	MOV	@(dd16:16,ER0),ER7
	MOV	@(dd16:16,ER7),ER7
	MOV	@(dd24,ER0),ER0
	MOV	@(dd24,ER7),ER0
	MOV	@(dd24,ER0),ER7
	MOV	@(dd24,ER7),ER7
	MOV	@(dd24:24,ER0),ER0
	MOV	@(dd24:24,ER7),ER0
	MOV	@(dd24:24,ER0),ER7
	MOV	@(dd24:24,ER7),ER7
	MOV	@ER0+,ER0
	MOV	@ER0+,ER7
	MOV	@ER7+,ER0
	MOV	@ER7+,ER7
	MOV	@aa16,ER0
	MOV	@aa16,ER7
	MOV	@aa16:16,ER0
	MOV	@aa16:16,ER7
	MOV	@aa24,ER0
	MOV	@aa24,ER7
	MOV	@aa24:24,ER0
	MOV	@aa24:24,ER7
	MOV	ER6,@ER2
	MOV	ER0,@ER4
	MOV	ER1,@ER7
	MOV	ER5,@ER7
	MOV	ER7,@ER7
	MOV	ER5,@(dd16,ER4)
	MOV	ER0,@(dd16,ER7)
	MOV	ER4,@(dd16:16,ER1)
	MOV	ER7,@(dd16:16,ER7)
	MOV	ER0,@(dd24,ER0)
	MOV	ER0,@(dd24,ER7)
	MOV	ER7,@(dd24,ER0)
	MOV	ER7,@(dd24,ER7)
	MOV	ER0,@(dd24:24,ER0)
	MOV	ER0,@(dd24:24,ER7)
	MOV	ER7,@(dd24:24,ER0)
	MOV	ER7,@(dd24:24,ER7)
	MOV	ER0,@-ER0
	MOV	ER1,@-ER0
	MOV	ER2,@-ER0
	MOV	ER6,@-ER7
	MOV	ER7,@-ER7
	MOV	ER5,@aa16:16
	MOV	ER6,@aa16
	MOV	ER6,@aa16:16
	MOV	ER7,@aa16:16
	MOV	ER0,@aa24
	MOV	ER7,@aa24
	MOV	ER0,@aa24:24
	MOV	ER7,@aa24:24

	MOVFPE	@aa16,R0H
	MOVFPE	@aa16,R0L
	MOVFPE	@aa16,R7L
	MOVFPE	@aa16:16,R0H
	MOVFPE	@aa16:16,R0L
	MOVFPE	@aa16:16,R7L

	MOVTPE	R0H,@aa16
	MOVTPE	R0L,@aa16
	MOVTPE	R7L,@aa16
	MOVTPE	R0H,@aa16:16
	MOVTPE	R0L,@aa16:16
	MOVTPE	R7L,@aa16:16

	POP.W	R0
	POP.W	R6
	POP.W	E6

	POP.L	ER0
	POP.L	ER6

	POP	R0
	POP	R6
	POP	E6
	POP	ER0
	POP	ER6

	PUSH.W	R0
	PUSH.W	R6
	PUSH.W	E6

	PUSH.L	ER0
	PUSH.L	ER6

	PUSH	R0
	PUSH	R6
	PUSH	E6
	PUSH	ER0
	PUSH	ER6

	ROTL.B	R1H
	ROTL.B	R7L

	ROTL.W	R0
	ROTL.W	R7
	ROTL.W	E0
	ROTL.W	E7

	ROTL.L	ER0
	ROTL.L	ER7

	ROTL	R1H
	ROTL	R7L
	ROTL	R0
	ROTL	R7
	ROTL	E0
	ROTL	E7
	ROTL	ER0
	ROTL	ER7

	SLEEP

	STC.B	CCR,R0H
	STC.B	CCR,R1H
	STC.B	CCR,R7L

	STC.W	CCR,@ER0
	STC.W	CCR,@ER7
	STC.W	CCR,@(dd16,ER0)
	STC.W	CCR,@(dd16,ER7)
	STC.W	CCR,@(dd16:16,ER0)
	STC.W	CCR,@(dd16:16,ER7)
	STC.W	CCR,@(dd24,ER0)
	STC.W	CCR,@(dd24,ER7)
	STC.W	CCR,@(dd24:24,ER0)
	STC.W	CCR,@(dd24:24,ER7)
	STC.W	CCR,@-ER0
	STC.W	CCR,@-ER7
	STC.W	CCR,@aa16
	STC.W	CCR,@aa16:16
	STC.W	CCR,@aa24
	STC.W	CCR,@aa24:24

	STC	CCR,R0H
	STC	CCR,R1H
	STC	CCR,R7L
	STC	CCR,@ER0
	STC	CCR,@ER7
	STC	CCR,@(dd16,ER0)
	STC	CCR,@(dd16,ER7)
	STC	CCR,@(dd16:16,ER0)
	STC	CCR,@(dd16:16,ER7)
	STC	CCR,@(dd24,ER0)
	STC	CCR,@(dd24,ER7)
	STC	CCR,@(dd24:24,ER0)
	STC	CCR,@(dd24:24,ER7)
	STC	CCR,@-ER0
	STC	CCR,@-ER7
	STC	CCR,@aa16
	STC	CCR,@aa16:16
	STC	CCR,@aa24
	STC	CCR,@aa24:24

	TRAPA	#0:2
	TRAPA	#1:2
	TRAPA	#2:2
	TRAPA	#3:2
	TRAPA	#0
	TRAPA	#1
	TRAPA	#2
	TRAPA	#3
ZZZ:
	END

