;***************************************************************
;   Intel's 80251 microcontroller family has two operating
; modes, binary and source.  These are set when programming
; the device.  This file (E80251S.ASM) and table (80251S.TBL)
; are for the source mode.  Files E80251B.ASM and table
; 80251B.TBL are for the binary mode.

	CPU	"80251S.TBL"		;Processor
	HOF	"INT8"			;Hex format

;***************************************************************
;   To maintain source compatibility with the 8051, the carry
; flag is represented with a C within all mnemonics, not a CY
; as in the 80251 manuals.  This may be changed by the user by
; replacing all occurances of C, with CY, in the table.
;
;	ANL	C,/PSW.7

;***************************************************************
;   The PUSH immediate data instructions are written as:
;
;	PUSH	#data8
;	PUSH.W	#data16
;
; Note the .W on the word instruction.

;***************************************************************
;   Universal Cross-Assemblers has added two mnemonics for the
; 80251 family, CALL and JMP.	The assembler automatically uses
; the shortest of ACALL, LCALL and ECALL with the CALL mnemonic,
; and the shortest of SJMP, AJMP, LJMP and EJMP with the JMP
; mnemonic.

;***************************************************************
;   This is a list of specical function registers and bit names
; with their corresponding addresses.  These must be included
; in your source file to be used by the assembler.
;
;8xC251 Special Function Registers
;
ACC:	EQU	0E0H	;ACCUMULATOR
B:	EQU	0F0H	;B REGISTER
CCAP0H: EQU	0FAH	;PCA Module 0 Compare/Capture Register High Byte
CCAP0L: EQU	0EAH	;PCA Module 0 Compare/Capture Register Low Byte
CCAP1H: EQU	0FBH	;PCA Module 1 Compare/Capture Register High Byte
CCAP1L: EQU	0EBH	;PCA Module 1 Compare/Capture Register Low Byte
CCAP2H: EQU	0FCH	;PCA Module 2 Compare/Capture Register High Byte
CCAP2L: EQU	0ECH	;PCA Module 2 Compare/Capture Register Low Byte
CCAP3H: EQU	0FDH	;PCA Module 3 Compare/Capture Register High Byte
CCAP3L: EQU	0EDH	;PCA Module 3 Compare/Capture Register Low Byte
CCAP4H: EQU	0FEH	;PCA Module 4 Compare/Capture Register High Byte
CCAP4L: EQU	0EEH	;PCA Module 4 Compare/Capture Register Low Byte
CCAPM0: EQU	0DAH	;PCA Compare/Capture Module 0 Mode Register
CCAPM1: EQU	0DBH	;PCA Compare/Capture Module 1 Mode Register
CCAPM2: EQU	0DCH	;PCA Compare/Capture Module 2 Mode Register
CCAPM3: EQU	0DDH	;PCA Compare/Capture Module 3 Mode Register
CCAPM4: EQU	0DEH	;PCA Compare/Capture Module 4 Mode Register
CCON:	EQU	0D8H	;PCA Timer/Counter Control Register
CH:	EQU	0F9H	;PCA Timer/Counter High Byte
CL:	EQU	0E9H	;PCA Timer/Counter Low Byte
CMOD:	EQU	0D9H	;PCA Timer/Counter Mode Register
DPH:	EQU	083H	;Data Pointer High
DPL:	EQU	082H	;Data Pointer Low
DPXL:	EQU	084H	;Data Pointer Extended Low
IEC0:	EQU	0A8H	;Interrupt Enable Control Register 0
IPH0:	EQU	0B7H	;Interrupt Priority High Control Register 0
IPL0:	EQU	0B8H	;Interrupt Priority Low Control Register 0
P0:	EQU	080H	;Port 0
P1:	EQU	090H	;Port 1
P2:	EQU	0A0H	;Port 2
P3:	EQU	0B0H	;Port 3
PCON:	EQU	087H	;Power Control Register
PSW:	EQU	0D0H	;Program Status Word
PSW1:	EQU	0D1H	;Program Status Word 1
RCAP2H: EQU	0CBH	;Timer 2 Reload/Capture Register High Byte
RCAP2L: EQU	0CAH	;Timer 2 Reload/Capture Register Low Byte
SADDR:	EQU	0A9H	;Slave Individual Address Register
SADEN:	EQU	0B9H	;Mask Byte Register
SBUF:	EQU	099H	;Serial Data Buffer
SCON:	EQU	098H	;Serial Port Control Register
SP:	EQU	081H	;Stack Pointer - LS byte of SPX
SPH:	EQU	0BEH	;Stack Pointer High - MSB of SPX
T2CON:	EQU	0C8H	;Timer 2 Control Register
T2MOD:	EQU	0C9H	;Timer 2 Mode Control Register
TCON:	EQU	088H	;Timer 0/1 Control Register
TMOD:	EQU	089H	;Timer 0/1 Mode Control Register
TH0:	EQU	08CH	;Timer 0 Register High Byte
TL0:	EQU	08AH	;Timer 0 Register Low Byte
TH1:	EQU	08DH	;Timer 1 Register High Byte
TL1:	EQU	08BH	;Timer 1 Register Low Byte
TH2:	EQU	0CDH	;Timer 2 Register High Byte
TL2:	EQU	0CCH	;Timer 2 Register Low Byte
WDTRST: EQU	0A6H	;Watchdog Timer Reset Register
;
;MCS-51 INTERNAL BIT ADDRESSES
;
; For CCON (0D8H)
CCF0:	EQU	0D8H	;PCA Module Compare/Capture Flag 0
CCF1:	EQU	0D9H	;PCA Module Compare/Capture Flag 1
CCF2:	EQU	0DAH	;PCA Module Compare/Capture Flag 2
CCF3:	EQU	0DBH	;PCA Module Compare/Capture Flag 3
CCF4:	EQU	0DCH	;PCA Module Compare/Capture Flag 4
CR:	EQU	0DEH	;PCA Timer/Counter Run Control Bit
CF:	EQU	0DFH	;PCA Timer/Counter Overflow Flag
; For IE0 (0A8H)
EA:	EQU	0AFH	;Global Interrupt Enable
EC:	EQU	0AEH	;PCA Interrupt Enable
ET2:	EQU	0ADH	;Timer 2 Overflow Interrupt Enable
ES:	EQU	0ACH	;Serial I/O Interrupt Enable
ET1:	EQU	0ABH	;Timer 1 Overflow Interrupt Enable
EX1:	EQU	0AAH	;External Interrupt 1 Enable
ET0:	EQU	0A9H	;Timer 0 Overflow Interrupt Enable
EX0:	EQU	0A8H	;External Interrupt 0 Enable
; For PSW (0D0H)
CY:	EQU	0D7H	;Carry Flag
AC:	EQU	0D6H	;Auxiliary Carry Flag
F0:	EQU	0D5H	;User Flag 0
RS1:	EQU	0D4H	;Register Select MS bit
RS0:	EQU	0D3H	;Register Select LS bit
OV:	EQU	0D2H	;Overflow Flag
UD:	EQU	0D1H	;User-definable Flag
P:	EQU	0D0H	;Parity bit

PS:	EQU	0BCH	;PRIORITY SERIAL PORT
PT1:	EQU	0BBH	;PRIORITY TIMER 1
PX1:	EQU	0BAH	;PRIORITY EXTERNAL 1
PT0:	EQU	0B9H	;PRIORITY TIMER 0
PX0:	EQU	0B8H	;PRIORITY EXTERNAL 0
; For SCON (098H)
SM0:	EQU	09FH	;Serial Port Mode Bit 0
SM1:	EQU	09EH	;Serial Port Mode Bit 1
SM2:	EQU	09DH	;Serial Port Mode Bit 2
REN:	EQU	09CH	;Receiver Enable Bit
TB8:	EQU	09BH	;Transmit Bit 8
RB8:	EQU	09AH	;Receive Bit 8
TI:	EQU	099H	;Transmit Interrupt Flag Bit
RI:	EQU	098H	;Receive Interrupt Flag Bit
; For TCON (088H)
TF1:	EQU	08FH	;Timer 1 Overflow Flag
TR1:	EQU	08EH	;Timer 1 Run Control Bit
TF0:	EQU	08DH	;Timer 0 Overflow Flag
TR0:	EQU	08CH	;Timer 0 Run Control Bit
IE1:	EQU	08BH	;Interrupt 1 Flag
IT1:	EQU	08AH	;Interrupt 1 Type Control Bit
IE0:	EQU	089H	;Interrupt 0 Flag
IT0:	EQU	088H	;Interrupt 0 Type Control Bit
; For T2CON (0C8H)
TF2:	EQU	0CFH	;Timer 2 Overflow Flag
EXF2:	EQU	0CEH	;Timer 2 External Flag
RCLK:	EQU	0CDH	;Receive Clock Bit
TCLK:	EQU	0CCH	;Transmit Clock Bit
EXEN2:	EQU	0CBH	;Timer 2 External Enable Bit
TR2:	EQU	0CAH	;Timer 2 Run Control Bit
CT2:	EQU	0C9H	;Timer 2 Counter/Timer Select
CPRL2:	EQU	0C8H	;Capture/Reload Bit

;***************************************************************
;
RESET:	ORG	0000H
	JMP	START

;***************************************************************
;  All bit addresses may be specified in one of three ways:
;
	ORG	0200H
START:
	CLR	20H.1	;BIT ADDRESSABLE AREA
	CLR	CY	;BIT DIRECT ADDRESS
	CLR	PSW.7	;BIT ADDRESSABLE REG

;******************************************************
;   Examples of 80251 instructions are:

ABSOL	EQU	0580H
IMM8	EQU	-16
IMM16	EQU	-1024
DATA8	EQU	IMM8
DATA16	EQU	IMM16
DIRECT	EQU	80H
dir8	EQU	24H
DIR16	EQU	1234H
LONG	EQU	1234H
dis16	EQU	2345H
dis24	EQU	3456H

	ACALL	ABSOL

	ADD	A,R0
	ADD	A,dir8
	ADD	A,@R0
	ADD	A,#IMM8
	ADD	R15,R0
	ADD	WR30,WR0
	ADD	DR60,DR0
	ADD	R15,#data8
	ADD	WR30,#data16
	ADD	 R15,dir8
	ADD	WR30,dir8
	ADD	 R15,dir16
	ADD	WR30,dir16
	ADD	 R15,@WR0
	ADD	 R15,@DR0

	ADDC	A,R1
	ADDC	A,dir8
	ADDC	A,@R1
	ADDC	A,#IMM8

	AJMP	ABSOL

	ANL	A,R2
	ANL	A,dir8
	ANL	A,@R1
	ANL	A,#IMM8
	ANL	dir8  ,A
	ANL	dir8  ,#IMM8
	ANL	R14,R1
	ANL	WR28,WR2
	ANL	 R8,#data8
	ANL	WR16,#data16
	ANL	  R8,dir8
	ANL	WR16,dir8
	ANL	  R8,dir16
	ANL	WR16,dir16
	ANL	 R14,@WR2
	ANL	 R14,@DR4

	ANL	C,CY
	ANL	C,P0.5

	ANL	C,/CY
	ANL	C,/PSW.7
	ANL	C,/2AH.6

	CJNE	A,dir8	,$+42H
	CJNE	A,#IMM8,$+42H
	CJNE	R0,#IMM8,$+42H
	CJNE	@R0,#IMM8,$+42H

	CLR	A
	CLR	C
	CLR	CY
	CLR	PSW.7

	CMP	R13,R2
	CMP	WR24,WR6
	CMP	DR28,DR8
	CMP	 R8,#data8
	CMP	WR14,#data16
	CMP	 DR4,#-data16
	CMP	  R7,dir8
	CMP	WR14,dir8
	CMP	  R0,dir16
	CMP	WR30,dir16
	CMP	 R14,@WR2
	CMP	 R14,@DR4

	CPL	A
	CPL	C
	CPL	CY
	CPL	PSW.7

	DA	A

	DEC	A
	DEC	R4
	DEC	dir8
	DEC	@R1
	DEC	 R15,#1
	DEC	  R8,#2
	DEC	  R7,#4
	DEC	WR30,#1
	DEC	WR16,#2
	DEC	WR14,#4
	DEC	DR60,#2
	DEC	DR56,#4
	DEC	DR28,#1

	DIV	AB
	DIV	R14,R1
	DIV	WR28,WR2

	DJNZ	R0,$+42H
	DJNZ	dir8, $+42H

	ECALL	123456H
	ECALL	@DR56

	EJMP	123456H
	EJMP	@DR60

	ERET

	INC	A
	INC	R7
	INC	dir8
	INC	@R1
	INC	DPTR
	INC	 R15,#1
	INC	  R8,#2
	INC	  R7,#4
	INC	WR30,#1
	INC	WR16,#2
	INC	WR14,#4
	INC	DR60,#2
	INC	DR56,#4
	INC	DR28,#1

	JB	2AH.6,$+42H
	JB	PSW.7,$+42H
	JB	CY,$+42H

	JBC	2AH.6,$+42H
	JBC	PSW.7,$+42H
	JBC	CY,$+42H

	JC	$+42H
	JE	$+42H
	JG	$+42H
	JLE	$+42H

	JMP	@A+DPTR

	JNB	2AH.6,$+42H
	JNB	PSW.7,$+42H
	JNB	CY,$+42H

	JNC	$+42H
	JNE	$+42H
	JNZ	$+42H
	JSG	$+42H
	JSGE	$+42H
	JSL	$+42H
	JSLE	$+42H
	JZ	$+42H

	LCALL	LONG
	LCALL	@WR30

	LJMP	LONG
	LJMP	@WR30

	MOV	A,R7
	MOV	A,dir8
	MOV	A,@R1
	MOV	A,#IMM8
	MOV	R7,A
	MOV	R7,dir8
	MOV	R0,#IMM8
	MOV	dir8  ,A
	MOV	dir8  ,R7
	MOV	dir8  ,81H
	MOV	dir8  ,@R1
	MOV	dir8  ,#IMM8
	MOV	@R1,A
	MOV	@R0,dir8
	MOV	@R0,#IMM8
	MOV	DPTR,#IMM16

	MOV	 R0,R15
	MOV	WR30,WR0
	MOV	DR28,DR8
	MOV	R15,#data8
	MOV	WR16,#data16
	MOV	DR56,#-data16
	MOV	  R7,dir8
	MOV	WR16,dir8
	MOV	DR56,dir8
	MOV	  R8,dir16
	MOV	WR16,dir16
	MOV	DR56,dir16
	MOV	 R15,@WR0
	MOV	 R14,@WR2
	MOV	 R14,@DR4
	MOV	WR28,@WR2
	MOV	WR26,@DR4
	MOV	dir8,R4
	MOV	dir8,WR8
	MOV	dir8,DR12
	MOV	dir16,R12
	MOV	dir16,WR0
	MOV	dir16,WR4
	MOV	dir16,DR4
	MOV	 @WR4,R8
	MOV	 @DR4,R8
	MOV	 @WR0,WR12
	MOV	@DR12,WR0
	MOV	 R15,@WR0+dis16
	MOV	 R14,@WR2-dis16
	MOV	 R14,@DR4-dis24
	MOV	 R13,@DR8+dis24
	MOV	WR28,@WR2+dis16
	MOV	WR28,@DR8+dis24
	MOV	WR24,@DR12+dis24
	MOV	 @WR0+dis16,R12
	MOV	@DR12+dis24,R0
	MOV	 @WR8+dis16,WR4
	MOV	 @DR8+dis24,WR4
	MOV	C,2AH.6
	MOV	C,CY
	MOV	C,PSW.7
	MOV	2AH.6,C
	MOV	CY,C
	MOV	PSW.7,C

	MOVC	A,@A+DPTR
	MOVC	A,@A+PC

	MOVH	DR60,#data16

	MOVS	WR12,R0

	MOVZ	WR12,R0

	MOVX	A,@R0
	MOVX	A,@DPTR
	MOVX	@R0,A
	MOVX	@DPTR,A

	MUL	AB

	MUL	 R1,R14
	MUL	 WR0,WR30

	NOP

	ORL	A,R7
	ORL	A,dir8
	ORL	A,@R0
	ORL	A,@R1
	ORL	A,#IMM8
	ORL	dir8  ,A
	ORL	dir8  ,#IMM8
	ORL	 R0,R15
	ORL	WR30,WR0
	ORL	 R7,#data8
	ORL	 WR0,#data16
	ORL	 R15,dir8
	ORL	 WR0,dir8
	ORL	 R15,dir16
	ORL	 WR0,dir16
	ORL	 R15,@WR0
	ORL	  R2,@DR28

	ORL	C,CY
	ORL	C,2AH.6

	ORL	C,/CY
	ORL	C,/PSW.7

	POP	dir8
	POP	R15
	POP	WR30
	POP	 DR0

	PUSH	dir8
	PUSH	#data8
	PUSH.W	#data16
	PUSH	R15
	PUSH	WR30
	PUSH	 DR0

	RET
	RETI

	RL	A
	RLC	A

	RR	A
	RRC	A

	SETB	C
	SETB	2AH.6
	SETB	PSW.7

	SJMP	$+42H

	SLL	 R15
	SLL	 WR0

	SRA	 R15
	SRA	 WR0

	SRL	 R15
	SRL	 WR0

	SUB	R15,R0
	SUB	WR24,WR6
	SUB	DR28,DR8
	SUB	R15,#data8
	SUB	 WR0,#data16
	SUB	DR60,#data16
	SUB	  R0,dir8
	SUB	WR30,dir8
	SUB	  R0,dir16
	SUB	WR30,dir16
	SUB	  R0,@WR30
	SUB	 R15,@DR0

	SUBB	A,R7
	SUBB	A,dir8
	SUBB	A,@R1
	SUBB	A,#IMM8

	SWAP	A

	TRAP

	XCH	A,R7
	XCH	A,dir8
	XCH	A,@R1

	XCHD	A,@R0

	XRL	A,R7
	XRL	A,dir8
	XRL	A,@R1
	XRL	A,#IMM8
	XRL	dir8  ,A
	XRL	dir8  ,#IMM8
	XRL	R15,R0
	XRL	 WR0,WR30
	XRL	R15,#data8
	XRL	 WR0,#data16
	XRL	 R15,dir8
	XRL	 WR0,dir8
	XRL	 R15,dir16
	XRL	 WR0,dir16
	XRL	 R15,@WR0
	XRL	  R0,@DR60

	END
