;************************************************
;
; Z8002/4 EXAMPLE FILE
; THE Z8001/3 IS NOT SUPPORTED.
; SOME Z8000 INSTRUCTIONS FOLLOW
;
	CPU	"Z8002.TBL"
	HOF	"INT16"

D8:	EQU	-16
D16:	EQU	-1234
D32:	EQU	-12345678
PORT:	EQU	1234H
A16:	EQU	1234H
BIT:	EQU	5
NUM:	EQU	6

	ORG	1000H

	ADD	 R0,R15
	ADD	 R1,R14
	ADD	 R2,R13
	ADD	 R3,R12
	ADD	 R4,R11
	ADD	 R5,R10
	ADD	 R6,R9
	ADD	 R7,R8
	ADD	 R8,R7
	ADD	 R9,R6
	ADD	R10,R5
	ADD	R11,R4
	ADD	R12,R3
	ADD	R13,R2
	ADD	R14,R1
	ADD	R15,R0

	ADD	 R0,#D16
	ADD	 R1,#D16
	ADD	 R2,#D16
	ADD	 R3,#D16
	ADD	 R4,#D16
	ADD	 R5,#D16
	ADD	 R6,#D16
	ADD	 R7,#D16
	ADD	 R8,#D16
	ADD	 R9,#D16
	ADD	R10,#D16
	ADD	R11,#D16
	ADD	R12,#D16
	ADD	R13,#D16
	ADD	R14,#D16
	ADD	R15,#D16

	ADD	 R0,@R15
	ADD	 R1,@R14
	ADD	 R2,@R13
	ADD	 R3,@R12
	ADD	 R4,@R11
	ADD	 R5,@R10
	ADD	 R6,@R9
	ADD	 R7,@R8
	ADD	 R8,@R7
	ADD	 R9,@R6
	ADD	R10,@R5
	ADD	R11,@R4
	ADD	R12,@R3
	ADD	R13,@R2
	ADD	R14,@R1

	ADD	 R0,A16
	ADD	 R1,A16
	ADD	 R2,A16
	ADD	 R3,A16
	ADD	 R4,A16
	ADD	 R5,A16
	ADD	 R6,A16
	ADD	 R7,A16
	ADD	 R8,A16
	ADD	 R9,A16
	ADD	R10,A16
	ADD	R11,A16
	ADD	R12,A16
	ADD	R13,A16
	ADD	R14,A16
	ADD	R15,A16

	ADD	 R0,A16(R15)
	ADD	 R1,A16(R14)
	ADD	 R2,A16(R13)
	ADD	 R3,A16(R12)
	ADD	 R4,A16(R11)
	ADD	 R5,A16(R10)
	ADD	 R6,A16(R9)
	ADD	 R7,A16(R8)
	ADD	 R8,A16(R7)
	ADD	 R9,A16(R6)
	ADD	R10,A16(R5)
	ADD	R11,A16(R4)
	ADD	R12,A16(R3)
	ADD	R13,A16(R2)
	ADD	R14,A16(R1)

	ADDB	RH0,RL7
	ADDB	RH1,RL6
	ADDB	RH2,RL5
	ADDB	RH3,RL4
	ADDB	RH4,RL3
	ADDB	RH5,RL2
	ADDB	RH6,RL1
	ADDB	RH7,RL0
	ADDB	RL0,RH7
	ADDB	RL1,RH6
	ADDB	RL2,RH5
	ADDB	RL3,RH4
	ADDB	RL4,RH3
	ADDB	RL5,RH2
	ADDB	RL6,RH1
	ADDB	RL7,RH0

	ADDB	RH0,#D8
	ADDB	RH1,#D8
	ADDB	RH2,#D8
	ADDB	RH3,#D8
	ADDB	RH4,#D8
	ADDB	RH5,#D8
	ADDB	RH6,#D8
	ADDB	RH7,#D8
	ADDB	RL0,#D8
	ADDB	RL1,#D8
	ADDB	RL2,#D8
	ADDB	RL3,#D8
	ADDB	RL4,#D8
	ADDB	RL5,#D8
	ADDB	RL6,#D8
	ADDB	RL7,#D8

	ADDB	RH0,@R15
	ADDB	RH1,@R14
	ADDB	RH2,@R13
	ADDB	RH3,@R12
	ADDB	RH4,@R11
	ADDB	RH5,@R10
	ADDB	RH6,@R9
	ADDB	RH7,@R8
	ADDB	RL0,@R7
	ADDB	RL1,@R6
	ADDB	RL2,@R5
	ADDB	RL3,@R4
	ADDB	RL4,@R3
	ADDB	RL5,@R2
	ADDB	RL6,@R1

	ADDB	RH0,A16
	ADDB	RH1,A16
	ADDB	RH2,A16
	ADDB	RH3,A16
	ADDB	RH4,A16
	ADDB	RH5,A16
	ADDB	RH6,A16
	ADDB	RH7,A16
	ADDB	RL0,A16
	ADDB	RL1,A16
	ADDB	RL2,A16
	ADDB	RL3,A16
	ADDB	RL4,A16
	ADDB	RL5,A16
	ADDB	RL6,A16
	ADDB	RL7,A16

	ADDB	RH0,A16(R15)
	ADDB	RH1,A16(R14)
	ADDB	RH2,A16(R13)
	ADDB	RH3,A16(R12)
	ADDB	RH4,A16(R11)
	ADDB	RH5,A16(R10)
	ADDB	RH6,A16(R9)
	ADDB	RH7,A16(R8)
	ADDB	RL0,A16(R7)
	ADDB	RL1,A16(R6)
	ADDB	RL2,A16(R5)
	ADDB	RL3,A16(R4)
	ADDB	RL4,A16(R3)
	ADDB	RL5,A16(R2)
	ADDB	RL6,A16(R1)

	ADDL	 RR0,RR14
	ADDL	 RR2,RR12
	ADDL	 RR4,RR10
	ADDL	 RR6,RR8
	ADDL	 RR8,RR6
	ADDL	RR10,RR4
	ADDL	RR12,RR2
	ADDL	RR14,RR0

	ADDL	 RR0,#D32
	ADDL	 RR2,#D32
	ADDL	 RR4,#D32
	ADDL	 RR6,#D32
	ADDL	 RR8,#D32
	ADDL	RR10,#D32
	ADDL	RR12,#D32
	ADDL	RR14,#D32

	ADDL	 RR0,@R14
	ADDL	 RR2,@R12
	ADDL	 RR4,@R10
	ADDL	 RR6,@R8
	ADDL	 RR8,@R6
	ADDL	RR10,@R4
	ADDL	RR12,@R2
	ADDL	RR14,@R1

	ADDL	 RR0,A16
	ADDL	 RR2,A16
	ADDL	 RR4,A16
	ADDL	 RR6,A16
	ADDL	 RR8,A16
	ADDL	RR10,A16
	ADDL	RR12,A16
	ADDL	RR14,A16

	ADDL	 RR0,A16(R15)
	ADDL	 RR2,A16(R13)
	ADDL	 RR4,A16(R11)
	ADDL	 RR6,A16(R9)
	ADDL	 RR8,A16(R7)
	ADDL	RR10,A16(R5)
	ADDL	RR12,A16(R3)
	ADDL	RR14,A16(R1)

	CALL	@R15
	CALL	@R14
	CALL	@R13
	CALL	@R12
	CALL	@R5
	CALL	@R4
	CALL	@R3
	CALL	@R2
	CALL	@R1

	CALL	A16

	CALL	A16(R15)
	CALL	A16(R14)
	CALL	A16(R13)
	CALL	A16(R5)
	CALL	A16(R4)
	CALL	A16(R3)
	CALL	A16(R2)
	CALL	A16(R1)

	CALR	A16
	CALR	$+4098
	CALR	$-4092

	CLR	R15
	CLR	R14
	CLR	R13
	CLR	R5
	CLR	R4
	CLR	R3
	CLR	R2
	CLR	R1
	CLR	R0

	CLR	@R15
	CLR	@R14
	CLR	@R4
	CLR	@R3
	CLR	@R2
	CLR	@R1

	CLR	A16

	CLR	A16(R15)
	CLR	A16(R14)
	CLR	A16(R13)
	CLR	A16(R12)
	CLR	A16(R3)
	CLR	A16(R2)
	CLR	A16(R1)

	CLRB	RL7
	CLRB	RL6
	CLRB	RL5
	CLRB	RL4
	CLRB	RH4
	CLRB	RH3
	CLRB	RH2
	CLRB	RH1
	CLRB	RH0

	CLRB	@R15
	CLRB	@R14
	CLRB	@R3
	CLRB	@R2
	CLRB	@R1

	CLRB	A16

	CLRB	A16(R15)
	CLRB	A16(R14)
	CLRB	A16(R13)
	CLRB	A16(R4)
	CLRB	A16(R3)
	CLRB	A16(R2)
	CLRB	A16(R1)

	COMFLG	P
	COMFLG	S,P
	COMFLG	Z,S,P
	COMFLG	C,Z,S,P
	COMFLG	C,Z,S,V

	CPI	 R0,@R15, R0,F
	CPI	 R1,@R14, R1,LT
	CPI	 R2,@R13, R2,LE
	CPI	 R3,@R12, R3,ULE
	CPI	 R4,@R11, R4,OV
	CPI	 R5,@R10, R5,MI
	CPI	 R6,@R9 , R6,EQ
	CPI	 R7,@R8 , R7,C
	CPI	 R9,@R6 , R9,GE
	CPI	R10,@R5 ,R10,GT
	CPI	R11,@R4 ,R11,UGT
	CPI	R12,@R3 ,R12,NOV
	CPI	R13,@R2 ,R13,PL
	CPI	R14,@R1 ,R14,NE
	CPI	R15,@R1 ,R15,NC

	CPIB	RH0,@R15, R0,F
	CPIB	RH1,@R14, R1,LT
	CPIB	RH2,@R13, R2,LE
	CPIB	RH3,@R12, R3,ULE
	CPIB	RH4,@R11, R4,OV
	CPIB	RH5,@R10, R5,MI
	CPIB	RH6,@R9 , R6,EQ
	CPIB	RH7,@R8 , R7,C
	CPIB	RL0,@R7 , R8,T
	CPIB	RL1,@R6 , R9,GE
	CPIB	RL2,@R5 ,R10,GT
	CPIB	RL3,@R4 ,R11,UGT
	CPIB	RL4,@R3 ,R12,NOV
	CPIB	RL5,@R2 ,R13,PL
	CPIB	RL6,@R1 ,R14,NE
	CPIB	RL7,@R1 ,R15,NC

	CPIR	 R0,@R15, R0,F
	CPIR	 R1,@R14, R1,LT
	CPIR	 R2,@R13, R2,LE
	CPIR	 R3,@R12, R3,ULE
	CPIR	 R4,@R11, R4,OV
	CPIR	 R5,@R10, R5,MI
	CPIR	 R6,@R9 , R6,EQ
	CPIR	 R7,@R8 , R7,C
	CPIR	 R9,@R6 , R9,GE
	CPIR	R10,@R5 ,R10,GT
	CPIR	R11,@R4 ,R11,UGT
	CPIR	R12,@R3 ,R12,NOV
	CPIR	R13,@R2 ,R13,PL
	CPIR	R14,@R1 ,R14,NE
	CPIR	R15,@R1 ,R15,NC

	CPIRB	RH0,@R15, R0,F
	CPIRB	RH1,@R14, R1,LT
	CPIRB	RH2,@R13, R2,LE
	CPIRB	RH3,@R12, R3,ULE
	CPIRB	RH4,@R11, R4,PE
	CPIRB	RH5,@R10, R5,MI
	CPIRB	RH6,@R9 , R6,Z
	CPIRB	RH7,@R8 , R7,ULT
	CPIRB	RL1,@R6 , R9,GE
	CPIRB	RL2,@R5 ,R10,GT
	CPIRB	RL3,@R4 ,R11,UGT
	CPIRB	RL4,@R3 ,R12,PO
	CPIRB	RL5,@R2 ,R13,PL
	CPIRB	RL6,@R1 ,R14,NZ
	CPIRB	RL7,@R1 ,R15,UGE

	DI	VI
	DI	NVI
	DI	VI,NVI
	DI	NVI,VI

	DIV	 RR0,R15
	DIV	 RR2,R13
	DIV	 RR4,R11
	DIV	RR10,R5
	DIV	RR12,R3
	DIV	RR14,R1

	DIV	 RR0,#D16
	DIV	 RR2,#D16
	DIV	 RR4,#D16
	DIV	RR12,#D16
	DIV	RR14,#D16

	DIV	 RR0,@R14
	DIV	 RR2,@R12
	DIV	RR12,@R2
	DIV	RR14,@R1

	DIV	 RR0,A16
	DIV	 RR2,A16
	DIV	 RR4,A16
	DIV	RR12,A16
	DIV	RR14,A16

	DIV	 RR0,A16(R15)
	DIV	 RR2,A16(R13)
	DIV	RR10,A16(R5)
	DIV	RR12,A16(R3)
	DIV	RR14,A16(R1)

	DIVL	 RQ0,RR14
	DIVL	 RQ4,RR10
	DIVL	 RQ8,RR6
	DIVL	RQ12,RR2

	DIVL	 RQ0,#D32
	DIVL	 RQ4,#D32
	DIVL	 RQ8,#D32
	DIVL	RQ12,#D32

	DIVL	 RQ0,@R14
	DIVL	 RQ4,@R10
	DIVL	 RQ8,@R6
	DIVL	RQ12,@R2

	DIVL	 RQ0,A16
	DIVL	 RQ4,A16
	DIVL	 RQ8,A16
	DIVL	RQ12,A16

	DIVL	 RQ0,A16(R15)
	DIVL	 RQ4,A16(R11)
	DIVL	 RQ8,A16(R7)
	DIVL	RQ12,A16(R3)

	DJNZ	R15,$-252
	DJNZ	R14,$-250
	DJNZ	R13,$-248
	DJNZ	R3 ,$-252
	DJNZ	R2 ,$-252
	DJNZ	R1 ,$-252
	DJNZ	R0 ,$-252

	DBJNZ	RL7,$-252
	DBJNZ	RL6,$-250
	DBJNZ	RL5,$-248
	DBJNZ	RH2,$-252
	DBJNZ	RH1,$-252
	DBJNZ	RH0,$-252

	EI	VI
	EI	NVI
	EI	VI,NVI
	EI	NVI,VI

	HALT

	IN	 R0,@R15
	IN	 R1,@R14
	IN	 R2,@R13
	IN	 R9,@R6
	IN	R10,@R5
	IN	R11,@R4
	IN	R12,@R3
	IN	R15,@R1

	IN	 R0,PORT
	IN	 R1,PORT
	IN	 R2,PORT
	IN	R13,PORT
	IN	R14,PORT
	IN	R15,PORT

	SIN	 R0,PORT
	SIN	 R1,PORT
	SIN	 R2,PORT
	SIN	R12,PORT
	SIN	R13,PORT
	SIN	R14,PORT
	SIN	R15,PORT

	INB	RH0,@R15
	INB	RH1,@R14
	INB	RH2,@R13
	INB	RL4,@R3
	INB	RL5,@R2
	INB	RL6,@R1
	INB	RL7,@R1

	INB	RH0,PORT
	INB	RH1,PORT
	INB	RH2,PORT
	INB	RH3,PORT
	INB	RL4,PORT
	INB	RL5,PORT
	INB	RL6,PORT
	INB	RL7,PORT

	SINB	RH0,PORT
	SINB	RH1,PORT
	SINB	RL5,PORT
	SINB	RL6,PORT
	SINB	RL7,PORT

	JP	F  ,@R15
	JP	LT ,@R14
	JP	LE ,@R13
	JP	ULE,@R12
	JP	OV ,@R11
	JP	MI ,@R10
	JP	EQ ,@R9
	JP	C  ,@R8
	JP	    @R7
	JP	T  ,@R7
	JP	GE ,@R6
	JP	GT ,@R5
	JP	UGT,@R4
	JP	NOV,@R3
	JP	PL ,@R2
	JP	NE ,@R1
	JP	NC ,@R1

	JP	F  ,A16
	JP	LT ,A16
	JP	LE ,A16
	JP	ULE,A16
	JP	OV ,A16
	JP	MI ,A16
	JP	EQ ,A16
	JP	C  ,A16
	JP	    A16
	JP	T  ,A16
	JP	GE ,A16
	JP	GT ,A16
	JP	UGT,A16
	JP	NOV,A16
	JP	PL ,A16
	JP	NE ,A16
	JP	NC ,A16

	JP	F  ,A16(R15)
	JP	LT ,A16(R14)
	JP	LE ,A16(R13)
	JP	ULE,A16(R12)
	JP	OV ,A16(R11)
	JP	MI ,A16(R10)
	JP	EQ ,A16(R9 )
	JP	C  ,A16(R8 )
	JP	    A16(R7 )
	JP	T  ,A16(R7 )
	JP	GE ,A16(R6 )
	JP	GT ,A16(R5 )
	JP	UGT,A16(R4 )
	JP	NOV,A16(R3 )
	JP	PL ,A16(R2 )
	JP	NE ,A16(R1 )
	JP	NC ,A16(R1 )

R08:	JR	F  ,R08
	JR	LT ,R08
	JR	LE ,R08
	JR	ULE,R08
	JR	OV ,R08
	JR	MI ,R08
	JR	EQ ,R08
	JR	C  ,R08
	JR	    R08
	JR	T  ,R08
	JR	GE ,R08
	JR	GT ,R08
	JR	UGT,R08
	JR	NOV,R08
	JR	PL ,R08
	JR	NE ,R08
	JR	NC ,R08

	LD	 R0,R15
	LD	 R1,R14
	LD	 R2,R13
	LD	 R3,R12
	LD	 R4,R11
	LD	R14,R1
	LD	R15,R0

	LD	 R0,@R15
	LD	 R1,@R14
	LD	 R2,@R13
	LD	 R3,@R12
	LD	R12,@R3
	LD	R13,@R2
	LD	R14,@R1

	LD	 R0,A16
	LD	 R1,A16
	LD	 R2,A16
	LD	R13,A16
	LD	R14,A16
	LD	R15,A16

	LD	 R0,A16(R15)
	LD	 R1,A16(R14)
	LD	 R2,A16(R13)
	LD	R13,A16(R2)
	LD	R14,A16(R1)

	LD	 R0,R15(#D16)
	LD	 R1,R14(#D16)
	LD	 R2,R13(#D16)
	LD	R12, R3(#D16)
	LD	R13, R2(#D16)
	LD	R14, R1(#D16)

	LD	 R0,R15(R15)
	LD	 R1,R14(R14)
	LD	R13,R2 (R2 )
	LD	R14,R1 (R1 )

	LD	@ R1,R15
	LD	@ R1,R14
	LD	@ R2,R13
	LD	@R12,R3
	LD	@R13,R2
	LD	@R14,R1
	LD	@R15,R0

	LD	A16, R0
	LD	A16, R1
	LD	A16, R7
	LD	A16, R8
	LD	A16, R9
	LD	A16,R10
	LD	A16,R11
	LD	A16,R12
	LD	A16,R13
	LD	A16,R14
	LD	A16,R15

	LD	A16(R15), R0
	LD	A16(R14), R1
	LD	A16(R13), R2
	LD	A16(R12), R3
	LD	A16(R11), R4
	LD	A16( R2),R13
	LD	A16( R1),R14
	LD	A16( R1),R15

	LD	R15(#D16), R0
	LD	R14(#D16), R1
	LD	 R5(#D16),R10
	LD	 R4(#D16),R11
	LD	 R3(#D16),R12
	LD	 R2(#D16),R13
	LD	 R1(#D16),R14
	LD	 R1(#D16),R15

	LD	R15(R15), R0
	LD	R14(R14), R1
	LD	R13(R13), R2
	LD	R12(R12), R3
	LD	 R1( R1),R14
	LD	 R1( R0),R15

	LD	 R0,#D16
	LD	 R1,#D16
	LD	 R2,#D16
	LD	R13,#D16
	LD	R14,#D16
	LD	R15,#D16

	LD	@ R1,#D16
	LD	@ R1,#D16
	LD	@ R2,#D16
	LD	@R13,#D16
	LD	@R14,#D16
	LD	@R15,#D16

	LD	A16,#D16

	LD	A16(R15),#D16
	LD	A16(R14),#D16
	LD	A16(R13),#D16
	LD	A16( R3),#D16
	LD	A16( R2),#D16
	LD	A16( R1),#D16
	LD	A16( R1),#D16

	LDB	RH0,RL7
	LDB	RH1,RL6
	LDB	RH2,RL5
	LDB	RL4,RH3
	LDB	RL5,RH2
	LDB	RL6,RH1
	LDB	RL7,RH0

	LDB	RH0,@R15
	LDB	RH1,@R14
	LDB	RH2,@R13
	LDB	RL4,@R3
	LDB	RL5,@R2
	LDB	RL6,@R1

	LDB	RH0,A16
	LDB	RH1,A16
	LDB	RH2,A16
	LDB	RL3,A16
	LDB	RL4,A16
	LDB	RL5,A16
	LDB	RL6,A16
	LDB	RL7,A16

	LDB	RH0,A16(R15)
	LDB	RH1,A16(R14)
	LDB	RH2,A16(R13)
	LDB	RL3,A16(R4)
	LDB	RL4,A16(R3)
	LDB	RL5,A16(R2)
	LDB	RL6,A16(R1)

	LDB	RH0,R15(#D16)
	LDB	RH1,R14(#D16)
	LDB	RH2,R13(#D16)
	LDB	RL5, R2(#D16)
	LDB	RL6, R1(#D16)

	LDB	RH0,R15(R15)
	LDB	RH1,R14(R14)
	LDB	RH2,R13(R13)
	LDB	RL5,R2 (R2 )
	LDB	RL6,R1 (R1 )

	LDB	@ R1,RL7
	LDB	@ R1,RL6
	LDB	@ R2,RL5
	LDB	@ R3,RL4
	LDB	@R14,RH1
	LDB	@R15,RH0

	LDB	A16,RH0
	LDB	A16,RH1
	LDB	A16,RH2
	LDB	A16,RH3
	LDB	A16,RL4
	LDB	A16,RL5
	LDB	A16,RL6
	LDB	A16,RL7

	LDB	A16(R15),RH0
	LDB	A16(R14),RH1
	LDB	A16(R13),RH2
	LDB	A16( R2),RL5
	LDB	A16( R1),RL6
	LDB	A16( R1),RL7

	LDB	R15(#D16),RH0
	LDB	R14(#D16),RH1
	LDB	 R5(#D16),RL2
	LDB	 R4(#D16),RL3
	LDB	 R3(#D16),RL4
	LDB	 R2(#D16),RL5
	LDB	 R1(#D16),RL6
	LDB	 R1(#D16),RL7

	LDB	R15(R15),RH0
	LDB	R14(R14),RH1
	LDB	R13(R13),RH2
	LDB	 R4( R4),RL3
	LDB	 R3( R3),RL4
	LDB	 R2( R2),RL5
	LDB	 R1( R1),RL6
	LDB	 R1( R0),RL7

	LDB	RH0,#D8
	LDB	RH1,#D8
	LDB	RL4,#D8
	LDB	RL5,#D8
	LDB	RL6,#D8
	LDB	RL7,#D8

	LDB	@ R1,#D8
	LDB	@ R1,#D8
	LDB	@ R2,#D8
	LDB	@ R3,#D8
	LDB	@R15,#D8

	LDB	A16,#D8

	LDB	A16(R15),#D8
	LDB	A16(R14),#D8
	LDB	A16( R3),#D8
	LDB	A16( R2),#D8
	LDB	A16( R1),#D8
	LDB	A16( R1),#D8

	LDL	RR0,RR8
	LDL	RR2,RR6
	LDL	RR4,RR4
	LDL	RR6,RR2
	LDL	RR8,RR0

	LDL	RR0,@R15
	LDL	RR2,@R13
	LDL	RR4,@R11
	LDL	RR6,@R9
	LDL	RR8,@R7

	LDL	RR0,A16
	LDL	RR2,A16
	LDL	RR4,A16
	LDL	RR6,A16
	LDL	RR8,A16

	LDL	RR0,A16(R15)
	LDL	RR2,A16(R13)
	LDL	RR4,A16(R11)
	LDL	RR6,A16(R9)
	LDL	RR8,A16(R7)

	LDL	RR0,R15(#D16)
	LDL	RR2,R13(#D16)
	LDL	RR4,R11(#D16)
	LDL	RR6, R9(#D16)
	LDL	RR8, R7(#D16)

	LDL	RR0,R15(R15)
	LDL	RR2,R13(R13)
	LDL	RR4,R11(R11)
	LDL	RR6,R9 (R9 )
	LDL	RR8,R7 (R7 )

	LDL	@ R7,RR8
	LDL	@ R9,RR6
	LDL	@R11,RR4
	LDL	@R13,RR2
	LDL	@R15,RR0

	LDL	A16,RR0
	LDL	A16,RR2
	LDL	A16,RR4
	LDL	A16,RR6
	LDL	A16,RR8

	LDL	A16(R15),RR0
	LDL	A16(R13),RR2
	LDL	A16(R11),RR4
	LDL	A16( R9),RR6
	LDL	A16( R7),RR8

	LDL	R15(#D16),RR0
	LDL	R13(#D16),RR2
	LDL	R11(#D16),RR4
	LDL	 R9(#D16),RR6
	LDL	 R7(#D16),RR8

	LDL	R15(R15),RR0
	LDL	R13(R13),RR2
	LDL	R11(R11),RR4
	LDL	 R9( R9),RR6
	LDL	 R7( R7),RR8

	LDL	RR0,#D32
	LDL	RR2,#D32
	LDL	RR4,#D32
	LDL	RR6,#D32
	LDL	RR8,#D32

	LDA	 R0,A16
	LDA	 R1,A16
	LDA	R15,A16

	LDA	 R0,A16(R15)
	LDA	 R1,A16(R14)
	LDA	 R2,A16(R13)
	LDA	 R3,A16(R12)
	LDA	R14,A16(R1)

	LDA	 R0,R15(#D16)
	LDA	 R1,R14(#D16)
	LDA	 R2,R13(#D16)
	LDA	 R3,R12(#D16)
	LDA	R14, R1(#D16)

	LDA	 R0,R15(R15)
	LDA	 R1,R14(R14)
	LDA	 R2,R13(R13)
	LDA	R12,R3 (R3 )
	LDA	R13,R2 (R2 )
	LDA	R14,R1 (R1 )

	LDAR	R15,$-252
	LDAR	R14,$-250
	LDAR	R13,$-248
	LDAR	R12,$-32764
	LDAR	R2 ,$-252
	LDAR	R1 ,$-252
	LDAR	R0 ,$-252

	LDCTL	    FCW, R9
	LDCTL	REFRESH, R8
	LDCTL	PSAPOFF, R7
	LDCTL	   PSAP, R6
	LDCTL	 NSPOFF, R5
	LDCTL	    NSP, R4

	LDCTL	 R9,	FCW
	LDCTL	 R8,REFRESH
	LDCTL	 R7,PSAPOFF
	LDCTL	 R6,   PSAP
	LDCTL	 R5, NSPOFF
	LDCTL	 R4,	NSP

	LDCTLB	FLAGS,RH5
	LDCTLB	RL7,FLAGS

	LDD	@ R1,@R15, R0
	LDD	@ R1,@R14, R1
	LDD	@ R2,@R13, R2
	LDD	@R10,@R5 ,R10
	LDD	@R11,@R4 ,R11
	LDD	@R12,@R3 ,R12
	LDD	@R13,@R2 ,R13
	LDD	@R14,@R1 ,R14
	LDD	@R15,@R1 ,R15

	LDDB	@ R1,@R15, R0
	LDDB	@ R1,@R14, R1
	LDDB	@ R2,@R13, R2
	LDDB	@ R3,@R12, R3
	LDDB	@R11,@R4 ,R11
	LDDB	@R12,@R3 ,R12
	LDDB	@R13,@R2 ,R13
	LDDB	@R14,@R1 ,R14
	LDDB	@R15,@R1 ,R15

	LDDR	@ R1,@R15, R0
	LDDR	@ R1,@R14, R1
	LDDR	@ R2,@R13, R2
	LDDR	@R13,@R2 ,R13
	LDDR	@R14,@R1 ,R14
	LDDR	@R15,@R1 ,R15

	LDDRB	@ R1,@R15, R0
	LDDRB	@ R1,@R14, R1
	LDDRB	@ R2,@R13, R2
	LDDRB	@ R3,@R12, R3
	LDDRB	@R12,@R3 ,R12
	LDDRB	@R13,@R2 ,R13
	LDDRB	@R14,@R1 ,R14
	LDDRB	@R15,@R1 ,R15

	LDI	@ R1,@R15, R0
	LDI	@ R1,@R14, R1
	LDI	@ R2,@R13, R2
	LDI	@ R3,@R12, R3
	LDI	@ R4,@R11, R4
	LDI	@ R5,@R10, R5
	LDI	@ R6,@R9 , R6
	LDI	@ R7,@R8 , R7
	LDI	@R12,@R3 ,R12
	LDI	@R13,@R2 ,R13
	LDI	@R14,@R1 ,R14
	LDI	@R15,@R1 ,R15

	LDIB	@ R1,@R15, R0
	LDIB	@ R1,@R14, R1
	LDIB	@ R2,@R13, R2
	LDIB	@ R3,@R12, R3
	LDIB	@R11,@R4 ,R11
	LDIB	@R12,@R3 ,R12
	LDIB	@R13,@R2 ,R13
	LDIB	@R14,@R1 ,R14
	LDIB	@R15,@R1 ,R15

	LDIR	@ R1,@R15, R0
	LDIR	@ R1,@R14, R1
	LDIR	@ R2,@R13, R2
	LDIR	@R13,@R2 ,R13
	LDIR	@R14,@R1 ,R14
	LDIR	@R15,@R1 ,R15

	LDIRB	@ R1,@R15, R0
	LDIRB	@ R1,@R14, R1
	LDIRB	@ R2,@R13, R2
	LDIRB	@R11,@R4 ,R11
	LDIRB	@R12,@R3 ,R12
	LDIRB	@R13,@R2 ,R13
	LDIRB	@R14,@R1 ,R14
	LDIRB	@R15,@R1 ,R15

	LDK	 R0,#NUM
	LDK	 R1,#NUM
	LDK	R11,#NUM
	LDK	R12,#NUM
	LDK	R13,#NUM
	LDK	R14,#NUM
	LDK	R15,#NUM

	LDM	 R0,@R15,#6
	LDM	 R1,@R14,#6
	LDM	 R2,@R13,#6
	LDM	 R3,@R12,#6
	LDM	R12,@R3 ,#6
	LDM	R13,@R2 ,#6
	LDM	R14,@R1 ,#6
	LDM	R15,@R1 ,#6

	LDM	 R0,A16,#6
	LDM	 R1,A16,#6
	LDM	 R2,A16,#6
	LDM	R13,A16,#6
	LDM	R14,A16,#6
	LDM	R15,A16,#6

	LDM	 R0,A16(R15),#6
	LDM	 R1,A16(R14),#6
	LDM	R13,A16(R2) ,#6
	LDM	R14,A16(R1) ,#6
	LDM	R15,A16(R1) ,#6

	LDM	@R15, R0,#6
	LDM	@R14, R1,#6
	LDM	@R3 ,R12,#6
	LDM	@R2 ,R13,#6
	LDM	@R1 ,R14,#6
	LDM	@R1 ,R15,#6

	LDM	A16, R0,#6
	LDM	A16, R1,#6
	LDM	A16, R2,#6
	LDM	A16, R3,#6
	LDM	A16,R13,#6
	LDM	A16,R14,#6
	LDM	A16,R15,#6

	LDM	A16(R15), R0,#6
	LDM	A16(R14), R1,#6
	LDM	A16(R13), R2,#6
	LDM	A16(R3) ,R12,#6
	LDM	A16(R2) ,R13,#6
	LDM	A16(R1) ,R14,#6
	LDM	A16(R1) ,R15,#6

	LDPS	@R15
	LDPS	@R14
	LDPS	@R13
	LDPS	@R3
	LDPS	@R2
	LDPS	@R1

	LDPS	A16

	LDPS	A16(R15)
	LDPS	A16(R14)
	LDPS	A16(R13)
	LDPS	A16(R3)
	LDPS	A16(R2)
	LDPS	A16(R1)

	LDR	R15,$-252
	LDR	R14,$-250
	LDR	R13,$-248
	LDR	R12,$-32764
	LDR	R4 ,$-252
	LDR	R1 ,$-252
	LDR	R0 ,$-252

	LDR	$-252	,R15
	LDR	$-250	,R14
	LDR	$-248	,R13
	LDR	$-32764 ,R12
	LDR	$+32771 ,R11
	LDR	$-252	,R10
	LDR	$-252	,R1
	LDR	$-252	,R0

	LDRB	RL7,$-252
	LDRB	RL6,$-250
	LDRB	RH3,$-252
	LDRB	RH2,$-252
	LDRB	RH1,$-252
	LDRB	RH0,$-252

	LDRB	$-252	,RL7
	LDRB	$-250	,RL6
	LDRB	$-248	,RL5
	LDRB	$-252	,RH2
	LDRB	$-252	,RH1
	LDRB	$-252	,RH0

	LDRL	RR14,$-250
	LDRL	RR12,$-32764
	LDRL	RR10,$-252
	LDRL	RR4 ,$-252
	LDRL	RR2 ,$-252
	LDRL	RR0 ,$-252

	LDRL	$-250	,RR14
	LDRL	$-32764 ,RR12
	LDRL	$-252	,RR10
	LDRL	$-252	,RR2
	LDRL	$-252	,RR0

	MBIT

	MREQ	R15
	MREQ	R14
	MREQ	R13
	MREQ	R4
	MREQ	R3
	MREQ	R2
	MREQ	R1
	MREQ	R0

	MRES

	MSET

	MULT	 RR0,R15
	MULT	RR10,R5
	MULT	RR12,R3
	MULT	RR14,R1

	MULT	 RR0,#D16
	MULT	 RR2,#D16
	MULT	RR12,#D16
	MULT	RR14,#D16

	MULT	 RR0,@R14
	MULT	 RR2,@R12
	MULT	RR12,@R2
	MULT	RR14,@R1

	MULT	 RR0,A16
	MULT	 RR2,A16
	MULT	RR12,A16
	MULT	RR14,A16

	MULT	 RR0,A16(R15)
	MULT	 RR2,A16(R13)
	MULT	RR12,A16(R3)
	MULT	RR14,A16(R1)

	MULTL	 RQ0,RR14
	MULTL	 RQ8,RR6
	MULTL	RQ12,RR2

	MULTL	 RQ0,#D32
	MULTL	 RQ4,#D32
	MULTL	 RQ8,#D32
	MULTL	RQ12,#D32

	MULTL	 RQ0,@R14
	MULTL	 RQ4,@R10
	MULTL	 RQ8,@R6
	MULTL	RQ12,@R2

	MULTL	 RQ0,A16
	MULTL	 RQ4,A16
	MULTL	 RQ8,A16
	MULTL	RQ12,A16

	MULTL	 RQ0,A16(R15)
	MULTL	 RQ4,A16(R11)
	MULTL	 RQ8,A16(R7)
	MULTL	RQ12,A16(R3)

	END
