;***********************************************************
;
; THIS IS AN EXAMPLE PROGRAM FOR THE Z80 MICROPROCESSOR.
; IT IS TAKEN FROM PAGE 255 OF THE APRIL 5, 1984
; ISSUE OF EDN, AND AFTER ONLY FORMAT MODIFICATIONS,
; IT IS PASSED ON AS AN EXAMPLE, FREE OF
; CHARGE, BY UNIVERSAL CROSS-ASSEMBLERS.
;
	CPU		"Z80.TBL"	; CPU TABLE
	HOF		"INT8"		; HEX OUTPUT FORMAT
;
;***********************************************************
;
;  POLAR -- RECTANGULAR TO POLAR CONVERSION
;
;  AUTHOR:  HENRY WOLFSON
;           ELECTRO-OPTICAL SYSTEMS
;           MAHWAH, NJ
;
;
;  ENTER WITH IX = X
;             IY = Y
;
;  RETURN WITH DE = R = SQRT( X**2 + Y**2 )
;   AND        HL = ATAN ( Y/X ) IN RADIANS * 2 **( 15 )
;
;DURING PROCESSING THE REGISTERS USED ARE AS FOLLOWS:
;
;	B' = SHIFT CTR,  S
;	C' = STEP CTR
;	BC = CURRENT ENTRY FROM ARCTAN TABLE, POLTBL
;	DE = ANGLE ACCUMULATOR (ALGEBRAIC SUM OF BC )
;	HL = POINTER TO CURRENT ENTRY IN POLTBL
;	DE'= TEMP STG FOR X / 2**STEPCTR
;	HL'=		  Y / 2**STEPCTR
;
;
;	THE SUM OF THE SQUARES OF X AND Y MUST BE LESS
;	THAN 9B74 HEX.
;  Y IS A NORMAL TWO'S COMPLEMENT NR.
;  X MUST BE POS INTEGER,  LESS THAN 7FFF HEX
;
;***********************************************************
;
	ORG	0H		; RESET ORIGIN

POLAR:	LD	DE,0	;CLEAR ANGLE ACCUM
	LD	HL,POLTBL   ;SET TABLE PTR TO 1ST ENTRY
	EXX
	LD	C,0	;INITIALIZE STEP CTR = 0
;
; ****   MAIN LOOP STARTS HERE    ****
;
POLOOP:	PUSH	IX	;  DE' = X
	POP	DE	
	PUSH	IY	;  HL' = Y
	POP	HL
;SET SHIFT CTR = STEP CTR, THEN SHIFT DE' AND HL' RT S TIMES
	LD	B,C	; B' = C'      STEP CTR
	XOR	A
	CP	B
	JR	Z,POL002   ;BYPASS IF S = 0 (FIRST STEP)
POL001:	SRL	D	;SHIFT X AND Y RIGHT
	RR	E	;LOGICAL SHIFT FOR X
	SRA	H	;ARITHMETIC SHIFT FOR Y
	RR	L	
	DJNZ	POL001	;SHIFT UNTIL S = 0
POL002:	EXX		;GET TABLE ENTRY INTO BC
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	EXX
	BIT 	7,H	;TEST SIGN OF Y
	JR	Z,POLRCW   ;IF Y>0 THEN ROTATE CLOCKWISE
	EXX		;ELSE ROTATE CCW
	LD	A,E	;SUBT TABLE ENTRY FROM ANGLE ACCUM
	SUB	C	
	LD	E,A
	LD	A,D
	SBC	A,B
	LD	D,A	; DE = DE - BC
	EXX
	ADD	IY,DE	;  Y = Y + X/(2**(STEPCTR))
	CALL	CM2	;TWOS COMPL HL'
	EX	DE,HL
	ADD	IX,DE	;  X = X - Y/(2**(STEPCTR))
POL003:	INC	C	;NEXT STEP
	LD	A,C	;TEST STEP CTR = 15
	CP	15	
	JR	Z,POLOOP   ;LOOP BACK IF NOT 15
	LD	BC,(POLCON) ;ELSE FINISH UP
	PUSH	IX	;BC'= COS(45)*COS(26)*COS(14)....
	POP	DE	;DE' = X
	CALL	MUL	; DE' = DE' * BC'
	EXX
	PUSH	DE	;GET ACCUMULATED ANGLE
	EXX
	POP	HL		;  HL' = DE
	RET
POLRCW:	EXX		;FOR CW ROTATION, ADD TABLE ENTRY
			;TO ANGLE ACCUM
	EX	DE,HL	
	ADD	HL,BC
	EX	DE,HL	;  DE = DE + BC
	EXX
	EX	DE,HL
	ADD	IX,DE	; X = X + Y/(2**(STEPCTR))
	CALL	CM2	;  COMPLEMENT HL'
	EX	DE,HL
	ADD	IY,DE	;  Y = Y - X/(2**(STEPCTR))
	JR	POL003
;
;   DATA
;
POLCON:	DWL	39797	;(2**16)*COS(45)*COS(27)*COS(14)....
;
;  ARCTANGENT TABLE --- ATN(1/2**(N))  --- UNITS ARE
;		        RADIANS * 2 **(14)
;
POLTBL:	DWL	12868	; 0	45.00	DEG
	DWL	 7596	; 1	26.57
	DWL	 4014	; 2	14.04
	DWL	 2037	; 3	 7.13
	DWL	 1023	; 4	 3.58
	DWL	  512	; 5	 1.79
	DWL	  256	; 6	  .90
	DWL	  128	; 7	  .45
	DWL	   64	; 8	  .22
	DWL	   32	; 9	  .11
	DWL	   16   ;10	  .056
	DWL	    8   ;11	  .028
	DWL	    4	;12	  .014
	DWL	    2	;13	  .007
	DWL	    1	;14       .0035
;
;***********************************************************
;
;     MUL ---  TWO BYTE MULTIPLY --
;
;   ENTER WITH BC AND BE CONTAINING THE TWO 16 BIT
;   MULTIPLICANDS.
;
;   THE 32 BIT RESULT IS IN DE AND HL, DE IS MSW.
;   BC IS UNCHANGED.
;
;***********************************************************
;
MUL:	XOR	A	;CLEAR A AND CARRY FLAG
	LD 	H,A	;CLEAR PARTIAL PROD LSBS IN H AND L
	LD	L,A	
	LD	A,16	;SET LOOP CTR = 16
MUL1:	EX	DE,HL	;LEFTSHIFT DE WITH CARRY
	ADC	HL,HL
	EX	DE,HL
	JR	NC,MUL2		;ADD BC TO PARTIAL PROD
	ADD	HL,BC		;IF MSB OF DE WAS A 1
	JR	NC,MUL2		;INCREMENT DE IF HL MADE
	INC	DE		;A CARRY
MUL2:	DEC	A	;DECREMENT LOOP COUNTER
	RET	Z	;RETURN IF ZERO
	ADD	HL,HL	;LEFT SHIFT HL, THEN DE
	JR	MUL1
;
;
;***********************************************************
;
;   CM2  ---  SUBROUTINE TO TWOS COMPLEMENT A 2 BYTE
;	NUMBER IN HL
;
CM2:	LD	A,H
	CPL		;NOTICE ALTERNATE CPL FORMAT
	LD	H,A
	LD	A,L
	CPL
	LD	L,A
	INC	HL
	RET
;
	END
