;***********************************************************
;
;THIS IS AN EXAMPLE PROGRAM FOR THE Z8 MICROPROCESSOR.
;IT IS TAKEN FROM AN ARTICLE BY STEVE CIARCIA ON
;PAGE 120 & 122 OF THE OCTOBER 1984 ISSUE OF BYTE MAGAZINE,
;AND AFTER ONLY FORMAT MODIFICATIONS, IT IS
;PASSED ON AS AN EXAMPLE, FREE OF CHARGE, BY
;UNIVERSAL CROSS-ASSEMBLERS.

	HOF	"INT8"		;INTEL OUTPUT FORMAT
	CPU	"Z8.TBL"	;CPU TABLE

;THE ASSEMBLER WILL CHECK THAT ADRESSES FOR INSTRUCTIONS
;REQUIRING DOUBLE REGISTERS ARE EVEN, AND FLAG AN
;ASSEMBLY ERROR IF THEY ARE NOT.

;THE FOLLOWING IS A LIST OF Z8 REGISTER NAMES
;WITH THEIR CORRESPONDING ADRESSES.  THE USER
;MAY WISH TO INCLUDE THEM IN THEIR SOURCE FILE
;
SPL:	EQU	255		;STACK POINTER LOW
SPH:	EQU	254		;STACK POINTER HIGH
RP:	EQU	253		;REGISTER POINTER
FLAGS:	EQU	252		;PROGRAM CONTROL FLAGS
IMR:	EQU	251		;INTERRUPT MASK REGISTER
IRQ:	EQU	250		;INTERRUPT REQUEST REGISTER
IPR:	EQU	249		;INTERRUPT PRIORITY REGISTER
P01M:	EQU	248		;PORTS 0-1 MODE
P3M:	EQU	247		;PORT 3 MODE
P2M:	EQU	246		;PORT 2 MODE
PRE0:	EQU	245		;T0 PRESCALER LOAD
T0:	EQU	244		;TIMER/COUNTER 0 LOAD
PRE1:	EQU	243		;T1 PRESCALER LOAD
T1:	EQU	242		;TIMER/COUNTER 1 LOAD
TMR:	EQU	241		;TIMER MODE REGISTER
SIO:	EQU	240		;SERIAL I/O

P3:	EQU	003		;PORT 3
P2:	EQU	002		;PORT 2
P1:	EQU	001		;PORT 1
P0:	EQU	000		;PORT 0

;EXAMPLES OF Z8 INSTRUCTIONS FOLLOW:
;
	ORG	32		;PC AFTER RESET

	LD	R9,#IMM8	;9C80
	LD	R9,R3		;98E3
	LD	R9,GPR3 	;9823
	LD	GPR3,R9 	;9923
	LD	R9,@R11 	;E39B
	LD	@R9,R11 	;F39B
	LD	GPR1,GPR3	;E42301
	LD	R1,@GPR3	;E523E1
	LD	GPR1,@R3	;E5E301
	LD	GPR1,@GPR3	;E52301
	LD	GPR1,#IMM8	;E60180
	LD	@R1,#IMM8	;E7E180
	LD	@GPR1,#IMM8	;E70180
	LD	@R1,GPR3	;F523E1
	LD	@GPR1,R3	;F5E301
	LD	@GPR1,GPR3	;F52301
	LD	R9,IMM8(R11)	;C79B80
	LD	IMM8(R9),R11	;D7B980

	LDC	R9,@RR10	;C29A
	LDC	@RR8,R11	;D2B8

	LDCI	@R9,@RR10	;C39A
	LDCI	@RR8,@R7	;D378

	LDE	R9,@RR10	;829A
	LDE	@RR8,R11	;92B8

	LDEI	@R9,@RR10	;839A
	LDEI	@RR8,@R7	;9378

	NOP			;FF

	OR	R9,R11		;429B
	OR	R9,@R11 	;439B
	OR	R1,GPR3 	;4423E1
	OR	GPR1,R3 	;44E301
	OR	GPR1,GPR3	;442301
	OR	R1,@GPR3	;4523E1
	OR	GPR1,@R3	;45E301
	OR	GPR1,@GPR3	;452301
	OR	R1,#IMM8	;46E180
	OR	GPR1,#IMM8	;460180
	OR	@R1,#IMM8	;47E180
	OR	@GPR1,#IMM8	;470180

	POP	R3		;50E3
	POP	GPR3		;5023
	POP	@R3		;51E3
	POP	@GPR3		;5123

GPR1:	EQU	01H		;GENERAL PURPOSE REG 1
GPR3:	EQU	23H		;GENERAL PURPOSE REG 3
GPR4:	EQU	24H		;GENERAL PURPOSE REG 4
IMM8:	EQU	80H		;8 BIT IMMEDIATE

;***********************************************************
;
; Z8 VERSION RANGE-FINDER ROUTINES
;
; DRIVE INIT LINE AND SET UP CLOCKS
;
	ORG	1500H
INIT:	EQU	$
	DI			;SHUT DOWN INTERRUPTS
	OR	IMR,#20H	;ENABLE IRQ 5 (TIMER 1)
	LD	02H,#02 	;TURN ON INIT LINE
	OR	TMR,#0CH	;LOAD AND START TIMER 1
	EI			;ENABLE INTERRUPTS
	RET			;RETURN TO BASIC
;
;
; THIS IS THE INTERRUPT-DRIVEN RANGING ROUTINE
;
;
RANGE:	EQU	$
	INC	30H		;ADD 1 TO PERIOD COUNTER
	JR	NZ,ECHO 	;IF NO WRAP, CHECK ECHO
	LD	30H,#0FFH	;SET COUNT TO %FF
	JR	DONE		;AND SHUT DOWN RANGE ROUTINE
ECHO:	EQU	$
	TM	02H,#01 	;IS ECHO BIT ON?
	JR	Z,EXIT		;NO, LET ANOTHER PASS OCCUR
DONE:	EQU	$
	LD	31H,#0FFH	;TURN ON DONE FLAG
	AND	TMR,#0F3H	;TURN OFF T1 TIMER
	AND	IMR,#1FH	;DISABLE IRQ 5 INTERRUPT
	LD	02H,#0		;SHUT OFF INIT LINE
EXIT:	EQU	$
	IRET			;RETURN FROM INTERRUPT
;
;END OF MACHINE-LANGUAGE ROUTINES
;
ZZZZ:	EQU	$

	END

