;**************************************************************
;
;   The Z380 table supports all instructions defined in the
; Z380 User's Manual.  I/O addresses for specific Z380
; microcontrollers may have to be added by the user with equate
; directives.
;
	CPU	"Z380.TBL"	;CPU TABLE
	HOF	"INT8"		;HEX FORMAT
	ORG	1000H		;ORIGIN

;   Many Z380 instructions may be written by including an
; optional A, HL, or W in the text.  These are shown
; surrounded with square brackets [] in the User's Manual.
; Cross-32 supports both formats of these instructions.
; Several examples are:
	CP	  (HL)		;BE
	CP	A,(HL)		;BE
	ADDW	   BC		;ED84
	ADDW	HL,BC		;ED84
	LD	(IX+12H),BC	;DDCB120B
	LDW	(IX+12H),BC	;DDCB120B

;   After reset, the Z380 is in Native mode and Word mode.
; It may be placed in Extended mode with the "SETC XM"
; instruction.	Although Extended mode affects the operation
; and validity of many instructions, it does not affect the way
; they are assembled.  Cross-32 does not prevent the user from
; using any instruction at any time.  If the user wishes to
; write pure Native mode software, they may wish to use the Z80
; table.
;   Likewise, the Z380 may be switched between Word mode and
; Long Word mode with the "SETC LW" and "RESC LW" instructions.
; Although Long Word mode affects the operation and validity of
; many instructions, it does not affect the way they are
; assembled.  Cross-32 does not prevent the user from using any
; instruction at any time.  If the user wishes to write pure
; Word mode software, they may wish to use the Z80 table.
; Cross-32 does not check the validity of the instruction the
; user chooses.

;   The Z380 uses a decoder directive to fetch an additional
; byte or word of immediate data or address.  In addition to
; specifying the decoder directive (DDIR), the user must add
; a IB for or IW to each instruction.  Many examples follow:
;
; Table E-1: Valid with DDIR IB in Extended mode.
;
	SETC	XM
	DDIR	IB
	ADDIB	HL,(123456H)
	DDIR	IB
	ADDIB	SP,123456H
	DDIR	IB
	CALLIB	123456H
	DDIR	IB
	CALLIB	C,123456H
	DDIR	IB
	CALLIB	M,123456H
	DDIR	IB
	CALLIB	NC,123456H
	DDIR	IB
	CALLIB	NZ,123456H
	DDIR	IB
	CALLIB	P,123456H
	DDIR	IB
	CALLIB	PE,123456H
	DDIR	IB
	CALLIB	V,123456H
	DDIR	IB
	CALLIB	PO,123456H
	DDIR	IB
	CALLIB	NV,123456H
	DDIR	IB
	CALLIB	Z,123456H
	DDIR	IB
	JPIB	123456H
	DDIR	IB
	JPIB	C,123456H
	DDIR	IB
	JPIB	M,123456H
	DDIR	IB
	JPIB	NC,123456H
	DDIR	IB
	JPIB	NS,123456H
	DDIR	IB
	JPIB	NV,123456H
	DDIR	IB
	JPIB	NZ,123456H
	DDIR	IB
	JPIB	P,123456H
	DDIR	IB
	JPIB	PE,123456H
	DDIR	IB
	JPIB	PO,123456H
	DDIR	IB
	JPIB	S,123456H
	DDIR	IB
	JPIB	V,123456H
	DDIR	IB
	JPIB	Z,123456H
	DDIR	IB
	SUBIB	HL,(123456H)
	DDIR	IB
	SUBIB	SP,123456H

; Table E-5: Valid with DDIR IW in Extended mode.
;
	SETC	XM
	DDIR	IW
	ADDIW	HL,(12345678H)
	DDIR	IW
	ADDIW	SP,12345678H
	DDIR	IW
	CALLIW	12345678H
	DDIR	IW
	CALLIW	C,12345678H
	DDIR	IW
	CALLIW	M,12345678H
	DDIR	IW
	CALLIW	NC,12345678H
	DDIR	IW
	CALLIW	NZ,12345678H
	DDIR	IW
	CALLIW	P,12345678H
	DDIR	IW
	CALLIW	PE,12345678H
	DDIR	IW
	CALLIW	V,12345678H
	DDIR	IW
	CALLIW	PO,12345678H
	DDIR	IW
	CALLIW	NV,12345678H
	DDIR	IW
	CALLIW	Z,12345678H
	DDIR	IW
	JPIW	12345678H
	DDIR	IW
	JPIW	C,12345678H
	DDIR	IW
	JPIW	M,12345678H
	DDIR	IW
	JPIW	NC,12345678H
	DDIR	IW
	JPIW	NS,12345678H
	DDIR	IW
	JPIW	NV,12345678H
	DDIR	IW
	JPIW	NZ,12345678H
	DDIR	IW
	JPIW	P,12345678H
	DDIR	IW
	JPIW	PE,12345678H
	DDIR	IW
	JPIW	PO,12345678H
	DDIR	IW
	JPIW	S,12345678H
	DDIR	IW
	JPIW	V,12345678H
	DDIR	IW
	JPIW	Z,12345678H
	DDIR	IW
	SUBIW	HL,(12345678H)
	DDIR	IW
	SUBIW	SP,12345678H

; Some additional examples of Z380 instructions follow:
;
	ADD	A,(HL)
	ADD	A,(IX+12H)
	ADD	A,(IY+12H)
	ADD	A,12H
	ADD	A,A
	ADD	A,B
	ADD	A,C
	ADD	A,D
	ADD	A,E
	ADD	A,H
	ADD	A,IXL
	ADD	A,IXU
	ADD	A,IYL
	ADD	A,IYU
	ADD	A,L
	ADD	HL,(1234H)
	ADD	HL,BC
	ADD	HL,DE
	ADD	HL,HL
	ADD	HL,SP
	ADD	IX,BC
	ADD	IX,DE
	ADD	IX,IX
	ADD	IX,SP
	ADD	IY,BC
	ADD	IY,DE
	ADD	IY,IY
	ADD	IY,SP
	ADD	SP,1234H

	ADDW	(IX+12H)
	ADDW	(IY+12H)
	ADDW	1234H
	ADDW	BC
	ADDW	DE
	ADDW	HL
	ADDW	HL,(IX+12H)
	ADDW	HL,(IY+12H)
	ADDW	HL,1234H
	ADDW	HL,BC
	ADDW	HL,DE
	ADDW	HL,HL
	ADDW	HL,IX
	ADDW	HL,IY
	ADDW	IX
	ADDW	IY

	BIT	0,(HL)
	BIT	0,(IX+12H)
	BIT	0,(IY+12H)
	BIT	0,A
	BIT	0,B
	BIT	0,C
	BIT	0,D
	BIT	0,E
	BIT	0,H
	BIT	0,L
	BIT	1,(HL)
	BIT	1,(IX+12H)
	BIT	1,(IY+12H)
	BIT	1,A
	BIT	1,B
	BIT	1,C
	BIT	1,D
	BIT	1,E
	BIT	1,H
	BIT	1,L
	BIT	2,(HL)
	BIT	2,(IX+12H)
	BIT	2,(IY+12H)
	BIT	2,A
	BIT	2,B
	BIT	2,C
	BIT	2,D
	BIT	2,E
	BIT	2,H
	BIT	2,L
	BIT	3,(HL)
	BIT	3,(IX+12H)
	BIT	3,(IY+12H)
	BIT	3,A
	BIT	3,B
	BIT	3,C
	BIT	3,D
	BIT	3,E
	BIT	3,H
	BIT	3,L
	BIT	4,(HL)
	BIT	4,(IX+12H)
	BIT	4,(IY+12H)
	BIT	4,A
	BIT	4,B
	BIT	4,C
	BIT	4,D
	BIT	4,E
	BIT	4,H
	BIT	4,L
	BIT	5,(HL)
	BIT	5,(IX+12H)
	BIT	5,(IY+12H)
	BIT	5,A
	BIT	5,B
	BIT	5,C
	BIT	5,D
	BIT	5,E
	BIT	5,H
	BIT	5,L
	BIT	6,(HL)
	BIT	6,(IX+12H)
	BIT	6,(IY+12H)
	BIT	6,A
	BIT	6,B
	BIT	6,C
	BIT	6,D
	BIT	6,E
	BIT	6,H
	BIT	6,L
	BIT	7,(HL)
	BIT	7,(IX+12H)
	BIT	7,(IY+12H)
	BIT	7,A
	BIT	7,B
	BIT	7,C
	BIT	7,D
	BIT	7,E
	BIT	7,H
	BIT	7,L

	BTEST

	CALL	1234H
	CALL	C,1234H
	CALL	M,1234H
	CALL	NC,1234H
	CALL	NZ,1234H
	CALL	P,1234H
	CALL	PE,1234H
	CALL	V,1234H
	CALL	PO,1234H
	CALL	NV,1234H
	CALL	Z,1234H

	CALR	$+12345BH
	CALR	$+1238H
	CALR	$+15H
	CALR	C,$+12345BH
	CALR	C,$+1238H
	CALR	C,$+15H
	CALR	M,$+12345BH
	CALR	M,$+1238H
	CALR	M,$+15H
	CALR	NC,$+12345BH
	CALR	NC,$+1238H
	CALR	NC,$+15H
	CALR	NZ,$+12345BH
	CALR	NZ,$+1238H
	CALR	NZ,$+15H
	CALR	P,$+12345BH
	CALR	P,$+1238H
	CALR	P,$+15H
	CALR	PE,$+12345BH
	CALR	PE,$+1238H
	CALR	PE,$+15H
	CALR	PO,$+12345BH
	CALR	PO,$+1238H
	CALR	PO,$+15H
	CALR	Z,$+12345BH
	CALR	Z,$+1238H
	CALR	Z,$+15H

	CCF

	CPD

	CPDR

	CPI

	CPIR

	CPL	A
	CPL

	CPLW	HL
	CPLW

	DAA

	DDIR	IB
	DDIR	IB,LW
	DDIR	IB,W
	DDIR	IW
	DDIR	IW,LW
	DDIR	IW,W
	DDIR	LW
	DDIR	W

	DEC	(HL)
	DEC	(IX+12H)
	DEC	(IY+12H)
	DEC	A
	DEC	B
	DEC	BC
	DEC	C
	DEC	D
	DEC	DE
	DEC	E
	DEC	H
	DEC	HL
	DEC	IX
	DEC	IXL
	DEC	IXU
	DEC	IY
	DEC	IYL
	DEC	IYU
	DEC	L
	DEC	SP

	DECW	BC
	DECW	DE
	DECW	HL
	DECW	IX
	DECW	IY
	DECW	SP

	DI	1FH
	DI

	DIVUW	(IX+12H)
	DIVUW	(IY+12H)
	DIVUW	1234H
	DIVUW	BC
	DIVUW	DE
	DIVUW	HL
	DIVUW	HL,(IX+12H)
	DIVUW	HL,(IY+12H)
	DIVUW	HL,1234H
	DIVUW	HL,BC
	DIVUW	HL,DE
	DIVUW	HL,HL
	DIVUW	HL,IX
	DIVUW	HL,IY
	DIVUW	IX
	DIVUW	IY

	DJNZ	$+12345BH
	DJNZ	$+1238H
	DJNZ	$+14H

	EI	1FH
	EI

	EX	(SP),HL
	EX	(SP),IX
	EX	(SP),IY
	EX	A,(HL)
	EX	A,A
	EX	A,A'
	EX	A,B
	EX	A,C
	EX	A,D
	EX	A,E
	EX	A,H
	EX	A,L
	EX	AF,AF'
	EX	B,B'
	EX	BC,BC'
	EX	BC,DE
	EX	BC,HL
	EX	BC,IX
	EX	BC,IY
	EX	C,C'
	EX	D,D'
	EX	DE,DE'
	EX	DE,HL
	EX	DE,IX
	EX	DE,IY
	EX	E,E'
	EX	H,H'
	EX	HL,HL'
	EX	HL,IX
	EX	HL,IY
	EX	IX,IX'
	EX	IX,IY
	EX	IY,IY'
	EX	L,L'

	EXALL

	EXTS	A
	EXTS

	EXTSW	HL
	EXTSW

	EXX

	EXXX

	EXXY

	HALT

	IM	0
	IM	1
	IM	2
	IM	3

	IN	A,(12H)
	IN	A,(C)
	IN	B,(C)
	IN	C,(C)
	IN	D,(C)
	IN	E,(C)
	IN	H,(C)
	IN	L,(C)

	IN0	(12H)
	IN0	A,(12H)
	IN0	B,(12H)
	IN0	C,(12H)
	IN0	D,(12H)
	IN0	E,(12H)
	IN0	H,(12H)
	IN0	L,(12H)

	INA	A,(1234H)
	INAW	HL,(1234H)

	IND
	INDR
	INDRW
	INDW

	INI
	INIR
	INIRW
	INIW
	INW	BC,(C)
	INW	DE,(C)
	INW	HL,(C)

	JP	(HL)
	JP	(IX)
	JP	(IY)
	JP	1234H
	JP	C,1234H
	JP	M,1234H
	JP	NC,1234H
	JP	NZ,1234H
	JP	NS,1234H
	JP	NV,1234H
	JP	P,1234H
	JP	PE,1234H
	JP	PO,1234H
	JP	S,1234H
	JP	V,1234H
	JP	Z,1234H

	JR	$+12345BH
	JR	$+1238H
	JR	$+14H

	JR	C,$+12345BH
	JR	C,$+1238H
	JR	C,$+14H
	JR	NC,$+12345BH
	JR	NC,$+1238H
	JR	NC,$+14H
	JR	NZ,$+12345BH
	JR	NZ,$+1238H
	JR	NZ,$+14H
	JR	Z,$+12345BH
	JR	Z,$+1238H
	JR	Z,$+14H

	LD	B,(HL)
	LD	B,(IX+12H)
	LD	B,(IY+12H)
	LD	B,12H
	LD	B,A
	LD	B,B
	LD	B,C
	LD	B,D
	LD	B,E
	LD	B,H
	LD	B,IXL
	LD	B,IXU
	LD	B,IYL
	LD	B,IYU
	LD	B,L

	LD	BC,(1234H)
	LD	BC,(BC)
	LD	BC,(DE)
	LD	BC,(HL)
	LD	BC,(IX+12H)
	LD	BC,(IY+12H)
	LD	BC,(SP+12H)
	LD	BC,1234H
	LD	BC,BC
	LD	BC,DE
	LD	BC,HL
	LD	BC,IX
	LD	BC,IY

	LDW	DE,(1234H)
	LDW	DE,(BC)
	LDW	DE,(DE)
	LDW	DE,(HL)
	LDW	DE,(IX+12H)
	LDW	DE,(IY+12H)
	LDW	DE,(SP+12H)
	LDW	DE,BC
	LDW	DE,DE
	LDW	DE,HL
	LDW	DE,IX
	LDW	DE,IY

	LDW	HL,(1234H)
	LDW	HL,(BC)
	LDW	HL,(DE)
	LDW	HL,(HL)
	LDW	HL,(IX+12H)
	LDW	HL,(IY+12H)
	LDW	HL,(SP+12H)
	LDW	HL,BC
	LDW	HL,DE
	LDW	HL,HL
	LDW	HL,I
	LDW	HL,IX
	LDW	HL,IY
	LDW	I,HL
	LDW	IX,(1234H)
	LDW	IX,(BC)
	LDW	IX,(DE)
	LDW	IX,(HL)
	LDW	IX,(IY+12H)
	LDW	IX,(SP+12H)
	LDW	IX,BC
	LDW	IX,DE
	LDW	IX,HL
	LDW	IX,IY

	LDW	IY,(1234H)
	LDW	IY,(BC)
	LDW	IY,(DE)
	LDW	IY,(HL)
	LDW	IY,(IX+12H)
	LDW	IY,(SP+12H)
	LDW	IY,BC
	LDW	IY,DE
	LDW	IY,HL
	LDW	IY,IX
	LDW	SP,(1234H)

	LDCTL	A,DSR
	LDCTL	A,XSR
	LDCTL	A,YSR
	LDCTL	DSR,01H
	LDCTL	DSR,A
	LDCTL	HL,SR
	LDCTL	SR,01H
	LDCTL	SR,A
	LDCTL	SR,HL
	LDCTL	XSR,01H
	LDCTL	XSR,A
	LDCTL	YSR,01H
	LDCTL	YSR,A

	LDD
	LDDR
	LDDRW
	LDDW
	LDI
	LDIR
	LDIRW
	LDIW

	MLT	BC
	MLT	DE
	MLT	HL
	MLT	SP

	MTEST

	NEG	A
	NEG
	NEGW	HL
	NEGW

	NOP

	OTDM
	OTDMR
	OTDR
	OTDRW
	OTIM
	OTIMR
	OTIR
	OTIRW

	OUT	(12H),A
	OUT	(C),12H
	OUT	(C),A
	OUT	(C),B
	OUT	(C),C
	OUT	(C),D
	OUT	(C),E
	OUT	(C),H
	OUT	(C),L

	OUT0	(12H),A
	OUT0	(12H),B
	OUT0	(12H),C
	OUT0	(12H),D
	OUT0	(12H),E
	OUT0	(12H),H
	OUT0	(12H),L
	OUTA	(1234H),A
	OUTAW	(1234H),HL
	OUTD
	OUTDW
	OUTI
	OUTIW
	OUTW	(C),1234H
	OUTW	(C),BC
	OUTW	(C),DE
	OUTW	(C),HL

	PUSH	1234H
	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX
	PUSH	IY
	PUSH	SR

	RESC	LCK
	RESC	LW

	RET	C
	RET	M
	RET	NC
	RET	NS
	RET	NV
	RET	NZ
	RET	P
	RET	PE
	RET	PO
	RET	S
	RET	V
	RET	Z
	RET
	RETI
	RETN

	RLC	(HL)
	RLC	(IX+12H)
	RLC	(IY+12H)
	RLC	A
	RLC	B
	RLC	C
	RLC	D
	RLC	E
	RLC	H
	RLC	L

	RLCA

	RLCW	(HL)
	RLCW	(IX+12H)
	RLCW	(IY+12H)
	RLCW	BC
	RLCW	DE
	RLCW	HL
	RLCW	IX
	RLCW	IY

	RST	00H
	RST	08H
	RST	10H
	RST	18H
	RST	20H
	RST	28H
	RST	30H
	RST	38H

	SETC	LCK
	SETC	LW
	SETC	XM

ZZZ:
	END

