;******************************************************
;
	CPU     "TMS9900.TBL"   ;PROCESSOR TABLE
        HOF     "BIN16"         ;HEX FORMAT

; NOTE!!!
; THE TMS9900 TABLE SUPPLIED BY UNIVERSAL CROSS-ASSEMBLERS
; INCLUDES INSTRUCTIONS FOR THE TMS9995.  THE 9995
; INSTRUCTION SET IS AN OPCODE-COMPATIBLE SUPERSET OF
; THE 9900 PROCESSOR FAMILY.  THEREFORE, TMS9900.TBL
; MAY BE USED TO ASSEMBLE CODE FOR ALL MEMBERS OF THE
; TMS9900 FAMILY.

; NOTE!!!
; This processor is very particular about having code on even address
; boundaries.  It also places words on even boundaries MSB first.
; Therefore, it is essential to increment to an even address when defining
; labels for code or word storage (byte storage or access can, however
; reside on odd boundaries).
; The following syntax is recommended to ensure even boundaries:
; EVEN:     SETL    $ % 2
;           ORG     $ + EVEN
; LABEL:

; NOTE!!!
; THE FOLLOWING REGISTER VALUES MUST BE SPECIFIED IN
; IN ALL PROGRAMS, FOR TMS9900.TBL TO WORK PROPERLY.
;
R0:	EQU	0		;REGISTER
R1:	EQU	1		;REGISTER
R2:	EQU	2		;REGISTER
R3:	EQU	3		;REGISTER
R4:	EQU	4		;REGISTER
R5:	EQU	5		;REGISTER
R6:	EQU	6		;REGISTER
R7:	EQU	7		;REGISTER
R8:	EQU	8		;REGISTER
R9:	EQU	9		;REGISTER
R10:	EQU	10		;REGISTER
R11:	EQU	11		;REGISTER
R12:	EQU	12		;REGISTER
R13:	EQU	13		;REGISTER
R14:	EQU	14		;REGISTER
R15:	EQU	15		;REGISTER

;******************************************************
;
; THE FOLLOWING ARE EXAMPLES OF SOME OF THE VALID
; TMS9900 INSTUCTIONS.

IMM8:	EQU	-10H
IMM16:	EQU	4567H
LABEL:	EQU	1234H
GO_TO:	EQU	5678H
INDEX:	EQU	9ABCH
TABLE:	EQU    0DEF0H

	ORG	2000H

;Dual Operand Instructions

	MOV	R10,R11			;C2CA
	MOV	R10,*R11		;C6CA
	MOV	R10,@INDEX(R11)		;CACA9ABC
	MOV	R10,@LABEL		;C80A1234
	MOV	R10,*R11+		;CECA
	MOV	*R10,R11		;C2DA
	MOV	*R10,*R11		;C6DA
	MOV	*R10,@INDEX(R11)	;CADA9ABC
	MOV	*R10,@LABEL		;C81A1234
	MOV	*R10,*R11+		;CEDA
	MOV	@INDEX(R10),R11		;C2EA9ABC
	MOV	@INDEX(R10),*R11	;C6EA9ABC
	MOV	@INDEX(R10),@TABLE(R11)	;CAEA9ABCDEF0
	MOV	@INDEX(R10),@LABEL	;C82A9ABC1234
	MOV	@INDEX(R10),*R11+	;CEEA9ABC
	MOV	@LABEL,R11		;C2E01234
	MOV	@LABEL,*R11		;C6E01234
	MOV	@LABEL,@INDEX(R11)	;CAE012349ABC
	MOV	@LABEL,@GO_TO		;C82012345678
	MOV	@LABEL,*R11+		;CEE01234
	MOV	*R10+,R11		;C2FA
	MOV	*R10+,*R11		;C6FA
	MOV	*R10+,@INDEX(R11)	;CAFA9ABC
	MOV	*R10+,@LABEL		;C83A1234
	MOV	*R10+,*R11+		;CEFA

	MOVB	R10,R11			;D2CA
	MOVB	R10,*R11		;D6CA
	MOVB	R10,@INDEX(R11)		;DACA9ABC
	MOVB	R10,@LABEL		;D80A1234
	MOVB	R10,*R11+		;DECA
	MOVB	*R10,R11		;D2DA
	MOVB	*R10,*R11		;D6DA
	MOVB	*R10,@INDEX(R11)	;DADA9ABC
	MOVB	*R10,@LABEL		;D81A1234
	MOVB	*R10,*R11+		;DEDA
	MOVB	@INDEX(R10),R11		;D2EA9ABC
	MOVB	@INDEX(R10),*R11	;D6EA9ABC
	MOVB	@INDEX(R10),@TABLE(R11)	;DAEA9ABCDEF0
	MOVB	@INDEX(R10),@LABEL	;D82A9ABC1234
	MOVB	@INDEX(R10),*R11+	;DEEA9ABC
	MOVB	@LABEL,R11		;D2E01234
	MOVB	@LABEL,*R11		;D6E01234
	MOVB	@LABEL,@INDEX(R11)	;DAE012349ABC
	MOVB	@LABEL,@GO_TO		;D82012345678
	MOVB	@LABEL,*R11+		;DEE01234
	MOVB	*R10+,R11		;D2FA
	MOVB	*R10+,*R11		;D6FA
	MOVB	*R10+,@INDEX(R11)	;DAFA9ABC
	MOVB	*R10+,@LABEL		;D83A1234
	MOVB	*R10+,*R11+		;DEFA


;Dual Operand Instructions with Workspace Register Addressing

	COC	R10,R11			;22CA
	COC	*R10,R11		;22DA
	COC	@INDEX(R10),R11		;22EA9ABC
	COC	@LABEL,R11		;22E01234
	COC	*R10+,R11		;22FA


;Signed Multiply and Divide Instructions

	MPYS	R10			;01CA
	MPYS	*R10			;01DA
	MPYS	@INDEX(R10)		;01EA9ABC
	MPYS	@LABEL			;01E01234
	MPYS	*R10+			;01FA

	DIVS	R10			;018A
	DIVS	*R10			;019A
	DIVS	@INDEX(R10)		;01AA9ABC
	DIVS	@LABEL			;01A01234
	DIVS	*R10+			;01BA

;Extended Operation (XOP) Instruction

	XOP	R10,R11			;2ECA
	XOP	*R10,R11		;2EDA
	XOP	@INDEX(R10),R11		;2EEA9ABC
	XOP	@LABEL,R11		;2EE01234
	XOP	*R10+,R11		;2EFA

;Single Operand Instructions

	B	R10			;044A
	B	*R10			;045A
	B	@INDEX(R10)		;046A9ABC
	B	@LABEL			;04601234
	B	*R10+			;047A

;CRU Multiple-Bit Instructions

	LDCR	R10,11			;32CA
	LDCR	*R10,11			;32DA
	LDCR	@INDEX(R10),11		;32EA9ABC
	LDCR	@LABEL,11		;32E01234
	LDCR	*R10+,11		;32FA

;CRU Single-Bit Instructions

	SBO	127			;1D7F
	SBZ	127			;1E7F
	TB	127			;1F7F

;Jump Instructions

	JEQ	$ + 8AH			;1344
	JGT	$ + 8AH			;1544
	JH	$ + 8AH			;1B44
	JHE	$ + 8AH			;1444
	JL	$ + 8AH			;1A44
	JLE	$ + 8AH			;1244
	JLT	$ + 8AH			;1144
	JMP	$ + 8AH			;1044
	JNC	$ + 8AH			;1744
	JNE	$ + 8AH			;1644
	JNO	$ + 8AH			;1944
	JOC	$ + 8AH			;1844
	JOP	$ + 8AH			;1C44

;Shift Instructions

	SLA	R10,5			;0A5A
	SRA	R10,5			;085A
	SRC	R10,5			;0B5A
	SRL	R10,5			;095A

;Immediate Register Instructions

	AI	R10,-1234		;022AFB2E
	ANDI	R10,-1234		;024AFB2E
	CI	R10,-1234		;028AFB2E
	LI	R10,-1234		;020AFB2E
	ORI	R10,-1234		;026AFB2E

;Internal Register Load Immediate Instructions

	LWPI	-1234			;02E0FB2E
	LIMI	-1234			;0300FB2E

;Internal Register Load and Store Instructions

	STST	R10			;02CA
	LST	R10			;008A
	STWP	R10			;02AA
	LWP	R10			;009A

;Return Workspace Pointer Instruction

	RTWP				;0380

;External Instructions

	IDLE				;0340
	RSET				;0360
	CKOF				;03C0
	CKON				;03A0
	LREX				;03E0

ZZZ:
	END
