;------------------------------------------------------
; THIS IS AN EXAMPLE FOR THE TMS7000 MICROCOMPUTER
; FAMILY.  IT BEGINS ON PAGE 9-25 OF THE TMS 7000
; FAMILY DATA MANUAL FROM TEXAS INSTRUMENTS, AND
; AFTER ONLY FORMAT MODIFICATIONS FOR THIS
; ASSEMBLER, IT IS PASSED ON AS AN EXAMPLE, FREE OF
; CHARGE, BY UNIVERSAL CROSS-ASSEMBLERS.
;------------------------------------------------------
R0:      EQU   0
R1:      EQU   1
R2:      EQU   2
R3:      EQU   3
R4:      EQU   4
R5:      EQU   5
R6:      EQU   6
R7:      EQU   7
R8:      EQU   8
R9:      EQU   9
;------------------------------------------------------
P0:      EQU   100H
P1:      EQU   101H
P2:      EQU   102H
P3:      EQU   103H
P4:      EQU   104H
P5:      EQU   105H
P6:      EQU   106H
P7:      EQU   107H
P8:      EQU   108H
P9:      EQU   109H
P10:     EQU   10AH
P11:     EQU   10BH
P12:     EQU   10CH
P13:     EQU   10DH
P14:     EQU   10EH
P15:     EQU   10FH
P16:     EQU   110H
P17:     EQU   111H
P18:     EQU   112H
P19:     EQU   113H
P20:     EQU   114H
P21:     EQU   115H
P22:     EQU   116H
P23:     EQU   117H
;------------------------------------------------------
	 CPU     "TMS7000.TBL"    ; CPU TABLE
         HOF     "INT8"           ; HEX OUTPUT FORMAT
         PAGE     59              ; PAGE LENGTH

;------------------------------------------------------
         TITL    "HWUART"         ; TITLE

; This program uses the onboard UART to simulta-
; neously transmit an receive characters.
; Characters for transmitting are placed starting
; at TTABLE with the first byte equal to the
; string byte count.  The received bytes are
; stored in the table RTABLE with the beginning
; byte equal to the characters received.
;------------------------------------------------------
; Peripheral Register Definition  TMS7042
;------------------------------------------------------
IOCNT0:  EQU   P0      ; Interrupts and mode control
PORTA:   EQU   P4      ; Port A - UART input
ADDR:    EQU   P5      ; Port A direction
PORTB:   EQU   P6      ; Port B - UART output
IOCNT1:  EQU   P16     ; Interrupt 4,5 control
SMODE:   EQU   P17     ; Serial port mode
SCTL0:   EQU   P17     ; Serial port control 0
SSTAT:   EQU   P17     ; Serial port control status
T3DATA:  EQU   P20     ; Timer 3 data
SCTL1:   EQU   P21     ; Serial port control 1
RXBUF:   EQU   P22     ; Receiver buffer
TXBUF:   EQU   P23     ; Transmitter buffer

;------------------------------------------------------
; Register Definition
;------------------------------------------------------
POINTR:  EQU   R5      ; Pointer into receiver table
POINTT:  EQU   R6      ; Number of bytes ready to send
POINTC:  EQU   R7      ; Transmitter chars send so far
BITS:    EQU   R8      ; Store random conditional bits
;                        here
RTABLE:  EQU   30      ; Beginning of receiver table
;
BIT0:    EQU   1       ; Bit constants to make code more
BIT1:    EQU   2       ; readable
BIT2:    EQU   4
BIT3:    EQU   8
BIT4:    EQU   16
BIT5:    EQU   32
BIT6:    EQU   64
BIT7:    EQU   128
;------------------------------------------------------
;
         ORG   0F006H
START:   DINT
;
         MOVP  %2AH,IOCNT0 ; Single chip, clear INT
;                            flags
;                            Disable I1, I2, I3
         MOVP  %03H,IOCNT1 ; Clear INT4 flag and
;                            enable INT4
         MOV   %60H, B
         LDSP              ; Initialize stack pointer
	 MOVP  % ~BIT2 & 0FFH,ADDR ; Set A2 = input others
;                            are output
         MOVP  %BIT3,PORTB ; Enable TX by setting
;                            B3 = 1
         MOVP  %00H,P17    ; Make sure P17 points to
;                            SCTL0
         MOVP  %BIT6,SCTL0 ; Reset the UART via the
;                            UR bit
         MOVP  %01111110B,SMODE
;                            One stop bit, communi-
;                            cations mode, even
;                            parity, 8 bits,
;                            Asynchronous mode,
;                            Motorola
         MOVP  %15H,SCTL0  ; Clear the serial port
;                            reset bit
;        Clear all error flags and enable
;        the transmitter and receiver
         MOVP  %00H,SCTL1  ; Make sure the start bit
;                            is off
         MOVP  %0C0H,SCTL1 ; Use internal CLK, reset
;                            T3FLAG
;                            Disable T3 interrupt
;                            and set PS= 0
         MOVP  %103,T3DATA ; Set timer at 1200 baud
;                            (5 MHz)
         EINT              ; Enable maskable
;                            interrupt
SETUP:   CLR   POINTC      ; Clear bytes to transmit
;                            count
         CLR   POINTT      ; Clear bytes to transmit
         CLR   POINTR      ; Clear bytes received
;                            count
;
;------------------------------------------------------
;;; Main body of program goes here
;
;;; Main body fids and corrects serial port
;   error conditions by checking Bit 0 of
;   'BITS' and SSTAT.
;------------------------------------------------------
;   INTERRUPT 4 SERVICE ROUTINE
;------------------------------------------------------
INTER4:  BTJOP %38H,SSTAT,ERROR
;                           Was there an error?
         JMP   SAVEIT
ERROR:   OR    %BIT0,BITS ; Set an error bit for the
;                           main program to find
;                           and continue
SAVEIT:  PUSH  A          ; Save register A
         PUSH  B
         BTJZP %BIT1,SSTAT,TXOUT
;        Did receiver cause interrupt?
;
RXCV:    INC   POINTR     ; Get receiver table
;                           ponter
         CMP   %30,POINTR ; Is receiver table full
;                           yet?
         JHS   TXOUT      ; get out of routine
;                           if so
         MOV   POINTR,B   ; Get index value
SKIP1:   MOVP  RXBUF,A    ; Put received character
;                           in Register A
         STA   @RTABLE(B) ; Put value into table
         MOV   B,A        ; Store the new character
;                           count
         STA   @RTABLE    ; Put count at location
;                           0 in table and exit
TXOUT:   BTJZP %BIT0,SSTAT,OUTI4
;        Did XMIT cause interrupt?
;
XMIT:    CMP   POINTT,POINTC
;                         ; Is the table finished?
         JHS   OUTI4      ; Jump if finished
         INC   POINTC     ; Point to the next index
         MOV   POINTC,B   ; Get transmit table
;                           pointer
;
SKIP0:   LDA   @TTABLE(B) ; Load value from TX
;                           table
L1:	 CMP   %0,B       ; Is this the byte count?
	 JNE   OUTPUT     ; If not, output the byte
	 MOV   A,POINTT   ; If so, put into pointer
	 JMP   OUTI4
OUTPUT:  MOVP  A,TXBUF    ; Put data into
;                           transmitter
;
OUTI4:   POP   B          ; Restore registers
         POP   A
         RETI             ; Return to main program
;
TTABLE:  DFB   26         ; Text can be either in
;                           ROM or RAM registers
         DFB   "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
;
	 ORG   10000H-{4+1}*2   ; Set up 4 vectors
;                           =interrupts
         DWM   INTER4,START,START,START,START
         END
