;******************************************************
;
; TLCS-90 EXAMPLE FILE
; Special function registers, a small example, and
; addressing mode examples follow:
;
	CPU	"TLCS90.TBL"	;CPU TABLE
	HOF	"INT8"		;HEX FORMAT

; TMP90C840A/841A SPECIAL FUNCTION REGISTERS
; These may be modified for other versions of the TLCS-90
;
P0	EQU	0FFC0H		;Port 0
P1	EQU	0FFC1H		;Port 1
P2	EQU	0FFC4H		;Port 2
P3	EQU	0FFC6H		;Port 3
P4	EQU	0FFC8H		;Port 4
P5	EQU	0FFCAH		;Port 5
P6	EQU	0FFCCH		;Port 6
P7	EQU	0FFCDH		;Port 7
P8	EQU	0FFD0H		;Port 8
;
P01CR	EQU	0FFC2H		;Port 0/1 Control Register
P2CR	EQU	0FFC5H		;Port 2 Control Register
P3CR	EQU	0FFC7H		;Port 3 Control Register
P4CR	EQU	0FFC9H		;Port 4 Control Register
P67CR	EQU	0FFCEH		;Port 6/7 Control Register
P8CR	EQU	0FFD1H		;Port 8 Control Register
;
SMMOD	EQU	0FFCBH		;Stepping Motor Mode Register
SMCR	EQU	0FFCFH		;Stepping Motor Control Register
;
WDMOD	EQU	0FFD2H		;Watch Dog Timer Mode Register
WDCR	EQU	0FFD3H		;Watch Dog Timer Control Register
;
TREG0	EQU	0FFD4H		;8-bit Timer Register 0
TREG1	EQU	0FFD5H		;8-bit Timer Register 1
TREG2	EQU	0FFD6H		;8-bit Timer Register 2
TREG3	EQU	0FFD7H		;8-bit Timer Register 3
TCLK	EQU	0FFD8H		;8-bit Timer Source Clock Control Reg.
TFFCR	EQU	0FFD9H		;8-bit Timer Flip-Flop Control Reg.
TMOD	EQU	0FFDAH		;8-bit Timer Mode Register
TRUN	EQU	0FFDBH		;8-bit Timer/Serial Channel Baud Rate Control Reg.
CAP1L	EQU	0FFDCH		;16-bit Timer/Event Counter Capture Reg. 1 Low
CAP1H	EQU	0FFDDH		;16-bit Timer/Event Counter Capture Reg. 1 High
CAP2L	EQU	0FFDEH		;16-bit Timer/Event Counter Capture Reg. 2 Low
CAP2H	EQU	0FFDFH		;16-bit Timer/Event Counter Capture Reg. 2 High
TREG4L	EQU	0FFE0H		;16-bit Timer/Event Counter Reg. 4 Low
TREG4H	EQU	0FFE1H		;16-bit Timer/Event Counter Reg. 4 High
TREG5L	EQU	0FFE2H		;16-bit Timer/Event Counter Reg. 5 Low
TREG5H	EQU	0FFE3H		;16-bit Timer/Event Counter Reg. 5 High
T4MOD	EQU	0FFE4H		;16-bit Timer/Event Counter Mode Reg.
T4FFCR	EQU	0FFE5H		;16-bit Timer Flip-Flop 4 Control Reg.
;
SCMOD	EQU	0FFE9H		;Serial Channel Mode Register
SCCR	EQU	0FFEAH		;Serial Channel Control Register
SCBUF	EQU	0FFEBH		;Serial Channel Buffer Register
;
ADMOD	EQU	0FFEFH		;A/D Converter mode Register
ADREG	EQU	0FFEEH		;A/D Result Register
;
INTEL	EQU	0FFE6H		;Interrupt Enable Mask Reg. Low
INTEH	EQU	0FFE7H		;Interrupt Enable Mask Reg. High
;
IRFL	EQU	0FFC2H		;Interrupt Request Flag & IRF Clear High
IRFH	EQU	0FFC3H		;Interrupt Request Flag & IRF Clear Low
;
BX	EQU	0FFECH		;Bank Register X
BY	EQU	0FFEDH		;Bank Register Y


;******************************************************
;
; An example from the TOSHIBA Development Systems Manual
;
;**** SAMPLE PROGRAM FOR RTE90 OPERATION ****
;
	ORG	0FF00H		; PUBLIC SYMBOLS
	DFS	20
STACK_P EQU	$		; STACK AREA
				; MAIN PROGRAM
	ORG	0
				; ABSOLUTE CODE SEGMENT
MAIN:	JR	INIT		; JUMP INIT ROUTINE
;
	ORG	20H		; WATCH DOG ENTRY
	RETI			; RETURN INTERRUPT
;
;**** INITIALIZE ROUTINE ****
;
	ORG	80H
INIT:
	LD	SP,STACK_P	; STACK POINTER INITIAL
START:
	LD	HL,0FF00H	; MEMORY ADDRESS
	LD	A,5		; COUNTER (CLEARBYTE)
STID:
	LD	(HL),0		; (HL) <-- 0
	INC	HL		; INCREMENT HL
	DEC	A		; COUNTER-1
	JR	NZ,STID 	; IF COUNTER <> 0
				; THEN JUMP
				; ELSE END
LOOP:	JP	LOOP		; SELF JUMP
ENDP:				; END
;


;******************************************************
;
; EXAMPLES OF TLCS-90 ADDRESSING MODES

d:	EQU	00078H		;d
n:	EQU	00056H		;n
MN:	EQU	0CDABH		;MN
VW:	EQU	03412H		;VW
OFFnH:	EQU	0FFEFH		;0FFnH
cd:	EQU	05634H		;cd

;8-bit Load

	LD	A,B		;20
	LD	A,C		;21
	LD	A,D		;22
	LD	A,E		;23
	LD	A,H		;24
	LD	A,L		;25

	LD	B,A		;28
	LD	C,A		;29
	LD	D,A		;2A
	LD	E,A		;2B
	LD	H,A		;2C
	LD	L,A		;2D

	LD	C,L		;FD31
	LD	D,H		;FC32
	LD	E,E		;FB33
	LD	H,D		;FA34
	LD	L,C		;F935

	LDC	DMAS0,A 	;FE0400
	LDC	DMAD0,B 	;F80401
	LDC	DMAC0,C 	;F90402
	LDC	DMAM0,D 	;FA0403
	LDC	DMAS1,E 	;FB0404
	LDC	DMAD1,H 	;FC0405
	LDC	DMAC1,L 	;FD0406
	LDC	DMAM1,L 	;FD0407

	LDC	A,DMAS0 	;FE0600
	LDC	B,DMAD0 	;F80601
	LDC	C,DMAC0 	;F90602
	LDC	D,DMAM0 	;FA0603
	LDC	E,DMAS1 	;FB0604
	LDC	H,DMAD1 	;FC0605
	LDC	L,DMAC1 	;FD0606
	LDC	L,DMAM1 	;FD0607

	LD	B,n		;3056
	LD	C,n		;3156
	LD	D,n		;3256
	LD	E,n		;3356
	LD	H,n		;3456
	LD	L,n		;3556
	LD	A,n		;3656

	LD	B,(SP)		;E628
	LD	C,(IY)		;E529
	LD	D,(IX)		;E42A
	LD	E,(HL)		;E22B
	LD	H,(DE)		;E12C
	LD	L,(BC)		;E02D

	LD	B,(SP+d)	;F27828
	LD	C,(IY+d)	;F17829
	LD	D,(IX+d)	;F0782A

	LD	B,(HL+A)	;F328
	LD	C,(HL+A)	;F329
	LD	D,(HL+A)	;F32A

	LD	B,(vw)		;E3123428
	LD	C,(vw)		;E3123429
	LD	D,(vw)		;E312342A

	LD	B,(OFFnH)	;E7EF28
	LD	C,(OFFnH)	;E7EF29
	LD	D,(OFFnH)	;E7EF2A
	LD	A,(OFFnH)	;27EF

	LD	(SP),B		;EE20
	LD	(IY),C		;ED21
	LD	(IX),D		;EC22
	LD	(HL),E		;EA23
	LD	(DE),H		;E924
	LD	(BC),L		;E825

	LD	(SP+d),B	;F67820
	LD	(IY+d),C	;F57821
	LD	(IX+d),D	;F47822

	LD	(HL+A),B	;F720
	LD	(HL+A),C	;F721
	LD	(HL+A),D	;F722

	LD	(vw),B		;EB123420
	LD	(vw),C		;EB123421
	LD	(vw),D		;EB123422

	LD	(OFFnH),B	;EFEF20
	LD	(OFFnH),C	;EFEF21
	LD	(OFFnH),D	;EFEF22
	LD	(OFFnH),A	;2FEF

	LD	(SP),n		;EE3756
	LD	(IY),n		;ED3756
	LD	(IX),n		;EC3756
	LD	(HL),n		;EA3756
	LD	(DE),n		;E93756
	LD	(BC),n		;E83756

	LD	(SP+d),n	;F6783756
	LD	(IY+d),n	;F5783756
	LD	(IX+d),n	;F4783756

	LD	(HL+A),n	;F73756

	LD	(vw),n		;EB12343756

	LD	(OFFnH),n	;37EF56

;16-bit Load
	LD	HL,BC		;40
	LD	HL,DE		;41
	LD	HL,HL		;42
	LD	HL,IX		;44
	LD	HL,IY		;45
	LD	HL,SP		;46

	LD	BC,HL		;48
	LD	DE,HL		;49
	LD	HL,HL		;42
	LD	IX,HL		;4C
	LD	IY,HL		;4D
	LD	SP,HL		;4E

	LD	DE,SP		;FE39
	LD	HL,IY		;45
	LD	IX,IX		;FC3C
	LD	IY,HL		;4D
	LD	SP,DE		;F93E

	LDC	DMAS0,HL	;FA0500
	LDC	DMAD0,BC	;F80501
	LDC	DMAC0,DE	;F90502
	LDC	DMAM0,HL	;FA0503
	LDC	DMAS1,IX	;FC0504
	LDC	DMAD1,IY	;FD0505
	LDC	DMAC1,SP	;FE0506
	LDC	DMAM1,SP	;FE0507

	LDC	HL,DMAS0	;FA0700
	LDC	BC,DMAD0	;F80701
	LDC	DE,DMAC0	;F90702
	LDC	HL,DMAM0	;FA0703
	LDC	IX,DMAS1	;FC0704
	LDC	IY,DMAD1	;FD0705
	LDC	SP,DMAC1	;FE0706
	LDC	SP,DMAM1	;FE0707

	LD	BC,mn		;38ABCD
	LD	DE,mn		;39ABCD
	LD	HL,mn		;3AABCD
	LD	IX,mn		;3CABCD
	LD	IY,mn		;3DABCD
	LD	SP,mn		;3EABCD

	LD	BC,(SP) 	;E648
	LD	DE,(IY) 	;E549
	LD	HL,(IX) 	;E44A
	LD	IX,(HL) 	;E24C
	LD	IY,(DE) 	;E14D
	LD	SP,(BC) 	;E04E

	LD	BC,(SP+d)	;F27848
	LD	DE,(IY+d)	;F17849
	LD	HL,(IX+d)	;F0784A

	LD	BC,(HL+A)	;F348
	LD	DE,(HL+A)	;F349
	LD	HL,(HL+A)	;F34A

	LD	BC,(vw) 	;E3123448
	LD	DE,(vw) 	;E3123449
	LD	HL,(vw) 	;E312344A

	LD	BC,(OFFnH)	;E7EF48
	LD	DE,(OFFnH)	;E7EF49
	LD	IX,(OFFnH)	;E7EF4C
	LD	HL,(OFFnH)	;47EF

	LD	(SP),BC 	;EE40
	LD	(IY),DE 	;ED41
	LD	(IX),HL 	;EC42
	LD	(HL),IX 	;EA44
	LD	(DE),IY 	;E945
	LD	(BC),SP 	;E846

	LD	(SP+d),BC	;F67840
	LD	(IY+d),DE	;F57841
	LD	(IX+d),HL	;F47842

	LD	(HL+A),BC	;F740
	LD	(HL+A),DE	;F741
	LD	(HL+A),HL	;F742

	LD	(vw),BC 	;EB123440
	LD	(vw),DE 	;EB123441
	LD	(vw),HL 	;EB123442

	LD	(OFFnH),BC	;EFEF40
	LD	(OFFnH),DE	;EFEF41
	LD	(OFFnH),IX	;EFEF44
	LD	(OFFnH),HL	;4FEF

	LDW	(SP),mn 	;EE3FABCD
	LDW	(IY),mn 	;ED3FABCD
	LDW	(IX),mn 	;EC3FABCD
	LDW	(HL),mn 	;EA3FABCD
	LDW	(DE),mn 	;E93FABCD
	LDW	(BC),mn 	;E83FABCD

	LDW	(SP+d),mn	;F6783FABCD
	LDW	(IY+d),mn	;F5783FABCD
	LDW	(IX+d),mn	;F4783FABCD

	LDW	(HL+A),mn	;F73FABCD

	LDW	(vw),mn 	;EB12343FABCD

	LDW	(OFFnH),mn	;3FEFABCD

	PUSH	BC		;50
	PUSH	DE		;51
	PUSH	HL		;52
	PUSH	IX		;54
	PUSH	IY		;55
	PUSH	AF		;56

	POP	BC		;58
	POP	DE		;59
	POP	HL		;5A
	POP	IX		;5C
	POP	IY		;5D
	POP	AF		;5E

	LDA	BC,SP+d 	;F67838
	LDA	DE,IY+d 	;F57839
	LDA	HL,IX+d 	;F4783A

	LDA	BC,HL+A 	;F738
	LDA	DE,HL+A 	;F739
	LDA	HL,HL+A 	;F73A

;Exchange, Block Load and Search
	EX	DE,HL		;08
	EX	AF,AF'		;09
	EXX			;0A

	EX	(SP),BC 	;E650
	EX	(IY),DE 	;E551
	EX	(IX),HL 	;E452
	EX	(HL),IX 	;E254
	EX	(DE),IY 	;E155
	EX	(BC),SP 	;E056

	EX	(SP+d),BC	;F27850
	EX	(IY+d),DE	;F17851
	EX	(IX+d),HL	;F07852

	EX	(HL+A),BC	;F350
	EX	(HL+A),DE	;F351
	EX	(HL+A),HL	;F352

	EX	(vw),BC 	;E3123450
	EX	(vw),DE 	;E3123451
	EX	(vw),HL 	;E3123452

	EX	(OFFnH),BC	;E7EF50
	EX	(OFFnH),DE	;E7EF51
	EX	(OFFnH),IX	;E7EF54
	EX	(OFFnH),HL	;E7EF52

	LDI			;FE58
	LDIR			;FE59
	LDD			;FE5A
	LDDR			;FE5B

	CPI			;FE5C
	CPIR			;FE5D
	CPD			;FE5E
	CPDR			;FE5F

;8-bit Operations
	ADD	A,B		;F860
	ADD	A,C		;F960
	ADD	A,D		;FA60
	ADD	A,E		;FB60
	ADD	A,H		;FC60
	ADD	A,L		;FD60

	ADD	A,n		;6856

	ADD	A,(SP)		;E660
	ADD	A,(IY)		;E560
	ADD	A,(IX)		;E460
	ADD	A,(HL)		;E260
	ADD	A,(DE)		;E160
	ADD	A,(BC)		;E060
	ADD	A,(SP+d)	;F27860
	ADD	A,(IY+d)	;F17860
	ADD	A,(IX+d)	;F07860
	ADD	A,(HL+A)	;F360
	ADD	A,(vw)		;E3123460
	ADD	A,(OFFnH)	;60EF

	ADD	B,n		;F86856
	ADD	C,n		;F96856
	ADD	D,n		;FA6856
	ADD	E,n		;FB6856
	ADD	H,n		;FC6856
	ADD	L,n		;FD6856

	ADD	(SP),n		;EE6856
	ADD	(IY),n		;ED6856
	ADD	(IX),n		;EC6856
	ADD	(HL),n		;EA6856
	ADD	(DE),n		;E96856
	ADD	(BC),n		;E86856
	ADD	(SP+d),n	;F6786856
	ADD	(IY+d),n	;F5786856
	ADD	(IX+d),n	;F4786856
	ADD	(HL+A),n	;F76856
	ADD	(vw),n		;EB12346856
	ADD	(OFFnH),n	;EFEF6856


	INC	A		;86
	INC	B		;80
	INC	C		;81
	INC	D		;82
	INC	E		;83
	INC	H		;84
	INC	L		;85

	INC	(SP)		;E687
	INC	(IY)		;E587
	INC	(IX)		;E487
	INC	(HL)		;E287
	INC	(DE)		;E187
	INC	(BC)		;E087
	INC	(SP+d)		;F27887
	INC	(IY+d)		;F17887
	INC	(IX+d)		;F07887
	INC	(HL+A)		;F387
	INC	(vw)		;E3123487
	INC	(OFFnH) 	;87EF


	INCX	(OFFnH) 	;07EF

	DECX	(OFFnH) 	;0FEF


; 16-bit Operations
	ADD	HL,BC		;F870
	ADD	HL,DE		;F970
	ADD	HL,HL		;FA70
	ADD	HL,IX		;FC70
	ADD	HL,IY		;FD70
	ADD	HL,SP		;FE70

	ADD	HL,mn		;78ABCD

	ADD	HL,(SP) 	;E670
	ADD	HL,(IY) 	;E570
	ADD	HL,(IX) 	;E470
	ADD	HL,(HL) 	;E270
	ADD	HL,(DE) 	;E170
	ADD	HL,(BC) 	;E070
	ADD	HL,(SP+d)	;F27870
	ADD	HL,(IY+d)	;F17870
	ADD	HL,(IX+d)	;F07870
	ADD	HL,(HL+A)	;F370
	ADD	HL,(vw) 	;E3123470
	ADD	HL,(OFFnH)	;70EF

	ADD	IX,BC		;F814
	ADD	IY,DE		;F915
	ADD	SP,HL		;FA16
	ADD	IX,IX		;FC14
	ADD	IY,IY		;FD15
	ADD	SP,SP		;FE16

	ADD	IX,mn		;14ABCD
	ADD	IY,mn		;15ABCD
	ADD	SP,mn		;16ABCD

	ADD	IX,(SP) 	;E614
	ADD	IY,(IY) 	;E515
	ADD	SP,(IX) 	;E416
	ADD	IX,(HL) 	;E214
	ADD	IY,(DE) 	;E115
	ADD	SP,(BC) 	;E016

	ADD	IX,(SP+d)	;F27814
	ADD	IY,(IY+d)	;F17815
	ADD	SP,(IX+d)	;F07816

	ADD	IX,(HL+A)	;F314
	ADD	IY,(HL+A)	;F315
	ADD	SP,(HL+A)	;F316

	ADD	IX,(vw) 	;E3123414
	ADD	IY,(vw) 	;E3123415
	ADD	SP,(vw) 	;E3123416

	ADD	IX,(OFFnH)	;E7EF14
	ADD	IY,(OFFnH)	;E7EF14
	ADD	SP,(OFFnH)	;E7EF14


	INC	BC		;90
	INC	DE		;91
	INC	HL		;92
	INC	IX		;94
	INC	IY		;95
	INC	SP		;96

	INCW	(SP)		;E697
	INCW	(IY)		;E597
	INCW	(IX)		;E497
	INCW	(HL)		;E297
	INCW	(DE)		;E197
	INCW	(BC)		;E097
	INCW	(SP+d)		;F27897
	INCW	(IY+d)		;F17897
	INCW	(IX+d)		;F07897
	INCW	(HL+A)		;F397
	INCW	(vw)		;E3123497
	INCW	(OFFnH) 	;97EF


; Special Operations and CPU Control

	DAA	A		;0B
	CPL	A		;10
	NEG	A		;11

	LDAR	HL,$+2+cd	;173456

	CCF			;0E
	SCF			;0D
	RCF			;0C

	NOP			;00

	HALT			;01

	DI			;02
	EI			;03
	SWI			;FF

	MUL	HL,B		;F812
	MUL	HL,C		;F912
	MUL	HL,D		;FA12
	MUL	HL,E		;FB12
	MUL	HL,H		;FC12
	MUL	HL,L		;FD12

	MUL	HL,n		;1256

	MUL	HL,(SP) 	;E612
	MUL	HL,(IY) 	;E512
	MUL	HL,(IX) 	;E412
	MUL	HL,(HL) 	;E212
	MUL	HL,(DE) 	;E112
	MUL	HL,(BC) 	;E012
	MUL	HL,(SP+d)	;F27812
	MUL	HL,(IY+d)	;F17812
	MUL	HL,(IX+d)	;F07812
	MUL	HL,(HL+A)	;F312
	MUL	HL,(vw) 	;E3123412
	MUL	HL,(OFFnH)	;E7EF12


; Rotate and Shift

	RLCA			;A0
	RLC	A		;FEA0
	RLC	B		;F8A0
	RLC	C		;F9A0
	RLC	D		;FAA0
	RLC	E		;FBA0
	RLC	H		;FCA0
	RLC	L		;FDA0

	RLC	(SP)		;E6A0
	RLC	(IY)		;E5A0
	RLC	(IX)		;E4A0
	RLC	(HL)		;E2A0
	RLC	(DE)		;E1A0
	RLC	(BC)		;E0A0
	RLC	(SP+d)		;F278A0
	RLC	(IY+d)		;F178A0
	RLC	(IX+d)		;F078A0
	RLC	(HL+A)		;F3A0
	RLC	(vw)		;E31234A0
	RLC	(OFFnH) 	;E7EFA0


; Bit Operations
	BIT	0,A		;FEA8
	BIT	1,B		;F8A9
	BIT	2,C		;F9AA
	BIT	3,D		;FAAB
	BIT	4,E		;FBAC
	BIT	5,H		;FCAD
	BIT	6,L		;FDAE

	BIT	0,(SP)		;E6A8
	BIT	1,(IY)		;E5A9
	BIT	2,(IX)		;E4AA
	BIT	3,(HL)		;E2AB
	BIT	4,(DE)		;E1AC
	BIT	5,(BC)		;E0AD
	BIT	6,(SP+d)	;F278AE
	BIT	7,(IY+d)	;F178AF
	BIT	0,(IX+d)	;F078A8
	BIT	1,(HL+A)	;F3A9
	BIT	2,(vw)		;E31234AA
	BIT	3,(OFFnH)	;ABEF


;Jump, Call and Return

	JP	SP		;EEC8
	JP	F,IY		;EDC0
	JP	Z,IX		;ECC6
	JP	NZ,HL		;EACE
	JP	C,DE		;E9C7
	JP	NC,BC		;E8CF
	JP	PL,SP		;EECD
	JP	P,IY		;EDCD
	JP	MI,IX		;ECC5
	JP	M,HL		;EAC5
	JP	NE,DE		;E9CE
	JP	EQ,BC		;E8C6
	JP	OV,SP		;EEC4
	JP	NOV,IY		;EDCC
	JP	PE,IX		;ECC4
	JP	PO,HL		;EACC
	JP	GE,DE		;E9C9
	JP	LT,BC		;E8C1
	JP	GT,SP		;EECA
	JP	LE,IY		;EDC2
	JP	UGE,IX		;ECCF
	JP	ULT,HL		;EAC7
	JP	UGT,DE		;E9CB
	JP	ULE,BC		;E8C3

	JP	SP+d		;F678C8
	JP	F,IY+d		;F578C0
	JP	Z,IX+d		;F478C6
	JP	NZ,SP+d 	;F678CE
	JP	C,IY+d		;F578C7
	JP	NC,IX+d 	;F478CF
	JP	PL,SP+d 	;F678CD
	JP	P,IY+d		;F578CD
	JP	MI,IX+d 	;F478C5
	JP	M,SP+d		;F678C5
	JP	NE,IY+d 	;F578CE
	JP	EQ,IX+d 	;F478C6
	JP	OV,SP+d 	;F678C4
	JP	NOV,IY+d	;F578CC
	JP	PE,IX+d 	;F478C4
	JP	PO,SP+d 	;F678CC
	JP	GE,IY+d 	;F578C9
	JP	LT,IX+d 	;F478C1
	JP	GT,SP+d 	;F678CA
	JP	LE,IY+d 	;F578C2
	JP	UGE,IX+d	;F478CF
	JP	ULT,SP+d	;F678C7
	JP	UGT,IY+d	;F578CB
	JP	ULE,IX+d	;F478C3

	JP	HL+A		;F7C8
	JP	F,HL+A		;F7C0
	JP	Z,HL+A		;F7C6
	JP	NZ,HL+A 	;F7CE
	JP	C,HL+A		;F7C7
	JP	NC,HL+A 	;F7CF
	JP	PL,HL+A 	;F7CD
	JP	P,HL+A		;F7CD
	JP	MI,HL+A 	;F7C5
	JP	M,HL+A		;F7C5
	JP	NE,HL+A 	;F7CE
	JP	EQ,HL+A 	;F7C6
	JP	OV,HL+A 	;F7C4
	JP	NOV,HL+A	;F7CC
	JP	PE,HL+A 	;F7C4
	JP	PO,HL+A 	;F7CC
	JP	GE,HL+A 	;F7C9
	JP	LT,HL+A 	;F7C1
	JP	GT,HL+A 	;F7CA
	JP	LE,HL+A 	;F7C2
	JP	UGE,HL+A	;F7CF
	JP	ULT,HL+A	;F7C7
	JP	UGT,HL+A	;F7CB
	JP	ULE,HL+A	;F7C3

	JP	F,mn		;EBABCDC0
	JP	Z,mn		;EBABCDC6
	JP	NZ,mn		;EBABCDCE
	JP	C,mn		;EBABCDC7
	JP	NC,mn		;EBABCDCF
	JP	PL,mn		;EBABCDCD
	JP	P,mn		;EBABCDCD
	JP	MI,mn		;EBABCDC5
	JP	M,mn		;EBABCDC5
	JP	NE,mn		;EBABCDCE
	JP	EQ,mn		;EBABCDC6
	JP	OV,mn		;EBABCDC4
	JP	NOV,mn		;EBABCDCC
	JP	PE,mn		;EBABCDC4
	JP	PO,mn		;EBABCDCC
	JP	GE,mn		;EBABCDC9
	JP	LT,mn		;EBABCDC1
	JP	GT,mn		;EBABCDCA
	JP	LE,mn		;EBABCDC2
	JP	UGE,mn		;EBABCDCF
	JP	ULT,mn		;EBABCDC7
	JP	UGT,mn		;EBABCDCB
	JP	ULE,mn		;EBABCDC3

	JR	$+2+d		;C878
	JR	F,$+2+d 	;C078
	JR	Z,$+2+d 	;C678
	JR	NZ,$+2+d	;CE78
	JR	C,$+2+d 	;C778
	JR	NC,$+2+d	;CF78
	JR	PL,$+2+d	;CD78
	JR	P,$+2+d 	;CD78
	JR	MI,$+2+d	;C578
	JR	M,$+2+d 	;C578
	JR	NE,$+2+d	;CE78
	JR	EQ,$+2+d	;C678
	JR	OV,$+2+d	;C478
	JR	NOV,$+2+d	;CC78
	JR	PE,$+2+d	;C478
	JR	PO,$+2+d	;CC78
	JR	GE,$+2+d	;C978
	JR	LT,$+2+d	;C178
	JR	GT,$+2+d	;CA78
	JR	LE,$+2+d	;C278
	JR	UGE,$+2+d	;CF78
	JR	ULT,$+2+d	;C778
	JR	UGT,$+2+d	;CB78
	JR	ULE,$+2+d	;C378

	JP	mn		;1AABCD
	JRL	$+2+cd		;1B3456


	CALL	mn		;1CABCD
	CALR	$+2+cd		;1D3456


	DJNZ	$+2+d		;1878
	DJNZ	BC,$+2+d	;1978

	RET			;1E
	RET	F		;FED0
	RET	Z		;FED6
	RET	NZ		;FEDE
	RET	C		;FED7
	RET	NC		;FEDF
	RET	PL		;FEDD
	RET	P		;FEDD
	RET	MI		;FED5
	RET	M		;FED5
	RET	NE		;FEDE
	RET	EQ		;FED6
	RET	OV		;FED4
	RET	NOV		;FEDC
	RET	PE		;FED4
	RET	PO		;FEDC
	RET	GE		;FED9
	RET	LT		;FED1
	RET	GT		;FEDA
	RET	LE		;FED2
	RET	UGE		;FEDF
	RET	ULT		;FED7
	RET	UGT		;FEDB
	RET	ULE		;FED3

	RETI			;1F

	END
