;******************************************************
;
; SUPER8 EXAMPLE FILE
; INSTRUCTION ORDER TAKEN FROM THE 1985 SUPER8
; MICROCOMPUTER TECHNICAL MANUAL, PAGE 5-9.

	HOF	"INT8"		;INTEL HEX OUTPUT
	CPU	"SUPER8.TBL"	;CPU TABLE

; NOTES
;
; THE SUPER8 TABLE (SUPER8.TBL) DEFINES THE SIXTEEN *WORKING*
; REGISTERS AS R0,R1,R2,...,R14,15 AND RR0,RR2,RR4,...,R14.
; THE ACTUAL ADDRESS OF THESE
; REGISTERS IMMEDIATELY FOLLOWING A HARDWARE RESET ARE
; 0C0H THROUGH 0CFH, RESPECTIVELY.  CHANGING REGISTER
; POINTER ZERO (RP0) AND/OR REGISTER POINTER ONE (RP1)
; WILL CHANGE THE ADDRESS OF THESE REGISTERS.  THESE ARE
; THE ONLY REGISTER NAMES ACCEPTED BY THE ASSEMBLER
; IN FOUR BIT REGISTER LOCATIONS.
;
; ODD REGISTERS AND ODD WORKING REGISTERS IN LOCATIONS
; WHERE REGISTER ADDRESSES MUST BE EVEN WILL BE FLAGGED
; BY THE ASSEMBLER AS NOT IN SPECIFIED RANGE.

;	SYSTEM REGISTERS
;
SYM:	EQU	222	     ;SYSTEM MODE
IMR:	EQU	221	     ;INTERRUPT MASK REGISTER
IRQ:	EQU	220	     ;INTERRUPT REQUEST REG.
IPL:	EQU	219	     ;INSTRUCTION POINTER LOW
IPH:	EQU	218	     ;INSTRUCTION POINTER HIGH
SPL:	EQU	217	     ;STACK POINTER LOW
SPH:	EQU	216	     ;STACK POINTER HIGH
RP1:	EQU	215	     ;REGISTER POINTER 1
RP0:	EQU	214	     ;REGISTER POINTER 0
FLAGS:	EQU	213	     ;PROGRAM CONTROL FLAGS
P4:	EQU	212	     ;PORT 4
P3:	EQU	211	     ;PORT 3
P2:	EQU	210	     ;PORT 2
P1:	EQU	209	     ;PORT 1
P0:	EQU	208	     ;PORT 0

;	BANK 0 REGISTERS
;
IPR:	EQU	255	     ;INTERRUPT PRIORITY
EMT:	EQU	254	     ;EXTERNAL MEMORY TIMING
P2BIP:	EQU	253	     ;PORT 2/3B INTERRUPT PENDING
P2AIP:	EQU	252	     ;PORT 2/3A INTERRUPT PENDING
P2DM:	EQU	251	     ;PORT 2/3D MODE
P2CM:	EQU	250	     ;PORT 2/3C MODE
P2BM:	EQU	249	     ;PORT 2/3B MODE
P2AM:	EQU	248	     ;PORT 2/3A MODE
P4OD:	EQU	247	     ;PORT 4 OPEN-DRAIN
P4D:	EQU	246	     ;PORT 4 DIRECTION
H1C:	EQU	245	     ;HANDSHAKE 1 CONTROL
H0C:	EQU	244	     ;HANDSHAKE 0 CONTROL
PM:	EQU	241	     ;PORT MODE
P0M:	EQU	240	     ;PORT 0 MODE
UIO:	EQU	239	     ;UART DATA
UIE:	EQU	237	     ;UART INTERRUPT ENABLE
URC:	EQU	236	     ;UART RECEIVE CONTROL
UTC:	EQU	235	     ;UART TRANSMIT CONTROL
C1CL:	EQU	229	     ;COUNTER 1 CAPTURE LOW
C1CH:	EQU	228	     ;COUNTER 1 CAPTURE HIGH
C0CL:	EQU	227	     ;COUNTER 0 CAPTURE LOW
C0CH:	EQU	226	     ;COUNTER 0 CAPTURE HIGH
C1CT:	EQU	225	     ;COUNTER 1 CONTROL
C0CT:	EQU	224	     ;COUNTER 0 CONTROL

;	BANK 1 REGISTERS
;
WUMSK:	EQU	255	     ;WAKE-UP MASK
WUMCH:	EQU	254	     ;WAKE-UP MATCH
UMB:	EQU	251	     ;UART MODE B
UMA:	EQU	250	     ;UART MODE A
UBGL:	EQU	249	     ;UART BAUD-RATE GENERATOR LOW
UBGH:	EQU	248	     ;UART BAUD-RATE GENERATOR HIGH
DCL:	EQU	241	     ;DMA COUNT LOW
DCH:	EQU	240	     ;DMA COUNT HIGH
C1TCL:	EQU	229	     ;COUNTER 1 TIME CONSTANT LOW
C1TCH:	EQU	228	     ;COUNTER 1 TIME CONSTANT HIGH
C0TCL:	EQU	227	     ;COUNTER 0 TIME CONSTANT LOW
C0TCH:	EQU	226	     ;COUNTER 0 TIME CONSTANT HIGH
C1M:	EQU	225	     ;COUNTER 1 CONTROL
C0M:	EQU	224	     ;COUNTER 0 CONTROL

;	EXAMPLE REGISTERS
;
GPR1:	EQU	01H		;GENERAL PURPOSE REG 1
GPR3:	EQU	23H		;GENERAL PURPOSE REG 3
GPR4:	EQU	24H		;GENERAL PURPOSE REG 4
IMM8:	EQU	80H		;8 BIT IMMEDIATE
IMM16:	EQU	1234H		;16 BIT IMMEDIATE

	ORG	32		;PC AFTER RESET

	ADC	R9,R11		;129B
	ADC	R9,@R11 	;139B
	ADC	GPR1,GPR3	;142301
	ADC	GPR1,@GPR3	;152301
	ADC	GPR1,#IMM8	;160180

	ADD	R9,R11		;029B
	ADD	R9,@R11 	;039B
	ADD	GPR1,GPR3	;042301
	ADD	GPR1,@GPR3	;052301
	ADD	GPR1,#IMM8	;060180

	AND	R9,R11		;529B
	AND	R9,@R11 	;539B
	AND	GPR1,GPR3	;542301
	AND	GPR1,@GPR3	;552301
	AND	GPR1,#IMM8	;560180

	BAND	R9,GPR3,#7	;679E23
	BAND	GPR3,#7,R9	;679F23

	BCP	R9,GPR3,#7	;179E23

	BITC	R9,#7		;579E

	BITR	R9,#7		;779E

	BITS	R9,#7		;779F

	BOR	R9,GPR3,#7	;079E23
	BOR	GPR3,#7,R9	;079F23

	BTJRF	$+43H,R9,#7	;379E40

	BTJRT	$+43H,R9,#7	;379F40

	BXOR	R9,GPR3,#7	;279E23
	BXOR	GPR3,#7,R9	;279F23

	CALL	1234H		;F61234
	CALL	@GPR4		;F424
				;EVEN ONLY
	CALL	#IMM8		;D480

	CCF			;EF

	CLR	GPR3		;B023
	CLR	@GPR3		;B123

	COM	GPR3		;6023
	COM	@GPR3		;6123

	CP	R9,R11		;A29B
	CP	R9,@R11 	;A39B
	CP	GPR1,GPR3	;A42301
	CP	GPR1,@GPR3	;A52301
	CP	GPR1,#IMM8	;A60180

	CPIJE	R9,@R11,$+43H	;C2B940

	CPIJNE	R9,@R11,$+43H	;D2B940

	DA	GPR3		;4023
	DA	@GPR3		;4123

	DEC	GPR3		;0023
	DEC	@GPR3		;0123

	DECW	GPR4		;8024
				;EVEN ONLY
	DECW	@GPR3		;8123

	DI			;8F

	DIV	GPR4,GPR3	;942324
				;DST EVEN ONLY
	DIV	GPR4,@GPR3	;952324
				;DST EVEN ONLY
	DIV	GPR4,#IMM8	;968024
				;DST EVEN ONLY

	DJNZ	R9,$ + 42H	;9A40

	EI			;9F

	ENTER			;1F

	EXIT			;2F

	INC	R9		;9E
	INC	GPR3		;2023
	INC	@GPR3		;2123

	INCW	GPR4		;A024
				;EVEN ONLY
	INCW	@GPR3		;A123

	IRET			;BF

	JP	@GPR4		;3024

	JP	1234H		;8D1234
	JP	C,1234H 	;7D1234
	JP	EQ,1234H	;6D1234
	JP	F,1234H 	;0D1234
	JP	GE,1234H	;9D1234
	JP	GT,1234H	;AD1234
	JP	LE,1234H	;2D1234
	JP	LT,1234H	;1D1234
	JP	MI,1234H	;5D1234
	JP	NC,1234H	;FD1234
	JP	NE,1234H	;ED1234
	JP	NOV,1234H	;CD1234
	JP	NZ,1234H	;ED1234
	JP	OV,1234H	;4D1234
	JP	PL,1234H	;DD1234
	JP	UGE,1234H	;FD1234
	JP	UGT,1234H	;BD1234
	JP	ULE,1234H	;3D1234
	JP	ULT,1234H	;7D1234
	JP	Z,1234H 	;6D1234

	JR	$ + 42H 	;8B40
	JR	C,$ + 42H	;7B40
	JR	EQ,$ + 42H	;6B40
	JR	F,$ + 42H	;0B40
	JR	GE,$ + 42H	;9B40
	JR	GT,$ + 42H	;AB40
	JR	LE,$ + 42H	;2B40
	JR	LT,$ + 42H	;1B40
	JR	MI,$ + 42H	;5B40
	JR	NC,$ + 42H	;FB40
	JR	NE,$ + 42H	;EB40
	JR	NOV,$ + 42H	;CB40
	JR	NZ,$ + 42H	;EB40
	JR	OV,$ + 42H	;4B40
	JR	PL,$ + 42H	;DB40
	JR	UGE,$ + 42H	;FB40
	JR	UGT,$ + 42H	;BB40
	JR	ULE,$ + 42H	;3B40
	JR	ULT,$ + 42H	;7B40
	JR	Z,$ + 42H	;6B40

	LD	R9,#IMM8	;9C80
	LD	R9,GPR3 	;9823
	LD	GPR3,R9 	;9923
	LD	R9,@R11 	;C79B
	LD	@R9,R11 	;D79B
	LD	GPR1,GPR3	;E42301
	LD	GPR1,@GPR3	;E52301
	LD	GPR1,#IMM8	;E60180
	LD	@GPR1,#IMM8	;D60180
	LD	@GPR1,GPR3	;F52301
	LD	R9,IMM8(R11)	;879B80
	LD	IMM8(R9),R11	;97B980

	LDB	R9,GPR3,#7	;479E23
	LDB	GPR3,#7,R9	;479F23

	LDC	R9,@RR10	;C39A
				;SRC EVEN ONLY
	LDC	@RR8,R11	;D3B8
				;DST EVEN ONLY
	LDC	R9,07FH(RR10)	;E79A7F
				;(rr) EVEN ONLY
	LDC	07FH(RR10),R9	;F79A7F
				;(rr) EVEN ONLY
	LDC	R9,IMM16(RR10)	;A79A3412
				;(rr)>1
	LDC	IMM16(RR10),R9	;B79A3412
				;(rr)>1
	LDC	R9,IMM16	;A7903412
	LDC	IMM16,R9	;B7903412

	LDE	R9,@RR10	;C39B
				;SRC EVEN ONLY
	LDE	@RR8,R11	;D3B9
				;DST EVEN ONLY
	LDE	R9,07FH(RR10)	;E79B7F
				;(rr) EVEN ONLY
	LDE	07FH(RR10),R9	;F79B7F
				;(rr) EVEN ONLY
	LDE	R9,IMM16(RR10)	;A79B3412
				;(rr)>1
	LDE	IMM16(RR10),R9	;B79B3412
				;(rr)>1
	LDE	R9,IMM16	;A7913412
	LDE	IMM16,R9	;B7913412

	LDCD	R9,@RR10	;E29A
				;SRC EVEN ONLY
	LDED	R9,@RR10	;E29B
				;SRC EVEN ONLY

	LDCI	R9,@RR10	;E39A
				;SRC EVEN ONLY
	LDEI	R9,@RR10	;E39B
				;SRC EVEN ONLY

	LDCPD	@RR8,R11	;F2B8
				;DST EVEN ONLY
	LDEPD	@RR8,R11	;F2B9
				;DST EVEN ONLY

	LDCPI	@RR8,R11	;F3B8
				;DST EVEN ONLY
	LDEPI	@RR8,R11	;F3B9
				;DST EVEN ONLY

	LDW	GPR4,GPR4	;C42424
				;BOTH EVEN ONLY
	LDW	GPR4,@GPR4	;C52424
				;BOTH EVEN ONLY
	LDW	GPR4,#IMM16	;C6241234
				;DST EVEN ONLY

	MULT	GPR4,GPR3	;842324
				;DST EVEN ONLY
	MULT	GPR4,@GPR3	;852324
				;DST EVEN ONLY
	MULT	GPR4,#IMM8	;868024
				;DST EVEN ONLY

	NEXT			;0F

	NOP			;FF

	OR	R9,R11		;429B
	OR	R9,@R11 	;439B
	OR	GPR1,GPR3	;442301
	OR	GPR1,@GPR3	;452301
	OR	GPR1,#IMM8	;460180

	POP	GPR3		;5023
	POP	@GPR3		;5123

	POPUD	GPR1,@GPR3	;922301

	POPUI	GPR1,@GPR3	;932301

	PUSH	GPR3		;7023
	PUSH	@GPR3		;7123

	PUSHUD	@GPR1,GPR3	;820123

	PUSHUI	@GPR1,GPR3	;830123

	RCF			;CF

	RET			;AF

	RL	GPR3		;9023
	RL	@GPR3		;9123

	RLC	GPR3		;1023
	RLC	@GPR3		;1123

	RR	GPR3		;E023
	RR	@GPR3		;E123

	RRC	GPR3		;C023
	RRC	@GPR3		;C123

	SB0			;4F

	SB1			;5F

	SBC	R9,R11		;329B
	SBC	R9,@R11 	;339B
	SBC	GPR1,GPR3	;342301
	SBC	GPR1,@GPR3	;352301
	SBC	GPR1,#IMM8	;360180

	SCF			;DF

	SRA	GPR3		;D023
	SRA	@GPR3		;D123

	SRP0	#50H		;3152
	SRP1	#68H		;3169
	SRP	#40H		;3140

	SUB	R9,R11		;229B
	SUB	R9,@R11 	;239B
	SUB	GPR1,GPR3	;242301
	SUB	GPR1,@GPR3	;252301
	SUB	GPR1,#IMM8	;260180

	SWAP	GPR3		;F023
	SWAP	@GPR3		;F123

	TCM	R9,R11		;629B
	TCM	R9,@R11 	;639B
	TCM	GPR1,GPR3	;642301
	TCM	GPR1,@GPR3	;652301
	TCM	GPR1,#IMM8	;660180

	TM	R9,R11		;729B
	TM	R9,@R11 	;739B
	TM	GPR1,GPR3	;742301
	TM	GPR1,@GPR3	;752301
	TM	GPR1,#IMM8	;760180

	WFI			;3F

	XOR	R9,R11		;B29B
	XOR	R9,@R11 	;B39B
	XOR	GPR1,GPR3	;B42301
	XOR	GPR1,@GPR3	;B52301
	XOR	GPR1,#IMM8	;B60180

	END

