;**************************************************************
; THIS TABLE SUPPORTS THE SGS-THOMSON ST62 AND ST63
; MICROCONTROLLER FAMILIES, COMMONLY KNOWN AS THE ST6.
;
	CPU	"ST6.TBL"	;PROCESSOR TABLE
	HOF	"BIN8"		;HEX OUTPUT FORMAT

;**************************************************************
;
; ST62 DATA SPACE EXAMPLE
; COPY THIS SECTION INTO YOUR SOURCE CODE
;
X	EQU	080H		;X REGISTER
Y	EQU	081H		;Y REGISTER
V	EQU	082H		;V REGISTER
W	EQU	083H		;W REGISTER
;
PA	EQU	0C0H		;PORT A DATA REGISTER
PB	EQU	0C1H		;PORT A DATA REGISTER
PC	EQU	0C2H		;PORT A DATA REGISTER
;
PADR	EQU	0C4H		;PORT A DIRECTION REGISTER
PBDR	EQU	0C5H		;PORT A DIRECTION REGISTER
PCDR	EQU	0C6H		;PORT A DIRECTION REGISTER
;
IOR	EQU	0C8H		;INTERRUPT OPTION REGISTER
RDW	EQU	0C9H		;DATA ROM WINDOW REGISTER
;
PAOR	EQU	0CCH		;PORT A OPTION REGISTER
PBOR	EQU	0CDH		;PORT B OPTION REGISTER
PCOR	EQU	0CEH		;PORT C OPTION REGISTER
;
ADDR	EQU	0D0H		;A/D DATA REGISTER
ADCR	EQU	0D1H		;A/D CONTROL REGISTER
TPSCR	EQU	0D2H		;TIMER PSC REGISTER
TDR	EQU	0D3H		;TIMER DATA REGISTER
TTSCRR	EQU	0D4H		;TIMER TSCR REGISTER
;
WR	EQU	0D8H		;WATCHDOG REGISTER
;
A	EQU	0FFH		;ACCUMULATOR

;**************************************************************
;
; ST62 PROGRAM MEMORY EXAMPLE WITH
; EXAMPLES OF ST6 INSTRUCTIONS
;
	ORG	0880H		;USER PROGRAM

START:	ADD	A,A
	ADD	A,X
	ADD	A,Y
	ADD	A,V
	ADD	A,W
	ADD	A,(X)
	ADD	A,(Y)
	ADD	A,IOR

	ADDI	A,22H

	CALL	ZZZ

	CLR	A
	CLR	X
	CLR	Y
	CLR	V
	CLR	W
	CLR	IOR

	COM	A

	DEC	A
	DEC	X
	DEC	Y
	DEC	V
	DEC	W
	DEC	(X)
	DEC	(Y)
	DEC	IOR

	JP	ZZZ

	JRC	$-15
	JRC	$+16

	JRNC	$-15
	JRNC	$+16

	JRR	0,IOR,LABEL
	JRR	1,IOR,LABEL
	JRR	2,IOR,LABEL
	JRR	3,IOR,LABEL
	JRR	4,IOR,LABEL
	JRR	5,IOR,LABEL
	JRR	6,IOR,LABEL
	JRR	7,IOR,LABEL

LABEL:	LD	A,A
	LD	A,X
	LD	A,Y
	LD	A,V
	LD	A,W
	LD	X,A
	LD	Y,A
	LD	V,A
	LD	W,A
	LD	A,(X)
	LD	A,(Y)
	LD	(X),A
	LD	(Y),A
	LD	A,IOR
	LD	IOR,A

	LDI	A,22H
	LDI	X,22H
	LDI	Y,22H
	LDI	V,22H
	LDI	W,22H
	LDI	IOR,22H

	NOP

	RES	0,A
	RES	1,X
	RES	2,Y
	RES	3,V
	RES	4,W
	RES	5,IOR
	RES	6,W
	RES	7,IOR

	RET

	RETI

	RLC	A

	SLA	A

	STOP

ZZZ:	WAIT

; VECTORS
;
	ORG	0FF0H
	DWM	START		;INTERRUPT VECTOR #4
	DWM	START		;INTERRUPT VECTOR #3
	DWM	START		;INTERRUPT VECTOR #2
	DWM	START		;INTERRUPT VECTOR #1

	ORG	0FFCH
	DWM	START		;NMI
	DWM	START		;RESET

	END
