;***********************************************************
; THIS TABLE SUPPORTS THE MICROCHIP PIC17Cxx MICROCONTROLLER.
;
; NOTE! THIS CHIP USES BYTE ADDRESSING FOR ITS DATA
;       REGISTER FILE, AND 2 BYTE, WORD ADDRESSING FOR
;       ITS PROGRAM MEMORY.  THEREFORE, ONE MUST SET
;     	WORD LENGTH (WDLN) TO 1 WHEN DEFINING DATA MEMORY,
;	AND 2 WHEN DEFINING PROGRAM MEMORY.

; NOTE! The multiply instructions (MULLW and MULWF) are not
;	supported by the PIC17C42 processor.  They are clearly
;	marked in the PIC17xx table (file PIC17XX.TBL) and may
;	be removed or ignored when targeting the PIC17C42.
;
	CPU	"PIC17xx.TBL"
	HOF	"INT16"

; Register file
	HEX	"OFF"	;Turn hex output off
	ORG	0x0
	WDLN	1	;1 byte data
;
; Unbanked
INDF0:	DFS	1	;Uses F1 to address data memory
FSR0:	DFS	1	;inderect data memory address pointer 0
PCL:	DFS	1	;Low order 8 bits of PC
PCLATH:	DFS	1	;Holding register for upper 8 bits of PC
ALUSTA:	DFS	1	;ALU Status
RTCSTA:	DFS	1	;Real Time Clock Status
CPUSTA:	DFS	1	;CPU Status
INTSTA:	DFS	1	;Interrupt Status
INDF1:	DFS	1	;Uses contents of F9 to address data memory
FSR1:	DFS	1	;Indirect data memory address pointer 1
W:	DFS	1	;W register
RTCCL:	DFS	1	;Real time clock counter LS byte
RTCCH:	DFS	1	;Real time clock counter MS byte
TBLPTRL: DFS	1	;Low byte of program memory table pointer
TBLPTRH: DFS	1	;High byte of program memory table pointer
BSR:	DFS	1	;Bank select register
;
; Bank 0
PORTA:	DFS	1	;Port A
DDRB:	DFS	1	;Data direction register for Port B
PORTB:	DFS	1	;Port B data latch
RCSTA:	DFS	1	;Serial Port Receive Status
RCREG:	DFS	1	;Serial Port Receive Register
TXSTA:	DFS	1	;Serial Port Transmit Statu
TXREG:	DFS	1	;Serial Port Transmit Register
SPBRG:	DFS	1	;Baud Rate Generator
;
; Bank 1
DDRC:	EQU	10h	;Data Direction Register for Port C
PORTC:	EQU	11h	;Port C Data Latch
DDRD:	EQU	12h	;Data Direction Register for Port D
PORTD:	EQU	13h	;Port D Data Latch
DDRE:	EQU	14h	;Data Direction Register for Port E
PORTE:	EQU	15h	;Port E Data Latch
PIR:	EQU	16h	;Peripheral Interrupt Request
PIE:	EQU	17h	;Peripheral Interrupt Enable
;
; Bank 2
TMR1:	EQU	10h	;Timer 1
TMR2:	EQU	11h	;Timer 2
TMR3L:	EQU	12h	;Timer 3 Low byte
TMR3H:	EQU	13h	;Timer 3 High byte
PR1:	EQU	14h	;Timer 1 Period Register
PR2:	EQU	15h	;Timer 2 Period Register
PR3L:	EQU	16h	;Timer 3 Period Register, Low byte
PR3H:	EQU	17h	;Timer 3 Period Register, High byte
CA1L:	EQU	16h	;Capture 1 register, Low byte
CA1H:	EQU	17h	;Capture 1 register, High byte
;
; Bank 3
PW1DCL:	EQU	10h	;
PW2DCL:	EQU	11h	;
PW1DCH:	EQU	12h	;
PW2DCH:	EQU	13h	;
CA2L:	EQU	14h	;Capture 2 low byte
CA2H:	EQU	15h	;Capture 2 high byte
TCON1:	EQU	16h	;
TCON2:	EQU	17h	;
;
;User registers
User1:	DFS	1	;
User2:	DFS	1	;
;
; etc.
;

; Code segment
	ORG	0	;Begining of Program Memory
	HEX	"ON"	;Turn hex output on
	WDLN	2	;Set program word length to 2 bytes
	
	DFS	8	;Reset Vector
	DFS	8	;INT Pin Interrupt Vector
	DFS	8	;RTTC Timer Interrupt Vector
	DFS	8	;RT Pin Interrupt Vector
	DFS	8	;Peripheral Interrupt Vector

; EXAMPLES OF PIC17Cxx INSTRUCTIONS FOLLOW:
;
	ORG	0100h

	ADDLW	-256	
	ADDLW	255	

	ADDWF	0,0	
	ADDWF	0	
	ADDWF	127,0	
	ADDWF	255,1	

	BCF	0,0	
	BCF	5,1	
	BCF	9,2	
	BCF	55,3	
	BCF	99,4	
	BCF	127,5	
	BCF	201,6	
	BCF	255,7	

	CALL	0	
	CALL	0x1FFF	

	CLRF	0,0	
	CLRF	0	
	CLRF	127,0	
	CLRF	255,1	

	CLRWDT		

	CPFSEQ	0	
	CPFSEQ	127	
	CPFSEQ	255	

	GOTO	0	
	GOTO	0x1FFF	

	IORLW	0	
	IORLW	-256	
	IORLW	255	

	IORWF	0,0	
	IORWF	0	
	IORWF	127,0	
	IORWF	255,1	

	LCALL	0	
	LCALL	255	
	LCALL	65535	

	MOVFP	0,0	
	MOVFP	255,31	

	MOVLB	0	
	MOVLB	-256	
	MOVLB	255	

	MOVLW	0	
	MOVLW	-256	
	MOVLW	255	

	MOVPF	0,0	
	MOVPF	31,255	

	MOVWF	0	
	MOVWF	127	
	MOVWF	255	

	NEGW	0,0	
	NEGW	0	
	NEGW	127,0	
	NEGW	255,1	

	NOP		

	RETFIE		

	RETURN		

	SLEEP		

	TABLRD	0,0,255 
	TABLRD	0,1,255 
	TABLRD	1,0,255 
	TABLRD	1,1,255 

	TABLWT	0,0,0	
	TABLWT	0,0,255 
	TABLWT	0,1,255 
	TABLWT	1,0,255 
	TABLWT	1,1,255 

	TLRD	0,0	
	TLRD	0,255	
	TLRD	1,255	
	TLRD	0,255	
	TLRD	1,255	

	TLWT	0,0	
	TLWT	0,255	
	TLWT	1,255	
	TLWT	0,255	
	TLWT	1,255	

	XORLW	-256	
	XORLW	255	

	XORWF	0,0	
	XORWF	0	
	XORWF	127,0	
	XORWF	255,1	

	END

