;******************************************************
;   The PIC16xx table provided, is for Microchip's
; PIC16Cxx Series of 8-bit CMOS microcontrollers.
; It may be used for all PIC16Cxx chips from the PIC16C61
; through the PIC16C84.  The PIC165x table must be used
; for the PIC16C5x family.

;******************************************************
;   Another Hexadecimal Output Format has been added
; to the assembler for this family:

	HOF	"INHX8M"

; This is the 8-bit merged Intellec hex format as described
; by Microchip.  It is identical to the "INT8"  hex format 
; except that it produces a  low byte / high byte word.

;******************************************************
; The 16xx family uses a 14-bit program word.  To
; make use of common Hexadecimal Output Formats,
; this assembler (like some others) uses a 16-bit
; word with the most significant 4 bits set to zero.
; PIC16xx programmers will ignore these extra bits.
; However, the word length in bytes must be set to 2.

	WDLN	2		;Word lenght must be 2

;******************************************************
; PIC16Cxx Register File
; The following are the special function registers for
; the PIC16C61.  The number and addresses of registers
; in the PIC16Cxx family varies greatly.  Define the
; special function and general purpose registers for
; your particular PIC16Cxx chip, and check it carefully.

; Some registers in different banks have the same name
; and address.  This is acceptable, because the PIC16Cxx
; only uses the least significant 7 bits for register
; addressing.  Register banks must be selected with
; the RP0 bit in the STATUS register.

;Bank 0 
;
INDF:	EQU	00h	;Indirect addressing register
TMR0:	EQU	01h	;Timer 0 Module
PCL:	EQU	02h	;Program Counter Low byte
STATUS:	EQU	03h	;STATUS register
FSR:	EQU	84h	;Indirect data memory address pointer
PORTA:	EQU	05h	;Port A I/O register
PORTB:	EQU	06h	;Port B I/O register
PCLATH:	EQU	0Ah	;Write buffer for upper 5 bits of PC
INTCON:	EQU	0Bh	;Interrupt control

;Bank 1
;
INDF:	EQU	00h	;Indirect addressing register
OPTION:	EQU	81h	;OPTION control register
PCL:	EQU	02h	;Program Counter Low byte
STATUS:	EQU	03h	;STATUS register
FSR:	EQU	84h	;Indirect data memory address pointer
TRISA:	EQU	85h	;Port A tri-state data direction register
TRISB:	EQU	86h	;Port B tri-state data direction register
PCLATH:	EQU	0Ah	;Write buffer for upper 5 bits of PC
INTCON:	EQU	0Bh	;Interrupt control

;******************************************************
; Some sample PIC16Cxx instruction are:
; The CPU directive must be included.
;
	CPU	"PIC16xx.TBL"	;Table definition
	TITL	"PIC16Cxx EXAMPLE"
	PAGE	55		;Page size
;
;
;	TYPE 0
;
TYPE0:	GOTO	TYPE1
	NOP			;0000
	CLRW			;0100
	OPTION			;0062
	SLEEP			;0063
	CLRWDT			;0064
	RETURN			;0008
	RETFIE			;0009
;
;	TYPE 1
;
TYPE1:	GOTO	TYPE2
	CLRF	00H		;0180
	CLRF	01H		;0181
	CLRF	40H		;01C0
	CLRF	7FH		;01FF

	MOVWF	00H		;0080
	MOVWF	01H		;0081
	MOVWF	40H		;00C0
	MOVWF	7FH		;00FF
;
;	TYPE 2
;
TYPE2:	GOTO	TYPE3
	TRIS	05H		;0065
	TRIS	06H		;0066
;
;	TYPE 3
;
TYPE3:	GOTO	TYPE4
	RETLW	00H		;3400
	RETLW	01H		;3401
	RETLW	40H		;3440
	RETLW	80H		;3480
	RETLW	0FFH		;34FF

	CALL	000H		;2000
        CALL    020H            ;2020
	CALL	400H		;2400
	CALL	7FFH		;27FF

	MOVLW	00H		;3000
	MOVLW	80H		;3080
	MOVLW	0FFH		;30FF

	IORLW	00H		;3800
	IORLW	01H		;3801
	IORLW	80H		;3880
	IORLW	0FFH		;38FF

	ADDLW	00H		;3E00
	ADDLW	01H		;3E01
	ADDLW	80H		;3E80
	ADDLW	0FFH		;3EFF

	XORLW	00H		;3A00
	XORLW	80H		;3A80
	XORLW	0FFH		;3AFF

	SUBLW	00H		;3C00
	SUBLW	80H		;3C80
	SUBLW	0FFH		;3CFF

	ANDLW	00H		;3900
	ANDLW	80H		;3980
	ANDLW	0FFH		;39FF
;
;	TYPE 4
;
TYPE4:	GOTO	TYPE5
	GOTO	000H		;2800
	GOTO	400H		;2C00
	GOTO	7FFH		;2FFF
;
;	TYPE 5
;
TYPE5:	GOTO	TYPE6
	SUBWF	00H,0		;0200
	SUBWF	7FH,0		;027F
	SUBWF	00H,1		;0280
	SUBWF	40H,1		;02C0
	SUBWF	7FH,1		;02FF

	DECF	00H,0		;0300
	DECF	7FH,0		;037F
	DECF	00H,1		;0380
	DECF	40H,1		;03C0
	DECF	7FH,1		;03FF

	IORWF	00H,0		;0400
	IORWF	40H,0		;0440
	IORWF	7FH,0		;047F
	IORWF	00H,1		;0480
 	IORWF	40H,1		;04C0
	IORWF	7FH,1		;04FF

	ANDWF	00H,0		;0500
	ANDWF	01H,0		;0501
	ANDWF	40H,1		;05C0
	ANDWF	7FH,1		;05FF

	XORWF	00H,0		;0600
	XORWF	01H,0		;0601
	XORWF	40H,1		;06C0
	XORWF	7FH,1		;06FF

	ADDWF	00H,0		;0700
	ADDWF	01H,0		;0701
	ADDWF	40H,1		;07C0
	ADDWF	7FH,1		;07FF

	MOVF	00H,0		;0800
	MOVF	01H,0		;0801
	MOVF	40H,1		;08C0
	MOVF	7FH,1		;08FF

	COMF	00H,0		;0900
	COMF	01H,0		;0901
	COMF	40H,1		;09C0
	COMF	7FH,1		;09FF

	INCF	00H,0		;0A00
	INCF	01H,0		;0A01
	INCF	40H,1		;0AC0
	INCF	7FH,1		;0AFF

	DECFSZ	00H,0		;0B00
	DECFSZ	01H,0		;0B01
	DECFSZ	40H,1		;0BC0
	DECFSZ	7FH,1		;0BFF

	RRF	00H,0		;0C00
	RRF	01H,0		;0C01
	RRF	40H,1		;0CC0
	RRF	7FH,1		;0CFF

	RLF	00H,0		;0D00
	RLF	01H,0		;0D01
	RLF	40H,1		;0DC0
	RLF	7FH,1		;0DFF

	SWAPF	00H,0		;0E00
	SWAPF	01H,0		;0E01
	SWAPF	40H,1		;0EC0
	SWAPF	7FH,1		;0EFF

	INCFSZ	00H,0		;0F00
	INCFSZ	40H,1		;0FC0
	INCFSZ	7FH,1		;0FFF
;
;	TYPE 6
;
TYPE6:	GOTO	TYPE7
	BCF	00H,0		;1000
	BCF	01H,0		;1001
	BCF	40H,1		;10C0
	BCF	40H,7		;13C0
	BCF	7FH,7		;13FF

	BSF	00H,0		;1400
	BSF	01H,0		;1401
	BSF	40H,7		;17C0
	BSF	7FH,7		;17FF

	BTFSC	00H,0		;1800
	BTFSC	01H,0		;1801
	BTFSC	40H,7		;1BC0
	BTFSC	7FH,7		;1BFF

	BTFSS	00H,0		;1C00
	BTFSS	01H,0		;1C01
	BTFSS	40H,7		;1FC0
	BTFSS	7FH,7		;1FFF

;
TYPE7:	GOTO	TYPE0

	END
