;******************************************************
;   The PIC165X table provided, is for Microchip's
; PIC16C5x Series of 8-bit CMOS microcontrollers.
; It may be used for all regular and enhanced PIC16C5x
; chips from the PIC1650 through the PIC16C58.

;******************************************************
;   Another Hexadecimal Output Format has been added
; to the assembler for this chip:

	HOF	"INHX8M"

; This is the 8-bit merged Intellec hex format as described
; by Microchip.  It is identical to the "INT8"  hex format 
; except that it produces a  low byte / high byte word.

;******************************************************
; The 165x family uses a 12-bit program word.  To
; make use of common Hexadecimal Output Formats,
; this assembler (like some others) uses a 16-bit
; word with the most significant 4 bits set to zero.
; PIC165x programmers will ignore these extra bits.
; However, the word length in bytes must be set to 2.

	WDLN	2		;Must be 2

;******************************************************
; PIC165x Register File
; These values should be copied into you program.
; Define your own general purpose registers (08h-7Fh)
; in the same manner.
;
INDF:	EQU	00h	;Indirect addressing register
TMR0:	EQU	01h	;Timer 0 Module
PCL:	EQU	02h	;Program Counter Low byte
STATUS:	EQU	03h	;STATUS register
FSR:	EQU	04h	;File Select Register
PORTA:	EQU	05h	;Port A I/O register
PORTB:	EQU	06h	;Port B I/O register
PORTC:	EQU	07h	;Port C I/O register

;******************************************************
; Some sample PIC165x instruction are:
; The CPU directive must be included.
;
	CPU	"PIC165X.TBL"	;Table definition
	TITL	"PIC16C5x EXAMPLE"
	PAGE	60		;Page size
;
	ADDWF	04H,0		;01C4
	ADDWF	04H,1		;01E4
	ANDLW	00H		;0E00
	ANDLW	01H		;0E01
	ANDWF	01H,0		;0141
	ANDWF	01H,1		;0161
	BCF	01H,1		;0421
	BCF	01H,2		;0441
	BCF	01H,4		;0481
	BCF	01H,7		;04E1
	BSF	01H,1		;0521
	BSF	01H,2		;0541
	BSF	01H,4		;0581
	BSF	01H,7		;05E1
	BSF	02H,0		;0502
	BTFSC	01H,0		;0601
	BTFSC	01H,1		;0621
	BTFSC	01H,2		;0641
	BTFSC	01H,4		;0681
	BTFSC	01H,7		;06E1
	BTFSS	04H,7		;07E4
	BTFSS	08H,0		;0708
	BTFSS	08H,1		;0728
	BTFSS	08H,2		;0748
	BTFSS	08H,4		;0788
	CALL	02H		;0902
	CALL	04H		;0904
	CALL	0FFH		;09FF
	CLRF	02H		;0062
	CLRF	04H		;0064
	CLRW			;0040
	CLRWDT			;0004
	COMF	02H,0		;0242
	COMF	02H,1		;0262
	DECF	02H,0		;00C2
	DECF	02H,1		;00E2
	DECFSZ	01H,0		;02C1
	DECFSZ	01H,1		;02E1
	GOTO	00H		;0A00
	GOTO	01H		;0A01
	GOTO	100H		;0B00
	GOTO	1FFH		;0BFF
	INCF	01H,0		;0281
	INCF	01H,1		;02A1
	INCFSZ	01H,0		;03C1
	INCFSZ	01H,1		;03E1
	IORLW	01H		;0D01
	IORLW	02H		;0D02
	IORLW	0FFH		;0DFF
	IORLW	10H		;0D10
	IORWF	00H,0		;0100
	IORWF	00H,1		;0120
	MOVF	01H,0		;0201
	MOVF	01H,1		;0221
	MOVLW	00H		;0C00
	MOVLW	01H		;0C01
	MOVLW	02H		;0C02
	MOVLW	04H		;0C04
	MOVLW	08H		;0C08
	MOVLW	0FFH		;0CFF
	NOP			;0000
	OPTION			;0002
	RETLW	00H		;0800
	RETLW	01H		;0801
	RETLW	02H		;0802
	RETLW	04H		;0804
	RETLW	0FFH		;08FF
	RLF	01H,0		;0341
	RLF	01H,1		;0361
	RRF	01H,0		;0301
	RRF	01H,1		;0321
	SLEEP			;0003
	SUBWF	01H,0		;0081
	SUBWF	01H,1		;00A1
	SUBWF	02H,0		;0082
	SUBWF	02H,1		;00A2
	SWAPF	04H,0		;0384
	SWAPF	04H,1		;03A4
	TRIS	05H		;0005
	TRIS	06H		;0006
	XORLW	04H		;0F04
	XORLW	08H		;0F08
	XORLW	0FFH		;0FFF
	XORWF	00H,1		;01A0
	XORWF	01H,0		;0181
	XORWF	01H,1		;01A1
	XORWF	02H,0		;0182
ZZZ:
	END
