;*******************************************************
;
; THE 7810 TABLE CONTAINS THE INSTRUCTIONS USED BY THE
; NEC78C10 MICROCOMPUTER, USING THE SYNTAX DEFINED
; IN THE NEC PROGRAMMING MANUAL.
;
; THERE ARE NO SPECIAL NOTES FOR THIS PROCESSOR.
;
; SOME SAMPLE CODE FOLLOWS:

	CPU	"NEC7810.TBL"	;CPU TABLE
	HOF	"MOT16"		;HEX FORMAT
;
BYTE:	EQU	56H
WA:	EQU	12H
WORD:	EQU	1234H

; 8-Bit Data Transfer
;
	MOV	EAH,A		;18
	MOV	EAL,A		;19
	MOV	B,A		;1A
	MOV	C,A		;1B
	MOV	D,A		;1C
	MOV	L,A		;1F

	MOV	A,EAH		;08
	MOV	A,B		;0A
	MOV	A,H		;0E
	MOV	A,L		;0F

	MOV	PA,A		;4DC0
	MOV	PB,A		;4DC1
	MOV	PF,A		;4DC5
	MOV	MKH,A		;4DC6
	MOV	MKL,A		;4DC7
	MOV	ANM,A		;4DC8
	MOV	SMH,A		;4DC9
	MOV	ETMM,A		;4DCC
	MOV	MM,A		;4DD0
	MOV	MCC,A		;4DD1
	MOV	MB,A		;4DD3
	MOV	MC,A		;4DD4
	MOV	TXB,A		;4DD8
	MOV	TM1,A		;4DDB

	MOV	A,PA		;4CC0
	MOV	A,PB		;4CC1
	MOV	A,PF		;4CC5
	MOV	A,MKH		;4CC6
	MOV	A,SMH		;4CC9
	MOV	A,EOM		;4CCB
	MOV	A,CR0		;4CE0
	MOV	A,CR1		;4CE1
	MOV	A,CR2		;4CE2

	MOV	V,WORD		;70683412
	MOV	A,WORD		;70693412
	MOV	D,WORD		;706C3412
	MOV	H,WORD		;706E3412

	MOV	WORD,A		;70793412
	MOV	WORD,C		;707B3412
	MOV	WORD,D		;707C3412

	MVI	V,BYTE		;6856
	MVI	A,BYTE		;6956
	MVI	PA,BYTE		;640056
	MVI	PF,BYTE		;640556
	MVI	MKH,BYTE	;640656
	MVI	ANM,BYTE	;648056
	MVI	SMH,BYTE	;648156
	MVI	EOM,BYTE	;648356

	MVIW	WA,BYTE		;711256

	MVIX	B,BYTE		;4956
	MVIX	D,BYTE		;4A56
	MVIX	H,BYTE		;4B56

	STAW	WA		;6312

	LDAW	WA		;0112

	STAX	B		;39
	STAX	D		;3A
	STAX	H		;3B
	STAX	D-		;3E
	STAX	H-		;3F
	STAX	D+BYTE		;BB56
	STAX	H+A		;BC
	STAX	H+B		;BD
	STAX	H+BYTE		;BF56

	EXX			;11
	EXA			;10
	EXH			;50

; 16-Bit Data Transfer
;
	BLOCK			;31

	DMOV	B,EA		;B5
	DMOV	D,EA		;B6
	DMOV	H,EA		;B7

	STEAX	H		;4893
	STEAX	D++		;4894
	STEAX	H++		;4895
	STEAX	D+BYTE		;489B56
	STEAX	H+A		;489C
	STEAX	H+B		;489D
	STEAX	H+EA		;489E
	STEAX	H+BYTE		;489F56

	POP	V		;A0
	POP	B		;A1
	POP	D		;A2
	POP	H		;A3
	POP	EA		;A4

	TABLE			;48A8

; 8-Bit Arithmetic [Register]
;
	ADD	A,V		;60C0
	ADD	A,A		;60C1
	ADD	A,L		;60C7

	ADD	V,A		;6040
	ADD	E,A		;6045
	ADD	H,A		;6046
	ADD	L,A		;6047

; 8-Bit Arithmetic [Memory]
;
	ADDX	B		;70C1
	ADDX	D		;70C2
	ADDX	H		;70C3
	ADDX	D+		;70C4
	ADDX	H+		;70C5
	ADDX	D-		;70C6
	ADDX	H-		;70C7

; Immediate Data
;
	ADI	A,BYTE		;4656
	ADI	V,BYTE		;744056
	ADI	B,BYTE		;744256
	ADI	C,BYTE		;744356
	ADI	D,BYTE		;744456
	ADI	E,BYTE		;744556
	ADI	H,BYTE		;744656
	ADI	L,BYTE		;744756
	ADI	PA,BYTE		;644056
	ADI	PB,BYTE		;644156
	ADI	PC,BYTE		;644256
	ADI	PD,BYTE		;644356
	ADI	PF,BYTE		;644556
	ADI	MKH,BYTE	;644656
	ADI	MKL,BYTE	;644756
	ADI	ANM,BYTE	;64C056
	ADI	SMH,BYTE	;64C156
	ADI	EOM,BYTE	;64C356
	ADI	TMM,BYTE	;64C556

; 16-Bit Arithmetic
;
	EADD	EA,A		;7041
	EADD	EA,B		;7042
	EADD	EA,C		;7043

	DOFF	EA,B		;74DD
	DOFF	EA,D		;74DE
	DOFF	EA,H		;74DF

; Multiply/Divide
;
	MUL	A		;482D
	MUL	B		;482E
	MUL	C		;482F

	DIV	A		;483D
	DIV	B		;483E
	DIV	C		;483F

; Increment/Decrement
;
	INR	A		;41
	INR	B		;42
	INR	C		;43

	INRW	WA		;2012

	INX	SP		;02
	INX	B		;12
	INX	D		;22
	INX	H		;32
	INX	EA		;A8

; Others
;
	DAA			;61
	STC			;482B
	CLC			;482A
	NEGA			;483A

; Rotate and Shift
;
	RLD			;4838

	RRD			;4839

	RLL	A		;4835
	RLL	B		;4836
	RLL	C		;4837

	RLR	A		;4831
	RLR	B		;4832
	RLR	C		;4833

	DSLL	EA		;48A4

	DSLR	EA		;48A0

; Jump
;
	JMP	WORD		;543412
	JB			;21
	JR	$+16		;CF
	JRE	$+257		;4EFF
	JEA			;4828

; Call
;
	CALL	WORD		;403412
	CALB			;4829
	CALF	$878		;7878
	CALT	$+16		;8F
	SOFTI			;72

; Return
;
	RET			;B8
	RETS			;B9
	RETI			;62

; Bit
;
	BIT	0,WA		;5812
	BIT	1,WA		;5912
	BIT	2,WA		;5A12
	BIT	3,WA		;5B12
	BIT	4,WA		;5C12
	BIT	5,WA		;5D12
	BIT	6,WA		;5E12
	BIT	7,WA		;5F12

; CPU Control
;
	SK	CY		;480A
	SK	HC		;480B
	SK	Z		;480C

	SKN	CY		;481A
	SKN	HC		;481B
	SKN	Z		;481C

	SKIT	FNMI		;4840
	SKIT	FT0		;4841
	SKIT	FT1		;4842
	SKIT	F1		;4843
	SKIT	F2		;4844
	SKIT	FE0		;4845
	SKIT	FE1		;4846
	SKIT	FEIN		;4847
	SKIT	FAD		;4848
	SKIT	FSR		;4849
	SKIT	FST		;484A
	SKIT	ER		;484B
	SKIT	OV		;484C
	SKIT	AN4		;4850
	SKIT	AN5		;4851
	SKIT	AN6		;4852
	SKIT	AN7		;4853
	SKIT	SB		;4854

	EI			;AA
	DI			;BA
	HLT			;483B

ZZZ:
	END
