;******************************************************
; NEC7500.TBL SUPPORTS THE uPD7508A PROCESSOR
; THE FOLLOWING ORDER IS FROM PAGE 3-28 OF
; 1984 NEC MICROCOMPUTER PRODUCTS DATABOOK
; INSTRUCTION SET "A"
;
	HOF	"INT8" 		;HEX FORMAT
	CPU	"NEC7500.TBL"	;CPU TABLE
;
	ORG	0100H
;
ADR8:	EQU	55H		;RANGE:  0 TO 255
DAT4:	EQU	 5H		;RANGE:  -8 TO 15
DAT8:	EQU	12H		;RANGE:  -128 TO 255
TADR4:	EQU	0C5H		;RANGE:	 0C0H TO 0CFH
TADR6:	EQU	0D5H		;RANGE:  0C0H TO 0FFH
BIT:	EQU	3		;RANGE:  0 TO 3
VEC:	EQU	4095		;RANGE:  0 TO 4095
PAG64:	EQU	164H		;RANGE:  WITHIN 64 BYTE PAGE
LAB11:	EQU	456H		;RANGE:  0 TO 2047 
LAB12:	EQU	0ABCH		;RANGE:  0 TO 4095
PORT:	EQU	4		;RANGE:  0 TO 15

	LADR	ADR8		;3855

	LAI	DAT4		;15

	LAM	DL		;40
	LAM	DE		;41
	LAM	HL-		;50
	LAM	HL+		;51
	LAM	HL		;52

	LAMTL			;3F34

	LDEI	DAT8		;4F12

	LDI	DAT4		;3E25

	LEI	DAT4		;3E05

	LHI	DAT4		;3E35

	LHLI	DAT8		;4E12

	LHLT	TADR4		;C5

	LLI	DAT4		;3E15

	ST			;57

	TAD			;3EAA

	TAE			;3E8A

	TAH			;3EBA

	TAL			;3E9A

	TDA			;3EAB

	TEA			;3E8B

	THA			;3EBB

	TLA			;3E9B

	XAD			;4A

	XADR	ADR8		;3955

	XAE			;4B

	XAH			;7A

	XAL			;7B

	XAM	DL		;44
	XAM	DE		;45
	XAM	HL-		;54
	XAM	HL+		;55
	XAM	HL		;56

	XHDR	ADR8		;3A55

	XLDR	ADR8		;3B55

	ACSC			;7C

	AISC	DAT4		;05

	ASC			;7D

	ANL			;3FB2

	EXL			;7E

	ORL			;3FB6

	CMA			;7F

	RAR			;3FB3

	RC			;78

	SC			;79

	DDRS	ADR8		;3C55

	DES			;48

	DLS			;58

	IDRS	ADR8		;3D55

	IES			;49

	ILS			;59

	RMB	BIT		;6B

	SMB	BIT		;6F

	CALL	LAB11		;3456

	CALT	TADR6		;D5

	JAM	VEC		;3F1F

	JCP	PAG64		;A4

	JMP	LAB12		;2ABC

	RT			;53
	
	RTPSW			;43

	RTS			;5B

	POPDE			;3E8F

	POPHL			;3E9F

	PSHDE			;3E8E

	PSHHL			;3E9E

	TAMSP			;3F31

	TSPAM			;3F35

	SKABT	BIT		;77

	SKAEI	DAT4		;3F65

	SKAEM	DAT4		;5F

	SKC			;5A

	SKDEI	DAT4		;3E65

	SKEEI	DAT4		;3E45

	SKHEI	DAT4		;3E75

	SKLEI	DAT4		;3E55

	SKMBF	BIT		;63

	SKMBT	BIT		;67

	TAMMOD			;3F3F

	TCNTAM			;3F3B

	TIMER			;3F32

	DI	DAT4		;3F85

	EI	DAT4		;3F95

	SKI	DAT4		;3F45

	SIO			;3F33

	TAMSIO			;3F3E

	TSIOAM			;3F3A

	ANP	PORT,DAT4	;4C54

	IP	PORT		;3FC4

	IP1			;71

	IP54			;3F38

	IPL			;70

	OP	PORT		;3FE4

	OP3			;73

	OP54			;3F3C

	OPL			;72

	ORP	PORT,DAT4	;4D54

	HALT			;3F36

	NOP			;00

	STOP			;3F37
ZZZ:
	END

