;******************************************************
;   The HMCS400 table provided, is for Hitachi's
; HMCS400 Series of microcontrollers.

; NOTES!!!
; --------
; The HMCS400 family uses a 10-bit program word.  To
; make use of common Hexadecimal Output Formats,
; this assembler (like some others) uses a 16-bit
; word with the most significant 6 bits set to zero.
; HMCS400 programmers will ignore these extra bits.
; However, the word length in bytes must be set to 2:

	WDLN	2		;Must be 2

; USING THE BR INSTRUCTION, THE ASSEMBLER WILL AUTOMATICALLY 
; SELECT THE SHORTEST FORM OF THE BRANCH ON STATUS 1 .
; BRS AND BRL MAY BE USED TO SPECIFY THE EXACT FORM.
; SEE EXAMPLES BELOW.

	TITL	"EXAMPLE INSTRUCTIONS FOR HITACHI'S HMCS400"
	CPU	"HMCS400.TBL"
	HOF	"INT8"
	PAGE	60
	ORG	$100
;
;	EXAMPLE INSTRUCTIONS FOR HMCS400 MICROCONTROLLER
;
	AI	$F		;028F

	ALEI	$7		;02B7

	ALEM			;0014

	ALEMD	$074		;01140074

	AM			;0008

	AMD	$04C		;0108004C

	AMC			;0018

	AMCD	$043		;01180043

	ANEM			;0004

	ANEMD	$038		;01040038

	ANM			;009C

	ANMD	$02C		;019C002C

	AYY			;0054

	BLEM			;00C4

	BNEM			;0044

L1:	BR	L1		;0314
L2:	BR	L2		;0315
	BRS	L1		;0314
	BR	ZZZ		;039D

	BRL	L1		;01700114

	CAL	$3F		;01FF

	CALL	L1		;01600114

	COMB			;0140

	DAA			;00A6

	DAS			;00AA

	DB			;00CF

	DY			;00DF

	EORM			;001C

	EORMD	$04B		;011C004B

	IB			;004C

	ILEM	$4		;0034

	ILEMD	$3,$030		;01330030
	ILEMD	$2,$030		;01320030
	ILEMD	$1,$030		;01310030
	ILEMD	$0,$030		;01300030

	INEM	$A		;002A

	INEMD	4,$030		;01240030

	IY			;005C

	JMPL	L1		;01500114

	LAB			;0048

	LAI	$0		;0230

	LAM			;0090
	LAMX			;0091
	LAMY			;0092
	LAMXY			;0093

	LAMD	$032		;01900032

	LAMR	$6		;0276

	LAR	$3		;0253

	LASPX			;0068

	LASPY			;0058

	LAW			;01000000

	LAY			;00AF

	LBA			;00C8

	LBI	$6		;0206

	LBM			;0040
	LBMX			;0041
	LBMY			;0042
	LBMXY			;0043

	LBR	$3		;0243

	LMA			;0094
	LMAX			;0095
	LMAY			;0096
	LMAXY			;0097

	LMAD	$034		;01940034

	LMADY			;00D0
	LMADYX			;00D1

	LMAIY			;0050
	LMAIYX			;0051

	LMID	$8,$004		;01A80004
	LMID	$F,$009		;01AF0009
	LMID	$E,$00A		;01AE000A
	LMID	$F,$00B		;01AF000B

	LMIIY	$0		;0290

	LRA	$1		;02D1

	LRB	$4		;02C4

	LWA			;01100000

	LWI	0		;00F0

	LXA			;00E8

	LXI	$4		;0224

	LYA			;00D8

	LYI	$0		;0210

	NEGA			;0060

	NOP			;0000

	OR			;0144

	ORM			;000C

	ORMD	$07F		;010C007F

	P	7		;01B7

	REC			;00EC

	RED			;0064

	REDD	$2		;0262

	REM	3		;008B
	REM	2		;008A

	REMD	0,$002		;01880002
	REMD	1,$002		;01890002

	ROTL			;00A1

	ROTR			;00A0

	RTN			;0010

	RTNI			;0011

	SBY			;014C

	SEC			;00EF

	SED			;00E4

	SEDD	$0		;02E0
	SEDD	$1		;02E1
	SEDD	$2		;02E2
	SEDD	$3		;02E3

	SEM	0		;0084

	SEMD	$3,$043		;01870043

	SMC			;0098

	SMCD	$035		;01980035

	STOP			;014D

	STS			;0148

	SYY			;00D4

	TBR	$3		;00B3

	TC			;006F

	TD			;00E0

	TDD	3		;02A3

	TM	3		;008F

	TMD	2,$02C		;018E002C

	XMA			;0080
	XMAX			;0081
	XMAY			;0082
	XMAXY			;0083

	XMAD	$02D		;0180002D

	XMB			;00C0
	XMBX			;00C1
	XMBY			;00C2
	XMBXY			;00C3

	XMRA	$3		;02F3

	XSPX			;0001

	XSPXY			;0003

	XSPY			;0002

	YNEI	$A		;007A
ZZZ:
	END
